/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* Monitor site view changes */

#include "isis.h"

sview *
site_getview()
  {
        return(isis_mutex?  &isis_svmutex: &isis_sv);
  }

sv_init()
  {
        static firsttime;
        if(firsttime++ == 0)
        {
            int sv_new_sview();
            isis_entry(GENERIC_NEW_SVIEW, sv_new_sview, "sv_watch:sv_new_sview");
            isis_swlist = qu_null();
        }
  }

struct svmon
{
        site_id sv_sid;
        int     sv_event;
        int     sv_uid;
        int     sv_act;
        int     sv_viewid;
        int     (*sv_proc)();
        char    *sv_arg;
};

static adesc    sv_adesc ={ sizeof(svmon), 0, 8, };

#define sv_alloc()        ((svmon*)mallocate(&sv_adesc))

sv_free(svm)
  svmon *svm;
  {
        act_ev(-1, svm->sv_act, ACT_WATCH);
        mdeallocate((char*)svm, &sv_adesc);
  }

static  SVID;

sv_monitor(routine, arg)
  ifunc *routine;
  char *arg;
  {
        return(sv_watch(0, W_MONITOR, routine, arg));
  }

sv_monitor_cancel(svid)
  {
        sv_watch_cancel(svid);
  }

sv_watch(sid, event, routine, arg)
  site_id sid;
  ifunc *routine;
  char *arg;
  {
        register svmon *svm = sv_alloc();
        svm->sv_uid = ++SVID;
        svm->sv_viewid = 0;
        svm->sv_act = isis_ctp->task_act;
        act_ev(1, svm->sv_act, ACT_WATCH);
        svm->sv_sid = sid;
        svm->sv_event = event;
        svm->sv_proc = routine;
        svm->sv_arg = arg;
        (void)qu_add_svm(isis_swlist, SVID, svm, sv_free);
        return(SVID);
  }

sv_watch_cancel(svid)
  {
        register queue *qp;
        if(qp = qu_find(isis_swlist, svid))
        {
            qu_free(qp);
            return(0);
        }
        return(-1);
  }

sv_dovcall(svm)
  register svmon *svm;
  {
        register sview *sv = isis_mutex? &isis_svmutex: &isis_sv;
        isis_ctp->task_routine = svm->sv_proc;
        isis_ctp->task_arg0 = svm->sv_arg;
        isis_ctp->task_act = svm->sv_act;
        (*svm->sv_proc)(sv, svm->sv_arg);
        sv_free(svm);
  }

sv_doecall(svm)
  register svmon *svm;
  {
        isis_ctp->task_routine = svm->sv_proc;
        isis_ctp->task_arg0 = svm->sv_arg;
        (*svm->sv_proc)(svm->sv_sid, svm->sv_event, svm->sv_arg);
        sv_free(svm);
  }

sv_new_sview(mp)
  register message *mp;
  {
        register sview *sp = (sview*)msg_getfield(mp, CL_VIEW, 1, NULLIARG);
        register queue *qp, *nqp;

        bcopy(sp, isis_mutex? &isis_svmutex: &isis_sv, sizeof(sview));
        for(qp = isis_swlist->qu_next; qp != isis_swlist; qp = nqp)
        {
            register svmon *svm = qp->qu_svm, *scopy;
            nqp = qp->qu_next;
            if(isis_mutex && svm->sv_act != isis_mutex)
                continue;
            if(svm->sv_viewid == sp->sv_viewid || ((svm->sv_viewid&0xFF) == (sp->sv_viewid&0xFF) && svm->sv_viewid > sp->sv_viewid))
                break;
            svm->sv_viewid = sp->sv_viewid;
            switch(svm->sv_event)
            {
              case W_FAIL:
                   if(svm->sv_sid != NULLSID)
                   {
                       if(bit(sp->sv_failed, SITE_NO(svm->sv_sid)))
                            continue;
                   }
                   else
                   {
                        register s;
                        if(btst(sp->sv_failed) == 0)
                            continue;
                        for(s = 0; s < MAX_SITES; s++)
                            if(bit(sp->sv_failed, s))
                            {
                                svm->sv_sid = MAKE_SITE_ID(s, 0);
                                break;
                            }
                   }
                   goto trigger;
              case W_RECOVER:
                   if(svm->sv_sid != NULLSID)
                   {
                       if(bit(sp->sv_recovered, SITE_NO(svm->sv_sid)))
                            continue;
                   }
                   else
                   {
                        register s;
                        if(btst(sp->sv_recovered) == 0)
                            continue;
                        for(s = 0; s < MAX_SITES; s++)
                            if(bit(sp->sv_recovered, s))
                            {
                                svm->sv_sid = MAKE_SITE_ID(s, sp->sv_incarn[s]);
                                break;
                            }
                   }
              trigger:
                    scopy = sv_alloc();
                    *scopy = *svm;
                    act_ev(1, svm->sv_act, ACT_WATCH);
                    t_fork(sv_doecall, scopy);
                    if(svm->sv_event != W_MONITOR)
                        qu_free(qp);
                    break;
              case W_MONITOR:
                    scopy = sv_alloc();
                    *scopy = *svm;
                    act_ev(1, svm->sv_act, ACT_WATCH);
                    t_fork(sv_dovcall, scopy);
                    break;
            }
        }
  }

site_monitor_dump()
  {
        register queue *qp;
        for(qp = isis_swlist->qu_next; qp != isis_swlist; qp = qp->qu_next)
        {
            register svmon *svm = qp->qu_svm;
            print("  [act %d swid %x]: ", svm->sv_act, svm->sv_uid);
            switch(svm->sv_event)
            {
              case W_MONITOR:  print("monitoring site-views, "); break;
              case W_FAIL:  print("watching site %d/%d, ", SITE_NO(svm->sv_sid), SITE_INCARN(svm->sv_sid)); break;
              case W_RECOVER:  print("waiting for site %d to recover, ", SITE_NO(svm->sv_sid)); break;
              default: print(" *** contains a sv_watch event code %d, site %d/%d *** ", svm->sv_event, SITE_NO(svm->sv_sid), SITE_INCARN(svm->sv_sid)); break;
            }
            print("Call ");
            cl_rname(svm->sv_proc);
            print("(%x)\n", svm->sv_arg);
        }
  }
