/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 * Client entry routines in ISIS: unpack args and dispatch request
 */
#include "isis.h"

address
pg_lookup(name)
  char *name;
  {
        register message *msg;
        address gaddr, pg_local_lookup();
        register len;

        if((len = strlen(name)) > PG_GLEN-1)
            name[len = PG_GLEN-1] = 0;
        gaddr = pg_local_lookup(name);
        if(gaddr.site)
            return(gaddr);
        msg = msg_newmsg();
        msg_addfield(msg, CL_GNAME, name, FTYPE_CHAR, len+1);
        if(isis(CL_LOOKUP, msg, (char*)&gaddr, sizeof(address)) != sizeof(address))
            panic("pg_lookup: no result returned");
        msg_delete(msg);
        return(gaddr);
  }

gl_desc *
pg_list(gname)
  char *gname;
  {
        gl_desc *glp = 0, *gp;
        register message *mp = msg_genmsg(CL_GNAME, gname, FTYPE_CHAR, strlen(gname)+1, 0);
        register len = isis(CL_PGLIST, mp, (char*)&glp, AMALLOC);
        msg_delete(mp);
        return(glp);
  }

pg_delete(gaddr)
  address gaddr;
  {
        message *msg = msg_newmsg();
        address all_members[2];
        char answ[MAX_PROCS];
        int rval;

        if(pg_rank(gaddr, my_address) == -1)
            return(-1);
        all_members[0] = ADDRESS(-1, -1, -1, -1);
        all_members[1] = NULLADDRESS;
        msg_addfield(msg, CL_GID, (char*)&gaddr, FTYPE_ADDRESS, sizeof(address));
        msg_addfield(msg, CL_PNAME, (char*)all_members, FTYPE_ADDRESS, sizeof(all_members));
        msg_insertfield(msg, SYSFLD_VCHANGE, NULLARG, FTYPE_CHAR, 0);
        rval = gbcast_l("s", gaddr, GENERIC_DELETE, msg, ALL, "%c", answ);
        msg_delete(msg);
        if(rval == 0)
        {
            isis_errno = IE_TOTFAIL;
            return(-1);
        }
        return(0);
  }

pg_leave(gaddr)
  address gaddr;
  {
        message *msg = msg_newmsg();
        static address name[2];
        char answ[MAX_PROCS];
        int rval;

        name[0] = my_address;
        msg_addfield(msg, CL_GID, (char*)&gaddr, FTYPE_ADDRESS, sizeof(address));
        msg_addfield(msg, CL_PNAME, (char*)name, FTYPE_ADDRESS, sizeof(name));
        msg_insertfield(msg, SYSFLD_VCHANGE, NULLARG, FTYPE_CHAR, 0);
        rval = gbcast_l("s", gaddr, GENERIC_DELETE, msg, ALL, "%c", answ);
        msg_delete(msg);
        if(rval == 0)
        {
            isis_errno = IE_TOTFAIL;
            return(-1);
        }
        cl_do_del_pgroup(gaddr);
        return(0);
  }

pg_addclient(gaddr, pname)
  address gaddr, pname;
  {
        register message *msg = msg_newmsg();
        static address addrs[3], name[2];
        char answ[MAX_PROCS];
        int rval;

        name[0] = pname;
        msg_addfield(msg, CL_GID, (char*)&gaddr, FTYPE_ADDRESS, sizeof(address));
        msg_addfield(msg, CL_PNAME, (char*)name, FTYPE_ADDRESS, sizeof(name));
        addrs[0] = gaddr;
        addrs[0].entry = GENERIC_ADDCLIENT;
        addrs[1] = pname;
        addrs[1].entry = GENERIC_ADDCLIENT;
        msg_insertfield(msg, SYSFLD_VCHANGE, NULLARG, FTYPE_CHAR, 0);
        rval = gbcast_grow("ls", addrs, msg, ALL, "%c", answ);
        msg_delete(msg);
        if(rval == 0)
            return(IE_TOTFAIL);
        return(0);
  }

pg_delclient(gaddr, pname)
  address gaddr, pname;
  {
        message *msg = msg_newmsg();
        static address name[2];
        char answ[MAX_PROCS];
        int rval;

        name[0] = pname;
        msg_addfield(msg, CL_GID, (char*)&gaddr, FTYPE_ADDRESS, sizeof(address));
        msg_addfield(msg, CL_PNAME, (char*)name, FTYPE_ADDRESS, sizeof(name));
        msg_insertfield(msg, SYSFLD_VCHANGE, NULLARG, FTYPE_CHAR, 0);
        rval = gbcast_l("s", gaddr, GENERIC_DELETE, msg, ALL, "%c", answ);
        msg_delete(msg);
        if(rval == 0)
            return(IE_TOTFAIL);
        return(0);
  }


pg_signal(gaddr, signo)
  address gaddr, signo;
  {
        message *msg = msg_newmsg();
        char answ[MAX_PROCS];
        int rval;

        msg_addfield(msg, CL_SIGNO, (char*)&signo, FTYPE_LONG, sizeof(int));
        rval = gbcast_l("s", gaddr, GENERIC_SIGNAL, msg, ALL, "%c", answ);
        msg_delete(msg);
        if(rval == 0)
            return(IE_TOTFAIL);
        return(0);
  }

struct  pwatch
  {
        int         pw_uid;
        int         pw_act;
        int         (*pw_proc)();
        int         pw_viewid;
        char        *pw_arg;
        groupview   *pw_gv;
  };

static adesc    pw_adesc ={ sizeof(pwatch), 0, 8, };

#define pw_alloc()        ((pwatch*)mallocate(&pw_adesc))

pw_free(pw)
  pwatch *pw;
  {
        act_ev(-1, pw->pw_act, ACT_WATCH);
        mdeallocate((char*)pw, &pw_adesc);
  }

static  PWID;

groupview *pg_getlocalview();

pg_monitor(gaddr, routine, arg)
  address gaddr;
  ifunc *routine;
  char *arg;
  {
        register pwatch *pw = pw_alloc();
        register groupview *gv;
        int pg_pwatch_invoke();
        register act = isis_ctp->task_act;
        if(isis_state&ISIS_STARTUP)
            act = 0;
        pw->pw_uid = ++PWID;
        pw->pw_viewid = 0;
        pw->pw_act = act;
        act_ev(1, pw->pw_act, ACT_WATCH);
        pw->pw_proc = routine;
        pw->pw_arg = arg;
        (void)pg_add_pw(isis_pgmon, gaddr, pw, pw_free);
        if(isis_joining)
        {
            register pwatch *npw = pw_alloc();
            register ginfo *gip = map_gaddr(gaddr);
            gv = 0;
            if(gip && (gip->gi_view.gv_flag&PG_FIRST))
                gv = &gip->gi_view;
            if(gv == 0 && (gv = pg_getlocalview(gaddr)) == 0)
            {
                print("pg_monitor: group ");
                paddr(gaddr);
                print("unknown locally after a join...\n");
                return(PWID);
            }
            pw->pw_viewid = gv->gv_viewid;
            npw->pw_proc = routine;
            npw->pw_arg = arg;
            npw->pw_gv = gv;
            npw->pw_act = act;
            act_ev(1, npw->pw_act, ACT_WATCH);
            t_fork_urgent(pg_pwatch_invoke, npw);
        }
        return(PWID);
  }

pg_monitor_act(gaddr, routine, arg)
  address gaddr;
  ifunc *routine;
  char *arg;
  {
        register pwatch *pw = pw_alloc();
        register groupview *gv;
        int pg_pwatch_invoke();
        pw->pw_uid = ++PWID;
        pw->pw_act = isis_ctp->task_act;
        act_ev(1, pw->pw_act, ACT_WATCH);
        pw->pw_proc = routine;
        pw->pw_arg = arg;
        (void)pg_add_pw(isis_pgmon, gaddr, pw, pw_free);
        if(isis_joining && (gv = pg_getlocalview(gaddr)))
        {
            register pwatch *npw = pw_alloc();
            pw->pw_viewid = gv->gv_viewid;
            npw->pw_proc = routine;
            npw->pw_arg = arg;
            npw->pw_gv = gv;
            npw->pw_act = isis_ctp->task_act;
            act_ev(1, npw->pw_act, ACT_WATCH);
            t_fork_urgent(pg_pwatch_invoke, npw);
        }
        return(PWID);
  }

pg_unmonitor(gaddr)
  address gaddr;
  {
        register queue *pw;
        while(pw = pg_find(isis_pgmon, gaddr))
            qu_free(pw);
  }

pg_monitor_cancel(pwid)
  {
        register queue *qp;
        for(qp = isis_pgmon->qu_next; qp != isis_pgmon; qp = qp->qu_next)
        {
            register pwatch *pw = qp->qu_pwatch;
            if(pw->pw_uid == pwid)
            {
                qu_free(qp);
                return(0);
            }
        }
        return(-1);
  }

pg_pwatch_invoke(pw)
  register pwatch *pw;
  {
        isis_ctp->task_routine = pw->pw_proc;
        isis_ctp->task_arg0 = pw->pw_arg;
        isis_ctp->task_act = pw->pw_act;
        (*pw->pw_proc)(pw->pw_gv, pw->pw_arg);
        pw_free(pw);
  }

pg_new_view(gv)
  register groupview *gv;
  {
        register queue *qp, *nqp;
        for(qp = isis_pgmon->qu_next; qp != isis_pgmon; qp = nqp)
        {
            nqp = qp->qu_next;
            if(isis_mutex && qp->qu_pwatch->pw_act != isis_mutex)
                continue;
            if(addr_cmp(qp->qu_pname, gv->gv_gaddr) == 0 && qp->qu_pwatch->pw_viewid < gv->gv_viewid)
            {
                register pwatch *pw = pw_alloc();
                qp->qu_pwatch->pw_viewid = gv->gv_viewid;
                *pw = *qp->qu_pwatch;
                pw->pw_gv = gv;
                act_ev(1, pw->pw_act, ACT_WATCH);
                t_fork(pg_pwatch_invoke, pw);
            }
        }
        w_new_view(gv);
  }

pg_monitor_dump()
  {
        register queue *qp;
        for(qp = isis_pgmon->qu_next; qp != isis_pgmon; qp = qp->qu_next)
        {
            register pwatch *pw = qp->qu_pwatch;
            print("  [act %d wid %x]: Monitor gaddr ", pw->pw_act, pw->pw_uid);
            paddr(qp->qu_pname);
            print(". Call ");
            cl_rname(pw->pw_proc); 
            print("(%x)\n", pw->pw_proc, pw->pw_arg);
        }   
  }
