/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* Logging structures */

typedef struct req_nod  req_nod;
typedef struct log_nod  log_nod;
typedef struct log_hdr  log_hdr;

struct  req_nod                 /* Node for buffering logged messages */
{
        message *msg;           /* Request or log entry message */
        long tstamp;            /* Timestamp */
        int entry;              /* Message entry point */
        req_nod *prev, *next;   /* Previous and next nodes on write queue */
};

struct  log_hdr                 /* Log header placed at start of every log */
{
        int     is_ckpt;        /* Is there a checkpoint in this log? */
        int     ckpt_blks;      /* Number of blocks in checkpoint */
        int     ckpt_len;       /* Space occupied by checkpoint */
};

struct  log_nod                 /* Logging information for each logged group */
{
        char    *fname;         /* Unique process/pgroup key */
        char    *l_name;        /* Name of file containing log */
        FILE    *l_fp;          /* Log file pointer */
        int     (*end_replay)();/* End of replay processing routine */
        int     replay_entry;   /* Entry point for manual replay */
        int     I_recovered;    /* Did this process recover this group? */
        int     flush_type;     /* Auto or manual flush */
        int     wri_off;        /* Offset to write new log entries */
        long    last_ts;        /* Last timestamp of a completed flush block */
        int     log_reqs;       /* Number of requests in stable log */
        int     req_q_len;      /* Number of requests on request queue */
        int     next_req;       /* Next request number for replay */
        int     next_ts;        /* Timestamp of next request to replay */
        int     end_blk;        /* End of current block for replay */
        log_hdr l_hdr;          /* Log header */
        req_nod *req_q_hd;      /* Request queue head */
        req_nod *req_q_tl;      /* Request queue tail */
};

/* External variables and functions for logging */

extern int log_in_replay;       /* Flag for testing if a process is in the
                                   middle of replaying its logs */

extern log_nod  *log_init               ( /* char *fname, *gname, 
                                             int replay_entno, flush_type,
                                             int (*end_of_replay)() */ );
extern int      log_action              ( /* char *gname */ );
extern int      log_remove              ( /* char *gname */ );
extern int      log_start_recovery      ( /* char *gname */ );
extern int      log_has_ckpt            ( /* char *gname */ );
extern int      log_checkpoint          ( /* char *gname */ );
extern int      log_replay_ckpt         ( /* char *gname */ );
extern int      log_write_msg           ( /* ginfo *gip, message *msg,
                                             int entry */ );
extern int      log_write               ( /* address gaddr, message *msg */ );
extern int      logging_out             ( /* message *msg */ );
extern int      log_flush               ( /* address gaddr */ );
extern int      log_recovered           ( /* address gaddr */ );
extern int      log_end_log_msg();
extern int      log_replay_msgs();

/* Constants used by the log manager and its applications */

#define L_NOCKPT        0       /* No checkpoint present in this log */
#define L_CKPT          1       /* Checkpoint present in this log */
#define L_MANUAL        0       /* Group is being logged manually */
#define L_AUTO          1       /* Group is being logged automatically */
#define L_INIT          0       /* pg_join should initialize this group */
#define L_JOIN          1       /* pg_join should join, not create, this group */
#define L_RECOVER       2       /* pg_join should recover this group from log */
#define COUNT_THRESH    8       /* Number of requests to buffer before */
                                /* automatically flushing log of messages */
#define REQS_THRESH     250     /* Number of requests to write in log before */
                                /* automatically forcing a checkpoint */
#define LEN_THRESH      1048576 /* Log size at which checkpoint should be taken */
#define END_REPLAY      -1      /* End of replay marker */

/* Locations of log files and temporary files for log manager */

#define LOG_SUBDIR      "logs"
#define LOG_TTMPLT      "log_tempXXXXXX"
#define LOG_TSPEC       "log_temp*"


