/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* State transfer toolkit utility */


#define   ISIS_SYS
# include "isis.h"
 
#ifdef  GOULD 
# undef gould           /* Correct bizarre problem with va_arg on struct passed by value */  
#endif 
# include <varargs.h>

saddr   my_addr;                /* Set in cl_isis.c */

typedef struct
{
        address gaddr;
        int     domain;
        int     locator;
} x_where;

#define FTYPE_WHERE     FTYPE_LONG

#define SMALL                   1
#define BIG                     2

static  xfer_rcv_accept(), xfer_rcv_big(), xf_where();
int     xfer_rcv_small();
static  pg_join_req(), pg_client_req(), xfer_send(), pg_join_action(), pg_client_action();
static  pg_addmemb();
static  address join_gaddr;
static  xfer_listen, xfer_sock; 
static  xfer_in_progress;
static  condition xfer_done;
condition       wants_to_run_after_join;

join_init()
  {
        isis_entry(GENERIC_JOIN_REQ, pg_join_req, "cl_join:pg_join_req");
        isis_entry(GENERIC_CLIENT_REQ, pg_client_req, "cl_join:pg_client_req");
        isis_entry(GENERIC_XFER_STATE, xfer_rcv_small, "cl_join:xfer_rcv_small");
        isis_entry(GENERIC_XFER_WHERE, xf_where, "cl_join:xf_where");
        isis_task(xfer_rcv_accept, "cl_join:xfer_rcv_accept");
        isis_task(xfer_rcv_big, "cl_join:xfer_rcv_big");
        isis_task(xfer_send, "cl_join:xfer_send");
        isis_task(pg_join_action, "cl_join:pg_join_action");
        isis_task(pg_client_action, "cl_join:pg_client_action");
  }

/* Join the group arranging for a state transfer too */
address
pg_join(va_alist)
  va_dcl
  {
        va_list ap;
        char *gname;
        register groupview *gv;
        ifunc *pg_init_routine = NULLROUTINE, *pg_monitor_routine = NULLROUTINE;
        int old_act, pg_monitor_arg, code, recover = 0;
        int retry = 0, dont_create = 0, size = SMALL, incarn = 0, niter = 0, logged = 0;
        char *credentials = "", *logfname;
        message *mp;
        address gaddr, *adp;
        register ginfo *gip;

        va_start(ap);
        gname = va_arg(ap, char*);
        if(isis_joining)
            t_wait(&wants_to_run_after_join);
        isis_joining = gname;
        gip = add_gname(gname);
        isis_errno = 0;
        while(code = va_arg(ap, int)) switch(code)
        {
          case PG_INIT:
                pg_init_routine = va_arg(ap, ifunc*);
                continue;
          case PG_MONITOR:
                if(pg_monitor_routine != NULLROUTINE)
                {
                    isis_errno = IE_BADARG;
                err:isis_joining = 0;
                    t_sig_all(&wants_to_run_after_join, 0);
                    va_end(ap);
                    group_unmap(gip);
                    return(NULLADDRESS);
                }
                pg_monitor_routine = va_arg(ap, ifunc*);
                pg_monitor_arg = va_arg(ap, int);
                continue;
          case PG_JOIN_AUTHEN:
                pg_join_verifier(gname, va_arg(ap, ifunc*));
                continue;
          case PG_CLIENT_AUTHEN:
                pg_client_verifier(gname, va_arg(ap, ifunc*));
                continue;
          case PG_XFER:
                begin
                {
                    int dom;
                    ifunc *snd_proc, *rcv_proc;
                    dom = va_arg(ap, int);
                    snd_proc = va_arg(ap, ifunc*);
                    rcv_proc = va_arg(ap, ifunc*);
                    allow_xfers_xd(gname, XD_USER+dom, snd_proc, rcv_proc);;
                }
                continue;
          case PG_CREDENTIALS:
                credentials = va_arg(ap, char*);
                continue;
          case PG_LOGGED:
                ++logged;
                begin
                {
                    int lentry, flush_when;
                    ifunc *routine;
                    logfname = va_arg(ap, char*);
                    lentry = va_arg(ap, int);
                    flush_when = va_arg(ap, int);
                    routine = va_arg(ap, ifunc*);
                    log_init(logfname, gname, lentry, flush_when, routine);
                }
                continue;
          case PG_DONTCREATE:
                ++dont_create;
                continue;
          case PG_BIGXFER:
                size = BIG;
                continue;
          case PG_INCARN:
                incarn = va_arg(ap, int);
                continue;
          default:
                isis_errno = IE_BADARG;
                goto err;
        }
        if(logged)
        {
            switch(log_action(gname, &incarn))
            {
                case L_INIT:
                    /* Just do normal stuff */
                    break;
    
                case L_JOIN:
                    /* Must join */
                    --recover;
                    break;
    
                case L_RECOVER:
                    /* Legal to create (or join) but recover from log */
                    ++recover;
                    break;
            }
        }
        gaddr = pg_lookup(gname);
        retry = 1;
        while(addr_isnull(gaddr))
        {
            static address mlist[2];
            if(dont_create || recover < 0)
            {   
                isis_errno = recover? IE_MUSTJOIN: IE_UNKNOWN;
                goto err;
            }
            mlist[0] = my_address;
            gaddr = pg_create(gname, incarn, mlist, (address*)0);
            if(!addr_isnull(gaddr))
            {
                gip->gi_gaddr = gaddr;
                if(logged)
                    rmgr_start_log(gaddr, logfname);
                if(recover)
                    log_start_recovery(gname);
                if(recover == 0 || log_has_ckpt(gname) == 0)
                {
                    if(pg_init_routine)
                        (*pg_init_routine)(gaddr);
                }
                else
                    log_replay_ckpt(gname);
                if(pg_monitor_routine)
                    pg_monitor(gaddr, pg_monitor_routine, pg_monitor_arg);
                isis_joining = 0;
                t_sig_all(&wants_to_run_after_join, 0);
                va_end(ap);
                return(gaddr);
            }
            if(retry-- == 0)
            {
                log_remove(gname);
                isis_errno = IE_AGAIN;
                goto err;
            }
            sleep(1);
            gaddr = pg_lookup(gname);
        }
        if(gv = pg_getlocalview(gaddr))
            for(adp = gv->gv_members; !addr_isnull(*adp); adp++)
                if(addr_cmp(*adp, my_address) == 0)
                {
                    isis_joining = 0;
                    t_sig_all(&wants_to_run_after_join, 0);
                    va_end(ap);
                    return(gaddr);
                }
        xfer_in_progress = 1;
        if(isis_mutex == 0)
        {
            if(old_act = act_begin())
                act_ev(1, old_act, ACT_MSG);
            act_block();
        }
        else
            old_act = -1;
        gip->gi_gaddr = gaddr;
        mp = msg_gen("%a,%d,%s", gaddr, size, credentials);
        if(size == BIG)
        {
            int slen;
            /* Create socket for blast channel */
            if((xfer_listen = socket(AF_INET, SOCK_STREAM, 0)) == -1)
                panic("xfer socket");
            /* my_addr initialized in cl_isis.c */
            my_addr.sin_port = 0;
            if(bind(xfer_listen, (struct sockaddr*)&my_addr, sizeof(my_addr)) == -1)
            {
                perror("bind");
                panic("xfer bind");
            }
            slen = sizeof(saddr);
            getsockname(xfer_listen, (struct sockaddr*)&my_addr, &slen);
            msg_put(mp, "%C", &my_addr, sizeof(saddr));
            listen(xfer_listen, 5);
            isis_input(xfer_listen, xfer_rcv_accept, gip);
        }
  loop:
        if(cbcast_l("s", gaddr, GENERIC_JOIN_REQ, mp, 1, "%d", &isis_errno) == 0)
        {
            register groupview *gv = pg_getlocalview(gaddr);
            register address *ap;
            /*
             * Join failed... fatal if I got added to the group */
            if(gv)
                for(ap = gv->gv_members; !addr_isnull(*ap); ap++)
                    if(addr_cmp(*ap, my_address) == 0)
                        panic("was added to a group that failed totally during state xfer");
            /* Ok to try again */
            if(++niter < 3)
                goto loop;
            isis_errno = IE_TOTFAIL;
        }
        xfer_in_progress = 0;
        if(size == BIG)
        {
            isis_input(xfer_listen, NULLROUTINE, NULLARG);
            close(xfer_listen);
        }
        msg_delete(mp);
        if(old_act != -1)
        {
            act_restart();
            act_end(old_act);
            if(old_act)
                act_ev(-1, old_act, ACT_MSG);
        }
        if(isis_errno == 0 && pg_monitor_routine)
            pg_monitor(gaddr, pg_monitor_routine, pg_monitor_arg);
        isis_joining = 0;
        t_sig_all(&wants_to_run_after_join, 0);
        va_end(ap);
        if(isis_errno)
        {
            group_unmap(gip);
            return(NULLADDRESS);
        }
        if(logged && !addr_isnull(gaddr))
        {
            log_checkpoint(gname);
            rmgr_start_log(gaddr, logfname);
        }
        return(gaddr);
  }

static  x_where XWHERE;

/* Tell remote side where transfer has gotten to */
static
xf_where(mp)
  message *mp;
  {
        reply(mp, "%d,%d", XWHERE.domain, XWHERE.locator);
  }
/* Unpack a received message, calling the receive routine as needed */
xfer_rcv_unpack(gip, mp)
  register ginfo *gip;
  register message *mp;
  {
        register count = 0;
        message *msg;
        while(msg_get(mp, "%d,%d,%m", &XWHERE.domain, &XWHERE.locator, &msg) == 3)
        {
            if(gip->gi_xfer_rcv[XWHERE.domain] == NULLROUTINE)
            {
                print("Group address is "); paddr(gip->gi_gaddr);
                print(", name %s, domain %d\n", gip->gi_gname, XWHERE.domain);
                panic("rcv routine undefined!");
            }
            (*gip->gi_xfer_rcv[XWHERE.domain])(XWHERE.locator, msg);
            msg_delete(msg);
            ++count;
        }
        return(count);
  }

/* Receive a block of state, used only for small transfers */
/* ** NOTE: This code is roughly duplicated in cl_lmgr.c:log_replay_ckpt.
            Any changes should also be made there. */
xfer_rcv_small(mp)
  register message *mp;
  {
        int fn, len;
        address gaddr;
        register ginfo *gip;
        msg_get(mp, "%a", &gaddr);
        gip = map_gaddr(gaddr);
        if(gip == (ginfo*)0)
            panic("xfer_rcv_small: can't map gaddr %x/%x", gaddr);
        (void)xfer_rcv_unpack(gip, mp);
  }

static xfer_rcv_sock;

/* Set up a channel for reception in big mode */
static 
xfer_rcv_accept(gip)
  ginfo *gip;
  {
        extern isis_socket;
        message *msg_read();
        saddr from;
        int fromlen = sizeof(saddr);
        signal(SIGPIPE, NULLROUTINE);
        if((xfer_rcv_sock = accept(xfer_listen, (struct sockaddr*)&from, &fromlen)) == -1)
            panic("join_and_xfer: accept failed");
        isis_input(xfer_rcv_sock, xfer_rcv_big, gip);
  }

/* Receive xfer blocks in big mode */
static 
xfer_rcv_big(gip)
  ginfo *gip;
  {
        extern isis_socket;
        message *msg_read();
        register message *mp;
        XWHERE.domain = 0;
        XWHERE.locator = -1;
        signal(SIGPIPE, NULLROUTINE);
        while(xfer_in_progress && (mp = msg_read(xfer_rcv_sock)))
        {
            address gaddr;
            msg_get(mp, "%a", &gaddr);
            if(xfer_rcv_unpack(gip, mp) == 0)
                xfer_in_progress = 0;
            msg_delete(mp);
        }
        isis_input(xfer_rcv_sock, NULLROUTINE, NULLARG);
        close(xfer_rcv_sock);
  }

static    blocked;
static    condition want_join;

pg_join_inhibit(flag)
  {
        static join_inhibited;
        if(flag)
        {
            ++join_inhibited;
            isis_state |= ISIS_XJOINS;
        }
        else if(--join_inhibited == 0)
        {
            t_sig_all(&want_join, 0);
            isis_state &= ~ISIS_XJOINS;
        }
        else if(join_inhibited < 0)
            panic("inhibit_join(0) called more often than inhibit_join(1)");
  }


/* Called from cl_watch in cl_isis */
join_block()
  {
        act_block();
        ++blocked;
  }

/*
 * Receive an xfer request.
 */
static
pg_join_req(mp)
  register message *mp;
  {
        address gaddr, who;
        int pg_join_done(), cl_wid;
        static wants_to_join;

        ++wants_to_join;
        isis_state |= ISIS_WJOIN;
        who = msg_getsender(mp);
        msg_get(mp, "%a", &gaddr);
        cl_wid = cl_watch_for(gaddr, who);
        if(isis_state&ISIS_XJOINS)
            (void)t_wait_l(&want_join, "isis system: wants to do pg_join, but joins are inhibited");
        coord_cohort(mp, gaddr, pg_join_action, NULLROUTINE, NULLARG);
        cl_watch_cancel(gaddr, cl_wid);
        if(--wants_to_join == 0)
            isis_state &= ~ISIS_WJOIN;
        if(blocked && isis_ctp->task_act == isis_mutex)
        {
            act_restart();
            --blocked;
        }
  }

typedef struct
{
        address x_who;
        address x_gaddr;
        int     x_how;
        int     x_size;
        int     x_rval;
} xinfo;

/* This is the coordinator routine */
static 
pg_join_action(mp, gaddr, how)
  register message *mp;
  address gaddr;
  {
        address who;
        int wid, size;
        register ginfo *gip = map_gaddr(gaddr);
        char *credentials;
        xinfo xi;
        
        if(gip == (ginfo*)0)
            panic("pg_join_action: gaddr lookup failed");
        /* Verify join and do add_member operation; these are idempotent */
        isis_ctp->task_routine = pg_join_action;
        who = msg_getsender(mp);
        msg_get(mp, "%d,%-s", &size, &credentials);
        if(gip->gi_join_verifier == 0 || (xi.x_rval = (*gip->gi_join_verifier)(credentials)) == 0)
        {
            extern saddr my_addr;
            if(size == BIG)
            {
                saddr sock;
                msg_get(mp, "%C", &sock, (int*)0);
                xfer_sock = socket(AF_INET, SOCK_STREAM, 0);
                my_addr.sin_port = 0;
                if(bind(xfer_sock, (struct sockaddr*)&my_addr, sizeof(my_addr)) == -1)
                {
                    perror("bind xfer_socket");
                    panic("pg_join_action: init");
                }
                if(connect(xfer_sock, (struct sockaddr*)&sock, sizeof(saddr)) == -1)
                {
                    perror("connect");
                    xi.x_rval = IE_CONNECT;
                    goto done;
                }
            }
            xi.x_rval = 0;
            xi.x_who = who;
            xi.x_how = how;
            xi.x_size = size;
            xi.x_gaddr = gaddr;
            /* When join takes place, trigger the xfer_send routine */
            xfer_in_progress = 1;
            if((wid = pg_watch(gaddr, who, W_JOIN, xfer_send, (char*)&xi)) == 0)
                /* Already a member */
                xfer_send(gaddr, who, W_JOIN, &xi);
            else
            {
                join_gaddr = gaddr;
                if(xi.x_rval = pg_addmemb(gaddr, who))
                {
                    pg_watch_cancel(wid);
                    goto done;
                }
                if(xfer_in_progress)
                    t_wait_l(&xfer_done, "isis system: coordinator waiting for xfer_send to finish");
            }
        }
        else if(xi.x_rval == -1)
            xi.x_rval = IE_NOTALLOWED;
        
  done:
        if(xfer_sock)
            close(xfer_sock);
        reply(mp, "%d", xi.x_rval);
  }

#define FLUSH_XFER      4096    /* Transmit when it reaches this size */

static x_where where;
static xinfo *cur_xi;
static message *xfer_mp;
static making_checkpoint;

xfer_to_checkpoint(gaddr)
  address gaddr;
  {
        register ginfo *gip = map_gaddr(gaddr);
        static xinfo xi;
        cur_xi = &xi;
        xi.x_rval = 0;
        where.gaddr = gaddr;
        where.domain = 0;
        where.locator = -1;
        making_checkpoint = 1;
        do
        {
            if(gip->gi_xfer_gen[where.domain] == NULLROUTINE)
                continue;
            (*gip->gi_xfer_gen[where.domain])(where.locator, gaddr);
            where.locator = -1;
        }
        while(++where.domain != XD_MAX);
        if(xfer_mp)
            xfer_flush();
        making_checkpoint = 0;
  }

static
xfer_send(gaddr, who, event, xi)
  address gaddr, who;
  xinfo *xi;
  {
        register ginfo *gip = map_gaddr(xi->x_gaddr);
        cur_xi = xi;
        where.gaddr = xi->x_gaddr;
        if(event == W_FAIL)
            xi->x_rval = IE_TOTFAIL;
        if(xi->x_how == TAKEOVER)
        {
            /* Find out how far the transfer had gotten */
            if(bcast(xi->x_who, GENERIC_XFER_WHERE, "", 1, "%d,%d", &where.domain, &where.locator) != 1)
                xi->x_rval = IE_BROKEN;
        }
        else
        {
            where.domain = 0;
            where.locator = -1;
        }
        if(xi->x_rval == 0)
        {
            do
            {
                if(gip->gi_xfer_gen[where.domain] == NULLROUTINE)
                    continue;
                (*gip->gi_xfer_gen[where.domain])(where.locator, xi->x_gaddr);
                where.locator = -1;
            }
            while(xi->x_rval == 0 && ++where.domain != XD_MAX);
            if(xfer_mp)
                xfer_flush();
            if(xi->x_rval == 0 && xi->x_size == BIG)
            {
                xfer_mp = msg_newmsg();
                xfer_flush();
            }
        }
        xfer_in_progress = 0;
        t_sig(&xfer_done, 0);
  }

xfer_out(va_alist)
  va_dcl
  {
        va_list ap;
        message *mp;
        if(cur_xi->x_rval == IE_BROKEN)
            return;
        va_start(ap);
        where.locator = va_arg(ap, int);
        mp = msg_newmsg();
        msg_doputf(mp, SYSFLD_SCAN, &ap);
        if(xfer_mp == 0)
            xfer_mp = msg_gen("%a", where.gaddr);
        msg_put(xfer_mp, "%d,%d,%m", where.domain, where.locator, mp);
        msg_delete(mp);
        if(msg_getlen(xfer_mp) >= FLUSH_XFER)
            xfer_flush();
        va_end(ap);
  }

xfer_flush()
  {
        register xinfo *xi = cur_xi;
        if(xfer_mp == 0)
            return;
        if(making_checkpoint)
            logging_out(xfer_mp);
        else if(xi->x_size == SMALL)
            cbcast_l("s", xi->x_who, GENERIC_XFER_STATE, xfer_mp, 0);
        else if(msg_write(xfer_sock, xfer_mp) == -1)
            xi->x_rval = IE_BROKEN;
        msg_delete(xfer_mp);
        xfer_mp = 0;
  }

allow_xfers_xd(gname, xd, send_routine, rcv_routine)
  char *gname;
  register xd;
  ifunc *send_routine, *rcv_routine;
  {
        register ginfo *gip;
        register g;
        if(xd > XD_MAX || xd < 0)
            panic("allow_xfers_xd: xd %d", xd);
        if(gname != 0)
        {
            gip = add_gname(gname);
            gip->gi_xfer_gen[xd] = send_routine;
            gip->gi_xfer_rcv[xd] = rcv_routine;
        }
        else
        {
            def_xfer_gen[xd] = send_routine;
            def_xfer_rcv[xd] = rcv_routine;
            for(gip = isis_groups; gip; gip = gip->gi_next)
            {
                gip->gi_xfer_gen[xd] = send_routine;
                gip->gi_xfer_rcv[xd] = rcv_routine;
            }
        }
  }

pg_join_verifier(gname, routine)
  char *gname;
  ifunc *routine;
  {
        add_gname(gname)->gi_join_verifier = routine;
  }

pg_client_verifier(gname, routine)
  char *gname;
  ifunc *routine;
  {
        add_gname(gname)->gi_client_verifier = routine;
  }

address
pg_subgroup(gaddr, sgname, incarn, mlist, clist)
  address gaddr;
  char *sgname;
  address *mlist, *clist;
  {
        register groupview *gv = pg_getlocalview(gaddr);
        register address *mp, *ap;
        if(gv == 0)
            return(NULLADDRESS);
        for(mp = mlist; !addr_isnull(*mp); mp++)
        {
            for(ap = gv->gv_members; !addr_isnull(*ap); ap++)
                if(addr_cmp(*mp, *ap) == 0)
                    break;
            if(addr_isnull(*ap))
                return(NULLADDRESS);
        }
        for(mp = mlist; !addr_isnull(*mp); mp++)
            if(addr_ismine(*mp))
                break;
        if(addr_isnull(*mp))
            return(NULLADDRESS);
        return(pg_create(sgname, incarn, mlist, clist));
  }

static address
pg_create(gname, incarn, mlist, clist)
  char *gname;
  address *mlist, *clist;
  {
        message *msg = msg_newmsg();
        address gaddr, alist[MAX_PROCS];
        register address *ap, *mp;

        if(strlen(gname) > PG_GLEN-1)
            gname[PG_GLEN-1] = 0;
        ap = alist;
        for(mp = mlist; mp && !addr_isnull(*mp); ++mp)
            *ap++ = *mp;
        *ap++ = NULLADDRESS;
        for(mp = clist; mp && !addr_isnull(*mp); ++mp)
            *ap++ = *mp;
        *ap++ = NULLADDRESS;
        msg_addfield(msg, CL_PNAME, (char*)alist, FTYPE_ADDRESS, sizeof(address)*(ap-alist));
        if(gname)
            msg_addfield(msg, CL_GNAME, gname, FTYPE_CHAR, strlen(gname)+1);
        msg_addfield(msg, CL_INCARN, (char*)&incarn, FTYPE_LONG, sizeof(incarn));
        if(isis(CL_CREATE, msg, (char*)&gaddr, sizeof(gaddr)) != sizeof(gaddr))
            panic("pg_create: no GID returned");
        msg_delete(msg);
        return(gaddr);
  }

static
pg_addmemb(gaddr, pname)
  address gaddr, pname;
  {
        register message *msg = msg_newmsg();
        static address addrs[3], name[2];
        char answ[MAX_PROCS];
        int rval;

        name[0] = pname;
        msg_addfield(msg, CL_GID, (char*)&gaddr, FTYPE_ADDRESS, sizeof(address));
        msg_addfield(msg, CL_PNAME, (char*)name, FTYPE_ADDRESS, sizeof(name));
        addrs[0] = gaddr;
        addrs[0].entry = GENERIC_ADDMEMB;
        addrs[1] = pname;
        addrs[1].entry = GENERIC_ADDMEMB;
        msg_insertfield(msg, SYSFLD_VCHANGE, NULLARG, FTYPE_CHAR, 0);
        rval = gbcast_grow("ls", addrs, msg, ALL, "%b", answ);
        msg_delete(msg);
        if(rval == 0)
            return(IE_TOTFAIL);
        return(0);
  }

pg_client(gaddr, credentials)
  address gaddr;
  char *credentials;
  {
        int rval, err;
        if((rval = bcast(gaddr, GENERIC_CLIENT_REQ, "%a/%s", gaddr, credentials, 1, "%d", &err)) == 1)
        {
            if((isis_errno = err) == 0)
                return(0);
            return(-1);
        }
        else if(rval == 0)
            isis_errno = IE_TOTFAIL;
        return(-1);
  }

static
pg_client_req(mp)
  register message *mp;
  {
        static pg_client_action();
        address gaddr;
        if(msg_get(mp, "%a", &gaddr) != 1)
            panic("pg_client_req");
        coord_cohort(mp, gaddr, pg_client_action, NULLROUTINE, NULLARG);
  }

static
pg_client_action(mp, gaddr, how)
  register message *mp;
  address gaddr;
  {
        char *credentials;
        register ginfo *gip;
        if(msg_get(mp, "%-s", &credentials) != 1)
            panic("pg_client_action");
        if((gip = map_gaddr(gaddr)) == (ginfo*)0)
            reply(mp, "%d", IE_UNKNOWN);
        else if(gip->gi_client_verifier && (*gip->gi_client_verifier)(credentials) == -1)
            reply(mp, "%d", IE_NOTALLOWED);
        else if(pg_addclient(gaddr, msg_getsender(mp)) == 0)
            reply(mp, "%d", 0);
        else
            reply(mp, "%d", isis_errno);
  }
