/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      Basic client->isis interface
 */

#define GENERIC_ENTRIES
#define ISIS_ERRORS
#define ISIS_SYS

# include "isis.h"

#ifdef UNIX_DOM
#include <sys/un.h>
#endif

/*  Sleep reverts to its normal meaning in this module! */
#undef  sleep
int     sleep();

struct  servent *getservbyname();
int     cl_local_delivery();
message *msg_read();

saddr   my_addr;
static  ifunc *msg_filter = cl_local_delivery;
static  queue *msg_queue, *msg_mutexqueue, *time_queue;
int     ISIS_TIME;
static  struct timeval time_0;
static  isis_setmax(), work_to_do(), isis_dosend();

int
find_act(a)
  address a;
  /* Inverse of map_act. */
  {
        register act;
        for(act = 0; act != MAX_ACT; act++)
        {
            if(ACT_VALID(act) && addr_cmp(act_map[act].act_id, a) == 0)
                return(act);
        }
        return(-1);
  }

int     act_bits = 1;   /* Actually in use */

isis_overflow()
  {
        panic("protos -> client channel backlog overflow!");
  }

#ifdef UNIX_DOM
static struct sockaddr_un ux_addr, ux_iaddr;
#endif

do_cl_dump()
  {
        print("Received signal CLDUMP.  Spooling dump into %d.log\n", getpid());
        isis_logging(1);
        cl_dump(DUMP_ALL, "received signal 1");
        isis_logging(0);
  }


#define IRETURN(code)  { if(my_process_id == ISIS) return(code); else exit(code); }

extern int pushes_by_ref;

/* Initialize to use ISIS facilities */
isis_init(CLIENT_PORT)
  {
        register i;
        int cl_rcv_reply(), cl_new_view(), cl_del_pgroup();
        int cl_register(), act_block(), run_tasks();
        struct hostent *hep, *gethostbyname(), BCAST();
        static saddr isis_addr;
        static first_time = 0;
        static isis_setmax();

        if(isis_state&ISIS_INIT)
            return(0);
        isis_state |= ISIS_INIT|ISIS_STARTUP;
        signal(1, do_cl_dump);
        isis_state |= ISIS_STARTUP;
        isis_forkcnt = 0;
        signal(SIGUSR1, isis_overflow);
        if(first_time++ == 0)
        {
            saddr true_name;
            int size = sizeof(true_name);
	    if(pushes_by_ref == -1)
	        check_varargs();
            if(my_process_id == 0)
                my_process_id = getpid();
            gettimeofday(&time_0, (struct timezone*)0);
            gethostname(my_host, 64);
            if((hep = gethostbyname(my_host)) == 0)
                panic("gethostbyname(%s)", my_host);
            my_addr.sin_family = AF_INET;
            bcopy(hep->h_addr, &my_addr.sin_addr, hep->h_length);
            if((intercl_socket = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
            {
                perror("socket");
                isis_state &= ~(ISIS_INIT|ISIS_STARTUP);
                IRETURN(-1);
            }
            isis_setmax(intercl_socket);
            my_addr.sin_port = 0;
            if(bind(intercl_socket, (struct sockaddr*)&my_addr, sizeof(my_addr)) == -1)
            {
                perror("bind intercl_socket");
                close(intercl_socket);
                isis_state &= ~(ISIS_INIT|ISIS_STARTUP);
                IRETURN(-1);
            }
            if(getsockname(intercl_socket, (struct sockaddr*)&true_name, &size) != 0)
                panic("getsockname failed");
            my_port_no = ntohs(true_name.sin_port);
            qu_freelist = qu_null();
            isis_wlist = qu_null();
            isis_pwlist = qu_null();
            isis_pgmon = qu_null();
            isis_tasks = qu_null();
            msg_queue = qu_null();
            msg_mutexqueue = qu_null();
            time_queue = qu_null();
            isis_entry(GENERIC_RCV_REPLY, cl_rcv_reply, "isis-clib:cl_rcv_reply");
            isis_entry(GENERIC_NEW_VIEW, cl_new_view, "isis-clib:cl_new_view");
            isis_entry(GENERIC_DEL_PGROUP, cl_del_pgroup, "isis-clib:cl_del_pgroup");
            isis_task(cl_register, "isis-clib:cl_register");
            isis_task(act_block, "isis-clib:act_block");
            isis_task(BCAST, "isis-clib:bcast");
        }
#ifdef  UNIX_DOM
        /* Create a UNIX domain socket to connect to ISIS on */
        if((isis_socket = socket(AF_UNIX, SOCK_STREAM, 0)) == -1)
        {
            perror("socket");
            isis_state &= ~(ISIS_INIT|ISIS_STARTUP);
            IRETURN(-1);
        }
        ux_addr.sun_family = AF_UNIX;
        sprintf(ux_addr.sun_path, "/tmp/Cl%d", my_process_id);
        unlink(ux_addr.sun_path);
        if(bind(isis_socket, (struct sockaddr*)&ux_addr, sizeof(my_addr)) == -1)
        {
            perror("bind isis_socket");
            close(isis_socket);
            isis_state &= ~(ISIS_INIT|ISIS_STARTUP);
            IRETURN(-1);
        }
        if(CLIENT_PORT == 0)
        {
            register struct servent *sp = getservbyname("isis", "tcp");
            if(sp == (struct servent*)0)
                panic("isis.*: service not listed in /etc/services on this host");
            CLIENT_PORT = sp->s_port;
        }
        ux_iaddr.sun_family = AF_UNIX;
        sprintf(ux_iaddr.sun_path, "/tmp/Is%d", CLIENT_PORT);
        if(connect(isis_socket, (struct sockaddr*)&ux_iaddr, sizeof(my_addr)) == -1)
        {
            unlink(ux_addr.sun_path);
            isis_state &= ~(ISIS_INIT|ISIS_STARTUP);
            if(my_process_id == ISIS)
                return(-1);
            print("isis_init: connect failed, isis is not currently running\n");
            IRETURN(-1);
        }
#else   UNIX_DOM
        /* Create a TCP socket to connect to ISIS on */
        if((isis_socket = socket(AF_INET, SOCK_STREAM, 0)) == -1)
        {
            perror("socket");
            isis_state &= ~(ISIS_INIT|ISIS_STARTUP);
            IRETURN(-1);
        }
        if(bind(isis_socket, (struct sockaddr*)&my_addr, sizeof(my_addr)) == -1)
        {
            perror("bind isis_socket");
            close(isis_socket);
            isis_state &= ~(ISIS_INIT|ISIS_STARTUP);
            IRETURN(-1);
        }
        if(CLIENT_PORT == 0)
        {
            register struct servent *sp = getservbyname("isis", "tcp");
            if(sp == (struct servent*)0)
                panic("isis.*: service not listed in /etc/services on this host");
            CLIENT_PORT = sp->s_port;
        }
        isis_addr = my_addr;
        isis_addr.sin_port = htons((short)CLIENT_PORT);
        if(connect(isis_socket, &isis_addr, sizeof(isis_addr)) == -1)
        {
            perror("connect");
            close(isis_socket);
            isis_state &= ~(ISIS_INIT|ISIS_STARTUP);
            exit(-1);
        }
#endif  UNIX_DOM
        isis_setmax(isis_socket);
        notify_set_input_func(run_tasks, run_tasks, isis_socket);
        t_init();
        /* Register with ISIS and get various stuff back */
        begin
        {
            int cl_register();
            message *msg;
            register cinfo *ci;

            if((msg = msg_read(isis_socket)) == NULLMP)
                panic("*** msg_read failed in isis_init ***");
            ci = (cinfo*)msg_getfield(msg, FLD_ANSW, 1, NULLIARG);
            if(ci == 0)
                panic("isis_init: no ANSW field (%d) in initial ISIS connect msg", FLD_ANSW);
            my_site_no = ci->ci_my_site_no;
            my_site_incarn = ci->ci_my_site_incarn;
            my_site_id = ci->ci_my_site_id;
            my_genid = ci->ci_genid;
            my_address = ADDRESS(my_site_no, my_site_incarn, my_process_id, 0);
            my_address.portno = my_port_no;
            isis_sv = ci->ci_cur_sview;
            strcpy(isis_dir, ci->ci_isisdir);
            bcopy(ci->ci_site_names, site_names, sizeof(site_names));
            bcopy(site_names[my_site_no], my_host, sizeof(my_host));
            msg_delete(msg);
            act_begin();
            act_block();
            t_fork(cl_register, 0);
        }
  skip_connect:
        bclr(my_bcastscope);
        coord_init();
        sv_init();
        join_init();
        w_init();
        tk_init();
        gd_init();
        intercl_init();
        bypass_init();
        x_init();
        isis_state |= ISIS_ISUP;
        return(0);
  }

isis_start_done()
  {
        if((isis_state&ISIS_STARTUP) == 0)
            return;
        isis_state &= ~ISIS_STARTUP;
        act_restart();
        act_end(0);
        log_replay_msgs();
  }

isis_disconnect()
  {
        isis_has_crashed(NULLARG);
  }

struct cl_watch
{
        address clw_gaddr;
        address clw_who;
        int     clw_act;
};

/*
 * Special act_block support for joins 
 */
static adesc cl_wad ={ sizeof(cl_watch), sizeof(cl_watch), 2 };
#define clw_alloc()     ((cl_watch*)mallocate(&cl_wad))

clw_free(clp)
  register cl_watch *clp;
  {
        mdeallocate((char*)clp, &cl_wad);
  }

cl_watch_for(gaddr, who)
  address gaddr, who;
  {
        static CL_WID;
        register cl_watch *clw;
        register ginfo *gip = map_gaddr(gaddr);
        register address *ap;
        register groupview *gv;
        gv = isis_mutex? &gip->gi_mutexview: &gip->gi_view;
        for(ap = gv->gv_members; !addr_isnull(*ap); ap++)
            if(addr_cmp(*ap, who) == 0)
            {
                print("cl_watch_for: "); paddr(who);
                print("is already a member of "); paddr(gaddr);
                print("\n");
                panic("cl_watch_for");
            }
        clw = clw_alloc();
        clw->clw_gaddr = gaddr;
        clw->clw_who = who;
        clw->clw_act = isis_ctp->task_act;
        qu_add_clw(gip->gi_clwatchq, ++CL_WID, clw, clw_free);
        return(CL_WID);
  }

cl_watch_cancel(gaddr, cl_wid)
  address gaddr;
  {
        register ginfo *gip = map_gaddr(gaddr);
        register queue *qp;
        if(qp = qu_find(gip->gi_clwatchq, cl_wid))
            qu_free(qp);
  }

dump_cl_watch_queue()
  {
        register ginfo *gip;
        register queue *qp;
        for(gip = isis_groups; gip; gip = gip->gi_next)
            for(qp = gip->gi_clwatchq->qu_next; qp != gip->gi_clwatchq; qp = qp->qu_next)
            {
                register cl_watch *clw = qp->qu_clw;
                print("  [CLWID %d]: Group ", qp->qu_name);
                paddr(clw->clw_gaddr);
                print(" waiting for join of client ");
                paddr(clw->clw_who);
                print("\n");
            }
  }

static  jbviewid;

/* Trigger join watches before other things get triggered */
check_cl_watch_queue(mp)
  register message *mp;
  {
        register queue *qp;
        register sys_groupview *npg = (sys_groupview*)msg_getfield(mp, CL_NEWVIEW, 1, (int*)0);
        register ginfo *gip = map_gaddr(npg->pg_gid);

        if(gip == (ginfo*)0)
            return;
        if(gip->gi_clwatchq->qu_viewid > npg->pg_viewid)
            panic("check_cl_watch_queue: viewid was %d backed down to %d\n", gip->gi_clwatchq->qu_viewid, npg->pg_viewid);
        if(gip->gi_clwatchq->qu_viewid == npg->pg_viewid)
            return;
        if(gip->gi_clwatchq->qu_viewid == 0)
            gip->gi_clwatchq->qu_viewid = npg->pg_viewid;
        else if(++gip->gi_clwatchq->qu_viewid != npg->pg_viewid)
            panic("check_cl_watch_queue: expected viewid %d skipped to %d\n", gip->gi_clwatchq->qu_viewid, npg->pg_viewid);
        for(qp = gip->gi_clwatchq->qu_next; qp != gip->gi_clwatchq; qp = qp->qu_next)
        {
            register cl_watch *clw = qp->qu_clw;
            register address *ap;
            for(ap = npg->pg_alist; !addr_isnull(*ap); ap++)
                if(addr_isequal(clw->clw_who, *ap))
                {
                    int join_block();
                    int save_act = isis_ctp->task_act;
                    isis_ctp->task_act = clw->clw_act;
                    qu_free(qp);
                    jbviewid = gip->gi_clwatchq->qu_viewid;
                    t_fork_urgent(join_block, 0);
                    isis_ctp->task_act = save_act;
                    return;
                }
        }
  }

int     isis_mask_bits = 32;
static  ifunc *isis_handler[128];
static  char *isis_hargs[128];
static  isis_hact[128];
static  bitvec sel_mask[MAX_ACT], sig_vec;
static  sig_count[128];
static  ifunc *isis_shandler[128];
static  char *isis_sargs[128];
static  condition *isis_conds[128];

static
isis_setmax(fdes)
  register fdes;
  {
        while(isis_mask_bits <= fdes)
            isis_mask_bits += 32;
  }

isis_input(fdes, handler, arg)
  ifunc *handler;
  char *arg;
  {
        if(fdes < 0 || fdes >= 128)
            panic("isis_input: bum file descriptor %d", fdes);
        isis_setmax(fdes);
        isis_handler[fdes] = handler;
        isis_hargs[fdes] = arg;
        isis_hact[fdes] = isis_ctp->task_act;
        isis_conds[fdes] = 0;
        if(handler != NULLROUTINE)
        {
            bis(sel_mask[0], fdes);
            bis(sel_mask[isis_ctp->task_act], fdes);
        }
        else
        {
            bic(sel_mask[0], fdes);
            bic(sel_mask[isis_ctp->task_act], fdes);
        }
  }

isis_input_sig(fdes, cond, arg)
  condition *cond;
  char *arg;
  {
        if(cond == 0)
            isis_input(fdes, NULLROUTINE, NULLARG);
        else
        {
            isis_input(fdes, isis_input_sig, arg);
            isis_conds[fdes] = cond;
        }
  }

static  isis_maxsig = -1;

static isis_sdispatch(sig)
  {
        bis(sig_vec, sig);
        if(isis_maxsig < sig)
            isis_maxsig = sig;
        ++sig_count[sig];
  }

isis_signal(signo, handler, arg)
  ifunc *handler;
  char *arg;
  {
        isis_shandler[signo] = handler;
        isis_sargs[signo] = arg;
        signal(signo, isis_sdispatch);
  }

static  condition accept_events;
static  struct timeval sel_poll = { 0, 0 };

fork_sighandlers()
  {
        register save = isis_ctp->task_act, i;
        for(i = 0; i <= isis_maxsig; i++)
            if(bit(sig_vec, i))
                while(sig_count[i])
                {
                    isis_ctp->task_act = 0;
                    t_fork(isis_shandler[i], isis_sargs[i]);
                    --sig_count[i];
                }
        isis_ctp->task_act = save;
        bclr(sig_vec);
        isis_maxsig = -1;
  }

isis_mainloop(routine)
  ifunc *routine;
  {
        if(routine)
            t_fork(routine, 0)->task_flag |= TASK_START;
        else
            isis_start_done();
        run_isis(1);
  }

run_tasks()
  {
        run_isis(0);
  }

int     suntools_loaded = 1;    /* Zeroed in "sun_dummy.c" if NOT loaded */

run_isis(cont)
  {
        extern intercl_xmits;
        static work_to_do();
        bitvec imask;
        do
        {
            register m, i;
            struct timeval sel_wait, *tp = &sel_wait;
            isis_runtasks();
            if((isis_state&ISIS_INIT) == 0)
                 return(-1);
            imask = sel_mask[isis_mutex];
            bis(imask, isis_socket);
            bis(imask, intercl_socket);
            if(isis_mutex == 0 && isis_maxsig >= 0)
            {
                 fork_sighandlers();
                 continue;
            }
            /* RACE CONDITION HYPOTHESIZED BY FRANK HERE! */
            if(cont == 0 || accept_events)
                 tp = &sel_poll;
            else if(isis_runqueue == 0)
            {
                register queue *qp;
                if(qp = qu_head(time_queue))
                {
                    register time = qp->qu_time-isis_gettime();
                    if(time < 250)
                        time = 250;
                    sel_wait.tv_sec = time/1000;
                    sel_wait.tv_usec = (time % 1000)*1000;
                }
                else
                    tp = (struct timeval*)0;
            }
            /* select only gets done if suntools is not loaded or tp will be null */
            while(select(isis_mask_bits, &imask, NULLIARG, NULLIARG, tp) == -1)
                if(errno != EINTR)
                {
                    perror("select");
                    return(-2);
                }
                else
                {
                    bclr(imask);
                    break;
                }
            if(tp || btst(imask))
                ISIS_TIME = isis_gettime();
            if(isis_mutex == 0 && isis_maxsig >= 0)
                fork_sighandlers();
            if(bitv(imask, sel_mask[isis_mutex]))
            {
                int save = isis_ctp->task_act;
                for(i = 0; i < isis_mask_bits; i++)
                    if(bit(imask, i) && isis_handler[i] != NULLROUTINE)
                    {
                        isis_ctp->task_act = isis_hact[i];
                        if(isis_handler[i] != isis_input_sig)
                            t_fork(isis_handler[i], isis_hargs[i]);
                        else if(t_waiting(isis_conds[i]))
                            t_sig(isis_conds[i], isis_hargs[i]);
                        else
                            panic("no task waiting for input on fdes %d (cond %x)\n", i, isis_conds[i]);
                    }
                isis_ctp->task_act = save;
            }
            if(bit(imask, isis_socket))
                isis_read();
            intercl_xmits = 0;
            if(bit(imask, intercl_socket))
                intercl_do_input();
            begin
            {    
                register queue *qp;
                while(qp = qu_head(time_queue))
                    if(qp->qu_time <= ISIS_TIME)
                    {
                        qu_remove(qp);
                        qu_free(qp);
                        continue;
                    }
                    else
                        break;
            }
            if(!btst(imask) && accept_events && !work_to_do())
                t_sig(&accept_events, 0);
        }
        while(cont || work_to_do());
  }

/* Accept any pending events, run corresponding tasks... return to caller when done */
isis_accept_events()
  {
        (void)t_wait_l(&accept_events, "isis system: suspended in isis_accept_events");
  }

static work_to_do()
  {
        if(qu_head(isis_runqueue))
            return(1);
        if(tank_status() != TANK_EMPTY)
            return(1);
        if(isis_mutex)
            return(qu_head(msg_mutexqueue) != NULLQP);
        return(qu_head(msg_queue) != NULLQP);
  }

condition       test_waiting;
/*
 *      Basic algorithm:
 *              Input one message
 *              Run it, and anything it choses to t_fork off
 *              Loop
 */
isis_runtasks()
 {
        register found_one, save_act;
        static running_tasks;

        if(running_tasks++)
            panic("recursive entry to isis_runtasks");
        do
        {
            register queue *qp, *nqp, *mq;
            register task *tp;
            while((tp = task_dequeue(&isis_runqueue)) != &isis_scheduler)
                task_swtch(tp, NULLROUTINE, NULLARG);
            /* No tasks left to run... scan message queue and see if anything can be processed */
            found_one = 0;
            mq = isis_mutex? msg_mutexqueue: msg_queue;
            if(qp = qu_head(mq))
            {
                register message *mp = qp->qu_msg;
                register address *ap;
                register entry;
                ++found_one;
                save_act = isis_ctp->task_act;
                if((isis_ctp->task_act = qp->qu_act) == 0 && isis_mutex)
                    isis_ctp->task_act = isis_mutex;
                entry = -1;
                ap = msg_getdests(mp);
                do
                {
                    if(addr_ismine(*ap))
                        if(entry == -1)
                            entry = ap->entry;
                        else
                        {
                            entry = -1;
                            break;
                        }
                    ++ap;
                }
                while(!addr_isnull(*ap));
                
                if(isis_mutex == 0 && entry == GENERIC_NEW_VIEW)
                {
                     check_cl_watch_queue(mp);
                     if(isis_mutex)
                         continue;
                }
                qu_remove(qp);
                if(entry == GENERIC_RCV_REPLY)
                    cl_rcv_reply(mp);
                else if(t_waiting(&test_waiting) && entry == 2)
                    t_sig(&test_waiting, 0);
                else
                    (*msg_filter)(mp); 
                act_ev(-1, qp->qu_act, ACT_MSG);
                isis_ctp->task_act = save_act;
                qu_free(qp);
            }

            /* Now check the message ``tank'' for cl-cl messages */
            if(tank_status() != TANK_EMPTY)
            {
                ++found_one;
                intercl_deliver();
            }
        }
        while(found_one);
        --running_tasks;
  }

cl_register()
  {
        int pid[2];
        register message *msg;
        pid[0] = my_process_id;
        pid[1] = my_port_no;
        msg = msg_genmsg(CL_PID, (char*)pid, FTYPE_LONG, sizeof(pid), 0);
        if(isis(CL_REGISTER, msg, (char*)&my_site_incarn, sizeof(int)) != sizeof(int))
            panic("CL_REGISTER foulup");
        my_address = ADDRESS(my_site_no, my_site_incarn, my_process_id, 0);
        my_address.portno = my_port_no;
        msg_delete(msg);
  }

int   ISIS_MSGID;

/* Do a system call and copy the answer to the designated place */
isis(ent, msg, answ, alen)
  message *msg;
  char *answ;
  {
        register message *rmsg;
        message *collect_reply();
        char *ptr;
        int len, msgid = isis_ctp->task_msgid;
        static isis_dosend();
        if(msgid == 0)
            msgid = (ISIS_MSGID += 2)+1;
        msg_insertfield(msg, SYSFLD_MSGID, (char*)&msgid, FTYPE_LONG, sizeof(int));
        isis_dosend(PRO(ent), msg);
        rmsg = collect_reply(msgid);
        isis_ctp->task_msgid = 0;
        if(alen && (ptr = msg_getfield(rmsg, FLD_ANSW, 1, &len)))
        {
            if(len)
                if(alen == AMALLOC)
                    bcopy(ptr, (*(char**)answ) = (char*)malloc(len), len);
                else if(len <= alen)
                    bcopy(ptr, answ, len);
                else
                    bcopy(ptr, answ, alen);
            msg_delete(rmsg);
            return(len);
        }
        msg_delete(rmsg);
        if(alen == 0)
            return(0);
        return(-1);
  }

/* Send a message and wait for the response.  */
message *
isis_rpc(dest, msg, pause_flag)
  address dest;
  message *msg;
  {
        message *collect_reply();
        int msgid = isis_ctp->task_msgid;
        if(msgid == 0)
            msgid = (ISIS_MSGID += 2)+1;
        if((isis_state&ISIS_INIT) == 0)
            panic("attempt to send to ISIS failed: must call isis_init first!");
        msg_insertfield(msg, SYSFLD_MSGID, (char*)&msgid, FTYPE_LONG, sizeof(int));
        msg_setdest(msg, dest);
        if(isis_ctp->task_act)
            msg_insertfield(msg, SYSFLD_ACT, (char*)&act_map[isis_ctp->task_act].act_id, FTYPE_ADDRESS, sizeof(address));
        msg_write(isis_socket, msg);
        if(pause_flag)
            t_wait_l(&isis_runqueue, "isis system: pausing before collecting syscall reply");
        return(collect_reply(msgid));
  }

/* Send this message to the designated entry point */
isis_send(dest, msg)
  address dest;
  message *msg;
  {
        int msgid = isis_ctp->task_msgid;
        if(msgid == 0)
            msgid = (ISIS_MSGID += 2);
        if((isis_state&ISIS_INIT) == 0)
            panic("attempt to send to ISIS failed: must call isis_init first!");
        msg_insertfield(msg, SYSFLD_MSGID, (char*)&msgid, FTYPE_LONG, sizeof(int));
        isis_dosend(dest, msg);
  }

static isis_dosend(dest, msg)
  address dest;
  message *msg;
  {
        msg_setdest(msg, dest);
        if(isis_ctp->task_act)
            msg_insertfield(msg, SYSFLD_ACT, (char*)&act_map[isis_ctp->task_act].act_id, FTYPE_ADDRESS, sizeof(address));
        msg_write(isis_socket, msg);
  }

/*
 * Drain any messages for this process... and
 * notice if ISIS is congested while I'm at it
 */
isis_input_drain()
  {
        bitvec imask;
        bclr(imask);
        forever
        {
            bis(imask, isis_socket);
            if(select(isis_mask_bits, &imask, NULLIARG, NULLIARG, (isis_state&ISIS_CONGESTED)? 0: &sel_poll) != 1)
                return;
            isis_read();
        }
  }

static  condition isis_decongested;

/*
 * To preserve the semantics of async. broadcasts must block on congestion
 * if no replies were wanted (else could violate non-preemption rule).
 * Otherwise, safe to block on condition variable, since must block to
 * collect replies in any case
 */
isis_decon_wait(nwant)
  {
        if(nwant == 0)
        {
            isis_ctp->task_flag |= TASK_CONGESTED;
            while(isis_state&ISIS_CONGESTED)
                isis_read();
            isis_ctp->task_flag &= ~TASK_CONGESTED;
        }
        else
            t_wait_l(&isis_decongested, "isis system: congested; waiting until drained");
  }

isis_read()
  {
        register message *mp;
        if(mp = msg_read(isis_socket))
            isis_gotmsg(mp, BYP_CHECK);
  }

isis_gotmsg(mp, flag)
  register message *mp;
  {
        register address *ap;
        register act = -1;
        register *msgid;
        if(flag == BYP_CHECK)
        {
            register address *gaddr;
            if(gaddr = (address*)msg_getfield(mp, SYSFLD_BYINFO, 1, 0))
            {
                bypass_recv(gaddr, mp);
                return;
            }
        }
        if(msgid = (int*)msg_getfield(mp, SYSFLD_MSGID, 1, NULLIARG))
            if(*msgid > ISIS_MSGID)
                ISIS_MSGID = (*msgid & ~1);
        if(ap = (address*)msg_getfield(mp, SYSFLD_ACT, 1, NULLIARG))
        {
            register i;
            for(i = 0; i != MAX_ACT; i++)
                if(ACT_VALID(i) && addr_cmp(act_map[i].act_id, *ap) == 0)
                {
                    act = i;
                    break;
                }
            if(act == -1)
                act = act_start(*ap, 0);
        }
        else
            act = 0;
        /* Note: <dp> is a list... safe to switch on <entry> only for certain generic entries! */
        switch(msg_getdests(mp)->entry)
        {
          case GENERIC_WANTDUMP:
            print("Received \"snapshot\" dump request.  Spooling dump into %d.log\n", getpid());
            isis_logging(1);
            cl_dump(DUMP_ALL, "received snapshot request");
            isis_logging(0);
            break;

          case GENERIC_CONGESTED:
            isis_state |= ISIS_CONGESTED;
            msg_delete(mp);
            break;

          case GENERIC_DECONGESTED:
            isis_state &= ~ISIS_CONGESTED;
            t_sig_all(&isis_decongested, 0);
            msg_delete(mp);
            break;

          case GENERIC_NEW_SNAMES:
            begin
            {
                char *sn;
                int sl;
                sn = msg_getfield(mp, CL_NEW_SNAMES, 1, &sl);
                bcopy(sn, site_names, sl);
            }
            msg_delete(mp);
            break;

          case GENERIC_NEW_VIEW:
          case GENERIC_DEL_PGROUP:
          case GENERIC_PROC_FAILED:
          case GENERIC_NEW_SVIEW:
            /* Adds to all queues */
            if(isis_mutex)
            {
                act_ev(1, act, ACT_MSG);
                msg_increfcount(mp);
                qu_add_mp(msg_mutexqueue, act, mp, msg_delete);
            }
            act_ev(1, act, ACT_MSG);
            qu_add_mp(msg_queue, act, mp, msg_delete);
            break;

          default:
            act_ev(1, act, ACT_MSG);
            if(isis_mutex && act == isis_mutex)
                qu_add_mp(msg_mutexqueue, act, mp, msg_delete);
            else
                qu_add_mp(msg_queue, act, mp, msg_delete);
        }
  }

static  ACT_IDS;

act_begin()
  {
        register old_act = isis_ctp->task_act;
        address aname;
        aname = my_address;
        aname.type = ISACT;
        aname.entry = ++ACT_IDS;
        ACT_IDS &= 0xFF;
        isis_ctp->task_act = act_start(aname, old_act);
        return(old_act);
  }

act_end(old_act)
  {
        isis_ctp->task_act = old_act;
  }

act_start(aname, old_act)
  address aname;
  {
        register act;
        register queue *qp;
        act_scan();
        for(act = 1; act < MAX_ACT; act++)
            if(ACT_VALID(act) == 0)
                break;
        if(act == MAX_ACT)
            panic("can't find an act_map slot");
        act_bits |= 1<<act;
        act_map[act].act_id = aname;
        act_map[act].act_evcount = 0;
        act_map[act].act_gotres[0] = act_map[act].act_gotres[1] = 0;
        return(act);
  }

act_scan()
  {
        register act, bno;
        bno = 2;
        for(act = 1; act < MAX_ACT; act++, (bno <<= 1))
            if((act_bits&bno) && act_map[act].act_evcount == 0)
            {
                register queue *qp;
                for(qp = isis_tasks->qu_next; qp != isis_tasks; qp = qp->qu_next)
                    if(qp->qu_task->task_act == act)
                        break;
                if(qp == isis_tasks)
                    act_bits &= ~bno;
            }
  }

act_ev(inc, act, type)
  register act;
  {
        act_map[act].act_evcount += inc;
  }

cc_gotres(where)
  {
        act_map[isis_ctp->task_act].act_gotres[where]++;
  }

dump_act()
  {
        register queue *qp;
        register act;
        act_scan();
        if(isis_mutex)
        {
            print("\nActivity %d ", isis_mutex);
            paddr(act_map[isis_mutex].act_id);
            if(isis_state&ISIS_STARTUP)
                print(" is doing startup\n");
            else
                print(" holds Mutex (entered in viewid %d)\n", jbviewid);
        }
        else 
            print("\nActivities:\n");
        for(act = 0; act < MAX_ACT; act++)
            if(ACT_VALID(act))
            {
                print("  Slot %d = ", act);
                if(act)
                    paddr(act_map[act].act_id);
                else
                    print("(system activity)");
                print(", %d pending watch/monitor requests and messages", act_map[act].act_evcount);
                if(act_map[act].act_gotres)
                    print(", got cc_result %d/%d", act_map[act].act_gotres[0], act_map[act].act_gotres[1]);
                print("\n");
            }
        if(msg_mutexqueue || msg_queue)
            print("\nMessage queues:\n");
        if(msg_mutexqueue)
            for(qp = msg_mutexqueue->qu_next; qp != msg_mutexqueue; qp = qp->qu_next)
            {
                register address *ap;
                print("  [act %d (* holds mutex *)] ", qp->qu_act);
                pmsg(qp->qu_msg);
            }
        if(msg_queue)
            for(qp = msg_queue->qu_next; qp != msg_queue; qp = qp->qu_next)
            {
                register address *ap;
                print("  [act %d] ", qp->qu_act);
                pmsg(qp->qu_msg);
            }
  }

static  block_count;


act_block()
  {
        register queue *qp, *nqp;
        register ginfo *gip;
        if(isis_mutex && isis_ctp->task_act != isis_mutex)
            panic("act_block: activity %d, but was already blocked by activity %d", isis_ctp->task_act, isis_mutex);
        ++block_count;
        if(isis_mutex)
            return;
        if(isis_ctp->task_act == 0)
            act_begin();
        isis_mutex = isis_ctp->task_act;
        for(gip = isis_groups; gip; gip = gip->gi_next)
            gip->gi_mutexview = gip->gi_view;
        for(qp = msg_queue->qu_next; qp != msg_queue; qp = nqp)
        {
            register message *mp;
            nqp = qp->qu_next;
            if(qp->qu_act == isis_mutex)
            {
                qu_remove(qp);
                qu_append(msg_mutexqueue, qp);
            }
            else switch(msg_getdests(mp = qp->qu_msg)->entry)
            {
              case GENERIC_NEW_VIEW:
              case GENERIC_DEL_PGROUP:
              case GENERIC_PROC_FAILED:
              case GENERIC_NEW_SVIEW:
                act_ev(1, 0, ACT_MSG);
                msg_increfcount(mp);
                qu_add_mp(msg_mutexqueue, 0, mp, msg_delete);
            }
        }
        isis_svmutex = isis_sv;
  }

act_restart()
  {
        register queue *qp, *lqp;
        if(isis_mutex == 0)
        {
            panic("act_restart: activity wasn't blocked");
            return;
        }
        if(--block_count)
            return;
        isis_mutex = 0;
        for(qp = msg_mutexqueue->qu_last; qp != msg_mutexqueue; qp = lqp)
        {
            lqp = qp->qu_last;
            if(qp->qu_act)
            {
                qu_remove(qp);
                qu_append(msg_queue->qu_next, qp);
            }
            else
                qu_free(qp);
        }
  }

/* Filters messages through a settable routine */
ifunc *isis_setfilter(proc)
  ifunc *proc;
  {
        register ifunc *old = msg_filter;
        if((msg_filter = proc) == NULLROUTINE)
        {
            msg_filter = old;
            old = NULLROUTINE;
        }
        return(old);
  }

#ifndef  SIMWRITEV

#       define MAXIOVECLEN     16

#else   SIMWRITEV

#       define MAXIOVECLEN     1

static writev(sock, iovp, iovl)
  register sock;
  register iovec *iovp;
  {
        if(iovl != 1)
            panic("writev iovl != 1!\n");
        return(write(sock, iovp->iov_base, iovp->iov_len);
  }
#endif  SIMWRITEV

/* Algorithm for sending to ISIS */
msg_write(sock, mp)
  register message *mp;
  {
        register nb, len = 0, iovlen;
        register struct iovec *iovp, *iovb;
        t_scheck();
        iovlen = msg_getiovlen(mp);
        iovb = iovp = (struct iovec*)malloc(nb = sizeof(struct iovec)*iovlen);
        bcopy(msg_getiovec(mp), iovp, nb);
        while(iovlen)
        {
            register iovl = iovlen;
            if(iovl > MAXIOVECLEN)
                iovl = MAXIOVECLEN;
            while((nb = writev(sock, iovp, iovl)) == -1)
            {
                if(errno == EINTR)
                    continue;
                if(sock == isis_socket)
                {
                    perror("isis_write");
                    isis_has_crashed("isis_write");
                }
                free(iovb);
                return(-1);
            }
            len += nb;
            while(nb)
            {
                if(iovp->iov_len <= nb)
                {
                    nb -= iovp->iov_len;
                    --iovlen;
                    ++iovp;
                }
                else
                {
                    iovp->iov_base += nb;
                    iovp->iov_len -= nb;
                    nb = 0;
                }
            }
        }
        if(len != msg_getlen(mp))
            panic("algorithmic error in msg_write");
        free(iovb);
        return(0);
  }

static  shutting_down;

isis_has_crashed(how)
  char *how;
  {
        register state = isis_state;
        if(isis_socket)
            close(isis_socket);
        isis_state = isis_socket = 0;
        if(how && isis_failed(how))
        {
            if(shutting_down)
                exit(0);
            if((state&ISIS_ISUP) == 0)
                panic("%s: <isis-protos> is not running on this machine", how);
            else
                panic("%s: <isis-protos> shutdown detected", how);
        
        }
  }

message *
msg_read(sock)
  {
        register message *mp;
        register long *space;
        register char *ptr;
        int length = 0;
        register nb;
        block_desc *blk_desc;
        static ntries;

        while((nb = read(sock, (char*)&length, sizeof(long))) != sizeof(long))
        {
            if(nb == -1 && errno == EINTR)
                continue;
            if(sock == isis_socket && (nb < 0 || ntries++ == 10))
                isis_has_crashed("read failed");
            return(0);
        }
        ntries = 0;
        length = ntohl (length);
        blk_desc = msg_blockalloc(length, 0);
        space = (long *)blk_desc->addr;
        space[0] = htonl (length);
        ptr = (char*)&space[1];
        length -= sizeof(long);
        while(length)
        {
            while((nb = read(sock, ptr, length)) <= 0)
            {
                if(nb == -1 && errno == EINTR)
                    continue;
                if(sock == isis_socket)
                {
                    if(nb == 0 && ntries++ < 10) 
                    {    
                        sleep(1);
                        continue; 
                    }
                    isis_has_crashed("read after fragmentation failed");
                }
                return(0);
            }
            length -= nb;
            ptr += nb;
        }
        if(mp = msg_reconstruct((char*)space, blk_desc))
            return(mp);
        if(sock == isis_socket)
            isis_has_crashed("can't reconstruct");
        return(0);
  }

static  ifunc *cl_entries[MAXENTRIES];
static  ifunc *cl_routines[MAXENTRIES];
static  char *cl_rnames[MAXENTRIES];

isis_entry(entry, routine, rname)
  ifunc *routine;
  char *rname;
  {
        if(entry < 0 || entry > MAXENTRIES)
            panic("isis_entry: entry %d out of range 0-%d", entry, MAXENTRIES);
        if(cl_entries[entry] && cl_entries[entry] != routine)
            print("Redefinition of entry %s as %s\n", cl_rnames[entry], rname);
        cl_entries[entry] = routine;
        isis_task(routine, rname);
  }

isis_logentry(gaddr, entry)
  address gaddr;
  {
        register ginfo *gip = map_gaddr(gaddr);
        if(gip == (ginfo*)0 || entry < 0 || entry > MAXBITS)
            panic("isis_logentry: illegal argument");
        bis(gip->gi_lentries, entry);
  }

pentry(addr, entry)
  address addr;
  {
        if(addr.type == ISAPID)
        {
            if(entry >= SYS_BASE && entry <= MAXENTRIES)
                print(generic_entries[entry-SYS_BASE]);
            else if(addr.process == my_process_id && cl_entries[entry])
                cl_rname(cl_entries[entry]);
            else
                print("%d", entry);
        }
        else
            print("%d", entry);
  }

isis_task(routine, rname)
  ifunc *routine;
  char *rname;
  {
        register n;

        for(n = 0; n < MAXENTRIES; n++)
            if(cl_routines[n] == 0)
            {
                cl_routines[n] = routine;
                cl_rnames[n] = rname;
                return;
            }
        panic("isis_task: table overflow");
  }

cl_rname(routine)
  ifunc *routine;
  {
        register n;

        for(n = 0; n < MAXENTRIES; n++)
            if(cl_routines[n] == routine)
            {
                print("%s", cl_rnames[n]);
                return;
            }
        print("0x%x", routine);
  }

char *
cl_getrname(entry)
  {
        static char num[16];

        if(cl_entries[entry])
        {
            register n;
            for(n = 0; n < MAXENTRIES; n++)
                if(cl_routines[n] == cl_entries[entry])
                    return(cl_rnames[n]);
        }
        sprintf(num, "%d", entry);
        return(num);
  }

/* Guarded op lookup */
gop_lookup(gopname)
  register char *gopname;
  {
        register n;
        if(gopname == (char*)0)
            return(-1);
        for(n = 0; n < MAXENTRIES; n++)
            if(cl_rnames[n] && strcmp(cl_rnames[n], gopname) == 0)
                return(n);
        if(strcmp("term", gopname))
            return(MAXENTRIES);
        print("Guard reference to op <%s>: entry undeclared\n", gopname);
        return(-1);
  }

/* Invoke guarded operation */
isis_invoke(entry, mp)
  register message *mp;
  {
        register address *alist;
        alist = msg_getdests(mp);
        while(!addr_isnull(*alist))
            alist++ -> entry = entry;
        (*msg_filter)(mp);
  }

cl_local_delivery(mp)
  register message *mp;
  {
        register address *alist;
        alist = msg_getdests(mp);
        if(alist == 0)
        {
            print("cl_local_delivery: ");
            pmsg(mp);
            panic("cl_local_delivery");
        }
        if(isis_state&ISIS_TRACE)
        {
            print("%d: Delivery of ", my_process_id);
            pmsg(mp);
        }
        bypass_piggyback(mp);
        while(alist->site)
        {
            register entry = alist->entry;
            if(alist->process == my_process_id && alist->site == my_site_no &&
              (alist->incarn == my_site_incarn || (alist->incarn == RECOVERY_INCARN || my_site_incarn == RECOVERY_INCARN)))
            {
                if(cl_entries[entry])
                {
                    register event_id *eid = (event_id*)msg_getfield(mp, SYSFLD_EID, 1, NULLIARG);
                    begin
                    {
                        register ginfo *gip;
                        for(gip = isis_groups; gip; gip = gip->gi_next)
                            if(gip->gi_lnode && bit(gip->gi_lentries, entry))
                            {
                                log_write_msg(gip, mp, entry);
                                break;
                            }
                        isis_state |= ISIS_RECEIVING;
                        isis_enum = entry;
                        isis_eid = eid;
                        isis_gip = gip;
                        isis_fork_urgent(cl_entries[entry], mp, mp);
                    }
                    if(eid)
                        edb_add(eid->e_pname, entry, eid->e_msgid);
                }
                else
                    print("cl_local_delivery: message to entry %d discarded -- entry not defined\n", entry);
            }
            ++alist;
        }
  }

message *
collect_reply(msgid)
  {
        register message *mp = 0;
        isis_ctp->task_msgid = msgid;
        mp = (message*)t_wait_l(&isis_ctp->task_mwant, "isis system: collecting reply");
        if(mp == NULLMP)
            panic("collect reply: no reply");
        isis_ctp->task_msgid = 0;
        return(mp);
  }

cl_new_view(mp)
  register message *mp;
  {
        register ginfo *gip;
        register sys_groupview *npg;
        register groupview *gv;
        npg = (sys_groupview*)msg_getfield(mp, CL_NEWVIEW, 1, NULLIARG);
        gip = add_group(npg->pg_name, npg->pg_gid);
        gv = isis_mutex? &gip->gi_mutexview: &gip->gi_view;
        pg_copy(npg, gv);
        cl_setscope();
        pg_new_view(gv);
        g_new_view(gip);
        if(isis_mutex && (gip->gi_view.gv_flag&(PG_VALID|PG_FIRST)) == 0)
        {
            gip->gi_view = gip->gi_mutexview;
            gip->gi_view.gv_flag = PG_FIRST;
        }
  }

cl_setscope()
  {
        register ginfo *gip;
        bclr(my_bcastscope);
        for(gip = isis_groups; gip; gip = gip->gi_next)
        {
            register address *ap;
            register groupview *gv;
            if(isis_mutex)
                gv = &gip->gi_mutexview;
            else
                gv = &gip->gi_view;
            for(ap = gv->gv_members; !addr_isnull(*ap); ap++)
                bis(my_bcastscope, ap->site);
            for(ap = gv->gv_clients; !addr_isnull(*ap); ap++)
                bis(my_bcastscope, ap->site);
        }
  }

pgroups_dump()
  {
        register queue *hp, *qp, *pg;
        register ginfo *gip;
        register n;
        print("\nProcess group views:\n");
        for(gip = isis_groups; gip; gip = gip->gi_next)
        {
            register groupview *gv = &gip->gi_view;
            print("Group %s, gaddr = ", gip->gi_gname);
            paddr(gip->gi_gaddr);
            print("\n");
            if(gv->gv_flag&PG_VALID)
            {
                print("    View %d, %d members = ", gv->gv_viewid, gv->gv_nmemb);
                paddrs(gv->gv_members);
                if(gv->gv_nclient)
                {
                    register address *ap;
                    print(", %d clients = ", gv->gv_nclient);
                    paddrs(gv->gv_clients);
                }
#ifdef          BYPASS
                print(", seqn: ["); 
                for(n = 0; n < gv->gv_nmemb; n++) 
                    print(" %d", gip->gi_bseqns[n]); 
                print(" ]\n");   
                if(qu_head(gip->gi_bypassq)) 
                { 
                    print("... bypass waitq:\n"); 
                    for(qp = gip->gi_bypassq->qu_next; qp != gip->gi_bypassq; qp = qp->qu_next) 
                    { 
                        print("    "); pmsg(qp->qu_msg);   
                    }
                }
#else
                print("\n");
#endif
            }
            if(isis_mutex == 0)
                continue;
            gv = &gip->gi_mutexview;
            if(gv->gv_flag&PG_VALID)
            {
                print("[act %d] %d, %d members = ", isis_mutex, gv->gv_viewid, gv->gv_nmemb);
                paddrs(gv->gv_members);
                if(gv->gv_nclient)
                {
                    register address *ap;
                    print(", %d clients = ", gv->gv_nclient);
                    paddrs(gv->gv_clients);
                }
                print("\n");
            }
        }
  }

cl_del_pgroup(mp)
  register message *mp;
  {
        register address *gaddr = (address*)msg_getfield(mp, CL_GID, 1, NULLIARG);
        cl_do_del_pgroup(*gaddr);
  }

cl_do_del_pgroup(gaddr)
  address gaddr;
  {
        register ginfo *gip;
        register groupview *gv;
        if((gip = map_gaddr(gaddr)) == 0)
            return;
        gv = isis_mutex? &gip->gi_mutexview: &gip->gi_view;
        gv->gv_nmemb = gv->gv_nclient = 0;
        gv->gv_members[0] = NULLADDRESS;
        gv->gv_clients[0] = NULLADDRESS;
        ++gv->gv_viewid;
        cl_setscope();
        pg_new_view(gv);
        group_unmap(gip);
        pg_unmonitor(gaddr);
  }

address
pg_local_lookup(gname)
  char *gname;
  {
        register ginfo *gip = map_gname(gname);
        if(gip)
            return(gip->gi_gaddr);
        return(NULLADDRESS);
  }

/* Get view only if known locally */
groupview *
pg_getlocalview(gaddr)
  address gaddr;
  {
        register ginfo *gip = map_gaddr(gaddr);
        if(gip)
        {
            register groupview *gv = isis_mutex? &gip->gi_mutexview: &gip->gi_view;
            if(gv->gv_flag&PG_VALID)
                return(gv);
        }
        return((groupview*)0);
  }

static sys_groupview sys_pg;

groupview *
pg_getview(gaddr)
  address gaddr;
  {
        register message *msg;
        static groupview pgview, *gv = 0;

        gaddr.entry = 0;
        if(gv = pg_getlocalview(gaddr))
            return(gv);
        msg = msg_genmsg(CL_GID, (char*)(char*)&gaddr, FTYPE_ADDRESS, sizeof(address), 0);
        if(isis(CL_GETVIEW, msg, &sys_pg, sizeof(sys_groupview)) > 0)
        {
            bzero(&pgview, sizeof(pgview));
            pg_copy(&sys_pg, gv = &pgview);
            gv->gv_flag |= PG_CACHED;
        }
        msg_delete(msg);
        return(gv);
  }

pg_rank(gaddr, who)
  address gaddr, who;
  {
        register groupview *gv;
        register address *ap;
        if((gv = pg_getlocalview(gaddr)) == 0)
        {
            isis_errno = IE_UNKNOWN;
            return(-1);
        }
        for(ap = gv->gv_members; !addr_isnull(*ap); ap++)
            if(addr_cmp(*ap, who) == 0)
                return(ap-gv->gv_members);
        isis_errno = IE_NOTMEMB;
        return(-1);
  }

pg_rank_all(gaddr, who)
  address gaddr, who;
  {
        register groupview *gv;
        register address *ap;
        if((gv = pg_getlocalview(gaddr)) == 0)
        {
            isis_errno = IE_UNKNOWN;
            return(-1);
        }
        for(ap = gv->gv_members; !addr_isnull(*ap); ap++)
            if(addr_cmp(*ap, who) == 0)
                return(ap-gv->gv_members);
        for(ap = gv->gv_clients; !addr_isnull(*ap); ap++)
            if(addr_cmp(*ap, who) == 0)
                return(gv->gv_nmemb + (ap-gv->gv_clients));
        isis_errno = IE_NOTMEMB;
        return(-1);
  }

/* Build a groupview from this pgroup, using old information if any */
pg_copy(pg, gv)
  register sys_groupview *pg;
  register groupview *gv;
  {
        register address *ap, *bp, *cp;
        if(gv->gv_flag&PG_VALID)
        {
            if(gv->gv_viewid >= pg->pg_viewid)
                return;
            gv->gv_departed = NULLADDRESS;
            gv->gv_joined = NULLADDRESS;
            ap = pg->pg_alist;
            bp = gv->gv_members;
            while(!addr_isnull(*bp) && !addr_isnull(*ap) && addr_cmp(*ap, *bp) == 0)
            {
                ++ap; ++bp;
                continue;
            }
            if(addr_isnull(*bp))
            {
                gv->gv_joined = *ap;
                intercl_isalive(*ap);
            }
            else
                gv->gv_departed = *bp;
        }
        else
        {
            gv->gv_gaddr = pg->pg_gid;
            bcopy(pg->pg_name, gv->gv_name, PG_GLEN);
            gv->gv_departed = NULLADDRESS;
            gv->gv_joined = NULLADDRESS;
            if(addr_ismine(pg->pg_alist[pg->pg_nmemb-1]))
                gv->gv_joined = my_address;
            else
                gv->gv_joined = NULLADDRESS;
            gv->gv_flag |= PG_VALID;
            for(ap = pg->pg_alist; !addr_isnull(*ap); ap++)
                intercl_isalive(*ap);
        }
        gv->gv_nmemb = pg->pg_nmemb;
        gv->gv_nclient = pg->pg_nclient;
        gv->gv_incarn = pg->pg_incarn;
        gv->gv_viewid = pg->pg_viewid;
        ap = pg->pg_alist;
        bp = gv->gv_members;
        do
            *bp++ = *ap;
        while(!addr_isnull(*ap++));
        bp = gv->gv_clients;
        do
            *bp++ = *ap;
        while(!addr_isnull(*ap++));
  }

cl_rcv_reply(mp)
  register message *mp;
  {
        register *msgid = (int*)msg_getfield(mp, SYSFLD_MSGID, 1, NULLIARG);
        register queue *qp;
        if(msgid == 0)
        {
            pmsg(mp);
            panic("cl_rcv_reply: message has no msgid number in it");
        }
        if(isis_state&ISIS_TRACE)
            print("cl_rcv_reply: received reply to message %d\n", *msgid);
        if(isis_tasks->qu_next != isis_tasks)
            for(qp = isis_tasks->qu_next; qp != isis_tasks; qp = qp->qu_next)
            {
                register task *tp = qp->qu_task;
                if(tp->task_msgid == *msgid && tp->task_mwant)
                {
                    msg_increfcount(mp);
                    t_sig(&tp->task_mwant, (char*)mp);
                    return;
                }
            }
  }

alist_len(alist)
  register address *alist;
  {
        register n = 0;
        while(alist++ -> site)
            ++n;
        return(n);
  }

address
PRO(entry)
  {
        address addr;

        addr.type = ISAPID;
        addr.site = my_site_no;
        addr.incarn = my_site_incarn;
        addr.process = PROTOCOLS;
        addr.entry = entry;
        return(addr);
  }

panic(fmt, a0, a1, a2, a3, a4, a5)
  char *fmt;
  {
#ifdef  UNIX_DOM
        char clfile[32];
        sprintf(clfile, "/tmp/Cl%d", my_process_id);
        unlink(clfile);
#endif
        switch(my_process_id)
        {
          default:
                print("ISIS client pid=%d: ", my_process_id);
                break;
          case REXEC:
                print("ISIS rexec service: ");
                break;
          case ISIS:
                print("ISIS site-monitor service: ");
                break;
        }
        print(fmt, a0, a1, a2, a3, a4, a5);
        print("\n");
        if((isis_state&(ISIS_ISUP|ISIS_TRACE)) == (ISIS_ISUP|ISIS_TRACE))
            cl_dump(DUMP_ALL, "PANIC");
        exit(1);
  }


address
ADDRESS(s, i, p, e)
  site_id s;
  {
        address d;

        d.type = ISAPID;
        d.site = s;
        d.incarn = i;
        d.process = p;
        d.entry = e;
        d.cluster = 0;
        d.portno = 0;
        return(d);
  }

addr_cmp(a, b)
  address a, b;
  {
        if(a.site != b.site)
            return(a.site-b.site);
        if(a.type == ISAGID)
        {
            if(a.groupid != b.groupid)
                return(a.groupid-b.groupid);
        }
        else
            if(a.process != b.process)
                return(a.process-b.process);
        if(a.type != b.type)
            return(a.type - b.type);
        if(a.incarn != b.incarn)
            return(a.incarn-b.incarn);
        if(a.entry == 0 || b.entry == 0)
            return(0);
        return(a.entry-b.entry);
  }

pr_dump(how)
  {
        register message *mp = msg_genmsg(CL_HOW, &how, FTYPE_LONG, sizeof(how), 0);
        int answ;
        isis(CL_WANTDUMP, mp, (char*)&answ, 1);
        msg_delete(mp);
  }

pr_rescan()
  {
        register message *mp = msg_newmsg();
        int answ;
        isis(PR_RESCANSITES, mp, (char*)&answ, 1);
        msg_delete(mp);
  }

pr_shutdown()
  {
        register message *mp = msg_newmsg();
        int answ;
        ++shutting_down;
        isis(CL_SHUTDOWN, mp, (char*)&answ, 1);
        msg_delete(mp);
  }

pr_makedump(file)
  char *file;
  {
        register message *mp;
        int answ, how = 0;
        mp = msg_genmsg(CL_FILE, file, FTYPE_CHAR, strlen(file)+1, 
                        CL_HOW, &how, FTYPE_LONG, sizeof(how), 0);
        isis(CL_WANTDUMP, mp, (char*)&answ, 1);
        msg_delete(mp);
  }


address *
set_entry(alist, entry)
  register address *alist;
  register entry;
  {
        while(!addr_isnull(*alist))
            alist++ -> entry = entry;
        return(alist);
  }


msg_trace_dump()
  {
        msg_dumpmsgs (MSG_SMALLDUMP);
        print ("\n");
        msg_dumpblocks ();
  }

isis_perror(str)
  char *str;
  {
        register e = -isis_errno;
        if(e <= 0 || e >= sizeof(IE_errors)/sizeof(*IE_errors))
            print("%s: isis errno %d not defined!", str, e);
        else
            print("%s: %s\n", str, IE_errors[e]);
  }

_btst(vec)
  bitvec vec;
  {
        register n;
        for(n = 0; n < BVL; n++)
            if(vec.bv_data[n])
                return(1);
        return(0);
  }

_bitv(vec1, vec2)
  bitvec vec1, vec2;
  {
        register n;
        for(n = 0; n < BVL; n++)
            if(vec1.bv_data[n] & vec2.bv_data[n])
                return(1);
        return(0);
  }

isis_sleep(n)
  {
        if(isis_ctp == &isis_scheduler || isis_ctp == 0)
            return(sleep(n));
        isis_sleep_ms(n*1000);
        return(0);
  }

isis_sleep_ms(ms)
  {
        condition wake_me_up = 0;
        extern t_sig();
        if(ms <= 0)
            return(-1);
        /* Sleep from a task */
        isis_ctp->task_sleep = ms;
        isis_timeout(ms, t_sig, &wake_me_up);
        t_wait_l(&wake_me_up, "isis system: sleep");
        isis_ctp->task_sleep = 0;
        return(0);
  }

/* Compute elapsed time since startup but convert to milliseconds */
isis_gettime()
  {
        struct timeval tp;
        gettimeofday(&tp, (struct timezone*)0);
        return((tp.tv_sec-time_0.tv_sec)*1000 + tp.tv_usec/1000);
  }

itimeout_event()
  {
        run_tasks();
  }

/* Specifies a timeout in milliseconds */
int     TIMEOUT_ID;
 
isis_timeout(time, routine, arg0, arg1)
  int (*routine)();
  char *arg0, *arg1;
  {
        return(isis_timeout_reschedule(0, time, routine, arg0, arg1));
  }

isis_timeout_reschedule(oldtid, time, routine, arg0, arg1)
  register time, oldtid;
  int (*routine)();
  char *arg0, *arg1;
  {
        register ISIS_TIME;
        register queue *qp, *hp;
        extern intercl_sweep();

        time += (ISIS_TIME = isis_gettime());
        if(routine == intercl_sweep)
        {
            /* Round up to next second */
            time += 999;
            time -= time%1000;
        }
        if(oldtid)
            for(qp = time_queue->qu_next; qp != time_queue; qp = qp->qu_next)
                if(qp->qu_timeargs[2] == (char*)oldtid)
                {
                    if(qp->qu_time <= time)
                        return(oldtid);
                    qp->qu_freeroutine = NULLROUTINE;
                    qu_free(qp);
                    break;
                }
        for(qp = time_queue->qu_next; qp != time_queue; qp = qp->qu_next)
            if(qp->qu_time >= time)
                break;
        qp = qu_add(qp, time, (char*)0, routine);
        qp->qu_timeargs[0] = arg0;
        qp->qu_timeargs[1] = arg1;
        qp->qu_timeargs[2] = (char*)++TIMEOUT_ID;
        if(suntools_loaded && (hp = qu_head(time_queue)) == qp)
        {
            static struct itimerval when;
            register time;
            if((time = (qp->qu_time-ISIS_TIME)) < 250)
                time = 250;
            when.it_value.tv_sec = time/1000;
            when.it_value.tv_usec = (time % 1000)*1000;
            notify_set_itimer_func(run_tasks, run_tasks, ITIMER_REAL, &when, (struct itimerval*)0);
        }
        return (TIMEOUT_ID);
  }
