/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#ifndef CL_INTERSITE
#define CL_INTERSITE

#ifdef  ISIS_SYS
# include <sys/ioctl.h>
# include <sys/socket.h>
#if(HPUX)
# include <time.h>
#else
# include <sys/time.h>
#endif
# include <netdb.h>
# include <signal.h>
# include <ctype.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
#endif  ISIS_SYS
 
/*
 *      Configuration parameters. In principle, most can be changed for each
 *      ISIS site and values need not match up.  However, MAXWSIZE is
 *      assumed to be the same system-wide and is limited by the number of
 *      bits in a long integer
 */

/* Window sizes... output side can be varied but may not exceed maxwsize */
#define WSIZE           32                      /* window size, power of 2, >= 2 */
#define MAXWSIZE        32                      /* Largest wsize can ever be */
#define WMASK           (WSIZE-1)               /* For computing mod WSIZE */
#define MAXWMASK        (MAXWSIZE-1)            /* For computing mod MAXWSIZE */

/* Other limits (can be varied) and constants (should probably not be changed) */
#define MAXSIZE         4192                    /* Piggybacking iclpkt size limit */
#define SMLPKT          64                      /* Packets are rarely smaller than this */
#define MAXMSGS         128                     /* Don't piggyback more than 128 messages per iclpkt */
#define PK_HIWAT        8192                    /* Block when bytes in window reaches this level */
#define PK_LOWAT        4096                    /* Restart when drains to this level */
#define MAX_IOVLEN      16                      /* System limit on iovec lengths */
#define MAX_UDP_IOVLEN  4                       /* Limit for UDP, which has problems on SUNs */
#define MAXMSGLEN       8192                    /* Fragment anything larger than this */
#define STAGEBUFSIZE   10240                    /* Size of staging area */
#define FRAGSIZE        4096                    /* Fragment size */
#define RCVSIZE         32*1024+32              /* Receive buffer size */
#define SNDSIZE         10*1024+32              /* Send buffer size */

struct iclpkt
{
        short   pk_size;                /* Length of iclpkt in bytes */
        char    pk_state;               /* State flags */
        char    pk_cnt;                 /* Counts messages in this message */
        short   pk_nret;                /* Number of retransmissions */
        long    pk_rtwhen;              /* Retransmit when we reach this time */
        long    pk_whensent;            /* Value of ``now'' when iclpkt was sent */
        message *pk_iclpkt;             /* The iclpkt itself */
        queue   *pk_contents;           /* Messages IN this iclpkt */
};

/* pk_state bits */
#define PK_INUSE        0x0001          /* Contains iclpkt */
#define PK_SENT         0x0002          /* Contains iclpkt */
#define PK_ACKED        0x0004          /* Set if acked */

/* Intersite information, added to message */
struct  interclient
{
        address ic_from;                /* Sender */
        address ic_dest;                /* Dest */
        short   ic_seqn;                /* Seqn for this iclpkt */
        short   ic_aseqn;               /* Seqn acknowledged */
        long    ic_abits;               /* Ack bits */
};


/* Describes a message on a congestion queue */
struct  mdesc
{
        message *md_msg;                /* pointer to the message */
        int     (*md_cb)();             /* Callback routine */
        char    *md_arg0;               /* Argument */
        char    *md_arg1;               /* Argument */
};

/* Fragmented message description */
struct  fraghdr
{
        int     fr_nfrags;              /* Number of fragments, not including stab */
        int     fr_msglen;              /* Total length of data part */
};

struct  ioq
{
        short   io_nslots;              /* Number of free slots in output window */
        short   io_nbytes;              /* Number of pending output bytes */
        char    io_state;               /* A few state bits */
        char    io_iseqn;               /* Last input I saw (initialize to 0) */
        char    io_nseqn;               /* Next output seqn to use */
        char    io_oseqn;               /* Oldest unacked output seqn */
        long    io_rtdelay;             /* Delay for iclpkt retransmission */
        long    io_backed;              /* Number of backlogged bytes */
        long    io_ndups;               /* Number of duplicate copies received */
        long    io_nacks;               /* Number of acks received */
        long    io_ndata;               /* Number of data iclpkts received */
        long    io_nmsgs;               /* Number of messages received */
        long    io_nsent;               /* Number of messages sent */
        long    io_nret;                /* Number of retransmissions */
        long    io_abits;               /* Acknowledgement field, tied to WSIZE above */
        long    io_lastin;              /* Time of last input */
        long    io_lastout;             /* Time of last output */
        long    io_wantack;             /* Time when I will want to send an ack for this ioq */
        saddr   io_address;             /* Destination address */
        fraghdr io_fhdr;                /* Fragment header, if assembling a message */
        block_desc *io_blk_desc;        /* Corresponding block descriptor */
        char    *io_fbody;              /* Buffer to assemble it in */
        char    *io_fptr;               /* Pointer into buffer */
        address io_claddr;              /* Current client address */
        queue   *io_backlog;            /* Backlog, if any */
        iclpkt  *io_accum;              /* Accumulating here */
        iclpkt  io_out[WSIZE];          /* Output iclpkts and associated infomation */
        message *io_in[MAXWSIZE];       /* Receive iclpkt */
};
        
/* io_state bits */
#define IO_INUSE        0x01            /* Queue allocation was done */
#define IO_ALIVE        0x02            /* This channel is alive */
#define IO_DEAD         0x04            /* This channel is dead */
#define IO_ESTAB        0x08            /* Connection established */
#define IO_ACCUM        0x10            /* Accumulating lazy iclpkts */
#define IO_URGENT       0x20            /* Accumulating urgent iclpkts */
#define IO_ASSEM        0x80            /* Reassembling a fragment */

/* Normal sequence numbers are 7-bit numbers.  Special values: */
#define SEQ_DEAD        (char)0x81      /* "You are dead" */
#define SEQ_ACK         (char)0x82      /* Acknowledgement only */

char    staging_buf[STAGEBUFSIZE];

/* Tank is a list of input messages to be processed */
#define tankstats 1

#define TANK_EMPTY      0
#define TANK_ATEONE     1
#define TANK_OTHER      2
#define TANK_FULL       3

typedef struct msg_tank{
        queue *head;                  /* Queue (FIFO) of pending messages. */
        long max_size;                /* Bound on number of bytes of stored messages. */
        long size;                    /* Current number of bytes of stored messages. */
#ifdef tankstats
        long max_bytes_used;          /* Maximum bytes ever used. */
        long nr_msgs1;
        long nr_msgs2;
#endif tankstats
}       msg_tank;

int     tankcount[MAX_SITES];   /* Number from each sender */

#define default_max_size 50000 /* bytes. */

msg_tank *msg_tank_create();
message *msg_tank_dequeue();
#endif  CL_INTERSITE
