/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      UDP code for iclpkt transmission between ISIS clients
 */

# define  ISIS_SYS
# include "isis.h"

struct  hostent *gethostbyname();
struct  servent *getservbyname();

#if     (HPUX)
#define   sendmsg(x, y, z)      panic("sendmsg was called\n")
#endif

/* Normal mode: rapid communication with the site */
#define TIME_FAIL             10        /* Detect failures after 10 times the rtdelay */
#define TIME_ESTAB          5000        /* Give up on connection estab. after 5 secs */
#define TIME_RET            4000        /* Initially, retransmit after 4secs */

int     intercl_xmits, intercl_sweep();
static  fragman(), intercl_output(), intercl_xmit(), msg_tank_enqueue();
static  intercl_trytosend(), intercl_drain_one_input();
static  ttid;
static  saddr my_addr;
static  message *ackiclpkt;
static  interclient ic_info, *ackinf;
static  ioq *ioqs;
static  ISIS_PORT;
static  staged_xmit;
static  msg_tank *tank; /* FIFO of incoming messages not yet sent to destination process. */
static  struct timeval tank_wait = { 0, 0 };
message *ic_newmsg();
static  queue *IOQS, *ZOMBIES;

static adesc    ic_adesc ={ sizeof(mdesc), 0, 16, };

#define mdalloc()        ((mdesc*)mallocate(&ic_adesc))
#define mdfree(qp)       mdeallocate((char*)qp,&ic_adesc)

#define FLUSH_ON        0               /* Turn lazy_flush on */
#define DO_FLUSH        1               /* Do lazy_flush now */

#define MAXSEQN         0x7f
#define SEQN(x)         ((x)&MAXSEQN)
#define INC(x, i)       SEQN(x+i)
#define DEC(x)          INC(x, MAXSEQN)

/* Decide if <sn> is between <lb> and <hb> */
static
INRANGE(lb, hb, sn)
  register lb, hb, sn;
  {
        if(lb == hb)
            return(sn == lb);
        if((lb < hb)? (sn < lb || sn > hb): (sn > hb && sn < lb))
            return(0);
        return(1);
  }

intercl_init()
  {
        extern run_tasks();
        tank = msg_tank_create(250000);
        isis_entry(GENERIC_CL_FRAGMAN, fragman, "fragment reassembly");
        notify_set_input_func(run_tasks, run_tasks, intercl_socket);
        ic_info.ic_from = my_address;
        ic_info.ic_seqn = SEQ_ACK;
        ackiclpkt = ic_newmsg();
        ackinf = (interclient*)msg_getfield(ackiclpkt, INTERCLIENT_HDR, 1, (int*)0);
        IOQS = qu_null();
        ZOMBIES = qu_null();
#ifdef  BYPASS
        intercl_sweep();
#endif  BYPASS
  }


struct  adesc io_ad ={ sizeof(ioq), sizeof(ioq), 4 };

#define io_alloc()   ((ioq*)mallocate(&io_ad))

io_free(ioqp)
  register ioq *ioqp;
  {
        mdeallocate((char*)ioqp, &io_ad);
  }

/* Prepare to communicate with process `addr' */
intercl_isalive(addr)
  address addr;
  {
        register struct hostent *hep;
        register ioq *ioqp;
        static char hknown[MAX_SITES];
        static saddr addr_by_site[MAX_SITES];
        register char *sp;
        if(addr_ismine(addr) || pg_find(IOQS, addr))
            return(0);
#ifdef  BYPASS
        ioqp = io_alloc();
        ioqp->io_claddr = addr;
        ioqp->io_state &= ~IO_DEAD;
        if(ioqp->io_state&IO_ALIVE)
            return(0);
        if(hknown[addr.site] == 0)
        {
            char str[64];
            strcpy(str, site_names[addr.site]);
            for(sp = str; *sp; ++sp)
                if(*sp == '/')
                    *sp-- = 0;
            if((hep = gethostbyname(str)) == 0)
            {
                print("intercl_isalive: site %s unknown in local hosts table\n", str);
                return(-1);
            }
            hknown[addr.site]++;
            addr_by_site[addr.site].sin_family = AF_INET;
            bcopy(hep->h_addr, &addr_by_site[addr.site].sin_addr, hep->h_length);
        }
        ioqp->io_address = addr_by_site[addr.site];
        ioqp->io_address.sin_port = htons(addr.portno);
        if((ioqp->io_state&IO_INUSE) == 0)
        {
            register iclpkt *out;
            ioqp->io_state |= IO_INUSE;
            ioqp->io_backlog = qu_null();
            for(out = ioqp->io_out; out != &ioqp->io_out[WSIZE]; out++)
                out->pk_contents = qu_null();
        }
        ioqp->io_state |= IO_ALIVE;
        ioqp->io_wantack = 0;
        ioqp->io_nslots = WSIZE;
        ioqp->io_iseqn = 0;
        ioqp->io_oseqn = 1;
        ioqp->io_nseqn = 1;
        ioqp->io_ndups = ioqp->io_nacks = ioqp->io_nmsgs = ioqp->io_ndata = 0;
        ioqp->io_nret = ioqp->io_nsent = ioqp->io_abits = 0;
        ioqp->io_rtdelay = TIME_RET;
        pg_add_ioq(IOQS, addr, ioqp, io_free);
#endif  BYPASS
        return(0);
  }

intercl_isdead(addr)
  address addr;
  {
        register i;
        register queue *iqp = pg_find(IOQS, addr), *qp;
        register ioq *ioqp;
        if(iqp == 0)
            return;
#ifdef  BYPASS
        pg_add(ZOMBIES, addr, NULLARG, NULLROUTINE);
        ioqp = iqp->qu_ioq;
        qu_remove(iqp);
        /* Drain output and input iclpkts */
        for(i = 0; i != WSIZE; i++)
        {
            register iclpkt *out = &ioqp->io_out[INC(ioqp->io_oseqn, i)&WMASK];
            register message *mp = out->pk_iclpkt;
            if(mp)
            {
                register queue *hp;
                msg_delete(mp);
                while(hp = qu_head(out->pk_contents))
                {
                    hp->qu_callback(ioqp->io_claddr, hp->qu_args[0], hp->qu_args[1]);
                    qu_free(hp);
                }
            }
        }

        /* Next drain backlogged messages */
        while(qp = qu_head(ioqp->io_backlog))
        {
            register mdesc *md = qp->qu_md;
            qu_free(qp);
            if(md->md_cb)
                md->md_cb(addr, md->md_arg0, md->md_arg1);
            msg_delete(md->md_msg);
            mdfree(md);
        }

        for(i = 0; i < MAXWSIZE; i++)
            if(ioqp->io_in[i])
                msg_delete(ioqp->io_in[i]);
        qu_free(iqp);
#endif  BYPASS
  }

/*
 *      These are the interesting routines.  They do iclpkted output
 *      and acknowledged input.  Fragment the iclpkt if necessary.
 */
intercl_send(exmode, mp, to, callback, arg0, arg1)
  register message *mp;
  register address *to;
  int (*callback)();
  char *arg0, *arg1;
  {
        static fragmenting;
#ifdef  BYPASS
        if(fragmenting == 0 && msg_getlen(mp) > MAXMSGLEN)
        {
            ++fragmenting;
            intercl_fragment(mp, to, callback, arg0, arg1);
            --fragmenting;
        }
        else
        {
            --to;
            while(!addr_isnull(*++to))
            if(!addr_ismine(*to))
            {
                register queue *qp = pg_find(IOQS, *to);
                register ioq *ioqp;
                if(qp == 0)
                    panic("intercl_send: unknown client");
                ioqp = qp->qu_ioq;
                if(addr_cmp(*to, ioqp->io_claddr) == 0)
                    (void)intercl_trytosend(mp, ioqp, FALSE, callback, arg0, arg1);
                else if(callback)
                    callback(*to, arg0, arg1);
            }
            else if(!exmode)
            {
                msg_increfcount(mp);
                isis_gotmsg(mp, BYP_DONTCHECK);
                callback(*to, arg0, arg1);
            }
            else
                callback(*to, arg0, arg1);
        }
#endif  BYPASS
  }

/*
 *   Trick to encourage piggybacking:
 *      force_piggybacking: set if all messages should be piggybacked for now 
 *      intercl_urgent: counts iclpkts containing urgent messages 
 *      ioqp->io_accum: identifies the corresponding urgent iclpkt, if any
 *      ioqp->io_state: IO_URGENT,IO_ACCUM set as needed
 */
static  force_piggybacking, intercl_urgent;

static
flush_urgent(ioqp)
  register ioq *ioqp;
  {
        if(ioqp->io_state&IO_URGENT)
            intercl_output(ioqp, ioqp->io_accum);
  }

/* Fragment this message into smaller pieces for transmission */
static
intercl_fragment(mp, to, callback, arg0, arg1)
  message *mp;
  address *to;
  int (*callback)();
  char *arg0, *arg1;
  {
        iovec *iovp;
        register iovec *ip;
        int iovl, msglen, nfrags, msgsize, firstfrag, iolen;
        char *iobase;
        message *fmp;
        fraghdr fhdr;
        address *dp, dests[MAX_SITES+1];
        address *dsite;
        iovp = msg_getiovec(mp);
        iovl = msg_getiovlen(mp);
        msgsize = 0;
        ++force_piggybacking;
        dp = dests;
        for(dsite = to; !addr_isnull(*dsite); ++dsite)
        {
            *dp = *dsite++;
            dp++->entry = GENERIC_CL_FRAGMAN;
        }
        *dp = NULLADDRESS;

        msglen = 0;
        for(ip = iovp; ip < &iovp[iovl]; ip++)
            msglen += ip->iov_len;
        nfrags = (msglen+FRAGSIZE-1)/FRAGSIZE;
        fhdr.fr_nfrags = nfrags;
        fhdr.fr_msglen = msglen;

        /* Now send <nfrags> messages containing data */
        firstfrag = 0;
        iolen = iovp->iov_len;
        iobase = iovp->iov_base;
        while(nfrags--)
        {
            register fragsize = 0, len;

            fmp = ic_newmsg();
            if(firstfrag++ == 0)
            {
                /* Only the first frag contains header */
                msg_addfield(fmp, INTERCLIENT_FHDR, (char*)&fhdr, FTYPE_LONG, sizeof(fhdr));
            }
            msg_setdests(fmp, dests);
            do
            {
                if((len = iolen) > FRAGSIZE-fragsize)
                    len = FRAGSIZE-fragsize;
                /* Should try and eliminate this extra copying eventually */
                msg_addfield(fmp, INTERCLIENT_FRAG, iobase, FTYPE_CHAR, len);
                if(iolen -= len)
                    iobase += len;
                else
                {
                    --iovl;
                    ++iovp;
                    iolen = iovp->iov_len;
                    iobase = iovp->iov_base;
                }
                fragsize += len;
                msgsize += len;
            }
            while(fragsize < FRAGSIZE && msgsize < msglen);
            if(nfrags)
                intercl_send(0, fmp, to, NULLROUTINE, 0, 0);
            else
                /* Callback on last fragment */
                intercl_send(0, fmp, to, callback, arg0, arg1);
            msg_delete(fmp);
        }
        --force_piggybacking;
        if(intercl_urgent)
        {
            register queue *qp;
            for(qp = IOQS->qu_next; qp != IOQS; qp = qp->qu_next)
                flush_urgent(qp->qu_ioq);
        }
  }


/*
 * Reassemble a fragmented message
 */
static
fragman(fmp)
  message *fmp;
  {
        register ioq *ioqp;
        register fraghdr *fh;
        char *malloc();
        static char *bptrs[256];
        static int blens[256];
        register i, n;
        address msender;
        queue *qp;

        msender =  msg_getsender(fmp);
        qp = pg_find(IOQS, msender);
        if(qp == 0)
            panic("Fragman");
        ioqp = qp->qu_ioq;
        fh = &ioqp->io_fhdr;
        if((ioqp->io_state&IO_ASSEM) == 0)
        {
            fraghdr *fhdr = (fraghdr*)msg_getfield(fmp, INTERCLIENT_FHDR, 1, (int*)0);
            *fh = *fhdr;
            ioqp->io_blk_desc = msg_blockalloc (((fh->fr_msglen+3)&~3), 0);
            ioqp->io_fbody = ioqp->io_blk_desc->addr;
            ioqp->io_fptr = ioqp->io_fbody;
            ioqp->io_state |= IO_ASSEM;
        }
        n = msg_getfields(fmp, INTERCLIENT_FRAG, bptrs, blens, 256);
        for(i = 0; i < n; i++)
        {
            bcopy(bptrs[i], ioqp->io_fptr, blens[i]);
            ioqp->io_fptr += blens[i];
        }
        /* If this was the last message, check for integrity and deliver it */
        if(--fh->fr_nfrags <= 0)
        {
            message *mp;
            mp = msg_reconstruct(ioqp->io_fbody, ioqp->io_blk_desc);
            isis_gotmsg(mp, BYP_CHECK);
            ioqp->io_state &= ~IO_ASSEM;
            ioqp->io_fbody = ioqp->io_fptr = 0;
        }
  }

/* Drain as many messages off the congestion queue as possible, encourage piggybacking */
static
intercl_drain(ioqp)
  register ioq *ioqp;
  {
        register queue *qp;

        ++force_piggybacking;
        while(qp = qu_head(ioqp->io_backlog))
        {
            register mdesc *md = qp->qu_md;
            register ob;
            if(intercl_trytosend(md->md_msg, ioqp, TRUE, md->md_cb, md->md_arg0, md->md_arg1))
            {
                --force_piggybacking;
                flush_urgent(ioqp);
                return;
            }
            ob = ioqp->io_backed;
            ioqp->io_backed -= msg_getlen(md->md_msg);
            msg_delete(md->md_msg);
            mdfree(md);
            qu_free(qp);
        }
        --force_piggybacking;
        flush_urgent(ioqp);
  }

/* Try to send this message, on congestion queue if `tryingtodrain' */
static
intercl_trytosend(mp, ioqp, tryingtodrain, callback, arg0, arg1)
  register message *mp;
  register ioq *ioqp;
  register tryingtodrain;
  int (*callback)();
  char *arg0, *arg1;
  {
        register size = msg_getlen(mp);
        register iclpkt *out = &ioqp->io_out[ioqp->io_nseqn&WMASK];
# ifdef INTERVERBOSE
        print("*** NET: TRY TO SEND "); pmsg(mp);
# endif
        if((ioqp->io_state&(IO_INUSE|IO_DEAD)) != IO_INUSE)
            panic("trytosend: io_state %x", ioqp->io_state);
        msg_increfcount(mp);
        if(force_piggybacking && (ioqp->io_state&IO_ACCUM))
        {
            /* Continue to accumulate iclpkt if possible */
            if(out->pk_size+size <= MAXSIZE)
            {
                if((ioqp->io_state&IO_URGENT) == 0)
                {
                    ioqp->io_state |= IO_URGENT;
                    ++intercl_urgent;
                }
                msg_addmsg(out->pk_iclpkt, INTERCLIENT_MSG, mp);
                if(callback)
                    qu_add_cb(out->pk_contents, callback, arg0, arg1);
                msg_delete(mp);
                out->pk_size = msg_getlen(out->pk_iclpkt);
                if(++out->pk_cnt == MAXMSGS-1 || out->pk_size >= MAXSIZE-SMLPKT)
                    intercl_output(ioqp, out);
                return(0);
            }
        }

        /* Flush accum iclpkt before starting a new iclpkt */
        if(ioqp->io_state&IO_ACCUM)
        {
            intercl_output(ioqp, out);
            out = &ioqp->io_out[ioqp->io_nseqn&WMASK];
        }

        /* This code generates a new iclpkt for <mp> */
        if(ioqp->io_nslots == 0 || (ioqp->io_backed && tryingtodrain == FALSE) || ioqp->io_nbytes > PK_HIWAT)
        {
            if(tryingtodrain == FALSE)
            {
                register mdesc *md = mdalloc();
                md->md_msg = mp;
                md->md_cb = callback;
                md->md_arg0 = arg0;
                md->md_arg1 = arg1;
                qu_add_md(ioqp->io_backlog, 1, md, NULLROUTINE);
                ioqp->io_backed += msg_getlen(mp);
                return(0);
            }
            msg_delete(mp);
            return(-1);
        }
        out->pk_iclpkt = ic_newmsg();
        out->pk_state = PK_INUSE;
        out->pk_cnt = 1;
        msg_addmsg(out->pk_iclpkt, INTERCLIENT_MSG, mp);
        out->pk_size = msg_getlen(out->pk_iclpkt);
        if(callback)
            qu_add_cb(out->pk_contents, callback, arg0, arg1);
        if(force_piggybacking && size < MAXSIZE-SMLPKT)
        {
            lazy_flush(FLUSH_ON);
            ioqp->io_state |= IO_ACCUM;
            ioqp->io_accum = out;
            if((ioqp->io_state&IO_URGENT) == 0)
            {
                ioqp->io_state |= IO_URGENT;
                ++intercl_urgent;
            }
        }
        else
            intercl_output(ioqp, out);
        msg_delete(mp);
        return(0);
  }

static message *
ic_newmsg()
  {
        register message *msg = msg_newmsg();
        msg_addfield(msg, INTERCLIENT_HDR, (char*)&ic_info, FTYPE_INTERCLIENT, sizeof(ic_info));
        return(msg);
  }

/* First time transmission of a message */
static
intercl_output(ioqp, out)
  register ioq *ioqp;
  register iclpkt *out;
  {
        register message *mp = out->pk_iclpkt;
        register interclient *ic = (interclient*)msg_getfield(mp, INTERCLIENT_HDR, 1, (int*)0);
        ioqp->io_nsent++;
        out->pk_state |= PK_SENT;
        ic->ic_seqn = ioqp->io_nseqn;
        ic->ic_from = my_address;
        ic->ic_dest = ioqp->io_claddr;
        out->pk_size = msg_getlen(mp);
        ioqp->io_nseqn = INC(ioqp->io_nseqn, 1);
        if(ioqp->io_accum == out)
        {
            if(ioqp->io_state&IO_URGENT)
                --intercl_urgent;
            ioqp->io_state &= ~(IO_ACCUM|IO_URGENT);
            ioqp->io_accum = 0;
        }
        ioqp->io_nbytes += msg_getlen(mp);
        out->pk_whensent = ISIS_TIME;
        out->pk_nret = 0;
        out->pk_rtwhen = out->pk_whensent+ioqp->io_rtdelay;
        ttid = isis_timeout_reschedule(ttid, 100000, intercl_sweep, 0, 0);
        intercl_xmit(ioqp, mp);
        return(0);
  }

/* Put a copy of the iclpkt on the wire... */
static
intercl_xmit(ioqp, mp)
  register ioq *ioqp;
  register message *mp;
  {
        register iovlen;
        register interclient *hdr;

        t_scheck();

        if((ioqp->io_state&IO_INUSE) == 0)
            return;

        if(mp == ackiclpkt)
        {
            if(my_site_incarn == RECOVERY_INCARN) 
                return;
            hdr = ackinf;
            hdr->ic_from = my_address;
            hdr->ic_dest = ioqp->io_claddr;
        }
        else
            hdr = (interclient*)msg_getfield(mp, INTERCLIENT_HDR, 1, (int*)0);
        hdr->ic_abits = ioqp->io_abits;
        hdr->ic_aseqn = ioqp->io_iseqn;
        ioqp->io_wantack = 0;

        iovlen = msg_getiovlen(mp);


# ifdef SCATTERSEND
        if(staged_xmit || iovlen > MAX_UDP_IOVLEN)
# endif SCATTERSEND
        {
            register char *sbp = staging_buf;
            register iovec *iovp = msg_getiovec(mp);
            register len = msg_getlen(mp);
            while(iovlen--)
            {
                bcopy(iovp->iov_base, sbp, iovp->iov_len);
                sbp += iovp++ ->iov_len;
            }
            if(sendto(intercl_socket, staging_buf, len, 0, (struct sockaddr*)&ioqp->io_address, sizeof(saddr)) != -1)
                errno = 0;
            else
                perror("intercl: sendto");
        }
# ifdef SCATTERSEND
        else
        {
            static struct msghdr mh;
            mh.msg_name = (caddr_t)&ioqp->io_address;
            mh.msg_namelen = sizeof(saddr);
            mh.msg_iov = msg_getiovec(mp);
            mh.msg_iovlen = iovlen;
            if(sendmsg(intercl_socket, &mh, 0) != -1)
                errno = 0;
            else
                perror("intercl: sendto");
        }
# endif SCATTERSEND
        if(errno == 0 || errno == ECONNREFUSED || errno == ENOBUFS) 
        {
            if(++intercl_xmits == 2)
            {
                ISIS_TIME = isis_gettime();
                intercl_drain_any_input();
            }
            return;
        }
        perror("send");
  }

/* Input all pending network iclpkts and tank them. */
static  bitvec tank_mask;
static  tank_mask_bits;

intercl_drain_any_input()
  {
        while(tank_mask_bits <= intercl_socket)
            tank_mask_bits += 32;
        bis(tank_mask, intercl_socket);
        while(tank->size <= tank->max_size && select(tank_mask_bits, &tank_mask, (int*)0, (int*)0, &tank_wait) == 1)
            intercl_drain_one_input();
  }

tank_status()
  {
        if(tank == 0)
            return(TANK_EMPTY);
        if(tank->size > tank->max_size)
            return(TANK_FULL);
        if(tank->size == 0)
            return(TANK_EMPTY);
        return(TANK_OTHER);
  }

intercl_do_input()
  {
        if(tank->size <= tank->max_size)
            intercl_drain_one_input();
  }

static
intercl_drain_one_input() 
  {
        int nb, fromlen;
        saddr from;
        long *msg_buf, len;
        block_desc *blk_desc;
        message *mp;

        intercl_xmits = 0;
        fromlen = sizeof(from);
        while((nb = recvfrom(intercl_socket, &len, sizeof(long), MSG_PEEK, (struct sockaddr*)&from, &fromlen)) != sizeof(long))
        {
            if(nb == -1 && errno == EINTR)
                continue;
            perror("intercl_drain_input -- recvfrom(len)");
            panic("intercl_drain_input(rval %d)", nb);
        }

        len = ntohl (len);
        blk_desc = msg_blockalloc(len, 0);
        msg_buf = (long *)blk_desc->addr;
        fromlen = sizeof(from);
  
        while((nb = recvfrom(intercl_socket, msg_buf, len, 0, (struct sockaddr*)&from, &fromlen)) != len)
        {
            if(nb == -1 && errno == EINTR)
                continue;
            perror("intercl_drain_input -- recvfrom");
            panic("intercl_drain_input wanted %d received %d", len, nb);
        }
  
        mp = msg_reconstruct((char*)msg_buf, blk_desc);
        if(mp == (message*)0)
        {
            print("intercl_drain_input -- can't reconstruct message\n");
            free(msg_buf);
            return;
        }
        msg_tank_enqueue(tank, mp);
  }

/*
 * Read and process a message from the network input tank.
 * Returns TANK_.... to indicate what we did
 */
intercl_deliver()
  {         
        register ioq *ioqp;
        register interclient *ic;
        message *mp;
        static in_intercl_input, strange_id;
        queue *qp;

        if ((mp = msg_tank_dequeue(tank)) == (message *) 0)
          return(TANK_EMPTY);

        if(in_intercl_input++)
            panic("recursion (%d) in intercl_input", in_intercl_input);
        if((ic = (interclient*)msg_getfield(mp, INTERCLIENT_HDR, 1, (int*)0)) == 0)
        {
            print("intercl_input -- can't extract interclient-hdr\n");
            msg_delete(mp);
            --in_intercl_input;
            return(TANK_OTHER);
        }
        if((qp = pg_find(IOQS, ic->ic_from)) == 0)
        {
            if(qp = pg_find(ZOMBIES, ic->ic_from))
            {
                print("intercl_input -- can't extract interclient-hdr\n");
                msg_delete(mp);
                --in_intercl_input;
                return(TANK_OTHER);
            }
            intercl_isalive(ic->ic_from);
            qp = pg_find(IOQS, ic->ic_from);
        }
        ioqp = qp->qu_ioq;
        ioqp->io_state |= IO_ESTAB;
        if(ic->ic_seqn != SEQ_ACK)
        {
            register message **in;
            /* Discard duplicate input messages */
            if(ioqp->io_wantack == 0)
                ioqp->io_wantack = ISIS_TIME+1000;
            in = &ioqp->io_in[ic->ic_seqn&MAXWMASK];
            if(INRANGE(INC(ioqp->io_iseqn, 1), INC(ioqp->io_iseqn, MAXWSIZE), ic->ic_seqn) && *in == 0)
            {
                ++ioqp->io_ndata;
                *in = mp;
                msg_increfcount(mp);
            }
            else { print("is a dup\n"); 
                ++ioqp->io_ndups;}
        }

        /* Briefly supress output */
        ++force_piggybacking;
        peek_ack(ic);
        if(ic->ic_seqn != SEQ_ACK && in_intercl_input == 1)
        {
            register n;
            register message **in;
            while(*(in = &ioqp->io_in[INC(ioqp->io_iseqn, 1)&MAXWMASK]))
            {
                message *msgs[MAXMSGS];
                register m;
                /* Now process the input messages */
                ioqp->io_iseqn = INC(ioqp->io_iseqn, 1);
                ioqp->io_abits >>= 1;
                m = msg_getmsgs(*in, INTERCLIENT_MSG, msgs, MAXMSGS);
                ioqp->io_nmsgs += m;
                for(n = 0; n < m; n++)
                {
                    if(ioqp->io_state&IO_ASSEM)
                    {
#                       ifdef INTERVERBOSE
                            print("*** INTERCL: TRY TO REASSEMBLE "); pmsg(msgs[n]);
#                       endif INTERVERBOSE
                        fragman(msgs[n]);
                    }
                    else
                    {
#                       ifdef INTERVERBOSE
                            print("*** INTERCL: TRY TO DELIVER "); pmsg(msgs[n]);
#                       endif INTERVERBOSE
                        isis_gotmsg(msgs[n], BYP_CHECK);
                    }
                }
                if((ioqp->io_state&(IO_INUSE|IO_DEAD)) != IO_INUSE)
                {
                    /* Special for site shutdown while loop ran above */
                    --force_piggybacking;
                    --in_intercl_input;
                    msg_delete(mp);
                    return(TANK_ATEONE);
                }
                msg_delete(*in);
                *in = (message*)0;
            }
        }
        if(ioqp->io_backed && (ioqp->io_nslots && ioqp->io_nbytes < PK_LOWAT))
            intercl_drain(ioqp);
        t_suspend();
        --force_piggybacking;
        if(intercl_urgent)
        {
            register queue *qp;
            for(qp = IOQS->qu_next; qp != IOQS; qp = qp->qu_next)
                flush_urgent(qp->qu_ioq);
        }
        if(ioqp->io_wantack)
            ttid = isis_timeout_reschedule(ttid, 100000, intercl_sweep, 0, 0);
        msg_delete(mp);
        --in_intercl_input;
        return(TANK_ATEONE);
  }

/* Glimpse of ACK info in arriving iclpkt: `processed up to ... (non-incl.) received ....' */
peek_ack(ic)
  register interclient *ic;
  {
        register ioq *ioqp;
        register iclpkt *out;
        register queue *hp, *ep;
        register aseqn, bn;

        hp = pg_find(IOQS, ic->ic_from);
        if(hp == 0)
            return;
        ioqp = hp->qu_ioq;
        bn = 1;
        aseqn = INC(ic->ic_aseqn, 1);
        if(ic->ic_abits && ioqp->io_oseqn != ioqp->io_nseqn && INRANGE(ioqp->io_oseqn, DEC(ioqp->io_nseqn), aseqn))
            while(ic->ic_abits >= bn)
            {
                 if(ic->ic_abits&bn)
                 {
                     register p = aseqn&WMASK;
                     if((ioqp->io_out[p].pk_state&(PK_INUSE|PK_SENT)) == (PK_INUSE|PK_SENT))
                         ioqp->io_out[p].pk_state |= PK_ACKED;
                 }
                 aseqn = INC(aseqn, 1);
                 bn <<= 1;
            }

        /* regenerate ack info */
        if(ic->ic_seqn >= 0)
            if(INRANGE(INC(ioqp->io_iseqn, 1), INC(ioqp->io_iseqn, MAXWSIZE), ic->ic_seqn))
            {
                register n = ic->ic_seqn-ioqp->io_iseqn-1;
                if(n < 0)
                    n += MAXSEQN+1;
                ioqp->io_abits |= 1<<n;
            }

        aseqn = ic->ic_aseqn;
        /* Clear output slots if I can safely do so */
        while(ioqp->io_oseqn != ioqp->io_nseqn && INRANGE(ioqp->io_oseqn, DEC(ioqp->io_nseqn), aseqn))
        {
            register dt;
            out = &ioqp->io_out[ioqp->io_oseqn&WMASK];
            if(out->pk_state&(PK_INUSE|PK_SENT) != (PK_INUSE|PK_SENT))
                panic("Unexpected output state %x\n", out->pk_state);
            ++ioqp->io_nslots;
            ioqp->io_nbytes -= msg_getlen(out->pk_iclpkt);
            ioqp->io_oseqn = INC(ioqp->io_oseqn, 1);
            msg_delete(out->pk_iclpkt);
            out->pk_iclpkt = 0;
            out->pk_state = 0;
            if(out->pk_nret == 0)
            {
                if((dt = ISIS_TIME-out->pk_whensent+1000) <= 2000)
                    dt = 3000;
                ioqp->io_rtdelay = ((ioqp->io_rtdelay<<3)-ioqp->io_rtdelay+dt)>>3;
            }
            while(hp = qu_head(out->pk_contents))
            {
                hp->qu_callback(ioqp->io_claddr, hp->qu_args[0], hp->qu_args[1]);
                qu_free(hp);
            }
        }
  }

/* Invoked when halting, true if nothing unacknowledged on any queue */
intercl_quiet()
  {
        register queue *qp;
        for(qp = IOQS->qu_next; qp != IOQS; qp = qp->qu_next)
        {
            register ioq *ioqp = qp->qu_ioq;

            if(ioqp->io_nslots != WSIZE)
                return(0);
        }
        return(1);
  }

lazy_flush(arg)
  {
        register queue *qp;
        static will_flush;
        if(arg == FLUSH_ON)
        {
            /* Just turn flush on */
            if(will_flush++ == 0)
                isis_timeout(500000, lazy_flush, DO_FLUSH, 0);
            return;
        }
        will_flush = 0;
        for(qp = IOQS->qu_next; qp != IOQS; qp = qp->qu_next)
        {
            register ioq *ioqp = qp->qu_ioq;
            if(ioqp->io_state&IO_ACCUM)
                intercl_output(ioqp, ioqp->io_accum);
        }
  }

/* 
 *      Invoked every second, approximately.
 *      Notice failed remote after 20secs, trigger failure detection
 */
intercl_sweep()
  {
        register queue *qp, *nqp;
        int stuff_to_send = 0;

        ttid = 0;
        /* Rotate IOQS entries for fairness */
        if(qp = qu_head(IOQS))
        {
            qu_remove(qp);
            qu_append(IOQS, qp);
        }

        for(qp = IOQS->qu_next; qp != IOQS; qp = nqp)
        {
            register ioq *ioqp = qp->qu_ioq;
            register iclpkt *out;
            register n, m;

            nqp = qp->qu_next;
            if(ioqp->io_state&IO_ALIVE)
            {
                /* Retransmit as needed */
                for(n = ioqp->io_oseqn; n != ioqp->io_nseqn; n = INC(n, 1))
                {
                    out = &ioqp->io_out[n&WMASK];
                    if((out->pk_state&(PK_INUSE|PK_ACKED)) == PK_INUSE)
                    {
                        ++stuff_to_send;
                        if(ISIS_TIME > out->pk_rtwhen)
                        {
                            if(++out->pk_nret > 2)
                                out->pk_rtwhen = ISIS_TIME+1000;
                            else
                                out->pk_rtwhen = ISIS_TIME+ioqp->io_rtdelay/out->pk_nret;
                            intercl_xmit(ioqp, out->pk_iclpkt);
                            ++ioqp->io_nret;
                        }
                    }
                }
            }
        }
        for(qp = IOQS->qu_next; qp != IOQS; qp = nqp)
        {
            register ioq *ioqp = qp->qu_ioq;
            nqp = qp->qu_next;
            if(ioqp->io_wantack && ISIS_TIME > ioqp->io_wantack)
            {
                ++ioqp->io_nacks;
                intercl_xmit(ioqp, ackiclpkt);
            }
            else if(ioqp->io_wantack)
                ++stuff_to_send;
        }
        if(ttid)
            return;
        if(stuff_to_send)
            ttid = isis_timeout(100000, intercl_sweep, 0, 0);
  }

intercl_newview()
  {
        register queue *qp, *nqp;
        for(qp = IOQS->qu_next; qp != IOQS; qp = nqp)
        {
            register ioq *ioqp = qp->qu_ioq;
            nqp = qp->qu_next;
            if(current_view.sv_incarn[ioqp->io_claddr.site] != ioqp->io_claddr.incarn)
                intercl_isdead(ioqp->io_claddr);
        }
  }

dump_interclient()
  {
        register queue *qp;
#ifdef  BYPASS
        print("Interclient dump: ");
        if(force_piggybacking)
            print("forced_piggybacking enabled (%d)\n", force_piggybacking);
        else
            print("\n");
        for(qp = IOQS->qu_next; qp != IOQS; qp = qp->qu_next)
            ioq_dump(qp->qu_ioq);
        msg_tank_dump(tank);
#endif
  }

static
ioq_dump(ioqp)
  register ioq *ioqp;
  {
        register iclpkt *out;
        register p;
        register queue *qp;
        if(ioqp->io_state)
        {
            print("  "); paddr(ioqp->io_claddr);
            print("\t[%s]:\n\t", site_names[ioqp->io_claddr.site]);
            if(ioqp->io_state)
            {
                if(ioqp->io_state&IO_ESTAB)
                    print("estab;");
                if(ioqp->io_state&IO_ALIVE)
                    print("alive;");
                if(ioqp->io_state&IO_ACCUM)
                    print("accum;");
                if(ioqp->io_state&IO_URGENT)
                    print("urg;");
                if(ioqp->io_state&IO_ASSEM)
                    print("assem;");
                if(ioqp->io_state&IO_DEAD)
                    print("is dead;");
            }
            print(" got: %d/%d+%d dups, sent: %d+%d ret, %d acks, ", ioqp->io_ndata, ioqp->io_nmsgs, ioqp->io_ndups, ioqp->io_nsent, ioqp->io_nret, ioqp->io_nacks);
            print(" backlog %d\n", ioqp->io_backed);
            for(p = ioqp->io_oseqn; p != ioqp->io_nseqn; p = INC(p, 1))
            {
                int ws, whs;
                out = &ioqp->io_out[p&WMASK];
                ws = ISIS_TIME-out->pk_whensent;
                whs = ws/10 % 100;
                ws /= 1000;
                print("\t... iclpkt %d = sl%d,sz%d,cnt%d", p, out-ioqp->io_out, out->pk_size, out->pk_cnt);
                if((out->pk_state&PK_ACKED) == 0)
                    print(", nret%d, waiting %d.%.2d", out->pk_nret, ws, whs);
                print(", state=<");
                if(ioqp->io_accum == out)
                    print("accum;");
                if(out->pk_state&PK_INUSE)
                    print("inuse;");
                if(out->pk_state&PK_SENT)
                    print("sent;");
                if(out->pk_state&PK_ACKED)
                    print("acked;");
                print(">\n");
            }
            while(p != INC(ioqp->io_oseqn, WSIZE))
            {
                out = &ioqp->io_out[p&WMASK];
                if(out->pk_iclpkt)
                    print("\t*** FOUND A PACKET IN SEQN %d... oseqn %d nseqn %d!\n", p, ioqp->io_oseqn, ioqp->io_nseqn);
                if(out->pk_state)
                    print("\t*** FOUND STATE %x in SEQN %d!... oseqn %d nseqn %d\n", out->pk_state, p, ioqp->io_oseqn, ioqp->io_nseqn);
                p = INC(p, 1);
            }
            for(p = 0; p < MAXWSIZE; p++)
                if(ioqp->io_in[p])
                    break;
            if(p == MAXWSIZE)
                return;
            print("\t... full input slots: seqn ");
            for(p = 1; p <= MAXWSIZE; p++)
                if(ioqp->io_in[INC(ioqp->io_iseqn,p)&MAXWMASK])
                    print("%d ", INC(ioqp->io_iseqn,p));
            print("\n");
        }
  }

/* Dump contents of an inter-site iclpkt */
static
ic_dump(why, mp)
  char *why;
  register message *mp;
  {
        register interclient *ic;
        register n, m;
        message *msgs[MAXMSGS];
        ic = (interclient*)msg_getfield(mp, INTERCLIENT_HDR, 1, (int*)0);
        m = msg_getmsgs(mp, INTERCLIENT_MSG, msgs, MAXMSGS);
        print("IS_DUMP: %s msg %x<%d> len %d", why, mp, m, msg_getlen(mp));
        if(ic == 0)
            print("[no header]\n");
        else
        {
            if(ic->ic_seqn == SEQ_ACK)
            {
                print("[from %x ACK, aseqn %d abits %x]\n", ic->ic_aseqn, ic->ic_abits);
                goto phd;
            }
            print("[from %x seqn %d aseqn %d abits %x]\n", ic->ic_from, ic->ic_seqn, ic->ic_aseqn, ic->ic_abits);
        }
        for(n = 0; n < m; n++)
        {
            print("  <%d>: mp %x = ", n, msgs[n]);
            pmsg(msgs[n]);
            msg_delete(msgs[n]);
        }
  phd:  msg_printheader(mp); msg_printaccess(mp);
  }

static
msg_tank *msg_tank_create(max_size)
  register long max_size;
  {
        static adesc ad = {sizeof(msg_tank), sizeof (msg_tank), 1};
        register msg_tank *tank = (msg_tank *) mallocate(&ad);
        tank->head = qu_null();
        tank->max_size = (max_size == 0 ? default_max_size : max_size);
        return(tank);
  }

static
msg_tank_set_max(tank, max_size)
  register msg_tank *tank;
  register long max_size;
  {
         tank->max_size = (max_size == 0 ? default_max_size : max_size);
  }

static
msg_tank_enqueue(tank, msg)
  register msg_tank *tank;
  register message *msg;
  {
        register interclient *ic;
        register s;
        if(ic = (interclient*)msg_getfield(msg, INTERCLIENT_HDR, 1, (int*)0))
        {
            ++tankcount[ic->ic_from.site];
            peek_ack(ic);
            qu_add_mp(tank->head, ic->ic_from.site, msg, NULLROUTINE);
            if (tank->size > tank->max_size)
                panic("pr_msgtank: Tank overflow on message %d bytes long.\n", msg_getlen(msg));
            tank->size += msg_getlen(msg);
        }
        else
        {
            print("Ignoring a message: no interclient hdr\n");
            msg_delete(msg);
        }
  }

/* Returns null (zero) message pointer if tank is empty. */
static
message *msg_tank_dequeue(tank)
  register msg_tank *tank;
  {
        register queue *q;
        register message *msg;
        register interclient *ic;
        if (q = qu_head(tank->head)) {
            msg = q->qu_msg;
            --tankcount[q->qu_name];
            qu_free(q);
            tank->size -= msg_getlen(msg);
            return(msg);
        }
        else
            return((message *)0);
  }

static
msg_tank_dump(tank)
  register msg_tank *tank;
  {
        queue *p;
        int s, n = 0;

        for (p = tank->head->qu_next; p != tank->head; p = p->qu_next)
            n++;
        print("  Message tank: %d messages, %d bytes\n", n, tank->size);
  }
