/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#include "isis.h"

static  adesc   gi_ad = { sizeof(ginfo), 0, 2 };

static ginfo *
gi_alloc()
  {
        register ginfo *gip = ((ginfo*)mallocate(&gi_ad));
        gip->gi_gaddr = NULLADDRESS;
        *gip->gi_gname = 0;
        gip->gi_join_verifier = NULLROUTINE;
        gip->gi_client_verifier = NULLROUTINE;
        gip->gi_view.gv_gaddr = NULLADDRESS;
        gip->gi_mutexview.gv_gaddr = NULLADDRESS;
        *gip->gi_view.gv_name = 0;
        *gip->gi_mutexview.gv_name = 0;
        gip->gi_view.gv_viewid = 0;
        gip->gi_mutexview.gv_viewid = 0;
        gip->gi_view.gv_flag = 0;
        gip->gi_mutexview.gv_flag = 0;
        gip->gi_lnode = 0;
        bclr(gip->gi_lentries);
        bcopy(def_xfer_rcv, gip->gi_xfer_rcv, sizeof(def_xfer_rcv));
        bcopy(def_xfer_gen, gip->gi_xfer_gen, sizeof(def_xfer_gen));
        gip->gi_next = isis_groups;
        gip->gi_clwatchq = qu_null();
        gip->gi_clwatchq->qu_viewid = 0;
        gip->gi_guarded = qu_null();
        gip->gi_pats = qu_null();
        gip->gi_events = qu_null();
        gip->gi_bypassq = qu_null();
        bzero(gip->gi_bseqns, sizeof(gip->gi_bseqns));
        isis_groups = gip;
        return(gip);
  }

gi_free(gip)
  register ginfo *gip;
  {
        qu_freeall(gip->gi_guarded);
        qu_freeall(gip->gi_pats);
        qu_freeall(gip->gi_events);
        if(qu_head(gip->gi_bypassq))
            panic("gi_free: bypassq not empty");
        qu_free(gip->gi_bypassq);
        mdeallocate((char*)gip,&gi_ad);
  }

ginfo *
map_gname(gname)
  register char *gname;
  {
        register ginfo *gip;
        if(*gname == '@')
            while(*++gname && *gname != ':')
                continue;
        for(gip = isis_groups; gip; gip = gip->gi_next)
            if(strcmp(gip->gi_gname, gname) == 0)
                return(gip);
        return((ginfo*)0);
  }

ginfo *
map_gaddr(gaddr)
  address gaddr;
  {
        register ginfo *gip;
        for(gip = isis_groups; gip; gip = gip->gi_next)
            if(addr_isequal(gaddr, gip->gi_gaddr))
                return(gip);
        return((ginfo*)0);
  }

ginfo *
add_gname(gname)
  register char *gname;
  {
        register ginfo *gip;
        if(*gname == '@')
            while(*++gname && *gname != ':')
                continue;
        if((gip = map_gname(gname)) == (ginfo*)0)
        {
            gip = gi_alloc();
            strcpy(gip->gi_gname, gname);
        }
        return(gip);
  }

ginfo *
add_group(gname, gaddr)
  char *gname;
  address gaddr;
  {
        register ginfo *gip;
        for(gip = isis_groups; gip; gip = gip->gi_next)
            if(addr_isequal(gaddr, gip->gi_gaddr))
                break;
            else if(strcmp(gip->gi_gname, gname) == 0)
                break;
        if(gip == (ginfo*)0)
            gip = gi_alloc();
        gip->gi_gaddr = gaddr;
        strcpy(gip->gi_gname, gname);
        return(gip);
  }

/* Only called if a join fails */
group_unmap(gip)
  register ginfo *gip;
  {
        register ginfo *gop = 0, *gjp;
        for(gjp = isis_groups; gjp; gjp = gjp->gi_next)
            if(gjp == gip)
                break;
            else
                gop = gjp;
        if(gjp == (ginfo*)0)
            panic("group_unmap: gip %x not found", gip);
        if(gop)
            gop->gi_next = gip->gi_next;
        else
            isis_groups = gip->gi_next;
        gi_free(gip);
  }
