/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#define   ISIS_SYS
# include "isis.h"


extern  errno;

/* Algorithm for writing a message to a FILE */
msg_fwrite(file, mp)
  FILE *file;
  register message *mp;
  {
        register nb, len = 0, iovlen;
        register struct iovec *iovp;
        register iov_len;
        register char *iov_base;
        t_scheck();
        iovlen = msg_getiovlen(mp);
        iovp = msg_getiovec(mp);
        iov_len = iovp->iov_len;
        iov_base = iovp->iov_base;
        while(iovlen)
        {
            while((nb = fwrite(iov_base, 1, iov_len, file)) == -1)
            {
                if(errno == EINTR)
                    continue;
                return(-1);
            }
            len += nb;
            while(nb)
            {
                if(iov_len <= nb)
                {
                    nb -= iov_len;
                    --iovlen;
                    ++iovp;
                    iov_len = iovp->iov_len;
                    iov_base = iovp->iov_base;
                }
                else
                {
                    iov_base += nb;
                    iov_len -= nb;
                    nb = 0;
                }
            }
        }
        if(len != msg_getlen(mp))
            panic("algorithmic error in msg_fwrite");
        return(0);
  }

message *
msg_fread(file)
  FILE *file;
  {
        register message *mp;
        register long *space;
        register char *ptr;
        int length = 0;
        register nb;
        block_desc *blk_desc;

        while((nb = fread((char*)&length, 1, sizeof(long), file)) != sizeof(long))
        {
            if(nb == -1 && errno == EINTR)
                continue;
            return(0);
        }
        length = ntohl (length);
        blk_desc = msg_blockalloc(length, 0);
        space = (long *)blk_desc->addr;
        space[0] = htonl (length);
        ptr = (char*)&space[1];
        length -= sizeof(long);
        while(length)
        {
            while((nb = fread(ptr, 1, length, file)) <= 0)
            {
                if(nb == -1 && errno == EINTR)
                    continue;
                return(0);
            }
            length -= nb;
            ptr += nb;
        }
        if(mp = msg_reconstruct((char*)space, blk_desc))
            return(mp);
        return(0);
  }
