/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* Various dump routines */

/*
 *      Interface to most callers:
 *              print(fmt, args): prints to log and flushes
 *              cl_dump(level, "why"): generates a dump at requested level
 *              paddr(addr): prints address, no linefeed
 *              pmsg(&msg): prints sender/dests/msgid, then linefeed
 */

#include "isis.h"

cl_dump(level, why, a0, a1, a2, a3)
  char *why;
  {
        register queue *qp;
        register s;
        extern char *isis_joining;

        print("\nCLIENT PROCESS %d INTERNAL DUMP REQUESTED: ", my_process_id);
        print(why, a0, a1, a2, a3);
        print("\n");
        if((isis_state&ISIS_INIT) == 0)
        {
            print("This client has not (re)initialized ISIS\n");
            return;
        }
        if(isis_state&ISIS_STARTUP)
            print("This client is (re)starting\n");
        if(isis_joining)
            print("This client is joining group <%s>\n", isis_joining);
        if(isis_state&ISIS_CONGESTED)
            print("ISIS is congested at this site\n");
        if(isis_state&ISIS_XJOINS)
            print("This client has inhibited joins\n");
        if(level&DUMP_MEM)
        {
            print("Memory mgt: %d allocs, %d frees, %d bytes in use\n", nalloc, nfree, memalloc-memfree);
            print("Message counts: %d allocs %d frees (%d in use)\n",
                msg_namsgs, msg_nfmsgs, msg_namsgs-msg_nfmsgs);
        }
        if(qu_head(isis_tasks))
        {
            print("\nTasks: %d created, %d light-weight context switched\n", isis_created, isis_switched);
            for(qp = isis_tasks->qu_next; qp != isis_tasks; qp = qp->qu_next)
                dump_task(qp);
        }
        dump_act();
        dump_trans();
        if(qu_head(isis_pgmon) || qu_head(isis_wlist) || qu_head(isis_swlist))
        {
            print("\nMonitoring / watching:\n");
            site_monitor_dump();
            pg_monitor_dump();
            proc_monitor_dump();
            dump_cl_watch_queue();
        }
        dump_tokens();
        print("\nSite view %d/%d:\n", isis_sv.sv_viewid&0xFF, isis_sv.sv_viewid>>8);
        begin
        {
            register site_id *s;
            for(s = isis_sv.sv_slist; *s; s++)
                print("    %s\t[site_no %d  site_incarn %d]\n", site_names[SITE_NO(*s)],
                        SITE_NO(*s), SITE_INCARN(*s));
        }
        dump_interclient();
        pgroups_dump();
        g_dump();
        msg_trace_dump();
  }

paddrs(addr)
  address *addr;
  {
        if(addr == 0)
        {
            print("( ??? )");
            return;
        }
        while(addr->site)
            paddr(*addr++);
  }

paddr(addr)
  address addr;
  {
        print("(");
        switch(addr.type)
        {
          case ISAGID:
            print("gaddr=%d/%d.%d[", addr.site, addr.incarn, addr.groupid);
            pentry(addr, addr.entry);
            print("])");
            return;
          case ISACT:
            print("act=");
          case ISAPID:
            switch(addr.process)
            {
              case PROTOCOLS:
                print("%d/%d:pr.", addr.site, addr.incarn);
                break;
              case REXEC:
                print("%d/%d:rexec.", addr.site, addr.incarn);
                break;
              default:
                print("%d/%d:%d.", addr.site, addr.incarn, addr.process);
                break;
            }
            pentry(addr, addr.entry);
            print(")");
            return;
          default:
            print("** addr type %d? **)", addr.type);
        }
  }

peid(eid)
  event_id eid;
  {
        char *cl_getrname();
        print("eid=<e_pname "); 
        if(addr_isnull(eid.e_pname))
            print("*");
        else
            paddr(eid.e_pname);
        print("; e_op %s; e_msgid", eid.e_op? cl_getrname(eid.e_op): "*");
        if(eid.e_msgid)
            print(" %d>", eid.e_msgid);
        else
            print("*>");
  } 

address
atoaddr(str)
  char *str;
  {
        int site, incarn, gaddr, entry;
        address addr;

        bzero(&addr, sizeof(addr));
        if(*str == '(')
            ++str;
        switch(*str)
        {
          case 'g':
            sscanf(str, "gaddr %d/%d.%d[%d]", &site, &incarn, &gaddr, &entry);
            addr.site = site;
            addr.incarn = incarn;
            addr.groupid = gaddr;
            addr.entry = entry;
            addr.type = ISAGID;
            break;

          default:
            sscanf(str, "%d/%d:", &site, &incarn);
            addr.site = site;
            addr.incarn = incarn;
            addr.type = ISAPID;
            while(*str && *str != ':') ++str;
            if(*str++ == ':')
            {
                if(*str == 'p')
                    addr.process = PROTOCOLS;
                else if(*str == 'r')
                    addr.process = REXEC;
                else
                    addr.process = atoi(str);
            }
        }
        return(addr);
  }

psid(sid)
  site_id sid;
  {
        print("%d/%d", SITE_NO (sid), SITE_INCARN (sid));
  }

char    *proto_names[]
={
        "cbcast", "iterated cbcast",
        "abcast", "iterated abcast",
        "gbcast", "iterated gbcast",
        "bcast", "iterated bcast",
        "reply",
        "client",
};

pmsg(msg)
  register message *msg;
  {
        register *msgid = (int*)msg_getfield(msg, SYSFLD_MSGID, 1, NULLIARG);
        register *proto = (int*)msg_getfield(msg, SYSFLD_PROTO, 1, NULLIARG);
        register address *dp;
        print("MSG %x ", msg);
        if(proto)
          print("%s", proto_names[*proto]);
        print(" from ");
        paddr(msg_getsender(msg));
        print(" to ");
        paddrs(dp = msg_getdests(msg));
        if(msgid)
            print(" msgid %d", *msgid);
        if(dp && dp->entry == GENERIC_NEW_VIEW)
            print(" viewid %d", ((sys_groupview*)msg_getfield(msg, CL_NEWVIEW, 1, 0))->pg_viewid);
        print(" size %d", msg_getlen(msg));
        print("\n");
  }

FILE    *isis_outfile;

isis_logging(flag)
  {
        static FILE *file;
        char buf[30];
        if(file == 0)
        {
            sprintf(buf, "%d.log", getpid());
            file = fopen(buf, "w");
        }
        if(flag)
            isis_outfile = file;
        else
            isis_outfile = 0;
  }

dump_task(qp)
  queue *qp;
   {
        register task *tp = qp->qu_task;
        extern condition isis_decon_wait;
        print("  TASK: ");
        cl_rname(tp->task_routine);
        print("(%x) [tp=%x], ", tp->task_arg0, tp);
        if(tp->task_queue)
        {
            if(tp->task_sleep)
            {
                int ms = tp->task_sleep%1000;
                print("sleep(%d", tp->task_sleep/1000);
                if(ms) print(".%.3d", ms);
                print(")");
            }
            else if(tp->task_waitingfor)
                print("wait (%s)", tp->task_waitingfor);
            else
                print("wait on user-defined condition (%5x)", tp->task_queue);
        }
        else if(tp != isis_ctp)
            print("** suspended, not on a condition queue **");
        else if((tp->task_flag&TASK_CONGESTED) == 0)
            print("** running **");
        else
            print("waiting for ISIS to congestion to subside");
        if(tp->task_flag&TASK_START)
            print(", startup task");
        if(tp->task_flag&TASK_LOGGED)
            print(", logged");
        if(tp->task_flag&TASK_INHIBIT)
            print(", inhibiting joins");
        if(tp->task_msgid)
            print(", msgid=%d", tp->task_msgid);
        print(", activity=%d", tp->task_act);
        print("\n");
        if(tp->task_msgs && tp->task_msgs->qu_next != tp->task_msgs)
        {
            register queue *mp;
            for(mp = tp->task_msgs->qu_next; mp != tp->task_msgs; mp = mp->qu_next)
            {
                print("  ...");
                pmsg(mp->qu_msg);
            }
        }
  }

dump_sid(qp)
  queue *qp;
  {
        print("%d/%d", SITE_NO(qp->qu_sid), SITE_INCARN(qp->qu_sid));
  }

dump_cond(qp)
  register queue *qp;
  {
        print("%x", qp->qu_cond);
  }

dump_sview(sv)
  register sview *sv;
  {
        register i;
        print("Got new sview!\n");
        print("sv->viewid %d/%d ", sv->sv_viewid&0xFF, sv->sv_viewid>>8);
        for(i = 0; sv->sv_slist[i]; i++)
            print("<%d/%d> ", SITE_NO(sv->sv_slist[i]), SITE_INCARN(sv->sv_slist[i]));
        print("\n");
        for(i = 0; i < MAX_SITES+1; i++)
            if(sv->sv_incarn[i] != DOWN_INCARN)
                print("sv_incarn[%d] = %d\n", i, sv->sv_incarn[i]);
        for(i = 0; i < MAX_SITES+1; i++)
            if(bit(sv->sv_failed, i))
                print("site %d has failed since the last view\n", i);
        for(i = 0; i < MAX_SITES+1; i++)
            if(bit(sv->sv_recovered, i))
                print("site %d has recovered since the last view\n", i);
  }


/*
 *  Note: it is perfectly reasonable for this to return 0 if you don't
 *  have an easy way to compute the <n'th> level caller's address on your
 *  machine.  We only use this for debugging in the message-trace routines
 */
char    *db_caller;
char *
callername (n_levels)
  int   n_levels;

{
#   if(SUN3)
    {
        asm ("movl a6, a0");
        while (n_levels-- > 0)
            asm ("movl a0@, a0");
        asm ("movl a0@(0x4), _db_caller");
    }
#   endif
#   if(HPUX)
    {
#ifdef hp9000s300
        asm ("mov.l %a6, %a0");
        while (n_levels-- > 0)
            asm ("mov.l (%a0), %a0");
        asm ("mov.l 0x4(%a0), _db_caller");
#endif hp9000s300
#ifdef hp9000s800
        db_caller = get_sp();
#endif hp9000s800
    }
#   endif
    return (db_caller);
}
