/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *
 *      ISIS distributed systems toolkit: coordinator-cohort algorithm
 */

#include "isis.h"
 
#ifdef  GOULD 
# undef gould           /* Correct bizarre problem with va_arg on struct passed by value */  
#endif 
#include <varargs.h>

queue   *cc_watching();
static  queue *cc_list, *res_list;
int     cc_result();

coord_init()
  {
        static initflag;

        if(!initflag)
        {
            int cohort();
            ++initflag;
            cc_list = qu_null();
            res_list = qu_null();
            isis_entry(GENERIC_CC_RESULT, cc_result, "coord_cohort:cc_result");
            isis_task(cohort, "coord_cohort:cohort");
        }
  }

coord_cohort(msg, gaddr, action, got_result, arg)
  message *msg;
  address gaddr;
  ifunc *action, *got_result;
  char *arg;
  {
        register message *rmsg;
        address coord, *players;
        register address *clist, *ap, *cp;
        int cohort(), how, wid;
        char *result, *t_wait_l();
        register groupview *gv;

        begin
        {
            /* Make a copy for safekeeping */
            register len;
            if(msg)
            {
                ap = msg_getdests(msg);
                len = sizeof(address)*(3+alist_len(ap));
                cp = clist = (address*)malloc(len);
                *cp = msg_getreplyto(msg);
                (cp++)->entry = GENERIC_RCV_REPLY;
                players = cp;
            }
            else
            {
                gv = pg_getlocalview(gaddr);
                if(gv == (groupview*)0)
                    return(-1);
                ap = gv->gv_members;
                len = sizeof(address)*(3+alist_len(ap));
                players = cp = clist = (address*)malloc(len);
            }
            while(!addr_isnull(*ap))
            {
                *cp = *ap++;
                (cp++)->entry = GENERIC_CC_RESULT;
            }
            *cp = NULLADDRESS;
        }
        how = ORIGINAL;
        do
        {
            address coordinator(), sender;
            int msgid = -1;

            if(msg)
                sender = msg_getsender(msg);
            else
                sender = gv->gv_members[0];
            if(msg)
                msgid = *(int*)msg_getfield(msg, SYSFLD_MSGID, 1, NULLIARG);

            coord = coordinator(gaddr, sender, players);
            coord.entry = 0;

            if(addr_cmp(coord, my_address) == 0)
            {
                for(cp = ap = clist; !addr_isnull(*cp); cp++)
                    if(!addr_ismine(*cp) || cp->entry != GENERIC_CC_RESULT)
                        *ap++ = *cp;
                *ap = NULLADDRESS;
                isis_ctp->task_cohorts = clist;
                isis_ctp->task_ccmsgid = msgid;
                isis_ctp->task_truesender = sender;

                (*action)(msg, gaddr, how, arg);

                isis_ctp->task_cohorts = 0;
                free(clist);
                return(0);
            }
            else
            {
                /* Save information under <sender,msgid> */
                register queue *wp, *qp;
                wp = cc_watching(sender, msgid);
                wid = 0;
                how = TAKEOVER;
                if((wid = pg_watch(gaddr, coord, W_LEAVE, cohort, (char*)&wp->qu_cond)) > 0)
                    rmsg = (message*)t_wait_l(&wp->qu_cond, "isis system: cohort waiting for coord termination message");
                else
                    rmsg = NULLMP;
                qu_free(wp);
                /* Now clean up queues */
                for(wp = cc_list->qu_next; wp != cc_list; wp = qp)
                {
                    qp = wp->qu_next;
                    if(qu_head(wp->qu_queue) == 0)
                        qu_free(wp);
                }
            }
        }
        while(rmsg == 0);
        pg_watch_cancel(wid);
        if(got_result)
            (*got_result)(rmsg);
        msg_delete(rmsg);
        free(clist);
        return(0);
 }

/*
 * Lookup session info, which is stored under <sender,msgid>.  Sender will
 * be the first listed address.  Might not find result, but this is no big deal.
 * It occurs when proceses join a group, in which case a new member might  
 * not have been a participant in a previously started coordinator-cohort computation.
 */
cc_result(msg)
  register message *msg;
  {
        register address *ap;
        register queue *qp, *wp;
        register msgid;
        address sender;

        cc_gotres(0);
        msgid = *(int*)msg_getfield(msg, SYSFLD_MSGID, 1, NULLIARG);
        sender = *(address*)msg_getfield(msg, FLD_TRUESENDER, 1, NULLIARG);
        if((qp = pg_find(cc_list, sender)) == 0)
            goto not_fnd;
        if((wp = qu_find(qp->qu_queue, msgid)) == 0)
            goto not_fnd;
        if(wp->qu_cond == 0)
            goto not_fnd;
        msg_increfcount(msg);
        cc_gotres(1);
        t_sig(&wp->qu_cond, (char*)msg);
        qu_remove(wp);
        return;
  not_fnd:
        msg_increfcount(msg);
        if((qp = pg_find(res_list, sender)) == 0)
            qp = pg_add_qu(res_list, sender, qu_null());
        if((wp = qu_find(qp->qu_queue, msgid)) == 0)
            wp = qu_add_mp(qp->qu_queue, msgid, msg, msg_delete);
        else 
            panic("cc_result: %d/%d already on res_list", sender.process, msgid);
  }

cc_panic(msg, who, msgid, why)
  message *msg;
  address who;
  char *why;
  {
        register queue *qp, *wp;

        print("%d: cc_panic: %s, sender ", my_process_id, why);
        paddr(who);
        pmsg(msg);
        print(", cc_queue:");
        for(qp = cc_list->qu_next; qp != cc_list; qp = qp->qu_next)
        {
            print("\n  CC ");
            paddr(qp->qu_pname);
            for(wp = qp->qu_queue->qu_next; wp != qp->qu_queue; wp = wp->qu_next)
                print(" = msgid %d... ", wp->qu_name);
        }
        print("\n");
        exit(0);
  }

/* Figure out who the coordinator should be */
address
coordinator(gaddr, sender, players)
  register address *players;
  address sender, gaddr;
  {
        register groupview *gv = pg_getlocalview(gaddr);
        register address *ap, *bp;
        register alen;

        if(gv == 0)
            panic("left a group while a coord-cohort computation was active");
        sender.entry = 0;
        for(ap = players; !addr_isnull(*ap); ap++)
            if(addr_ismine(*ap))
                break;
        if(addr_isnull(*ap))
        {
            print("I am "); paddr(my_address);
            print(" players "); paddrs(players);
            print("\n");
            panic("coordinator computation: didn't find self in player list");
        }
        for(ap = players; !addr_isnull(*ap); ap++)
            if(addr_cmp(*ap, sender) == 0)
                return(sender);
        alen = ap-players;
        for(ap = players; !addr_isnull(*ap); ap++)
            if(ap->site == sender.site)
                break;
        if(ap->site == 0)
            /* In this case, share the load */
            ap = &players[sender.site % alen];
        bp = ap;
        do
        {
            register address *vp;
            /* See if this guy is up */
            for(vp = gv->gv_members; !addr_isnull(*vp); vp++)
                if(addr_cmp(*vp, *ap) == 0)
                    return(*vp);
            /* Nope, move on to the next one */
            if((++ap)->site == 0)
                ap = players;
        }
        while(ap != bp);
        return(NULLADDRESS);
  }

/* Watch goes off: pass a null message pointer to the waiting task */
cohort(gaddr, paddr, event, cond)
  address gaddr, paddr;
  register condition *cond;
  {
        t_sig(cond, NULLARG);
  }

/* Maintain queue of <session,msgid> = cond */
queue *
cc_watching(sender, msgid)
  address sender;
  {
        register queue *qp, *wp;
        /* First check to see if we got the result early */
        if(qp = pg_find(res_list, sender))
            if(wp = pg_find(qp->qu_queue, msgid))
            {
                t_fork_msg(cc_result, wp->qu_msg);
                qu_free(wp);
                if(qu_head(qp->qu_queue) == 0)
                    qu_free(qp);
            }
        if((qp = pg_find(cc_list, sender)) == 0)
            qp = pg_add_qu(cc_list, sender, qu_null());
        if((wp = qu_find(qp->qu_queue, msgid)) == 0)
            wp = qu_add_cond(qp->qu_queue, msgid);
        else
        {
            print("cc_watching was called twice for %d/%d.  There should be two active tasks...\n", sender.process, msgid);
            isis_logging(1);
            cl_dump(-1, "cc_watching");
            isis_logging(0);
            cl_dump(-1, "cc_watching");
            panic("cc_watching %d/%d", sender.process, msgid);
        }
        return(wp);
  }

/* Sends a reply to cohorts only */
cc_terminate(va_alist)
  va_dcl
  {
        register message *msg = msg_newmsg();
        va_list ap;
        if(isis_ctp->task_cohorts)
            panic("cc_terminate: cohorts unknown or multiple invocation\n");
        msg_insertfield(msg, SYSFLD_MSGID, (char*)&isis_ctp->task_ccmsgid, FTYPE_LONG, sizeof(int));
        msg_insertfield(msg, FLD_TRUESENDER, (char*)&isis_ctp->task_truesender, FTYPE_ADDRESS, sizeof(address));
        va_start(ap);
        msg_doputf(msg, SYSFLD_SCAN, &ap);
        (void)cbcast_l("lm", isis_ctp->task_cohorts, msg, 0);
        va_end(ap);
        isis_ctp->task_cohorts = 0;
  }
