/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      This module implements the client-client bypass mechanism
 */

#include "isis.h"


queue   *bypass_queue;

bypass_init()
  {
        int bypass_recv(), bypass_control();
        isis_entry(GENERIC_BYPASS, bypass_recv, "bypass_recv");
        isis_entry(GENERIC_BYCNTL, bypass_control, "bypass_control");
        if(bypass_queue == 0)
            bypass_queue = qu_null();
  }

/* ISIS protos->local bypass facility */
bypass_control(mp)
  register message *mp;
  {
        nullreply(mp);
  }

/* ISIS protos sometimes piggybacks bypass flags on other messages */
bypass_piggyback(mp)
  register message *mp;
  {
        register *bypass_info;
        if((bypass_info = (int*)msg_getfield(mp, SYSFLD_BYPASS, 1, (int*)0)) == 0)
            return;
  }

message *
bypass_send(protocol, dests, msg, nwant)
  register address *dests;
  register message *msg;
  {
        message *collect_replies();
        register groupview *gv;
        register ginfo *gip;
        register address *ap, *dp;
        register entry, myrank;
        int msgid, bypass_sent();
        address *msg_setdests();
        int exmode = 0, abmode = 0;
        extern ISIS_MSGID;

#ifdef  BYPASS
        switch(protocol)
        {
          case CL_ABCAST_EX:
              ++exmode;
          case CL_ABCAST:
              ++abmode;
              break;

          case CL_FBCAST_EX:
          case CL_CBCAST_EX:
              ++exmode;

          case CL_FBCAST:
          case CL_CBCAST:
              break;

          default:
              return(0);
        }
        if((isis_state&ISIS_INIT) == 0)
            panic("attempt to broadcast failed: must call isis_init first!");
        if((isis_state&ISIS_BINHIBIT) || !addr_isnull(dests[1]) || dests[0].type != ISAGID)
            return(0);
        if(gip = map_gaddr(dests[0]))
        {
            gv = isis_mutex? &gip->gi_mutexview: &gip->gi_view;
            if(!(gv->gv_flag&PG_VALID))
                return(0);
        }
        else
            return(0);
        myrank = 0;
        for(ap = gv->gv_members; !addr_isnull(*ap); ap++)
            if(addr_cmp(*ap, my_address) == 0)
                break;
            else
                ++myrank;
        if(myrank == gv->gv_nmemb)
            return(0);
        msgid = isis_ctp->task_msgid;
        if(msgid == 0)
            msgid = (ISIS_MSGID += 2)+1;
        msg_setsender(msg, isis_ctp->task_addr);
        dp = ap = msg_setdests(msg, gv->gv_members);
        entry = dests[0].entry;
        while(!addr_isnull(*ap))
            ap++->entry = entry;
        msg_insertfield(msg, SYSFLD_MSGID, (char*)&msgid, FTYPE_LONG, sizeof(int));
        msg_insertfield(msg, SYSFLD_BYINFO, (char*)dests, FTYPE_ADDRESS, sizeof(address));
        ++gip->gi_bseqns[myrank];
        msg_insertfield(msg, SYSFLD_BYPASS, (char*)gip->gi_bseqns, FTYPE_LONG, sizeof(long)*gv->gv_nmemb);
        if(isis_ctp->task_act)
            msg_insertfield(msg, SYSFLD_ACT, (char*)&act_map[isis_ctp->task_act].act_id, FTYPE_ADDRESS, sizeof(address));
if(abmode) panic("intercl abcast not implemented yet");
        intercl_send(exmode, msg, dp, bypass_sent, msgid, 0);
        if(nwant)
            return(collect_replies(msgid, nwant));
        return((message*)-1);
#else
        return(0);
#endif
  }

/* intercl_send informs us that <msgid> "made it" to <dest> */
bypass_sent(dest, msgid, null)
  address dest;
  register msgid;
  {
  }

bypass_recv(gaddr, mp)
  register address *gaddr;
  register message *mp;
  {
        register *bseqn, *gp;
        register ginfo *gip;
        register groupview *gv;
        register flag;
        int blen, n, *obseqn;
        obseqn = bseqn = (int*)msg_getfield(mp, SYSFLD_BYPASS, 1, &blen);
        if(gip = map_gaddr(*gaddr))
        {
            gv = isis_mutex? &gip->gi_mutexview: &gip->gi_view;
            if(!(gv->gv_flag&PG_VALID))
                panic("bypass_recv: invalid group");
        }
        else
            panic("bypass_recv: unknown group");
        if((blen>>2) != gv->gv_nmemb)
        {
            cl_dump(-1, "unexpected mlist len");
            panic("bypass_recv: mlist len %d != expected %d", blen, gv->gv_nmemb);
        }
        gp = gip->gi_bseqns;
        flag = 0;
        for(n = 0; n < gv->gv_nmemb; n++)
            if(*bseqn++ < *gp++ && !addr_ismine(gv->gv_members[n]))
            {
                msg_increfcount(mp);
                qu_add_mp(gip->gi_bypassq, n, mp, NULLROUTINE);
print(".... BYPASS: spool a message\n");
                flag |= 1;
                break;
            }
        bseqn = obseqn;
        gp = gip->gi_bseqns;
        for(n = 0; n < gv->gv_nmemb; n++)
            if(*bseqn++ > *gp++)
            {
                gp[-1] = bseqn[-1];
                flag |= 2;
            }
        if((flag&1) == 0)
            isis_gotmsg(mp, BYP_DONTCHECK);
        if(flag&2)
        {
            register queue *qp, *nqp;
            for(qp = gip->gi_bypassq->qu_next; qp != gip->gi_bypassq; qp = nqp)
            {
                register message *msg;
                nqp = qp->qu_next;
                if((msg = qp->qu_msg) == mp)
                    continue;
                bseqn = (int*)msg_getfield(msg, SYSFLD_BYPASS, 1, &blen);
                blen >>= 2;
                if(blen != gv->gv_nmemb)
                    panic("bypass_recv: mlist has wrong length for queued msg!");
                for(n = 0; n < gv->gv_nmemb; n++)
                    if(*bseqn < *gp)
                        break;
                if(n == gv->gv_nmemb)
                {
print(".... BYPASS: despool a message\n");
                    isis_gotmsg(msg, BYP_DONTCHECK);
                    qu_free(qp);
                }
            }
        }
  }

bypass_newview(gv)
  {
        intercl_newview(gv);
  }

message *
collect_replies(msgid, nwant)
  {
        register message *rmp = msg_newmsg();
        isis_ctp->task_msgid = msgid;
        while(nwant--)
        {
            register message *mp = (message*)t_wait_l(&isis_ctp->task_mwant, "isis system: collecting bcast replies");
            msg_addmsg(rmp, FLD_ANSW, mp);
        }
        isis_ctp->task_msgid = 0;
        return(rmp);
  }

intercl_reply(fmsg, rmsg)
  message *fmsg, *rmsg;
  {
        register address *dp = msg_setdest(rmsg, msg_getreplyto(fmsg));
        register address *ap;
        register ginfo *gip;
        register groupview *gv;
        ap = (address*)msg_getfield(fmsg, SYSFLD_BYINFO, 1, (int*)0);
        if((gip = map_gaddr(*ap)) == (ginfo*)0)
            panic("intercl_reply: message took bypass route but gaddr map failed!");
        gv = isis_mutex? &gip->gi_mutexview: &gip->gi_view;
        if(!(gv->gv_flag&PG_VALID))
            return(0);
        msg_insertfield(rmsg, SYSFLD_BYINFO, (char*)ap, FTYPE_ADDRESS, sizeof(address));
        msg_insertfield(rmsg, SYSFLD_BYPASS, (char*)gip->gi_bseqns, FTYPE_LONG, sizeof(long)*gv->gv_nmemb);
        if(isis_ctp->task_act)
            msg_insertfield(rmsg, SYSFLD_ACT, (char*)&map_act(isis_ctp->task_act), FTYPE_ADDRESS, sizeof(address));
        intercl_send(0, rmsg, dp, NULLROUTINE, 0, 0);
  }
