/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 * Client entry routines in ISIS: unpack args and dispatch request
 */
#include "isis.h"
 
#ifdef  GOULD 
# undef gould           /* Correct bizarre problem with va_arg on struct passed by value */  
#endif 
#include <varargs.h>

message *isis_rpc(), *bypass_send();
address PRO();
int     ISIS_MSGID;

struct bc_args
{
        short           bc_pname;
        short           bc_options;
        short           bc_rval;
        short           bc_nsent;
        short           bc_nreplies;
        short           bc_done;
        short           bc_errno;
        address         bc_dest;
        va_list         *bc_ap; 
        char            *bc_acopy;
        condition       bc_await;
        event_id        bc_eid;
};

static adesc bc_ad ={ sizeof(bc_args), sizeof(bc_args), 2};

#define bc_alloc()  (bc_args*)mallocate(&bc_ad)

bc_free(bc)
  register bc_args *bc;
  {
        if(bc->bc_acopy)
            free(bc->bc_acopy);
        mdeallocate((char*)bc, &bc_ad);
  }

static  queue   *bc_queue;
static  BCID;

#define BASIC_BCAST(rname, pro)                                         \
/* VARARGS */                                                           \
rname(va_alist)                                                         \
  va_dcl                                                                \
  {                                                                     \
        int rval;                                                       \
        va_list ap;                                                     \
        va_start(ap);                                                   \
        rval = do_bcast(pro, 0, "", &ap);                               \
        va_end(ap);                                                     \
        return(rval);                                                   \
  }

#define BCAST_L(rname, pro, pro_ex)                                     \
/* VARARGS */                                                           \
rname(va_alist)                                                         \
  va_dcl                                                                \
  {                                                                     \
        register rval;                                                  \
        va_list ap;                                                     \
        va_start(ap);                                                   \
        rval = do_bcast(pro, pro_ex, va_arg(ap, char*), &ap);           \
        va_end(ap);                                                     \
        return(rval);                                                   \
  }

BASIC_BCAST(bcast,CL_ABCAST)
BASIC_BCAST(abcast,CL_ABCAST)
BASIC_BCAST(cbcast,CL_CBCAST)
BASIC_BCAST(fbcast,CL_FBCAST)
BASIC_BCAST(gbcast,CL_GBCAST)
BCAST_L(bcast_l,CL_ABCAST,CL_ABCAST_EX)
BCAST_L(abcast_l,CL_ABCAST,CL_ABCAST_EX)
BCAST_L(cbcast_l,CL_CBCAST,CL_CBCAST_EX)
BCAST_L(fbcast_l,CL_FBCAST,CL_FBCAST_EX)
BCAST_L(gbcast_l,CL_GBCAST,CL_GBCAST_EX)
BCAST_L(gbcast_grow,CL_GBCAST_GROW,CL_GBCAST_GROW)

#define O_GUARD         0x0001
#define O_LIST          0x0002
#define O_TASK          0x0004
#define O_CC            0x0008
#define O_MSEND         0x0010
#define O_MRCV          0x0020
#define O_LAZY          0x0040
#define O_REPLY         0x0080

do_bcast(pro, pro_ex, opstr, ap)
  register char *opstr;
  va_list *ap;
  {
        int rval;
        register bc_args *bc = bc_alloc();
        /* Tricky code to make a copy of args for use in a forked off call... */
        while(*opstr)
          switch(*opstr++)
          {
            default:
                isis_errno = IE_BADARG;
                bc_free(bc);
                return(-1);
            case 'g':
                /* Guard specified */
                bc->bc_options |= O_GUARD;
                continue;
            case 'l':
                /* Long form */
                bc->bc_options |= O_LIST;
                continue;
            case 'm':
                /* Both are messages */
                bc->bc_options |= O_MSEND|O_MRCV;
                continue;
            case 's':
                /* Sending a message, but reply can be unpacked */
                bc->bc_options |= O_MSEND;
                continue;
            case 'r':
                /* Sending normally, but want reply messages */
                bc->bc_options |= O_MRCV;
                continue;
            case 'x':
                pro = pro_ex;
                continue;
            case 'f':
                /* Fork a task handled by BCAST_L */
                bc->bc_options |= O_TASK;
                continue;
            case 'z':
                /* Lazy */
                bc->bc_options |= O_LAZY;
                continue;
            case 'R':
                /* reply, ignore congestion */
                bc->bc_options |= O_REPLY;
                continue;
          }
        bc->bc_pname = pro;
        if((bc->bc_options&O_TASK) == 0)
        {
            bc->bc_ap = ap;
            BCAST(bc);  
            rval = bc->bc_rval;
            bc_free(bc);
        }
        else
        {
            extern STACKLEN, BCAST();
            register off;
            off = (int) (&isis_ctp->task_data[STACKLEN]-((char*)&ap));
            bc->bc_acopy = (char*)malloc(off);
            bcopy((char*)&ap, bc->bc_acopy, off);
            off = bc->bc_acopy-(char*)&ap;
            /* Relocate the two things that point into the current stack */
            ap = (va_list*)(((char*)ap) + off);
            *ap = (va_list)((*(char**)ap)+off);
            bc->bc_ap = ap;
            if(bc_queue == NULLQP)
                bc_queue = qu_null();
            rval = ++BCID;
            qu_add_bc(bc_queue, BCID, bc);
            t_fork_urgent(BCAST, (char*)bc);
        }
        return(rval);
  }

bc_wait(bcid)
  register bcid;
  {
        register rval;
        register bc_args *bc;
        register queue *qp;
        if(bc_queue == 0 || (qp = qu_find(bc_queue, bcid)) == NULLQP)
        {
            isis_errno = IE_BADARG;
            return(-1);
        }
        bc = qp->qu_bc;
        qu_free(qp);
        if(bc->bc_done == 0)
            t_wait_l(&bc->bc_await, "isis system: waiting for bcast completion");
        rval = bc->bc_rval;
        isis_nsent = bc->bc_nsent;
        isis_nreplies = bc->bc_nreplies;
        isis_errno = bc->bc_errno;
        if(bc->bc_await)
            t_sig(&bc->bc_await, 0);
        else
            bc_free(bc);
        return(rval);
  }

bc_poll(bcid)
  register bcid;
  {
        register rval;
        register bc_args *bc;
        register queue *qp;
        if(bc_queue == 0 || (qp = qu_find(bc_queue, bcid)) == NULLQP)
        {
            isis_errno = IE_BADARG;
            return(-1);
        }
        bc = qp->qu_bc;
        return(bc->bc_done);
  }

event_id
bc_getevent(bcid)
  register bcid;
  {
        static event_id eid;
        register queue *qp;
        if(bc_queue == 0 || (qp = qu_find(bc_queue, bcid)) == NULLQP)
            return(eid);
        return(qp->qu_bc->bc_eid);
  }

address
eid_sender(eid)
  event_id eid;
  {
        return(eid.e_pname);
  }

bc_cancel(bcid)
  register bcid;
  {
        register queue *qp;
        int outcome;
        if(bc_queue == 0 || (qp = qu_find(bc_queue, bcid)) == NULLQP)
            return(0);
        gbcast(qp->qu_bc->bc_dest, GENERIC_G_CANCEL, "%e", bc_getevent(bcid), 1, "%d", &outcome);
        return(outcome);
  }

BCAST(bc)
  register bc_args *bc;
  {
        register message *msg;
        static message *Rmsgs[MAX_PROCS], **rmsgs = Rmsgs;
        address dest, *alist;
        int nwant, allocated = 0, nresp;
        char *nsent;
        message *rmsg, *gmsg;
        char *gformat;

        if(bc->bc_options&O_GUARD)
        {
            gformat = **(char***)bc->bc_ap;
            if(g_preparse(gformat) == -1)
            {
                bc->bc_rval = -1;
                goto done;
            }
            gmsg = msg_newmsg();
            if(msg_doputf(gmsg, SYSFLD_SCAN, bc->bc_ap) == -1)
            {
                msg_delete(gmsg);
                bc->bc_rval = -1;
                goto done;
            }
        }
        if(bc->bc_options&O_LIST)
            alist = va_arg(*bc->bc_ap, address *);
        else
        {
            static address addr[2];
	    extern pushes_by_ref;
            if(pushes_by_ref == -1)
		check_varargs();
            if(pushes_by_ref == 1)
                addr[0] = *va_arg(*bc->bc_ap, address*);
            else
                addr[0] = va_arg(*bc->bc_ap, address);
            addr[0].entry = va_arg(*bc->bc_ap, int);
            alist = addr;
        }
        if(bc->bc_options&O_GUARD)
        {
            if(alist_len(alist) != 1 || alist[0].type != ISAGID || pg_rank(alist[0], my_address) == -1)
            {
                isis_errno = IE_GUARD;
                bc->bc_rval = -1;
                msg_delete(gmsg);
                goto done;
            }
        }
        if(bc->bc_options&O_MSEND)
            msg = va_arg(*bc->bc_ap, message *);
        else
        {
            msg = msg_newmsg();
            allocated = 1;
            if(msg_doputf(msg, SYSFLD_SCAN, bc->bc_ap) == -1)
            {
                msg_delete(msg);
                bc->bc_rval = -1;
                goto done;
            }
        }
        if(bc->bc_options&O_LAZY)
            msg_makelazy(msg, LAZY_ALWAYS);
        if(bc->bc_options&O_GUARD)
        {
            bc->bc_dest = *alist;
            if(!allocated && msg_getfield(msg, SYSFLD_GUARD, 1, (int*)0))
                msg_deletefield(msg, SYSFLD_GUARD, 1);
            msg_putfld(msg, SYSFLD_GUARD, "%s,%m,%a", gformat, gmsg, *alist);
            msg_delete(gmsg);
            bc->bc_eid.e_op = alist->entry;
            alist->entry = GENERIC_G_EVAL;
        }
        else
            bc->bc_eid.e_op = -1;
        bc->bc_eid.e_pname = my_address;
        nwant = va_arg(*bc->bc_ap, int);
        isis_ctp->task_msgid = (ISIS_MSGID += 2)+(nwant != 0);
        bc->bc_eid.e_msgid = isis_ctp->task_msgid;
        msg_insertfield(msg, SYSFLD_EID, &bc->bc_eid, FTYPE_EVENT, sizeof(event_id));
        if(isis_ctp->task_act)
        {
            address act;
            act = map_act(isis_ctp->task_act);
            msg_insertfield(msg, SYSFLD_ACT, &act, FTYPE_ADDRESS, sizeof(address));
        }
        if(rmsg = bypass_send(bc->bc_pname, alist, msg, nwant))
        {
            if(nwant == 0)
            {
                isis_nsent = isis_nreplies = 0;
                goto done;
            }
        }
        else
        {
            register message *mp = msg_newmsg();
            msg_setsender(mp, isis_ctp->task_addr);
            msg_put(mp, "%A,%m,%d,%b", alist, alist_len(alist)+1, msg, nwant, my_bcastscope);
            if(allocated)
                msg_delete(msg);
            dest = PRO(bc->bc_pname);
            if((bc->bc_options&O_REPLY) == 0)
            {
                isis_input_drain();
                if(isis_state&ISIS_CONGESTED)
                    isis_decon_wait(nwant);
            }
            if(nwant == 0)
            {
                isis_send(dest, mp);
                isis_nsent = isis_nreplies = 0;
                msg_delete(mp);
                goto done;
            }
            rmsg = isis_rpc(dest, mp, bc->bc_options&O_TASK);
            msg_delete(mp);
        }
        if(nsent = msg_getfield(rmsg, FLD_NSENT, 1, NULLIARG))
            isis_nsent = *nsent;
        else
            isis_nsent = 0;
        if(bc->bc_options&O_MRCV)
            rmsgs = va_arg(*bc->bc_ap, message**);
        isis_nreplies = nresp = msg_getmsgs(rmsg, FLD_ANSW, rmsgs, MAX_PROCS);
        if(nresp == 0)
        {
            register *cl_errno = (int*)msg_getfield(rmsg, SYSFLD_ERRNO, 1, NULLIARG);
            msg_delete(rmsg);
            if(cl_errno)
            {
                isis_errno = *cl_errno;
                bc->bc_rval = -1;
                goto done;
            }
            goto done;
        }
        if((bc->bc_options&O_MRCV) == 0)
        {
            if(msg_dogetf(rmsgs, nresp, SYSFLD_SCAN, NULLIARG, bc->bc_ap) == -1)
            {
                extern char *isis_format;
                print("format <%s>: ", isis_format);
                isis_perror("msg_getf failed when unpacking replies");
            }
            while(nresp--)
                msg_delete(rmsgs[nresp]);
        }
        msg_delete(rmsg);
        bc->bc_rval = isis_nreplies;
  done:
        bc->bc_nsent = isis_nsent;
        bc->bc_nreplies = isis_nreplies;
        bc->bc_errno = isis_errno;
        ++bc->bc_done;
        if(bc->bc_await)
            t_sig(&bc->bc_await, 0);
  }

flush()
  {
        register message *mp = msg_newmsg(), *rmsg;
        rmsg = isis_rpc(PRO(CL_WANTFLUSH), mp, 0);
        msg_delete(mp);
        msg_delete(rmsg);
  }

/* Send reply message to the sender of a message */
nullreply(msg)
  message *msg;
  {
        register message *rmsg;
        int *msgid = (int*)msg_getfield(msg, SYSFLD_MSGID, 1, NULLIARG);
        if(msgid == 0)
            return;
        rmsg = msg_newmsg();
        msg_addfield(rmsg, FLD_ISNULLREP, 0, 0, 0);
        msg_insertfield(rmsg, SYSFLD_MSGID, (char*)msgid, FTYPE_LONG, sizeof(int));
        cbcast_l("mR", msg_getreplyto(msg), GENERIC_RCV_REPLY, rmsg, 0);
        msg_delete(rmsg);
  }

/* Send abort reply message to the sender of a message */
abortreply(msg)
  message *msg;
  {
        int ie_abort = IE_ABORT;
        register message *rmsg;
        int *msgid = (int*)msg_getfield(msg, SYSFLD_MSGID, 1, NULLIARG);
        if(msgid == 0)
            return;
        rmsg = msg_newmsg();
        msg_addfield(rmsg, FLD_ISABORTREP, &ie_abort, FTYPE_LONG, sizeof(int));
        msg_insertfield(rmsg, SYSFLD_MSGID, (char*)msgid, FTYPE_LONG, sizeof(int));
        cbcast_l("mR", msg_getreplyto(msg), GENERIC_RCV_REPLY, rmsg, 0);
        msg_delete(rmsg);
  }

reply(va_alist)
  va_dcl
  {
        va_list ap;
        register message *rmsg, *msg;
        int *msgid;

        va_start(ap);
        msg = va_arg(ap, message *);
        if(msgid = (int*)msg_getfield(msg, SYSFLD_MSGID, 1, NULLIARG))
        {
            rmsg = msg_newmsg();
            if(msg_doputf(rmsg, SYSFLD_SCAN, &ap) == -1) panic("REPLY: CAN'T GENERATE!");
            msg_insertfield(rmsg, SYSFLD_MSGID, (char*)msgid, FTYPE_LONG, sizeof(int));
            if(isis_ctp->task_cohorts == 0)
                cbcast_l("mR", msg_getreplyto(msg), GENERIC_RCV_REPLY, rmsg, 0);
            else
            {
                msg_insertfield(rmsg, FLD_TRUESENDER, (char*)&isis_ctp->task_truesender, FTYPE_ADDRESS, sizeof(address));
                cbcast_l("mlR", isis_ctp->task_cohorts, rmsg, 0);
            }
            msg_delete(rmsg);
        }
        va_end(ap);
  }

reply_l(va_alist)
  va_dcl
  {
        va_list ap;
        register message *rmsg, *msg;
        int *msgid;
        int excl = 0, options = 0;
        char *opstr;
        static address rdests[MAX_PROCS];
        register address *rp;

        va_start(ap);
        opstr = va_arg(ap, char*);
        msg = va_arg(ap, message*);
        while(*opstr)
          switch(*opstr++)
          {
            default:  panic("reply_l: bad option");
            case 'm': options |= O_MSEND; continue;
            case 'c': options |= O_CC; continue;
            case 'x': excl++; continue;
          }
        rp = rdests;
        if(isis_ctp->task_cohorts == 0)
        {
            *rp = msg_getreplyto(msg);
            rp++->entry = GENERIC_RCV_REPLY;
        }
        else
        {
            register address *xrp = isis_ctp->task_cohorts;
            do
                *rp++ = *xrp;
            while(!addr_isnull(*xrp++));
        }
        if(options&O_CC)
        {
            register address *xrp = va_arg(ap, address*);
            do
                *rp++ = *xrp;
            while(!addr_isnull(*xrp++));
        }
        *rp = NULLADDRESS;
        if(rp >= &rdests[MAX_PROCS])
            panic("too many destinations in a reply message\n");
        if(msgid = (int*)msg_getfield(msg, SYSFLD_MSGID, 1, NULLIARG))
        {
            if(options&O_MSEND)
                rmsg = va_arg(ap, message*);
            else
            {
                rmsg = msg_newmsg();
                msg_doputf(rmsg, SYSFLD_SCAN, &ap);
            }
            msg_insertfield(rmsg, SYSFLD_MSGID, (char*)msgid, FTYPE_LONG, sizeof(int));
            if(isis_ctp->task_cohorts)
                msg_insertfield(msg, FLD_TRUESENDER, (char*)&isis_ctp->task_truesender, FTYPE_ADDRESS, sizeof(address));
            cbcast_l(excl? "mxlR": "mlR", rdests, rmsg, 0);
            if((options&O_MSEND) == 0)
                msg_delete(rmsg);
        }
        else
            panic("reply_l: replying to non-RPC message");
        isis_ctp->task_cohorts = 0;
        va_end(ap);
  }

/* Forward <fmsg> to <to.ent> by actually delivering <cmsg> to that dest */
forward(fmsg, to, ent, cmsg)
  message *fmsg, *cmsg;
  address to;
  int ent;
  {
        static address dests[3], finfo[2];
        register *msgid;
        if(to.type != ISAPID)
            panic("forward: illegal to forward to a group");
        dests[0] = msg_getreplyto(fmsg);
        dests[1].entry = GENERIC_RCV_REPLY;
        dests[1] = to;
        dests[1].entry = ent;
        if(msgid = (int*)msg_getfield(fmsg, SYSFLD_MSGID, 1, NULLIARG))
        {
            finfo[FWI_SENDER] = msg_getsender(fmsg);
            finfo[FWI_NEWDEST] = to;
            msg_replacefield(cmsg, SYSFLD_FORWARD, (char*)finfo, FTYPE_ADDRESS, sizeof(finfo));
            if(cmsg != fmsg)
            {
                /* Arrange for replies to <cmsg> to be treated like replies to <fmsg> */
                msg_insertfield(cmsg, SYSFLD_MSGID, (char*)msgid, FTYPE_LONG, sizeof(int));
                msg_setreplyto(cmsg, dests[0]);
            }
            cbcast_l("ml", dests, cmsg, 0);
        }
        else
            panic("forward: attempt to forward a non-RPC message!");
  }
