/*
 * udptest.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.21 $
 * $Date: 1992/02/11 23:30:14 $
 */

/*
 * Ping-pong test of UDP
 */

#include "part.h"
#include "udp.h"
#include "site.h"

/*
 * These definitions describe the lower protocol
 */
#define HOST_TYPE IPhost
#define INIT_FUNC udptest_init
#define TRACE_VAR udptestp
#define PROT_STRING "udp"

static HOST_TYPE SERVER = SITE_SERVER_IP;
static HOST_TYPE CLIENT = SITE_CLIENT_IP;

static long	serverPort = 2001;
static long	clientPort = ANY_PORT;

#define TRIPS 100
#define TIMES 1
#define DELAY 3
/*
 * Define to do timing calculations
 */
#define TIME


/* 
 * It may be convenient to send between different UDP ports on the
 * same host, so we'll have custom participant assignment
 */
#define CUSTOM_ASSIGN

static void
clientSetPart( p )
    Part	*p;
{
    partInit(p, 1);
    partPush(p[0], &SERVER);
    partPush(p[0], &serverPort);
    /* 
     * If we don't specify the second participant, UDP will select a port
     * for us. 
     */
#if 0
    /* 
     * NOTE -- if you use two participants, make sure the second argument to 
     * the above call to partInit is 2
     */
    partPush(p[1], ANY_HOST);
    partPush(p[1], &clientPort);
#endif
}

static void
serverSetPart( p )
    Part 	*p;
{
    partInit(p, 1);
    partPush(*p, ANY_HOST);
    partPush(*p, &serverPort);
}

static int lens[] = { 
  1, 1000, 2000, 4000, 8000, 16000
};

/* #define SAVE_SERVER_SESSN */

#include "common_test.c"


static void
testInit()
{
}
