/* 
 * blast_internal.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.18 $
 * $Date: 1992/02/07 04:41:49 $
 */

#ifndef blast_internal_h
#define blast_internal_h
 
#include "xkernel.h"
#include "blast.h"

#define BLASTHLEN  sizeof(BLAST_HDR) 

/*
 * Trace levels
 */
#define REXMIT_T TR_EVENTS

/* 
 * opcodes in the message header
 */
#define BLAST_SEND 1
#define BLAST_NACK 2
#define BLAST_RETRANSMIT 3

#define BLAST_OK 2
#define BLAST_FAIL 2
#define MAX_FRAGS 16
 
typedef unsigned int	BlastSeq;

typedef struct  {
	unsigned int op;
	unsigned int prot_id;
	BlastSeq seq;
        unsigned short num_frag;
	unsigned short mask;
	unsigned int len;
} BLAST_HDR;

typedef struct {
	BLAST_HDR hdr;
	Msg frags[MAX_FRAGS+1];
	unsigned short mask;
	unsigned short old_mask;
	unsigned int wait;
        Bind binding;

        struct blast_state *state;
        Event event;
        int nack_sent;
	bool abort;
} MSG_STATE;

typedef struct blast_state {
        long	prot_id;
        BLAST_HDR short_hdr;
	BLAST_HDR cur_hdr;
        Map send_map;
        Map rec_map;
        MSG_STATE *rec_cache;
        MSG_STATE *send_cache;
	XObj self;
	int fragmentSize;
} BLAST_STATE;

typedef struct {
	Map 		active_map;
	Semaphore	createSem;
	Map 		passive_map;
	BlastSeq	max_seq;
	Semaphore 	outstanding_messages;
	int 		max_outstanding_messages;
} PSTATE;

typedef struct {
        long	prot;
	XObj	lls;
} ActiveID;

typedef int PassiveID;
	

#define I_TO_MASK(i) (1 << ((i) - 1))


/* If BLAST_SIM_DROPS is defined, BLAST will occasionally drop a fragment
 * before it gets to the appropriate BLAST session.
 */
/* #define BLAST_SIM_DROPS */


/*
 * If BLAST_LAST_FRAG_NACKS is defined, blast will send a negative
 * acknowledgment if it receives the last fragment and the message is
 * not complete.  BLAST_LAST_FRAG_NACKS should not be defined in an
 * environment where blast will see packets arrive out of order fairly
 * often (e.g., on the Internet.)
 */
/* #define BLAST_LAST_FRAG_NACKS */

extern u_int	blastFullMask[];
extern int 	traceblastp;

#ifdef __STDC__

xmsg_handle_t	blastPush( XObj, Msg * );
int		blastControlSessn( XObj, int, char *, int );
int		blastControlProtl( XObj, int, char *, int );
xkern_return_t	blastPop( XObj, XObj, Msg * );
xkern_return_t	blastDemux( XObj, XObj, Msg * );
XObj		blastCreateSessn( XObj, XObj, ActiveID * );
void		blast_mapFlush( Map );
int		blast_freeSendSeq( BLAST_STATE *, int );
long		blastHdrLoad( void *, char *, long, void * );
void		blastHdrStore( void *, char *, long, void * );
xkern_return_t	blastSenderPop( XObj, Msg *, BLAST_HDR * );
int		blast_mask_to_i( int );

void	blast_phdr( BLAST_HDR * );
char *	blastOpStr( int );
void	blastShowActiveKey( ActiveID *key, char *message );
void	blastShowMstate( MSG_STATE *m, char *message );
char *	blastShowMask( int );


#else

xmsg_handle_t	blastPush();
int		blastControlSessn();
int		blastControlProtl();
xkern_return_t	blastPop();
xkern_return_t	blastDemux();
XObj		blastCreateSessn();
void		blast_mapFlush();
int		blast_freeSendSeq();
long		blastHdrLoad();
void		blastHdrStore();
xkern_return_t	blastSenderPop();
int		blast_mask_to_i();

#ifndef NDEBUG
void	blast_phdr();
char *	blastOpStr();
void	blastShowActiveKey();
void	blastShowMstate();
char *	blastShowMask();
#endif ! NDEBUG

#endif __STDC__

#endif

