#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#include <string.h>
#include <dirent.h> 
#include "draw.h"
#include "scan.h"


int pnum;
Sc dbase;
extern add_entry();
extern graphics_data *data;

static char *token_names[] = {"type","name","files","device","ports","id",NULL,};

built_base()

 {
  dbase = ScCreate();

  DirWalk(DIRECTORY);

  }


int
DirWalk(dir)
char *dir;

 {
    char   *s, buf[BUFSIZ];
    struct dirent *dp;
    DIR    *dfd;

    if ( ( dfd = opendir(dir)) == NULL)
        {
           fprintf(stderr,"cann't open dir. %s \n",dir);
           return (0);
        }

    fprintf(stderr,"Looking for Protocol Templates in %s\n",dir);
    while((dp = readdir(dfd)) != NULL )
     {
       s = dp->d_name;
       while( *s != '.' ) s++;
     
       if ( strcmp(s,".g") == 0 ) {
            strcpy(buf,dir);
            strcat(buf,"/");
            strcat(buf,dp->d_name);
            readfile(buf);
        }
      }

    closedir(dfd);

  }
    

initialize(x)
te *x;

 {

  x->type[0] = '\0';
  x->name[0] = '\0';
  x->files[0] = '\0';
  x->ports[0] = '\0';
  x->id[0] = '\0';
  strcpy(x->device,"no"); 
  x->pnum = 0;
  }


readfile(name)
char *name;

  {
    te    x;
    FILE *fp;
    int token;
    char buf[BUFSIZ];

    initialize(&x);
    if (( fp = fopen(name,"r")) == NULL)
       {
        fprintf(stderr,"cann't open file %s\n",name);
        return;
       }
/*   fprintf(stderr,"opened file %s\n",name); */
     while ( (token = next_token(fp,buf)) != DONE )
       {
           switch (token) {

           case TYPE:    strcpy(x.type,buf);
                         break;

           case NAME:   strcpy(x.name,buf);
                         break;

           case FILES:   strcpy(x.files,buf);
                         break;
      
           case DEVICE:  strcpy(x.device,buf);
                         break;

           case PORTS:   strcpy(x.ports,buf);
                         x.pnum = pnum;
                         break;

           case ID:   strcpy(x.id,buf);
                         break;

           default:
                        fprintf(stderr,"cann't understand attribute %s\n",buf);
           }
       }
      
      add_entry(x.type); 
      ScInsert(dbase,&x);
      fclose(fp);
  }
    

int gettoken(s)
char *s;

 {

   int i;

   for(i=0; i < MAX_ATTR; i++)
     if( strcmp(s,token_names[i]) == 0 )
         return(i+1);
   return(ERROR);
 
   }


int next_token(fp,buf)
 FILE *fp;
 char *buf;

 {
     int i, token, j, flag;
     char   c;

     c = fgetc(fp);
     while( isspace(c) && c != EOF )
             c = fgetc(fp);
 
     if ( c == EOF )
        return(DONE);

     for(i=0; isalnum(c); i++)
        {
           buf[i] = c;
           c = fgetc(fp);
         }
     buf[i] = '\0';
     token = gettoken(buf);
     while ( isspace(c) )
             c = fgetc(fp);

     if ( c != '=' )
        fprintf(stderr,"warning = is missing\n");
     c = fgetc(fp);

     while ( isspace(c) )
             c = fgetc(fp);

     pnum = 0; flag = 0;
     for(i=0,j = 0; c != '\n'; )
       { 
        if ( c == ' ' ) 
         {
             if ( j == 0 ) pnum++;
             j++;
         }
        else
             j = 0;
        if ( j <= 1 )
         {
          flag = 1;
          buf[i] = c;
          i++;
         }
        c = fgetc(fp);
       }

     if ( flag == 1 )
         pnum++;
     buf[i] = '\0';
     return(token);

 }
