#include "gp.h"
#include "sc.h"


char *strsave(s)
char *s;

 {
   char *p;

   p = (char *) malloc(strlen(s)+1);
   strcpy(p,s);
   return(p);

 }

gpDestroy(g)
Graph g;
 
  {
   nodeptr p,q;
   int f = 1;

   for(p = g->root; p != NULL && f;)
     {
       q = p;
       p = p->right;
       if ( p == g->root )
            f = 0;
       free( (char *) q);
     }

   if ( g != NULL ) free( (char *) g);

   }

Graph gpNew()

 {
   Graph p;

   p = (Graph ) malloc(sizeof(graph));

  p->root = NULL;
  return(p);

}

compare(new,x,y,width,height,mode)
nodeptr new;
int  x,y,width,height;
int mode;

 {
    int ai, aj;
 
     ai = abs(new->name.x - x);
     aj = abs(new->name.y - y);
    
    if ( (ai <= width) && (aj <= height) )
            return(0);
    else if ( (ai <= width) && (aj <= new->name.height))
           return(0);
    else if ( (ai <= new->name.width) && (aj <= new->name.height))
           return(0);
    else if ( (ai <= new->name.width) && (aj <= height))
          return(0);

    else if ( y < new->name.y )
              return(-1);
    else if ( y > new->name.y )
             return(1);
    else if ( x > new->name.x )
            return(-1);
    else 
            return(1);
 }

Dcompare(new,x,y)
nodeptr new;
int  x,y;

 {
    int ai = (x - new->name.x );
    int aj = (y - new->name.y );

    if (ai >= 0 &&  ai <= new->name.width && aj >= 0 && aj <= new->name.height)
           return(0);
    else 
            return(1);
 }


nodeptr findnode(g,x,y,width,height)
Graph g;
int x,y,width,height;

 {
      int i;
      nodeptr p;
      node temp;

      if ( g == NULL ||  g->root == NULL )
           return(NULL);

      temp.name.x = x;
      temp.name.y = y;
      temp.name.width = width;
      temp.name.height = height;
      p = g->root;
  /*
      i = compare(p,x,y,width,height,0);
   */   i = compare(&temp,p->name.x,p->name.y,p->name.width,p->name.height,0);
      while ( i != 0 && p->right != g->root)
        {
              p = p->right;
             /*
              i = compare(p,x,y,width,height,0);
             */ i = compare(&temp,p->name.x,p->name.y,p->name.width,p->name.height,0);
        }

     if ( i == 0 )
          return(p);
     else
         return(NULL);

 }

nodeptr Dfindnode(g,x,y)
Graph g;
int x,y;

 {
      int i;
      nodeptr p;

      if ( g->root == NULL )
           return(NULL);

      p = g->root;
      i = Dcompare(p,x,y);
      while ( i != 0 && p->right != g->root)
        {
              p = p->right;
              i = Dcompare(p,x,y);
        }

     if ( i == 0 )
          return(p);
     else
         return(NULL);

 }

gpFreeNode(g,p)
Graph g;
nodeptr p;

 {

    free( (char *) p);

 }

printlist(g)
Graph g;

 {
   nodeptr p;


   for( p = g->root; p != NULL;  p = p->right)
     {

       if ( p->right == g->root )
          return;
        
       
     }

 }
 
nodeptr gpDeleteNode(g,x,y)
Graph g;
int x,y;

 {
    int i;
    nodeptr p;


    if ( g->root == NULL )
         return(NULL);
   
    p = g->root;
    i = Dcompare(p,x,y);
    while ( i != 0 && p->right != g->root )
     {
       p = p->right;
       i = Dcompare(p,x,y);
     }
 
    if ( p == p->right && i == 0 )
      {
         g->root = NULL;
         return(p);
      }
    else if ( i != 0 )
         return(NULL);

    if ( g->root == p )
         g->root = p->right;
    (p->left)->right = p->right;
    (p->right)->left = p->left;
    return(p);

  }
 

insert(g,new)
Graph g;
nodeptr new;

 {
    int  i;
    nodeptr  p;

    if ( g->root == NULL )
     {
         g->root = new;
         new->right = new;
         new->left = new;
    }
   else
       {
         p = g->root;
         i = compare(new,p->name.x,p->name.y,p->name.width,p->name.height,1);

         while ( i > 0 && p->right != g->root )
          {
            p = p->right;
            i = compare(new,p->name.x,p->name.y,p->name.width,p->name.height,1);
          }
 
         if ( p->right == g->root && i > 0 )
              p = p->right;
         else if ( p == g->root && i < 0 )
             g->root = new;
         else if ( i == 0 )
             fprintf(stderr,"node already exists \n");

         new->right = p;
         new->left = p->left;
         p->left = new;
         (new->left)->right = new;
       }

 }



findedge(p,x,y)
nodeptr p;
int x,y;

 {
    int i,h,w;

    for(i = 0; i <= p->pnum; i++)
      {
        w = x - (p->ports[i].x + p->name.x);
        h = y - (p->ports[i].y + p->name.y);
        if ( w >= UPPER_PORT_OFF && w <= EDGE_W+LOWER_PORT_OFF &&
             h >= UPPER_PORT_OFF && h <= EDGE_H+LOWER_PORT_OFF )
                 return(i);
      }
    return(-1);
 }

llist *new_llist(i,key)
int i;
nodeptr key;

 {
   llist *p;

   p = (llist *) malloc(sizeof(llist));
   
   if ( p == NULL ) {
        fprintf(stderr,"cann't malloc in new_llist\n");
        exit(0);
   }

   p->i = i; p->key = key; p->drow = 0;
   p->next = p->prev = p;
   return(p);

  }

edgetype gpAddEdge(g,x1,y1,x2,y2)
Graph g;
int   x1,y1,x2,y2;

  {
      edgetype res;
      nodeptr  p, q;
      int      i,j;
      llist    *tq, *tp;

      p = findnode(g,x1,y1,0,0);
      q = findnode(g,x2,y2,0,0);

      if ( p == NULL || q == NULL || q == p )
        {
              res.x1 = 0;
              res.y1 = 0;
              res.x2 = 0;
              res.y2 = 0;
              return(res);
        }
      i = findedge(p,x1,y1);
      j = findedge(q,x2,y2);
      if ( i < 0 || j < 0 || ( i > 0 && j > 0 ) || (i==0 && j==0) )
         {
            res.x1 = 0;
            res.y1 = 0;
            res.x2 = 0;
            res.y2 = 0;
            return(res);
         }
       tp = new_llist(j,q);
       tq = new_llist(i,p);

       port_insert(&(p->ports[i].other),tp);
       port_insert(&(q->ports[j].other),tq);

       res.x1 = p->ports[i].x + p->name.x + EDGE_X_OFF;
       res.y1 = p->ports[i].y + p->name.y + EDGE_Y_OFF;
       res.x2 = q->ports[j].x + q->name.x + EDGE_X_OFF;
       res.y2 = q->ports[j].y + q->name.y + EDGE_Y_OFF;

       return(res);
  }

edgetype gpDeleteEdge(g,x,y)
Graph g;
int x,y;

 {
    nodeptr p, q;
    edgetype res;
    int      index,i;
    llist    *temp;

    p = findnode(g,x,y,0,0);
    if  ( p == NULL )
      {
            res.x1 = 0;
            res.y1 = 0;
            res.x2 = 0;
            res.y2 = 0;
            return(res);
      }
    index = findedge(p,x,y);
    if ( index < 0 || p->ports[index].other == NULL )
      {
            res.x1 = 0;
            res.y1 = 0;
            res.x2 = 0;
            res.y2 = 0;
            return(res);
       }

   temp = port_remove(&(p->ports[index].other));
   i = temp->i;
   q = temp->key;

   res.x1 = q->ports[i].x + q->name.x + EDGE_X_OFF;
   res.y1 = q->ports[i].y + q->name.y + EDGE_Y_OFF;
   res.x2 = p->ports[index].x + p->name.x + EDGE_X_OFF;
   res.y2 = p->ports[index].y + p->name.y + EDGE_Y_OFF;
 
   free( (char *) temp);
   temp = keyremove(&(q->ports[i].other),p);
   if ( temp != NULL ) 
       free( ( char *) temp);
   else
       fprintf(stderr,"error in gpDeleteEdge\n");     

   return(res);

  }


getports(name,p)
char *name;
nodeptr p;

 {

   int i, j, k;

   for(j=1,i=0,k=0; name[i] != '\0' && j <= p->pnum; i++ )
     {
        if ( name[i] == ' ' ) 
          {
             p->ports[j].name[k] = '\0';
             j++;
             k = 0;
          } 
        else 
          {
             p->ports[j].name[k] = name[i];
             k++;
           }
      }

    p->ports[j].name[k] = '\0';

 }

findcoor(p,width)
nodeptr p;
int width;

 {
   int delta, offset,i;

   p->ports[0].x =(int ) (width / 2 ) - EDGE_X_OFF;
   p->ports[0].y = 0;
   p->ports[0].other = NULL;

   offset = delta = (int ) (width -(p->pnum* EDGE_W)) / (p->pnum+1);
   for(i=1; i <= p->pnum; i++)
     {
       p->ports[i].x = offset;
       p->ports[i].y = EDGE_Y1_OFF;
       offset += delta + EDGE_W;
       p->ports[i].other = NULL;
     }

 }
   
coor(p,width)
nodeptr p;
int width;

 {
   int delta, offset,i;

   p->ports[0].x =(int ) (width / 2 ) - EDGE_X_OFF;
   p->ports[0].y = 0;

   offset = delta = (int ) (width - EDGE_W) / (p->pnum+1);
   for(i=1; i <= p->pnum; i++)
     {
       p->ports[i].x = offset;
       p->ports[i].y = EDGE_Y1_OFF;
       offset += delta + EDGE_W;
     }

 }

nodeptr getnode(x,y,q,width)
int x,y;
TEPtr q;
int width;

 {

    nodeptr p;

    p = (nodeptr) malloc(sizeof(node));
 
    if  ( p == NULL ) {
         fprintf(stderr,"cann't malloc new node\n");
         exit(0);
    }

    p->visited = 0;
    p->f = 0;
    p->pnum = q->pnum;
    p->name.x = x;
    p->name.y = y;
    p->name.width = width;
    p->name.height = NODE_H;
    p->ports[0].x = EDGE_X_OFF;
    p->ports[0].y = EDGE_Y_OFF;
    strcpy(p->ports[0].name,q->name);
    strcpy(p->id,q->id);
    strcpy(p->type,q->type);
    getports(q->ports,p);
    findcoor(p,width);
  
    p->right = p->left = NULL;
    return(p);
 }

nodeptr gpDefineNode(g,x,y,name,width)
Graph g;
int x,y;
char *name;
int  width;

 {

    nodeptr  p;
    TEPtr q = ScLookup(dbase,name);

    if (q == NULL ){
       fprintf(stderr,"error in gpDefineNode \n");
       exit(0);
    }
    if ( (p = findnode(g,x,y,width,NODE_H)) != NULL)
         return(NULL);

    p = getnode(x,y,q,width); 
    insert(g,p);
    return(p);
 }
