/*
 * timetcp.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/********************************************************************
 *
 * Test TCP
 *	TRIPS: number of round trips per test
 *	TIMES: number of tests run
 *	Set message size by defining one of the following:
 *		ONESHOT = 1 byte
 *		LITTLE = 1, 200, 400, ... 1400 bytes
 *
 ********************************************************************/

#define ONESHOT

#include "xkernel.h"
#include "ip.h" 
#include "tcp.h"

static Protl IP, TCP;
static unsigned short clientport = 2001;
static unsigned short serverport = 2002;

IPhost client_host = SITE_CLIENT_IP;
IPhost server_host = SITE_SERVER_IP;
TCPaddr CLIENT, SERVER;
char *SERVERNAME;

typedef struct {
  int sec, usec;
} time;

static time starttime;
static int gotone;
static int count;
#define TRIPS 10000
#define TIMES 5
#define DELAY 2000

client()
{
  int p, s;
  int clientdemux(), null();
  Part whom[3];
  static char message[8 * 1024];
  int test = 0;
  int lenindex, len;
  static int lens[] = { 
#ifdef ONESHOT
    1,
#endif
#ifdef LITTLE
    1, 200, 400, 600, 800, 1000, 1200, 1400, 1024,
#endif  
  };

  s = NULL;
  p = xcreateprotl(clientdemux, null, null);
  printf("I am the client, talking to %s\n", SERVERNAME);

  init_partlist(whom, 2, TCPaddr);
  set_part(whom, 0, CLIENT);
  set_part(whom, 1, SERVER);

/* these lines replaced by above 3 lines -- may be removed if it works
                                                        071890 cliff
  whom[0].address = (char *) &CLIENT;
  whom[0].length = sizeof(TCPaddr);
  whom[1].address = (char *)&SERVER;
  whom[1].length = sizeof(TCPaddr);
  whom[2].address = (char *)0;
  whom[2].length = 0;
*/
  for (lenindex = 0; ; lenindex++) {
    if (lenindex >= sizeof(lens)/sizeof(long)) lenindex = 0;
    len = lens[lenindex];
    for (test = 0; test < TIMES; test++) {
      if (s <= 0) s = xopen(p, TCP, whom);
      if (s > 0) {
	printf("Sending (%d) ...\n", test);
	count = 0;
#ifdef PROFILE
	startProfile();
#endif
	xgettime(&starttime);
	xpush(s, message, len, 0, 0);
      } else {
	printf("Not sending, other host not up\n");
      }
      do {
	gotone = 0;
	xpause(DELAY);
      } while (gotone);
    }
  }
}
  
server()
{
  int serverdemux(), null(), p;
  Part whom[2];
  printf("I am the  server (%s)\n", SERVERNAME);

  init_partlist(whom, 1, TCPaddr);
  set_part(whom, 0, SERVER);


#ifdef xxxcliffxxx
 these lines replaced by above macros -- can be removed if it works
  whom[0].address = (char *) &SERVER.port;
  whom[0].length = /*2*/ sizeof(TCPaddr); /* 2 commented out cliff */
  whom[1].address = (char *)0;
  whom[1].length = 0;
#endif
  p = xcreateprotl(serverdemux, null, null);
  (void) xopenenable(p, TCP, whom);
}

user(argc, argv)
int argc;
char **argv;
{
  IPhost ipaddr, nametoip();
  printf("TCP timing test\n");
  IP = xgetprotlbyname("ip");
  TCP = xgetprotlbyname("tcp");
  CLIENT.host = client_host;
  SERVER.host = server_host;
  SERVERNAME = SITE_SERVER_NAME;
  if (xcontrolprotl(IP, GETMYADDR, &ipaddr, sizeof(IPhost)) != 
      sizeof(IPhost)) {
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n", ipaddr.a, ipaddr.b, ipaddr.c, ipaddr.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER.host = ipaddr;
      SERVERNAME = malloc(24);
      iptoname(SERVER.host, SERVERNAME);
      CLIENT.host.a = CLIENT.host.b = CLIENT.host.c = CLIENT.host.d = 0;
    } else if (!strncmp(argv[1], "-c", 2)) {
      CLIENT.host = ipaddr;
      SERVERNAME = &argv[1][2];
      SERVER.host = nametoip(SERVERNAME);
    }
    argc --;
    argv++;
  }
  CLIENT.port = clientport;
  SERVER.port = serverport;
  if (IP_EQUAL(ipaddr, SERVER.host)) {
    xcreateprocess(server, 5, 0);
  }
  if (IP_EQUAL(ipaddr, CLIENT.host)) {
    xcreateprocess(client, 6, 0);
  }
}

null(s,m,length)
int s, length;
char *m;
{
}

clientdemux(s, m, length)
int s, length;
char *m;
{
  time now, total;
  gotone = 1;
  if (++count < TRIPS) {
    xpush(s, m, length, 0, 0);
  } else {
    xgettime(&now);
    subtime(&starttime, &now, &total);
    printf("len = %4d, %d trips: %6d.%-6d\n", 
      length, TRIPS, total.sec, total.usec);
#ifdef PROFILE
	endProfile();
#endif
  }
}

serverdemux(s, m, length)
int s, length;
char *m;
{
  xpush(s, m, length, 0, 0);
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}
