/*
 * timeeth.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/********************************************************************
 *
 * Test Ethernet Protocol
 *	TRIPS: number of round trips per test
 *	TIMES: number of tests run
 *	Set message size by defining one of the following:
 *		ONESHOT = 1 byte
 *		LITTLE = 1, 200, 400, ... 1400 bytes
 *
 *********************************************************************/

#define ONESHOT

#include "xkernel.h"
#include "eth.h"

static Protl ETH;

ETHhost CLIENT = SITE_CLIENT_ETH;
ETHhost SERVER = SITE_SERVER_ETH;

char *SERVERNAME;

ethequal(a, b)
ETHhost *a, *b;
{
  return a->high == a->high && a->mid == b->mid && a->low == b->low;
}

typedef struct {
  int sec, usec;
} time;

static short mytype = 0x98;
static time starttime;
static int gotone;
static int count;
#define TRIPS 10000
#define TIMES 5
#define DELAY 2000

client()
{
  int cliffpartcount;
  int p, s;
  int clientdemux(), null();
  Part whom[3];
  static char message[8 * 1024];
  int test = 0;
  int lenindex, len;
  ETHaddr clnt, srvr;
  static int lens[] = { 
#ifdef ONESHOT
    1,
#endif
#ifdef LITTLE
    1, 200, 400, 600, 800, 1000, 1200, 1400, 1024,
#endif  
  };

  s = NULL;
  p = xcreateprotl(clientdemux, null, null);
  printf("I am the client, talking to %s\n", SERVERNAME);

  init_partlist(whom, 2, ETHaddr);
  clnt.type = mytype;
  clnt.host = CLIENT;
  srvr.type = mytype;
  srvr.host = SERVER;  
  set_part(whom, 0, clnt);
  set_part(whom, 1, srvr);

/*  these lines replaced by above macros -- can be replaced if it works
  whom[0].address = (char *) &mytype;
  whom[0].length = 2;
  whom[1].address = (char *)&SERVER;
  whom[1].length = 6;
  whom[2].address = (char *)0;
  whom[2].length = 0;
*/
  for (lenindex = 0; ; lenindex++) {
    if (lenindex >= sizeof(lens)/sizeof(long)) lenindex = 0;
    len = lens[lenindex];
    for (test = 0; test < TIMES; test++) {
      if (s <= 0) s = xopen(p, ETH, whom);
      if (s > 0) {
	printf("Sending (%d) ...\n", test);
	count = 0;
	xgettime(&starttime);
	xpush(s, message, len, 0, 0);
      } else {
	printf("Not sending, other host not up\n");
      }
      do {
	gotone = 0;
	xpause(DELAY);
      } while (gotone);
    }
  }
}
  
server()
{
  int serverdemux(), null(), p;
  Part whom[3];
  ETHaddr srvr;

  printf("I am the  server (%s)\n", SERVERNAME);
  init_partlist(whom, 1, ETHaddr);
  srvr.type = mytype;
  srvr.host = SERVER;  
  set_part(whom, 0, srvr);

/* these lines replaced by above macros -- can be removed if it works
  whom[0].address = (char *) &mytype;
  whom[0].length = 2;
  whom[1].address = (char *)0;
  whom[1].length = 0;
*/
  p = xcreateprotl(serverdemux, null, null);
  (void) xopenenable(p, ETH, whom);
}

user(argc, argv)
int argc;
char **argv;
{
  ETHhost eaddr, nametoeth();
  printf("Ether timing test\n");
  ETH = xgetprotlbyname("eth");
  SERVERNAME = SITE_SERVER_NAME;
  if (xcontrolprotl(ETH, GETMYADDR, &eaddr, 6) != 6) {
    printf("Cannot get my own enet addr\n");
    return;
  } else {
    printf("My enet addr = %x.%x.%x\n",eaddr.high, eaddr.mid, eaddr.low);
  }

  printf("argc = %d\n", argc);
  while (argc > 1) {
    printf("argv[1] = %s\n", argv[1]);
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER = eaddr;
      SERVERNAME = malloc(24);
      ethtoname(SERVER, SERVERNAME);
      CLIENT.low = CLIENT.high = CLIENT.mid = 0;
    } else if (!strncmp(argv[1], "-c", 2)) {
      CLIENT = eaddr;
      SERVERNAME = &argv[1][2];
      SERVER = nametoeth(SERVERNAME);
    }
    argc --;
    argv++;
  }
  if (ethequal(&eaddr, &SERVER)) {
    xcreateprocess(server, 5, 0);
  }
  if (ethequal(&eaddr, &CLIENT)) {
    xcreateprocess(client, 6, 0);
  }
}

null(s,m,length)
int s, length;
char *m;
{
}

clientdemux(s, m, length)
int s, length;
char *m;
{
  time now, total;
printf("==========  In clientdemux  ===========\n");
  gotone = 1;
  if (++count < TRIPS) {
    xpush(s, m, length, 0, 0);
  } else {
    xgettime(&now);
    subtime(&starttime, &now, &total);
    printf("len = %4d, %d trips: %6d.%-6d\n", 
      length, TRIPS, total.sec, total.usec);
  }
}

serverdemux(s, m, length)
int s, length;
char *m;
{
printf("==========  In serverdemux  ===========\n");
  xpush(s, m, length, 0, 0);
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}
