h51223
s 00950/00000/00000
d D 1.1 90/12/09 00:48:34 menze 1 0
c date and time created 90/12/09 00:48:34 by menze
e
u
U
f e 0
t
T
I 1
/*
 * testpsync.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 *
 *********************************************************************
 *
 * we configure the number and hosts of the participants by setting the
 * array part_index, e.g. int part_index[] = {FRANKLIN, KADMOS, FRANKLIN};
 * would have part[0] on fra, part[1] on kad, and part[2] on fra.  This
 * array needs to be lower (right before user()) because it depends on
 * a bunch of stuff.  See the declaration of it and the corresponding
 * comments below.  Also, see the options that getopt parses - we can
 * set the number of trips/test, the number of tests, and a debug
 * value that the user code uses and sets psyncs tracepsyncp with
 * ( caution - this sets the trace value for all psync users on a host,
 * not just this test).
 */

#include "xkernel.h"
#include "ip.h"
#include "udp.h"
#include "psync.h"

#define APP '0'

#define TRIPS_PER_TEST 2001
#define NUM_TESTS	20

#define NO  0
#define YES 1

/* these may be reset by command line options if I do getopt parsing */
;
unsigned        trips_per_test = TRIPS_PER_TEST;
unsigned        trip_num = TRIPS_PER_TEST;
unsigned        num_tests = NUM_TESTS;
unsigned        test_num = 1;	/* our current test */

#define LEGAL_OPTIONS "t:n:d:"
#define USAGE_STRING \
    "usage: bxpsync [-t trips_per_test] [-n num_tests] [-d debug_val]\n"

typedef struct {
    unsigned short  high, mid, low;
}               ETHhost;

/* from zep/etc/ethers: or running /usr/gmt/bin/sunlist */
#define	FRANKLIN_ENET_ADDRESS 	{0x0800, 0x2001, 0xD340}
#define GARAMOND_ENET_ADDRESS	{0x0800, 0x2001, 0x90DA}
#define LUBALIN_ENET_ADDRESS    {0x0800, 0x2001, 0x51D6}
#define KADMOS_ENET_ADDRESS   	{0x0800, 0x2001, 0x5154}
#define BENGUIAT_ENET_ADDRESS   {0x0800, 0x2001, 0x5040}
#define BEMBO_ENET_ADDRESS      {0x0800, 0x2001, 0xD982}
#define FUTURA_ENET_ADDRESS     {0x0800, 0x2001, 0x5324}
#define JENSON_ENET_ADDRESS     {0x0800, 0x2001, 0x90DA}
#define YUCCA_ENET_ADDRESS	{0x0800, 0x2001, 0x5173}
#define ORATOR_ENET_ADDRESS 	{0x0800, 0x2001, 0x4776}
#define CORONA_ENET_ADDRESS	{0x0800, 0x2001, 0x5040}
#define AURIGA_ENET_ADDRESS	{0x0800, 0x2001, 0x51E6}
#define PALOVERDE_ENET_ADDRESS	{0x0800, 0x2001, 0x51d6}
#define GRANJON_ENET_ADDRESS	{0x0800, 0x2001, 0x504a}
#define GACHAM_ENET_ADDRESS	{0x0800, 0x2001, 0x5153}


/* from /etc/hosts: or running /usr/gmt/bin/sunlist */
#define FRANKLIN_IP_ADDRESS	{192, 12, 69, 36}
#define GARAMOND_IP_ADDRESS	{192, 12, 69, 19}
#define LUBALIN_IP_ADDRESS      {192, 12, 69, 45}
#define KADMOS_IP_ADDRESS       {192, 12, 69, 49}
#define BENGUIAT_IP_ADDRESS     {192, 12, 69,  8}
#define BEMBO_IP_ADDRESS        {192, 12, 69, 37}
#define FUTURA_IP_ADDRESS       {192, 12, 69, 25}
#define JENSON_IP_ADDRESS       {192, 12, 69, 32}
#define YUCCA_IP_ADDRESS	{192, 12, 69, 15}
#define ORATOR_IP_ADDRESS	{192, 12, 69, 42}
#define CORONA_IP_ADDRESS	{192, 12, 69, 47}
#define AURIGA_IP_ADDRESS	{192, 12, 69, 11}
#define PALOVERDE_IP_ADDRESS	{192, 12, 69, 16}
#define GRANJON_IP_ADDRESS	{192, 12, 69, 27}
#define GACHAM_IP_ADDRESS	{192, 12, 69, 24}

#define FRANKLIN_PSYNC_ADDRESS	{2001, FRANKLIN_IP_ADDRESS}
#define GARAMOND_PSYNC_ADDRESS	{2001, GARAMOND_IP_ADDRESS}
#define LUBALIN_PSYNC_ADDRESS   {2001, LUBALIN_IP_ADDRESS}
#define KADMOS_PSYNC_ADDRESS    {2001, KADMOS_IP_ADDRESS}
#define BENGUIAT_PSYNC_ADDRESS  {2001, BENGUIAT_IP_ADDRESS}
#define BEMBO_PSYNC_ADDRESS     {2001, BEMBO_IP_ADDRESS}
#define FUTURA_PSYNC_ADDRESS    {2001, FUTURA_IP_ADDRESS}
#define JENSON_PSYNC_ADDRESS    {2001, JENSON_IP_ADDRESS}
#define YUCCA_PSYNC_ADDRESS	{2001, YUCCA_IP_ADDRESS}
#define ORATOR_PSYNC_ADDRESS	{2001, ORATOR_IP_ADDRESS}
#define CORONA_PSYNC_ADDRESS	{2001, CORONA_IP_ADDRESS}
#define AURIGA_PSYNC_ADDRESS	{2001, AURIGA_IP_ADDRESS}
#define PALOVERDE_PSYNC_ADDRESS	{2001, PALOVERDE_IP_ADDRESS}
#define GRANJON_PSYNC_ADDRESS	{2001, GRANJON_IP_ADDRESS}
#define GACHAM_PSYNC_ADDRESS	{2001, GACHAM_IP_ADDRESS}

struct psync_host {
    char           *name;
    ETHhost   enet_address;
    PSYNCaddr       psync_address;
};

static struct psync_host host_tab[] =
{
 {"franklin", FRANKLIN_ENET_ADDRESS, FRANKLIN_PSYNC_ADDRESS},
 {"benguiat", BENGUIAT_ENET_ADDRESS, BENGUIAT_PSYNC_ADDRESS},
 {"garamond", GARAMOND_ENET_ADDRESS, GARAMOND_PSYNC_ADDRESS},
 {"lubalin", LUBALIN_ENET_ADDRESS, LUBALIN_PSYNC_ADDRESS},
 {"kadmos", KADMOS_ENET_ADDRESS, KADMOS_PSYNC_ADDRESS},
 {"bembo", BEMBO_ENET_ADDRESS, BEMBO_PSYNC_ADDRESS},
 {"futura", FUTURA_ENET_ADDRESS, FUTURA_PSYNC_ADDRESS},
 {"jenson", JENSON_ENET_ADDRESS, JENSON_PSYNC_ADDRESS},
 {"yucca",  YUCCA_ENET_ADDRESS,  YUCCA_PSYNC_ADDRESS},
 {"orator", ORATOR_ENET_ADDRESS, ORATOR_PSYNC_ADDRESS},
 {"corona", CORONA_ENET_ADDRESS, CORONA_PSYNC_ADDRESS},
 {"auriga", AURIGA_ENET_ADDRESS, AURIGA_PSYNC_ADDRESS},
 {"gacham", GACHAM_ENET_ADDRESS, GACHAM_PSYNC_ADDRESS},
 {"paloverde", PALOVERDE_ENET_ADDRESS, PALOVERDE_PSYNC_ADDRESS},
 {"granjon", GRANJON_ENET_ADDRESS, GRANJON_PSYNC_ADDRESS}
};

#define NUM_PSYNC_HOSTS ( (sizeof(psync_host)) / (sizeof(struct host_tab)))

/* these correspond to indices in host_tab */
#define FRANKLIN 0
#define BENGUIAT 1
#define GARAMOND 2
#define LUBALIN  3
#define KADMOS   4
#define BEMBO    5
#define FUTURA   6
#define JENSON   7
#define YUCCA    8
#define ORATOR   9
#define CORONA   10
#define AURIGA   11
#define GACHAM   12
#define GRANJON  13
#define PALOVERDE 14

#define SAME_ETHERNET_ADDRESS(A,B) \
		((A).high==(B).high && (A).mid==(B).mid && (A).low==(B).low)

#define MESSAGE "xxxxxxxxyyyy3456789012345678901234567890123456"
#define MESSAGE_LENGTH 46	/* length of MESSAGE */

typedef struct {
    unsigned        sec;
    int             usec;
}               time;


time            starttime;
extern int      null();
int debug=0;  /* might  be used to set tracepsyncp, but also locally */

/* part_index is how you configure your test to run - just put the indeces
 * from host_tab into this, and you will get that many participants
 * running on those hosts.  participant 0 is the one who does the active
 * open, so host_tab[ part_index[0] ].name should be booted last.
 * Note that the number in this array must be <= MAX_PART, and there
 * must be MAX_PART demuxN funcs at the bottom (and demux[] must 
 * initialize in user to all N of them).
 */

int part_index[] = {FRANKLIN, BENGUIAT};

#define NUM_PARTS ( (sizeof(part_index)) / (sizeof(int))  )


Sessn           mysession;
PROTL           part_protl[MAX_PART];
extern int 
demux0(), demux1(), demux2(), demux3(), demux4(), demux5(),
demux6(), demux7();	/* must be MAX_PARTS of these decls. */
int             (*demux[MAX_PART]) ();	/* will be pointed to above in
					 * user() */

/* REPLY_TO_MSG tells if we should reply to the message or not.  Currently,
 * we reply if the count (the first word of the message) is equal to
 * our participant number modula NUM_PARTS.  If we want each user to
 * reply to everything, just define it to be 1.
 */

#if 0
#define REPLY_TO_MSG(m,part_num) \
	( ( *((unsigned *) m) % NUM_PARTS) == part_num  ? 1  : 0 )
#endif

#if 1
#define REPLY_TO_MSG(m,part_num) reply_to_msg(m,part_num) /* debug func*/
#endif

/* for getopt */
extern char    *optarg;
extern int      optind;

extern int     compose();

void 
user(argc, argv)
    int             argc;
    char           *argv[];

{
    int             p, r, n, x, i, z, y, c, rem,k, l;
    short           mytype = 0x98;
    int             clientdemux(), serverdemux(), psync_user_open_done();
    Part            whom[MAX_PART + 3];
    PROTL           PSYNC;
    ETHhost   myeaddr, my_ethernet_address();


    PSYNC = xgetprotlbyname("psync");
    while ((c = getopt(argc, argv, LEGAL_OPTIONS)) != -1)
	switch (c) {
	case 't':
	    trips_per_test = atoi(optarg);
	    trip_num = trips_per_test;
	    break;
	case 'n':
	    num_tests = atoi(optarg);
	    break;
	case 'd':
	    debug = atoi(optarg);	    
	    xcontrolprotl(PSYNC, SETDEBUG, &debug, sizeof(int) );
	    break;
	case '?':
	case 'h':
	default:
	    printf("%s", USAGE_STRING);
	    return;
	}

    printf("\n\n\n");
    myeaddr = my_ethernet_address("My ethernet address = " /* print it */ );
    printf("\n\n\n");

    /* the number of tests must be divisible by NUM_PARTS */
    rem = trips_per_test % NUM_PARTS;
    if (rem) {
	trips_per_test += (NUM_PARTS - rem);	/* make divisible by
						 * NUM_PARTS */
	trip_num = trips_per_test;
	printf("really doing %d trips", trips_per_test);
	printf(" - must be divisible by NUM_PART(%d)\n", NUM_PARTS);
    }
    if (NUM_PARTS > MAX_PART) {
	printf("*** PANIC - NUM_PARTS(%d) > MAX_PART(%d) - fix this\n\n",
	       NUM_PARTS, MAX_PART);
	return;
    }
    /* there must be at least MAX_PART of these */
    demux[0] = demux0;
    demux[1] = demux1;
    demux[2] = demux2;
    demux[3] = demux3;
    demux[4] = demux4;
    demux[5] = demux5;
    demux[6] = demux6;
    demux[7] = demux7;

    /*
     * create a (fake) user protocol for each participant.  participant 0
     * is the one who will call the active open, so he should be called
     * last and his host booted last. 
     */

    for (i = NUM_PARTS - 1; i >= 0; i--) {
	/* only fire up participants that belong on this host */
	if (SAME_ETHERNET_ADDRESS(myeaddr,
				  host_tab[part_index[i]].enet_address)) {
	    /* create a protocol for participant i on this host */
	    printf("firing up participant %d ... ", i);
	    fill_part_list(whom, i);	/* he knows part 0 does active
					 * open */
	    part_protl[i] = xcreateprotl(demux[i], psync_user_open_done,
					 (Pfs) null, (Pfs) null);
	    if (i > 0) {
		xopenenable(part_protl[i], PSYNC, whom);
                printf ("waiting...\n");
                printf ("starting algo...\n");

/************************/
/*********FOR TESTING PURPOSES ONLY*********/
/************************/

                
/************************/
/************************/
/*

                compose(mysession, &host_tab[i].psync_address, i);
*/
                printf("done composing\n");
            }
	    else {
		char            buf[100];

		strcpy(buf, MESSAGE);

printf("opening active sessn\n");
		mysession = (XObj)xopen(part_protl[0], PSYNC, whom);
printf("opened active sessn\n");
		if (mysession <= 0) {
		    printf("Not sending, other host(s) down. ");
		    printf("Boot me LAST!!!!\n\n");
		    return;

		}
		printf("\nDisconnect from ethernet now if you need to\n");
		for (x = z = 0; x < 1500000; x++)
		   y = x - (z + 2);

		/*
		 * The first word of the message is the sequence number.
		 * Currently, each participant replies to the message if
		 * the sequence number is equal to it modula NUM_PARTS.
		 * This reply policy is fixed in REPLY_TO_MSG and thus can
		 * be easily modified. 
		 */

                buf[0] = APP;
                trip_num--;       
        
		printf("Sending %5d (%2d/%2d)... ",
		       trips_per_test, test_num, num_tests);
		xgettime(&starttime);
		xpush(mysession, buf, MESSAGE_LENGTH);
/*
                compose(mysession, &host_tab[0].psync_address, 0);
*/
                printf("done composing\n");
	    }	/* if i>0 */

	    printf(" done firing up participant %d\n", i);
	}	/* if participant i is on this host */
    }  /* for all participants */

    printf("DONE firing up all participants that belong on this host\n\n");
}

algo0()
{
  char m[100];
  int  temp;

  temp = MESSAGE_LENGTH + 10;
  while(1)
    if (xcontrolsessn(mysession, GETMESSAGE, m, &temp)) {
      demux0(mysession, m, MESSAGE_LENGTH);
      temp = MESSAGE_LENGTH + 10;
    }
}

algo3()
{
  char m[100], ch;
  int msg, temp, c, count, i;
  int mymid, mymsgs[100], msgs[100], mid;

  temp = 50;
  printf("in algo3\n");
  while (!(xcontrolsessn(mysession, GETMESSAGE, m, &temp)));
  temp = 50;
  printf("received first msg\n");
  mid = mymid = msg = 0;
  count = 5;
  printf ("sending 5 msgs\n");
  for (i = 0; i < count; i++) {
    *((unsigned *)m) = msg++;
    mymsgs[mymid++] = xpush(mysession, m, MESSAGE_LENGTH);
  }
  printf ("Checking their stability\n");
  for (i = 0; i < mymid; i++)
    if (xcontrolsessn(mysession, STABLE, (char *)(&(mymsgs[i])), &temp))
       printf("mymsg stable\n");
    else
       printf("mymsg not stable\n");
  printf ("receiving 5 msgs from conv\n");
  while (mid < 5) 
    if (msgs[mid] = xcontrolsessn(mysession, GETMESSAGE, m, &temp)) {
      temp = 50;
      mid++;
    }
  printf ("Checking their stability\n");
  for (i = 0; i < mid; i++)
    if (xcontrolsessn(mysession, STABLE, (char *)(&(msgs[i])), &temp))
      printf("msg stable\n");
    else
      printf("msg not stable\n");
  printf ("Checking mymsgs stability again\n");
  for (i = 0; i < mymid; i++)
    if (xcontrolsessn(mysession, STABLE, (char *)(&(mymsgs[i])), &temp))
       printf("mymsg stable\n");
    else
       printf("mymsg not stable\n");
  mymsgs[mymid++] = xpush(mysession, m, MESSAGE_LENGTH);
  temp = 50;
  while (!xcontrolsessn(mysession, GETMESSAGE, m, &temp)); 
  printf ("Checking mymsgs stability again\n");
  for (i = 0; i < mymid; i++)
    if (xcontrolsessn(mysession, STABLE, (char *)(&(mymsgs[i])), &temp))
       printf("mymsg stable\n");
    else
       printf("mymsg not stable\n");
}

algo4()
{
  char m[100], ch;
  int msg, temp, c, count, i;
  int mymid, mymsgs[100], msgs[100], mid;

  temp = 50;
  mid = mymid = msg = 0;
  count = 5;
  printf ("sending 5 msgs\n");
  for (i = 0; i < count; i++) {
    *((unsigned *)m) = msg++;
    mymsgs[mymid++] = xpush(mysession, m, MESSAGE_LENGTH);
  }
  printf("mymsgs 0 %x\n", (int)(&(mymsgs[0])));
  printf("mymsgs 1 %x\n", (int)(&(mymsgs[1])));
  printf("mymsgs 2 %x\n", (int)(&(mymsgs[2])));
  printf("mymsgs 3 %x\n", (int)(&(mymsgs[3])));
  printf("mymsgs 4 %x\n", (int)(&(mymsgs[4])));
  printf ("Checking their stability\n");
  for (i = 0; i < mymid; i++)
    if (xcontrolsessn(mysession, STABLE, (char *)(&(mymsgs[i])), &temp))
       printf("mymsg stable\n");
    else
       printf("mymsg not stable\n");
  printf ("receiving 5 msgs from conv\n");
  while (mid < 5)
    if (msgs[mid] = xcontrolsessn(mysession, GETMESSAGE, m, &temp)) {
      temp = 50;
      mid++;
    }
  printf ("Checking their stability\n");
  for (i = 0; i < mid; i++)
    if (xcontrolsessn(mysession, STABLE, (char *)(&(msgs[i])), &temp))
      printf("msg stable\n");
    else
      printf("msg not stable\n");
  printf ("Checking mymsgs stability again\n");
  for (i = 0; i < mymid; i++)
    if (xcontrolsessn(mysession, STABLE, (char *)(&(mymsgs[i])), &temp))
       printf("mymsg stable\n");
    else
       printf("mymsg not stable\n");
  mymsgs[mymid++] = xpush(mysession, m, MESSAGE_LENGTH);
  temp = 50;
  while (!xcontrolsessn(mysession, GETMESSAGE, m, &temp));
  printf ("Checking mymsgs stability again\n");
  for (i = 0; i < mymid; i++)
    if (xcontrolsessn(mysession, STABLE, (char *)(&(mymsgs[i])), &temp))
       printf("mymsg stable\n");
    else
       printf("mymsg not stable\n");
}

/*

algo2()
{
  char m[100], ch;
  int msg, temp, c, count, i;
  int mymid, mymsgs[100], msgs[100], mid;

  temp = 50;
  mid = mymid = msg = 0;
  while(1) {
    printf("Command ? :\n");
    ch = getchar();
    printf("ch = %c\n", ch);
    scanf("%d", &c);
    printf("command = %d\n", c);
    switch (c) {
      case 0 : 
        scanf("%d", &count);
        for (i = 0; i < count; i++) {
          *((unsigned *)m) = msg++;
          mymsgs[mymid++] = xpush(mysession, m, MESSAGE_LENGTH);
        }
        break;
      case 1 :
        for (i = 0; i < mymid; i++)
          if (xcontrolsessn(mysession, STABLE, &(mymsgs[i]), &temp))
            printf("mymsg stable\n");
          else
            printf("mymsg not stable\n");
        mymid = 0;
        break;
      case 2 :
        for (i = 0; i < mid; i++)
          if (xcontrolsessn(mysession, STABLE, &(msgs[i]), &temp))
            printf("msg stable\n");
          else
            printf("msg not stable\n");
          mid = 0;
        break;
      case 3 :
          while (msgs[mid++] = xcontrolsessn(mysession, GETMESSAGE, m, &temp));
          break;
      default : break;
    }
  }
}

*/

fill_part_list(part, part_num)
    Part            part[];
    int             part_num;	/* 0 fires up active open */

{
    int             i;

    part[0].address = (char *) 0;
    part[0].length = 0;

    if (part_num > 0) {

	part[1].address = (char *) &host_tab[part_num].psync_address;
	part[1].length = sizeof(PSYNCaddr);
	part[2].address = part[3].address = (char *) 0;
	part[2].length = part[3].length = 0;

    } else {
	/* part_num == 0 */
	part[1].address = (char *) &host_tab[0].psync_address;
	part[1].length = sizeof(PSYNCaddr);
	for (i = 0; i < NUM_PARTS; i++) {
	    part[i + 1].address = 
		(char *) &host_tab[ part_index[i] ].psync_address;
	    part[i + 1].length = sizeof(PSYNCaddr);
	}
	part[i + 1].address = (char *) 0;
	part[i + 1].length = 0;

    }

}

null()
{
    printf("***PANIC: null process executed!!!\n");
}

printtime(m, t)
    char           *m;
    time           *t;
{
    printf("%s%d:%6d\n", m, t->sec, t->usec);
}



demux0(s, m, len)
    register Sessn  s;
    int             len;
    char           *m;
{

#   define MY_PART_NUM 0

    time            now, total;
    static unsigned count = 0;
    register unsigned *num_ptr = (unsigned *) m;
    char            buf[100];


    if (trip_num > 1) {
	trip_num--;

	if (1 /* REPLY_TO_MSG(m, MY_PART_NUM) */) {
	    /* increment the sequence number and reply */
	    (*num_ptr)++;
            trip_num--;   /* cause I don't receive my own message */
	    if (debug>3)
	        printf("part %2d: sending %d\n", MY_PART_NUM, *num_ptr);
	    xpush(s, m, MESSAGE_LENGTH);
	}
    } else {
        printf("in timing\n");
	xgettime(&now);
	count += trips_per_test;
	subtime(&starttime, &now, &total);


	printf("%3d.%6d  (%5d total trips)\n",
	       total.sec, total.usec, count);
	if (++test_num <= num_tests) {
	    /* start another test */
	    printf("Sending %5d (%2d/%2d)... ",
		   trips_per_test, test_num, num_tests);
	    trip_num = trips_per_test - 1;
	    strcpy(buf, MESSAGE);
	    num_ptr = (unsigned *) buf;
	    *num_ptr = 1;
	    xgettime(&starttime);
	    xpush(s, buf, MESSAGE_LENGTH);
	} else
	    printf("All done with the %d tests!!\n\n", num_tests);

    }

#undef MY_PART_NUM
}



demux1(s, m, len)
    register Sessn  s;
    int             len;
    char           *m;
{
    register unsigned *num_ptr = (unsigned *) m;

#   define MY_PART_NUM  1

    if (1 /* REPLY_TO_MSG(m, MY_PART_NUM) */) {
	/* increment the sequence number and reply */
	(*num_ptr)++;
	if (debug>3)
	    printf("part %2d: sending %d\n", MY_PART_NUM, *num_ptr);
	xpush(s, m, MESSAGE_LENGTH);
    }
#   undef MY_PART_NUM
}


demux2(s, m, len)
    register Sessn  s;
    int             len;
    char           *m;
{
    register unsigned *num_ptr = (unsigned *) m;

#   define MY_PART_NUM  2


    if (1) /* (REPLY_TO_MSG(m, MY_PART_NUM)) */{
	/* increment the sequence number and reply */
	(*num_ptr)++;
	if (debug>3)
	    printf("part %2d: sending %d\n", MY_PART_NUM, *num_ptr);
	xpush(s, m, MESSAGE_LENGTH);
    }
#   undef MY_PART_NUM
}


demux3(s, m, len)
    register Sessn  s;
    int             len;
    char           *m;
{
    register unsigned *num_ptr = (unsigned *) m;

#   define MY_PART_NUM  3


    if (REPLY_TO_MSG(m, MY_PART_NUM)) {
	/* increment the sequence number and reply */
	(*num_ptr)++;
	if (debug>3)
	    printf("part %2d: sending %d\n", MY_PART_NUM, *num_ptr);
	xpush(s, m, MESSAGE_LENGTH);
    }
#   undef MY_PART_NUM
}


demux4(s, m, len)
    register Sessn  s;
    int             len;
    char           *m;
{
    register unsigned *num_ptr = (unsigned *) m;

#   define MY_PART_NUM  4


    if (REPLY_TO_MSG(m, MY_PART_NUM)) {
	/* increment the sequence number and reply */
	(*num_ptr)++;
	if (debug>3)
	    printf("part %2d: sending %d\n", MY_PART_NUM, *num_ptr);
	xpush(s, m, MESSAGE_LENGTH);
    }
#   undef MY_PART_NUM
}


demux5(s, m, len)
    register Sessn  s;
    int             len;
    char           *m;
{
    register unsigned *num_ptr = (unsigned *) m;

#   define MY_PART_NUM  5


    if (REPLY_TO_MSG(m, MY_PART_NUM)) {
	/* increment the sequence number and reply */
	(*num_ptr)++;
	if (debug>3)
	    printf("part %2d: sending %d\n", MY_PART_NUM, *num_ptr);
	xpush(s, m, MESSAGE_LENGTH);
    }
#   undef MY_PART_NUM
}


demux6(s, m, len)
    register Sessn  s;
    int             len;
    char           *m;
{
    register unsigned *num_ptr = (unsigned *) m;

#   define MY_PART_NUM  6


    if (REPLY_TO_MSG(m, MY_PART_NUM)) {
	/* increment the sequence number and reply */
	(*num_ptr)++;
	if (debug>3)
	    printf("part %2d: sending %d\n", MY_PART_NUM, *num_ptr);
	xpush(s, m, MESSAGE_LENGTH);
    }
#   undef MY_PART_NUM
}


demux7(s, m, len)
    register Sessn  s;
    int             len;
    char           *m;
{
    register unsigned *num_ptr = (unsigned *) m;

#   define MY_PART_NUM  7


    if (REPLY_TO_MSG(m, MY_PART_NUM)) {
	/* increment the sequence number and reply */
	(*num_ptr)++;
	if (debug>3)
	   printf("part %2d: sending %d\n", MY_PART_NUM, *num_ptr);
	xpush(s, m, MESSAGE_LENGTH);
    }
#   undef MY_PART_NUM
}



psync_user_open_done(s, p)
    int             s;
    Part           *p;
{
    printf("USER: psync open complete s %x\n", s);
    mysession = (Sessn)s;
    printf("USER: psync open complete s %x\n", s);
}


addtime(t1, t2, t3)
    time           *t1, *t2, *t3;
{
    t3->sec = t2->sec + t1->sec;
    t3->usec = t2->usec + t1->usec;
    if (t3->usec >= 1000000) {
	t3->usec -= 1000000;
	t3->sec += 1;
    }
}


subtime(t1, t2, t3)
    time           *t1, *t2, *t3;
{
    t3->sec = t2->sec - t1->sec;
    t3->usec = t2->usec - t1->usec;
    if (t3->usec < 0) {
	t3->usec += 1000000;
	t3->sec -= 1;
    }
}

multime(t1, n, t3)
    time           *t1, *t3;
    unsigned        n;	/* assume n >= 0 */
{

    t3->sec = t1->sec * n;
    t3->usec = t1->usec * n;

    while (t3->usec >= 1000000) {
	t3->usec -= 1000000;
	t3->sec++;
    }
}

divtime(t1, n, t3)
    time           *t1, *t3;
    unsigned        n;	/* assume n >= 0 */
{

    unsigned        rem;

    t3->sec = t1->sec / n;
    rem = t1->sec % n;

    t3->usec = (t1->usec + rem * 1000000) / n;

}

tmp_enet_close()
{
    printf("***PANIC: tmp_enet_close executed!!!\n\n");
}

tmp_enet_open()
{
    printf("***PANIC: tmp_enet_open executed!!!\n\n");
}

tmp_enet_demux()
{
    printf("***PANIC: tmp_enet_demux executed!!!\n\n");
}

/* my_ethernet_address does the obvious */
ETHhost
my_ethernet_address(print_string)
    char           *print_string;	/* NULL if we aren't supposed to
					 * print anything */
{
    PROTL           ETH, p;
    ETHhost   myeaddr;

    p = xcreateprotl((Pfi) tmp_enet_demux, (Pfi) tmp_enet_open,
		     (Pfs) tmp_enet_close);
    ETH = xgetprotlbyname("eth");
    if (xcontrolprotl(ETH, MYADDR, &myeaddr, 6) != 6) {
	printf("Cannot get my own enet addr\n");
	exit(1);	/* to somewhere */
    }
    if (print_string != NULL)
	printf("%s%x.%x.%x\n", print_string,
	       myeaddr.high, myeaddr.mid, myeaddr.low);
    xdestroyprotl(p);
    return (myeaddr);
}



int reply_to_msg(m,part_num)
char *m;
int part_num;
{
int i;
static int count = 0;
static int limit = 1000000;
        unsigned msg_num =  *((unsigned *) m) , rtn;

	rtn = (  (msg_num % NUM_PARTS) == part_num  ? 1  : 0 );
	if (rtn) {
	  count++;
	  if (count > 5) limit = 200000;
	  if (count > 20) limit = 50000;
	  boxon();
	  for (i=limit; i>0; i--);
	  boxoff();
	}
/*	printf("reply_to_msg: num=%d, part_num=%d, rtn=%d\n",
 		msg_num, part_num, rtn);
 */
	return(rtn);
}


#ifdef PROFILE
#include "profile.c"
#endif


#include "scr.h"

#define FRAMEBUFFER 		0xfe20000
#define FRAMEBUFFERSIZE 	0x20000
#define FRAMEBUFFERWIDTH	1152
#define FRAMEBUFFERHEIGHT	900
#define WIDTH 300
#define HEIGHT 300
#define SCR                     xgetprotlbyname("scr")

draw_line(x1, y1, x2, y2)
{
  long l[4];
  l[0] = x1;
  l[1] = y1;
  l[2] = x2;
  l[3] = y2;
  xcontrolprotl(SCR, SCR_LINE, (char *)l, sizeof l);
}

draw_box(x1, y1, x2, y2, on)
{
  long l[5];
  l[0] = x1;
  l[1] = y1;
  l[2] = x2;
  l[3] = y2;
  l[4] = on;
  xcontrolprotl(SCR, SCR_BLT, (char *)l, sizeof l);
}

do_blt(x1, y1, x2, y2, dx, dy)
{
  long l[6];
  l[0] = x1;
  l[1] = y1;
  l[2] = x2;
  l[3] = y2;
  l[4] = dx;
  l[5] = dy;
  xcontrolprotl(SCR, SCR_BITBLT, (char *)l, sizeof l);
}

boxon()
{
  draw_box((FRAMEBUFFERWIDTH-WIDTH)/2, (FRAMEBUFFERHEIGHT-HEIGHT)/2,
    (FRAMEBUFFERWIDTH+WIDTH)/2, (FRAMEBUFFERHEIGHT+HEIGHT)/2, 1);
}

boxoff()
{
  draw_box((FRAMEBUFFERWIDTH-WIDTH)/2, (FRAMEBUFFERHEIGHT-HEIGHT)/2,
    (FRAMEBUFFERWIDTH+WIDTH)/2, (FRAMEBUFFERHEIGHT+HEIGHT)/2, 0);
}

E 1
