/* 
 * inline.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef ms_inline_h
#define ms_inline_h

#ifdef __STDC__
static inline nop()
{
  asm volatile ("nop");
}

static inline getsr()
{
  int x;
  asm volatile ("moveq #0,%0; movw	sr, %0" : "=d" (x) );
  return x;
}

static inline getstacksr()
{
  int x;
  asm volatile ("moveq #0,%0; movw	sp@, %0" : "=d" (x) );
  return x;
}

static inline void disable()
{
  asm volatile ("orw	#0x0700,sr");
}

static inline Ms_Spl7()
{
  int x;
  asm volatile ("movw	sr, %0" : "=d" (x));
  asm volatile ("orw	#0x0700, sr");
  return x;
}

static inline Ms_Splx(int x)
{
  asm volatile ("movw	%0, sr" : : "d" (x));
}

static inline void enable()
{
  asm volatile ("andw	#0xf0ff,sr");
}

static inline void Fc3WriteBit8(char *where, int what)
{
  asm volatile ("movsb	%0, %1@" : : "d" (what), "a" (where));
}

static inline void Fc3WriteBit16(char *where, int what)
{
  asm volatile ("movsw	%0, %1@" : : "d" (what), "a" (where));
}

static inline void Fc3WriteBit32(char *where, int what)
{
  asm volatile ("movsl	%0, %1@" : : "d" (what), "a" (where));
}

#ifndef min
static inline int min(int a, int b)
{
  return a < b ? a : b;
}
#endif

#ifndef max
static inline int max(int a, int b)
{
  return a > b ? a : b;
}
#endif

static inline Ms_FetchUSP()
{
  int x;
  asm volatile ("movl	usp, %0" : "=a" (x));
  return x;
}

static inline void breakpoint()
{
  asm volatile ("trap	#14");
}

static inline void Switch()
{
  asm volatile ("jra	_Switch");
}

static inline void ActivateReadyqHead()	/* what about Ms_ActivateReadyqHead */
{
  asm volatile ("jra	_ActivateReadyqHead");
}

static inline KernelStack()
{
  asm volatile ("movl	_StackBottom,sp" : : : "sp");
}

static inline swap1(int x)
{
  asm volatile ("rolw	#8, %0" : "=d" (x) : "0" (x));
  return x;
}

#define swap2(x) swap1(x)

static inline swap4(int x)
{
  asm volatile ("rolw	#8, %0; swap %0; rolw #8, %0" : "=d" (x) : "0" (x));
  return x;
}

static inline void flushCache()
{
  asm volatile ("movc	%0, cacr" : : "d" (9));
}

static inline int FetchSP()
{
  int x;
  asm volatile ("movl	sp,%0" : "=g" (x));
  return x;
}

static inline int FetchFP()
{
  int x;
  asm volatile ("movl	a6, %0" : "=g" (x));
  return x;
}

static inline void SetSP(long x)
{
  asm volatile ("movl	%0, sp" : : "g" (x));
}

static inline void SetUSP(long x)
{
  asm volatile ("movl	%0, usp" : : "a" (x));
}

typedef int (*Ff)(int, int); 
static inline void CallOnKernelStack(Ff f, int x, int y)
{
  extern char *StackBottom;
  long *p = (long *)StackBottom;
  *--p = FetchSP();
  SetSP((int)p);
  f(x, y);
  SetSP(*(long *)FetchSP());
}

static inline int ffs(int x)
{
  int y;
  asm volatile ("bfffo	%1{#0:#0},%0" : "=d" (y) : "d" (x));
  return x;
}

static inline bfset(int x, long *y)
{
  asm volatile ("bfset	%0@{%1:#1}" : : "a" (y), "d" (x));
}

static inline bfclr(int x, long *y)
{
  asm volatile ("bfclr	%0@{%1:#1}" : : "a" (y), "d" (x));
}

static inline Ms_Switch()
{
  asm volatile ("movw	#0x0080,sp@-;"
      "pea	1f;"
      "movw	sr,sp@-;"
      "orw	#0x0700,sr;"
      "movl	_Active,sp@-;"
      "jbsr	_Ms_Addready;"
      "addqw	#4,sp;"
      "jra	_Switch;"
      "1:" : : : "d0", "d1", "a0", "a1");
}

static inline unsigned char Fc3ReadBit8(char *where)
{
  int what;
  asm volatile ("movsb	%1@, %0" : "=d" (what) : "a" (where));
  return what;
}

static inline unsigned short Fc3ReadBit16(char *where)
{
  int what;
  asm volatile ("movsw	%1@, %0" : "=d" (what) : "a" (where));
  return what;
}

static inline unsigned Fc3ReadBit32(char *where)
{
  int what;
  asm volatile ("movsl	%1@, %0" : "=d" (what) : "a" (where));
  return what;
}

static inline unsigned CompleteGarbage(char *where)
{
  int what;
  asm volatile ("movsl	%1@, %0" : "=d" (what) : "a" (where));
  return what;
}

#endif /* __STDC__ */

#endif /* ms_inline_h */
