h22098
s 00119/00000/00000
d D 1.1 91/01/10 11:11:17 llp 1 0
c date and time created 91/01/10 11:11:17 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * ms_clock.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "ms_exception.h"
#include "ms_clock.h"
#include "unixtime.h"
#include "upi.h"
#include "clock.h"

union {
  InterruptRegister r;
  unsigned char u;
} TimerMask;

#define DIVIDE_BY 2

/*********************************************************
* Machine specific (Ms_) routines; called from clock.c
*********************************************************/

Ms_InitClock()
/*
 * Perform the required initialization for the timer.
 */
{
  unsigned char value;
  extern int Asm_Timer_interrupt();

  TimerMask.u = 0;
  TimerMask.r.enableInt5 = 1;
  
  setexvec(Asm_Timer_interrupt,INT5);
  
  CLKADDR->clk_intrreg = CLK_INT_HSEC;		/* set 1/100 sec clock intr */
  CLKADDR->clk_cmd = CLK_CMD_NORMAL;		/* enable clock intr */
  value = *(unsigned char *) V_INTERRUPT_REG;
  value |= TimerMask.u;
  *(unsigned char *) V_INTERRUPT_REG = value;
}

Ms_ReadTime(now)
register unsigned char *now;
{
  register int i;
  register u_char *cp = (u_char *)CLKADDR;

  for (i = CLK_HSEC; i < CLK_WEEKDAY; i++)	/* read counters */
    *now++ = *cp++;
}

Ms_ConvertTimeToUnix(chip, unixtime)
unsigned char chip[8];
UnixTime *unixtime;
{
  register int i;
  register unsigned long t = 0;
  unsigned short year;

  /*
   * Add the number of seconds for each year onto our time t.
   * We start at CHIPBASEYEAR, and count up to the year value given
   * by the chip.  If the year is greater/equal to the difference
   * between UNIXBASEYEAR and CHIPBASEYEAR, then that time is added into
   * the Unixtime time value we are calculating.
   */
  for (year = 0; year < chip[CLK_YEAR]; year++)
	  if (year >= (UNIXBASEYEAR - CHIPBASEYEAR))
		  t += SECSPERYEAR(year);

  /*
   * Now add in the seconds for each month that has gone
   * by this year, adjusting for leap year if appropriate.
   */
  for (i = 1; i < chip[CLK_MON]; i++)
	  t += SECSPERMONTH(i, year);

  t += (chip[CLK_DAY] - 1) * SECSPERDAY;
  t += chip[CLK_HOUR] * (60*60);
  t += chip[CLK_MIN] * 60;
  t += chip[CLK_SEC];

  unixtime->usec = chip[CLK_HSEC] * 10000;
  unixtime->sec = t;
}

/*********************************************************
* Internal routine: called at interrupt time
**********************************************************/

Timer_interrupt(
d0, d1, a0, a1,
frame
)
ExceptionStackFrame frame;
{
  register unsigned char value;
  static int doit = 0;
  extern Tick();
  extern unsigned short *tickInfo;

  value = *(unsigned char *) V_INTERRUPT_REG;
  value &= ~(TimerMask.u);
  *(unsigned char *) V_INTERRUPT_REG = value;
  value |= TimerMask.u;
  *(unsigned char *) V_INTERRUPT_REG = value;

  if (tickInfo) Tick(frame.x20.pc);
  if (++doit >= DIVIDE_BY) {
    doit = 0;
    ClockInterrupt();
  }
}


E 1
