h23592
s 00012/00001/00387
d D 1.4 91/01/10 11:13:59 llp 4 3
c Prepared for 3.1 Distribution
e
s 00001/00001/00387
d D 1.3 90/12/03 15:45:19 norm 3 2
c The test in join was comparing one message to itself
e
s 00020/00000/00368
d D 1.2 89/11/03 13:07:07 norm 2 1
c Implemented msg_foreach to traverse a message
e
s 00368/00000/00000
d D 1.1 89/10/24 13:46:36 norm 1 0
c date and time created 89/10/24 13:46:36 by norm
e
u
U
f e 0
t
T
I 4
/* 
 * nmessage.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

E 4
I 1
/*
D 4
 * %W%  %G%
E 4
I 4
 * These are the old (version 2) message routines; they now
 * get called to implement the graph part of the new (version
 * 3.1) messages
E 4
 */
I 4

E 4
#include "system.h"
#include "nmessage.h"
#include "assert.h"

#undef USESPL

/***************************************************************
/* Message Operations
/***************************************************************/

void nmsg_peek(m, off, len, b)
    register NMSG m;
    register int off;
    register int len;
    char *b;
{
  int tlen, toff;

#ifdef USESPL
  int x = spl7();

#endif
  assert(m->len >= len);
  switch (m->tag) {
   case NM_Contig:
     bcopy(m->body.contig.data + m->off, b, len);
     break;
   case NM_Single:
     nmsg_peek(m->body.single, off + m->off, len, b);
     break;
   case NM_Pair:
     toff = off + m->off;
     tlen = m->body.pair.l->len - toff;
     if (m->len - off < tlen)
       tlen = m->len - off;
     /* get tlen bytes out of left child, but no more than len */
     if (tlen > len)
       tlen = len;
     if (tlen > 0) {
       nmsg_peek(m->body.pair.l, toff, tlen, b);
       b += tlen;
     } else {
       tlen = 0;
     }
     toff = off + m->off - m->body.pair.l->len;
     if (toff < 0)
       toff = 0;
     assert(tlen >= 0 && tlen <= len);
     tlen = len - tlen;
     assert(tlen >= 0 && tlen <= len);
     if (tlen > 0)
       nmsg_peek(m->body.pair.r, toff, tlen, b);
     break;
  }
#ifdef USESPL
  splx(x);
#endif
}

NMSG nmsg_join(m1, m2)
    NMSG m1, m2;
{
#ifdef USESPL
  int x = spl7();

#endif
  register NMSG m;

  if (!m1) {
    m = m2;
  } else if (!m2) {
    m = m1;
  } else {
    if (((m1->tag == NM_Contig) && (m2->tag == NM_Contig)) &&
D 3
	(m1->body.contig.ref == m1->body.contig.ref) &&
E 3
I 3
	(m1->body.contig.ref == m2->body.contig.ref) &&
E 3
	((m1->body.contig.data + m1->len) ==
	 (m2->body.contig.data + m2->off))) {
      /* merge the messages */
      if (m1->ref == 1) {
	m1->len = m1->len + m2->len;
	nmsg_free(m2);
	m = m1;
      } else {
	nmsg_makecontig(m, m1->len + m2->len, m1->body.contig.data,
			m1->body.contig.ref);
	nmsg_free(m1);
	nmsg_free(m2);
      }
    } else {
      NMCREATEPAIR(m);
      m->body.pair.l = m1;
      m->body.pair.r = m2;
      m->len = m1->len + m2->len;
    }
  }
#ifdef USESPL
  splx(x);
#endif
  return (m);
}

NMSG nmsg_truncateleft(m, where)
    register NMSG m;
    int where;
{
  register NMSG n, source;
  register int len, off;

#ifdef USESPL
  int x = spl7();

#endif

  len = m->len - where;
  off = where;
  source = m;
  off += (m)->off;
  while (!((m)->tag == NM_Contig ||
	   ((m)->tag == NM_Pair && off < (m)->body.pair.l->len))) {
    if ((m)->tag == NM_Single)
      (m) = (m)->body.single;
    else {
      off -= ((m)->body.pair.l)->len;
      (m) = (m)->body.pair.r;
    }
    off += (m)->off;
  }
  off -= (m)->off;
  m->ref++;
  nmsg_free(source);
  if (m->ref == 1) {
    n = m;
    off += n->off;
  } else {
    NMCREATESINGLE(n);
    n->body.single = m;
  }
  n->off = off;
  n->len = len;
#ifdef USESPL
  splx(x);
#endif
  return (n);
}

NMSG nmsg_truncateright(m, where)
    register NMSG m;
    int where;
{
  register NMSG n, source;
  register int off, len;

#ifdef USESPL
  int x = spl7();

#endif

  off = 0;
  len = where;
  source = m;
  off += (m)->off;
  while (!((m)->tag == NM_Contig ||
	   ((m)->tag == NM_Pair && off + len > (m)->body.pair.l->len))) {
    if ((m)->tag == NM_Single)
      (m) = (m)->body.single;
    else
      (m) = (m)->body.pair.l;
    off += (m)->off;
  }
  off -= (m)->off;
  m->ref++;
  nmsg_free(source);
  if (m->ref == 1) {
    n = m;
    off += n->off;
  } else {
    NMCREATESINGLE(n);
    n->body.single = m;
  }
  n->off = off;
  n->len = len;
#ifdef USESPL
  splx(x);
#endif
  return (n);
}

void nmsg_display(m, level)	/* for debugging only */
    NMSG m;
    int level;
{
  int i;

  for (i = 0; i < level; i++)
    printf(" ");
  switch (m->tag) {
   case NM_Contig:
     printf("M<contig> addr=%d off=%d len=%d ref=%d data=%x \nref=%d ptr=%x\n",
	    m, m->off, m->len, m->ref, m->body.contig.data,
	    m->body.contig.ref->ref, m->body.contig.ref->ptr);
     break;
   case NM_Single:
     printf("M<single> addr=%d off=%d len=%d ref=%d ptr=%d\n", m,
	    m->off, m->len, m->ref, m->body.single);
     nmsg_display(m->body.single, level + 1);
     break;
   case NM_Pair:
     printf("M<pair> addr=%d off=%d len=%d ref=%d lptr=%d rptr=%d\n", m,
	    m->off, m->len, m->ref, m->body.pair.l, m->body.pair.r);
     nmsg_display(m->body.pair.l, level + 1);
     nmsg_display(m->body.pair.r, level + 1);
     break;
   default:
     break;
  }
}

/***************************************************************
/* Boundary Routines: Used only at kernel/user or
/*		      device/kernel boundary
/***************************************************************/

NMSG nmsg_internalize(data, len)
    char *data;
    int len;
{
  register NMSG m;

#ifdef USESPL
  int x = spl7();

#endif
  nmsg_createcontig(m, len);
  bcopy(data, m->body.contig.data, len);
#ifdef USESPL
  splx(x);
#endif
  return (m);
}

/***************************************************************
/* Hidden Routines: Used only by message operations;
/*		    not intended for use by protocols
/***************************************************************/

nmsg_free_it(m)
    NMSG m;
{
#ifdef USESPL
  int x = spl7();

#endif

  switch (m->tag) {
   case NM_Contig:
     if (--(m->body.contig.ref->ref) == 0) {
       char *temp;

       temp = m->body.contig.ref->ptr;
       m->body.contig.ref->xfree(temp);
       if ((char *) (m->body.contig.ref) != (temp)) {
	 free((char *) m->body.contig.ref);
       }
     }
     free((char *) m);
     break;
   case NM_Single:
     nmsg_free(m->body.single);
     free((char *) m);
     break;
   case NM_Pair:
     nmsg_free(m->body.pair.l);
     nmsg_free(m->body.pair.r);
     free((char *) m);
     break;
   default:
     break;
  }
#ifdef USESPL
  splx(x);
#endif
}

NMSG nmsg_fmakecontig(N, B, R)
    int N;
    char *B;
    REF *R;
{
  register NMSG M;

  (M) = ((NMSG) malloc(sizeof(struct nmsg)));
  (M)->tag = NM_Contig;
  (M)->ref = 1;
  (M)->off = 0;
  (M)->len = (N);
  (R)->ref++;
  (M)->body.contig.data = (B);
  (M)->body.contig.ref = (R);
  return M;
}

NMSG nmsg_fcreatecontig(N)
    int N;
{
  register NMSG M;

  (M) = ((NMSG) malloc(sizeof(struct nmsg)));
  (M)->tag = NM_Contig;
  (M)->ref = 1;
  (M)->off = 0;
  (M)->len = (N);
  (M)->body.contig.data = (char *) malloc((unsigned) N);
  (M)->body.contig.ref = (REF *) malloc(sizeof(REF));
  (M)->body.contig.ref->ref = 1;
  (M)->body.contig.ref->ptr = (M)->body.contig.data;
  (M)->body.contig.ref->xfree = free;
  return M;
}

NMSG nmsg_fclonecontig(m)
    NMSG m;
{
  NMSG r;

  nmsg_createcontig(r, (m)->len);
  bcopy((m)->body.contig.data, (r)->body.contig.data, (r)->len);
  return r;
}


nmsg_break(r_ptr, m_ptr, where)
    NMSG *r_ptr;
    NMSG *m_ptr;
    int where;
{
  NMSG r, m;
  NMSG temp;

  r = *r_ptr;
  m = *m_ptr;

  if (where < (m)->len) {
    if ((m)->tag == NM_Contig) {
      nmsg_makecontig(r, where,
		    (m)->body.contig.data + (m)->off, (m)->body.contig.ref);
      if ((m)->ref == 1) {
	(m)->len = (m)->len - where;
	(m)->body.contig.data = (m)->body.contig.data + where;
      } else {
	temp = m;
	nmsg_makecontig(m, (temp)->len - where, (temp)->body.contig.data + (m)->off + where, (temp)->body.contig.ref);
	nmsg_free(temp);
      }
    } else {
      (m)->ref++;
      (r) = nmsg_truncateright(m, where);
      (m) = nmsg_truncateleft(m, where);
    }
  } else {
    (r) = (m);
    (m) = NULL;
  }
  *r_ptr = r;
  *m_ptr = m;
}
I 2

void nmsg_foreach(m, f, arg1, arg2)
    register NMSG m;
    int (*f)();
    int *arg1, *arg2;
{
  switch (m->tag) {
    case NM_Contig:
      f(m->body.contig.data, m->len, arg1, arg2);
      break;
    case NM_Single:
      nmsg_foreach(m->body.single, f, arg1, arg2);
      break;
    case NM_Pair:
      nmsg_foreach(m->body.pair.l, f, arg1, arg2);
      nmsg_foreach(m->body.pair.r, f, arg1, arg2);
      break;
  }
}

E 2
E 1
