/*
 * vaddr.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */


#include "xkernel.h"
#include "eth.h"
#include "ip.h"
#include "blast.h"
#include "vaddr.h"

int tracevaddrp;

/* These macros map between BLAST and IP protocol ID's.  Since the IP
 * protocol field is just a byte, protocols which use VADDR must have
 * blast protocol numbers which are less that 256 and which are not
 * reserved IP protocol numbers.
 */
#define IPTOBLAST(X) (X)
#define BLASTTOIP(X) ((X) & 0xff)

/* If SIMULATE_ARP_FAILURE is defined, vaddr will not attempt to make a
 * local connection.  This is primarily useful for testing.
 */
/* #define SIMULATE_ARP_FAILURE */

    
static XObj VADDR_SELF;


vaddr_init(self)
XObj self;
{
  TRACE0(vaddrp, 1, "VADDR init");
  assert(x_is_protocol(self));
  if(VADDR_SELF) {
	Kabort("vaddr_init: can not open two VADDR protocols !");
  }
  VADDR_SELF = self;

  IFTRACE(vaddrp,1) x_printxobj(self);
}


XObj vaddr_open(self,hlp, p)
    XObj	self;
    XObj	hlp;
    Part 	*p;
{
    IPaddr	local_IPaddr, remote_IPaddr;
    BLASTaddr	local_BLASTaddr, remote_BLASTaddr;
    XObj	lls;
    Part	part[3];
    
    TRACE0(vaddrp, 3, "VADDR open");
    assert(x_is_protocol(self));
    assert(x_is_protocol(hlp));
    if (!p) {
	TRACE0(vaddrp, 1, "Bad participant set");
	x_errno = BAD_ADDR;
	return ERR_XOBJ;
    }
    local_IPaddr = get_part(p, 0, IPaddr);
    remote_IPaddr = get_part(p, 1, IPaddr);
    remote_BLASTaddr.host = remote_IPaddr.host;
    remote_BLASTaddr.prot = BLASTTOIP(remote_IPaddr.protocolnum);
    local_BLASTaddr.host = local_IPaddr.host;
    local_BLASTaddr.prot = BLASTTOIP(local_IPaddr.protocolnum);
    TRACE5(vaddrp, 4, "IP address is %d @ %d.%d.%d.%d",
	   remote_IPaddr.protocolnum, remote_IPaddr.host.a,
	   remote_IPaddr.host.b, remote_IPaddr.host.c, remote_IPaddr.host.d);
#ifndef SIMULATE_ARP_FAILURE
    /*
     * Try to open a local-network session
     */
    TRACE2(vaddrp, 4, "Opening BLAST with address %d @ %s",
	   remote_BLASTaddr.prot, inet_ntoa(remote_BLASTaddr.host));
    init_partlist(part, 2, BLASTaddr);
    set_part(part, 0, local_BLASTaddr);
    set_part(part, 1, remote_BLASTaddr);
    if ((lls = x_open(hlp, self->down[1], part)) != ERR_XOBJ) {
	return lls;
    }
#endif
    TRACE0(vaddrp, 4, "vaddr_open: could not open local-network session");
    /*
     * Try opening remote-network session
     */
    if ((lls = x_open(hlp, self->down[0], p)) != ERR_XOBJ) {
	return lls;
    }
    TRACE0(vaddrp, 4, "vaddr_open: could not open remote-network session");
    return ERR_XOBJ;
}


vaddr_openenable(self,hlp, p)
    XObj	self;
    XObj	hlp;
    Part	*p;
{
    IPaddr	local_IPaddr;
    BLASTaddr	local_BLASTaddr;
    Part	part[2];

    TRACE0(vaddrp, 3, "VADDR open enable");
    assert(x_is_protocol(self));
    assert(x_is_protocol(hlp));
    local_IPaddr = get_part(p, 0, IPaddr);
    TRACE1(vaddrp, 5, "IP prototocol %d", local_IPaddr.protocolnum);
    local_BLASTaddr.host = local_IPaddr.host;
    local_BLASTaddr.prot = IPTOBLAST(local_IPaddr.protocolnum);
    if (x_openenable(hlp, self->down[0], p) < 0) {
	TRACE0(vaddrp, 3, "Can't openenable remote-network protocol");
	x_errno = ALREADY_OPEN;
	return(-1);
    }
    init_partlist(part, 1, BLASTaddr);
    set_part(part, 0, local_BLASTaddr);
    if (x_openenable(hlp, self->down[1], part) < 0) {
	TRACE0(vaddrp, 3, "Can't openenable local-network protocol");
	x_opendisable(self,self->down[0], p);
	x_errno = ALREADY_OPEN;
	return(-1);
    }
    return(0);
}


vaddr_controlprotl(self,opcode, buf, len)
XObj self;
int opcode, len;
char *buf;
{
  assert(x_is_protocol(self));
  /* All opcodes are forwarded to the remote-network protocol */
  return x_controlprotl(self->down[0],opcode, buf, len);
}


/*ARGSUSED*/
vaddr_controlsessn(s, opcode, buf, len)
    XObj s;
    int opcode, len;
    char *buf;
{
    Kabort("VADDR control_sessn called!");
}


/*ARGSUSED*/
vaddr_push(s, msg,rmsg_ptr)
    XObj	s;
    Msg		msg;
    Msg		*rmsg_ptr;
{
    Kabort("VADDR push called");
}


/*ARGSUSED*/
vaddr_demux(self, s, dg)
XObj	self, s;
Msg	dg;
{
    Kabort("VADDR demux called");
}


/*ARGSUSED*/
vaddr_pop(s, ds, dg)
XObj	s, ds;
Msg	dg;
{
  Kabort("VADDR pop called");
}



vaddr_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->init = vaddr_init;
    p->push = noop;
    p->pop = noop;
    p->control = vaddr_controlprotl;
  } else {
    p->init = noop;
    p->push = vaddr_push;
    p->pop = vaddr_pop;
    p->control = vaddr_controlsessn;
  }
  p->instantiateprotl = noop;
  p->close = noop;
  p->open = (Pfi) vaddr_open;
  p->openenable = vaddr_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = vaddr_demux;
  p->getproc = vaddr_getproc;
}

