h13649
s 00002/00002/00050
d D 1.2 91/01/10 12:08:47 llp 2 1
c Prepared for 3.1 Distribution
e
s 00052/00000/00000
d D 1.1 90/11/16 13:07:41 menze 1 0
c date and time created 90/11/16 13:07:41 by menze
e
u
U
f e 0
t
T
I 1
/*
 * sb.h
 *
 * Derived from:
 *
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * Modified for x-kernel v3.1	12/10/90
D 2
 * Modifications Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Modifications Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

#ifndef sb_h
#define sb_h

#define TCP_BUFFER_SPACE (4 * 1024)
#define sbhiwat(X) (TCP_BUFFER_SPACE)

struct sb {
  struct sb_i *next, *prev;
  int space;
  int len;
};

struct sb_i {
  struct sb_i *next, *prev;
D 2
  MSG m;
E 2
I 2
  Msg m;
E 2
};

#define sblength(sb) ((sb)->len)
#define sbspace(sb)  (sbhiwat(sb)-sblength(sb))
#define sbinit(sb) { \
		       (sb)->next = (sb)->prev = (struct sb_i*)(sb); \
		       (sb)->len=0; \
		       (sb)->space=TCP_BUFFER_SPACE; \
		   }
#define sbconsumespace(sb,n) ((sb)->space -= (n))
#define sbfreespace(sb,n) ((sb)->space += (n))
#define sbrecvspace(sb) ((sb)->space)

extern struct sb_i *sbifreelist;
#define sbinew(s) { if ((s) = sbifreelist) sbifreelist = (s)->next; else (s) = (struct sb_i *)malloc(sizeof(struct sb_i)); }
#define sbifree(s) { (s)->next = sbifreelist; sbifreelist = (s); }

#endif
E 1
