h29648
s 00005/00005/00157
d D 1.2 91/01/10 12:08:43 llp 2 1
c Prepared for 3.1 Distribution
e
s 00162/00000/00000
d D 1.1 90/11/16 13:07:37 menze 1 0
c date and time created 90/11/16 13:07:37 by menze
e
u
U
f e 0
t
T
I 1
/*
 * in_hacks.c
 *
 * Derived from:
 *
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * Modified for x-kernel v3.1	12/10/90
D 2
 * Modifications Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Modifications Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */
D 2
#include "debug.h"
#include "upi.h"
E 2
I 2

#include "xkernel.h"
E 2
#include "tcp_internal.h"

/*ARGSUSED*/
in_pcbbind(inp, name)
struct inpcb *inp;
D 2
MSG *name;
E 2
I 2
Msg *name;
E 2
{
  Kabort("in_pcbbind");
}

in_pcballoc(so, head)
	XObj so;
	struct inpcb *head;
{
	register struct inpcb *inp;

	inp = (struct inpcb *)malloc(sizeof *inp);
	inp->inp_head = head;
	inp->inp_session = so;
	insque(inp, head);
	sotoinpcb(so) = inp;
	return (0);
}

/*ARGSUSED*/
in_pcbdisconnect(inp)
struct inpcb *inp;
{
  Kabort("in_pcbdisconnect");
}

tcppcblookup(src, sport, dst, dport, inp, tp, so)
struct in_addr src, dst;
u_short sport, dport;
struct inpcb **inp;
struct tcpcb **tp;
XObj *so;
{
  extern Map tcp_map;
  TCP_EXID id;
  XObj s;

  id.localport = dport;
  id.remoteport = sport;
  id.remoteaddr = *(IPhost *)&src.s_addr;
  TRACE3(tcpp, 3, "Looking for %d->%X.%d", 
    id.localport, id.remoteaddr, id.remoteport);
  /* look in the map */
  s = (XObj) map_resolve(tcp_map, (char *)&id);
  if (s == ERR_SESSN) {
    id.remoteport = (u_short)PADDING;
    *(unsigned long *)&id.remoteaddr = PADDING;
    TRACE3(tcpp, 3, "Looking for %d->%X.%d",
      id.localport, id.remoteaddr, id.remoteport);
    /* look in the map */
    s = (XObj) map_resolve(tcp_map, (char *)&id);
    if (s == ERR_SESSN) {
      *so = 0;
      *inp = 0;
      *tp = 0;
      return;
    } else {
      *so = s;
      *inp = 0;
      *tp =  0;
    }
  } else {
    *so = s;
    *inp = sototcpst(s)->inpcb;
    *tp =  sototcpst(s)->tcpcb;
  }
}

in_pcbdetach(inp)
struct inpcb *inp;
{
  remque(inp);
  free((char *)inp);
}

in_broadcast(addr)
struct in_addr addr;
{
  return (ntohl(addr.s_addr) & 0xff) == 0 ||
  	 (ntohl(addr.s_addr) & 0xff) == 0xff;
}

static void cksum_helper(data, len, odd, sofar)
unsigned short *data;
int len, *odd, *sofar;
{
  register unsigned long sum = *(unsigned long *)sofar;
  if (*odd) {
#if ENDIAN == LITTLE
    sum += *(u_char *)data << 8;
#else
    sum += *(u_char *)data;
#endif
    data = (unsigned short *)((char *)data + 1);
    len--;
  }
#define USEOCSUM
#ifdef USEOCSUM
  {
    register int wlen = len >> 1;
    sum += ocsum(data, wlen);
    data += wlen;
    len = len & 1;
  }
#endif
  while (len > 1) {
    sum += *data++;
    len -= 2;
  }
  if (len) {
#if ENDIAN == LITTLE
    sum += *(u_char *)data;
#else
    sum += *(u_char *)data << 8;
#endif
    *odd = 1;
  } else {
    *odd = 0;
  }
  *sofar = sum;
}

in_cksum(m, len)
D 2
MSG m;
E 2
I 2
Msg m;
E 2
int len;
{
  unsigned long sum = 0;
  int odd = 0;
  
  TRACE2(tcpp, 4, "tcp cksum: len = %d msg_len = %d", len, msg_len(m));
/*  assert(len == msg_len(m)); */
  msg_foreach(m, cksum_helper, &odd, &sum);
  sum = (sum & 0xffff) + ((sum >> 16) & 0xffff);
  sum = (sum & 0xffff) + ((sum >> 16) & 0xffff);
  assert(!(sum >> 16));
  return ~sum & 0xffff;
}
E 1
