/* 
 * select_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef select_internal_h
#define select_internal_h

#define SELECTHLEN sizeof(SELECT_HDR)
 
#define SELECTEXTIDLEN SELECTADLEN

#define SEL_OK 1
#define SEL_FAIL 2

/* On open, select will ask vchan to acquire 1+EXTRA_CHANNELS channels */
#define EXTRA_CHANNELS 2	

typedef struct  {
        RPCaddr server;
	char status;
} SELECT_HDR;

typedef struct {
	RPCaddr server;
	SELECT_HDR hdr;
  	XObj down_s;
} SELECT_STATE;

typedef struct {
	CHANaddr myCHANaddr;
	Map passive_map;
	Map active_map;
} PSTATE;

typedef RPCaddr PassiveID;


/* By using under_s as part of the active key, we get one select
 * session per channel session.  A single channel will have separate
 * channel sessions for client and server directions, so there are separate
 * select sessions for these directions as well.
 */

typedef struct {
    u_short command;
    XObj under_s;	
} ActiveID;
    
#endif
