/*
 * pmap5.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <rpc/rpc.h>
#include "xkernel.h"
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"
#include "pmap.h"
#include "pmap_internal.h"

static XObj SELF=0;
#define SUNRPC SELF->down[0]
#define PMAP5 SELF
static Msg null_msg={0,0};
int tracepmap5p=0;

static pmap5_instantiateprotl(self) 
XObj self;
{
  TRACE0(pmap5p, 1, "PMAP5 instanciateprotl");

  if (SELF) {
    Kabort("SUN Portmapper 5: can't instanciate twice");
  }
  SELF = self;
  return 0;
}


static pmap5_init(self)
XObj self;
{

  Part part[2];
  SUNRPCaddr server;
  IPhost myipaddr;


  

  if (x_controlprotl(SUNRPC, GETMYADDR, (char *)&myipaddr,
		     sizeof myipaddr) < 0) {
    printf("Can't find my IP addr\n");
    return(-1);
  }


  /* create address */
  server.prog = PMAP_PROG;
  server.vers = PMAP_VERS;
  server.proc = PMAPPROC_CALLIT;
  server.prot = 17;
  server.host.port = PMAP_PORT;  
  server.host.host = myipaddr;;
 
  init_partlist(part, 1, SUNRPCaddr); 
  set_part(part, 0 , server);
  x_openenable(PMAP5, SUNRPC, part);
}


static pmap5_demux(self,s, msg)
XObj 	self;
XObj	s;
Msg msg;
{
  char *buf;
  int len;
  int len2;
  int hlp;
  PMAP_ARGS args;
  int *results;
  Msg msg2;
  
  /* pmap callit not implemented */
 

  return(0);
}

static pmap5_opendone(self,s,part)
XObj self;
XObj s;
Part part;
{
  TRACE0(pmap5p,7,"--->pmap5_opendone");
}

pmap5_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = pmap5_instantiateprotl;
    p->init = pmap5_init;
  } else {
    p->instantiateprotl = noop;
    p->init = noop;
  }
  p->close = noop;
  p->control = noop;
  p->push = noop; 
  p->pop = noop;
  p->open = (Pfi) noop;
  p->openenable = noop;
  p->opendone = pmap5_opendone;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = pmap5_demux;
  p->getproc = pmap5_getproc;
}

