h53419
s 00023/00023/00113
d D 1.2 91/01/10 12:13:53 llp 2 1
c Prepared for 3.1 Distribution
e
s 00136/00000/00000
d D 1.1 90/12/08 23:38:39 menze 1 0
c date and time created 90/12/08 23:38:39 by menze
e
u
U
f e 0
t
T
I 1
/*
 * xnfs.h
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

D 2
#pragma once
E 2
I 2
#ifndef xnfs_h
#define xnfs_h
E 2

#include <sys/errno.h>
#include <rpc/types.h>
#include <rpc/rpc.h>
#include <nfs/nfs.h>
#include "ip.h"


#define REMOTESIZE	6
#define MAX_DIRENTRY	128
#define MAXFILENAME	64

D 2
/* nfs opcodes */
#define MOUNT		1	/* in controlprotl */
#define SETNFSDEBUG 	2
#define MKDIR		3
#define RMDIR		4
#define SETATTR		5
#define REMOVE		6
#define RENAME		7
#define SYMLINK		8
#define LINK            9
#define GETATTR		10
#define READLINK	11
#define READDIR  	18
E 2
I 2
/* nfs control opcodes */
#define NFS_MOUNT	(NFS_CTL*MAXOPS+0)
#define NFS_MKDIR	(NFS_CTL*MAXOPS+1)
#define NFS_RMDIR	(NFS_CTL*MAXOPS+2)
#define NFS_SETATTR	(NFS_CTL*MAXOPS+3)
#define NFS_REMOVE	(NFS_CTL*MAXOPS+4)
#define NFS_RENAME	(NFS_CTL*MAXOPS+5)
#define NFS_SYMLINK	(NFS_CTL*MAXOPS+6)
#define NFS_LINK	(NFS_CTL*MAXOPS+7)
#define NFS_GETATTR 	(NFS_CTL*MAXOPS+8)
#define NFS_READLINK	(NFS_CTL*MAXOPS+9)
#define NFS_READDIR  	(NFS_CTL*MAXOPS+10)
#define NFS_READ	(NFS_CTL*MAXOPS+11)
#define NFS_WRITE   	(NFS_CTL*MAXOPS+12)
#define NFS_SEEK    	(NFS_CTL*MAXOPS+13)
#define NFS_TELL	(NFS_CTL*MAXOPS+14)
E 2

D 2
#define NFS_OPEN    	12	/* in open */
#define NFS_CREATE  	13   
E 2
I 2
#define NFS_OPEN    	0	/* mode passed to open */
#define NFS_CREATE  	1   
E 2

D 2
#define NFS_READ	14	/* in controlsessn */
#define NFS_WRITE   	15
#define NFS_SEEK    	16
#define NFS_TELL	17


E 2
/* NFS filesystem structure; one per mounted file system */
typedef struct nfs_state {
    IPaddr	host_ipaddr;
    char        *pathname;  	/* filesystem root pathname */
    struct authunix_parms auth_parms; 	/* authentication stuff */
    fhandle_t 	fs_handle;	/* NFS handle for filesystem root */
    /* note that the order of these sessions is constant, and must be the
     * same as their corresponding RPC "opcodes" */
    Sessn	rpc_null_s;		/* NOT USED */
    Sessn	rpc_getattr_s;
    Sessn	rpc_setattr_s;
    Sessn	rpc_root_s;		/* NOT USED */
    Sessn	rpc_lookup_s;
    Sessn	rpc_readlink_s;
    Sessn	rpc_read_s;
    Sessn	rpc_writecache_s;	/* NOT USED */
    Sessn	rpc_write_s;
    Sessn	rpc_create_s;
    Sessn	rpc_remove_s;
    Sessn	rpc_rename_s;
    Sessn	rpc_link_s;
    Sessn	rpc_symlink_s;
    Sessn	rpc_mkdir_s;
    Sessn	rpc_rmdir_s;
    Sessn	rpc_readdir_s;		/* NOT USED WAIT, arevilak implemented*/
    Sessn	rpc_statfs_s;		/* NOT USED */
    Sessn	rpc_nproc_s;		/* NOT USED */
    unsigned    mount_port;	/* mount port number */
    unsigned    nfs_port;	/* NFS port number (currently always 2049) */

} NFS_F_STATE;

/* NFS session state structure; one per session == open file */
typedef struct {
    NFS_F_STATE		*fs_ptr;	/* filesystem */
    fhandle_t 		f_handle;	/* NFS file handle */
    struct nfsfattr 	f_attrs;	/* file attributes (from NFS lookup) */
    unsigned 		f_pointer;      /* current file pointer */
} NFS_S_STATE;

#define MNTPATHLEN 	1024
#define MAXMACHNAME	32



/* mount argument structure */
struct minfo {
    IPhost 	host;
    char	fs_pathname[MNTPATHLEN];
    char        machname[MAXMACHNAME];
    int		uid;
    int         gid;
};

struct  xlinkargs {
   char      *from;
   char      *to;
} xlinkargs;

struct create {
  char                  name[MAXFILENAME];
  u_long                mode;
  u_long                uid;
  u_long                gid;
  u_long                size;
  struct timeval        atime;
  struct timeval        mtime;
};


struct entrys {
    char        name[MAXFILENAME];
    u_int	fileid;
};

struct dirents {
    u_int          nentries;
    struct entrys  *entries;
};

struct rddir {
  char                  name[MAXFILENAME];
  u_long                offs;
  u_long                nbytes;
  struct entrys         direct[MAX_DIRENTRY];
};

struct xsymlinkargs {
   char                 *from;
   char		        *to;
   struct nfssattr      sattr;
} xsymlinkargs;
I 2

#endif
E 2
E 1
