/* 
 * lrpc.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "lrpc.h"
#include "lrpc_internal.h"


int tracelrpcp=0;
static XObj SELF=0;


static lrpc_instantiateprotl(self)
XObj self;
{
  SELF = self;
  self->state = malloc(sizeof(PSTATE));
  return(0);
}


static lrpc_init(self)
XObj self;
{
  PSTATE *pstate;
  
  TRACE0(lrpcp, 1, "LRPC init");
  pstate = (PSTATE *)self->state;
  pstate->map = map_create(100, sizeof(PassiveID));
  return(0);
}


static XObj lrpc_open(self,chlp, p)
XObj self;
XObj  chlp;
Part    *p;             /* p[0]=RPC address of server */
{
  XObj   	shlp,s,c;
  RPCaddr	server;
  LRPC_STATE 	*cstate, *sstate;
  PassiveID	key;
  PSTATE	*pstate;

  TRACE0(lrpcp, 3, "LRPC open");
  pstate = (PSTATE *)self->state;
  if (!p) {
    x_errno = BAD_ADDR;
    TRACE0(lrpcp,9,"error: 1");
    return(ERR_XOBJ);
  }
  server = get_part(p, 0, RPCaddr);
  key = server.command;
  shlp = (XObj) map_resolve(pstate->map, (char *) &key);
  if (shlp == ERR_XOBJ) {
    /* no open enable done */
    TRACE0(lrpcp,3,"lrpc_open: no openenable done ");
    return(0);
  }
  c = x_createsession(chlp,SELF,1);
  s = x_createsession(shlp,SELF,1);
  cstate = (LRPC_STATE *) malloc(sizeof(LRPC_STATE));
  cstate->type = CLIENT;
  cstate->other = s;
  c->state = (char *) cstate;
  c->binding = 0;
  c->rcnt = 1;
  sstate = (LRPC_STATE *) malloc(sizeof(LRPC_STATE));
  sstate->type = SERVER;
  sstate->other = c;
  s->state = (char *) sstate;
  s->binding = 0;
  s->rcnt = 1;
  x_callopendone(shlp,s, p); 
  return(c);
}


static lrpc_openenable(self,shlp, p)
XObj   self;
XObj   shlp;
Part    *p;
{
  RPCaddr	server;
  PassiveID	key;
  PSTATE	*pstate;

  TRACE0(lrpcp, 3, "LRPC open enable");
  pstate = (PSTATE *)self->state;
  server = get_part(p, 0, RPCaddr);
  key = server.command;
  if ((map_bind(pstate->map, (char *) &key, shlp) == ERR_BIND)) {
      x_errno = ALREADY_OPEN;
      TRACE0(lrpcp,9,"error: 1");
      return(-1);
  }
  return(0);
}


static lrpc_close(s)
XObj   s;
{
  LRPC_STATE *state;

  TRACE1(lrpcp, 1, "lrpc_close of session %x", s);
  if (!s) return(0); 
  s->rcnt = s->rcnt - 1;
  if (s->rcnt > 0) 
    return(0);
  if (s->state) 
    state = (LRPC_STATE *) s->state;
  x_destroysession(s);
  return(0);
}


static lrpc_push(s, msg, rmsg_ptr)
XObj   s;
Msg     msg;
Msg     *rmsg_ptr;
{
  LRPC_STATE *mystate, *otherstate;
  XObj other;

  TRACE0(lrpcp, 5, "lrpc_push");
  mystate = (LRPC_STATE *) s->state;
  if (mystate->type == CLIENT) {   /* It's a client session */
    x_demux(mystate->other,msg);
    *rmsg_ptr = mystate->reply;
    return(0);
  }
  /* It's a server session */
  other = mystate->other;
  otherstate = (LRPC_STATE *) other->state;    
  otherstate->reply = msg;
  return(0);
}


static lrpc_controlprotl(self,opcode, buf, len)
XObj	self;
int     opcode;
char    *buf;
int     len;
{
  switch (opcode) {
    default:
        x_errno = INVALID_OPCODE;
        return(-1);
   } 
}
  
static lrpc_controlsessn(s, opcode, buf, len)
XObj   s;
int     opcode;
char    *buf;
int     len;
{

  switch (opcode) {
    default:
        x_errno = INVALID_OPCODE;
        return(-1);
  }
}

lrpc_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = lrpc_instantiateprotl;
    p->init = lrpc_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = lrpc_controlprotl;
  } else {
    p->push = lrpc_push;
    p->pop = noop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = lrpc_controlsessn;
    p->close = lrpc_close;
  }
  p->open = (Pfi) lrpc_open;
  p->openenable = lrpc_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = noop;
  p->getproc = lrpc_getproc;
}

