/* 
 * chan.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef chan_h
#define chan_h

#include "blast.h"

/* Protocol number which IP uses to identify CHAN */
#define CHAN_IP_PROTOCOLNUM 42

#define CHANADLEN  sizeof(CHANaddr)

typedef struct chanaddr {
	IPhost 	host;
	int	prot;
} CHANaddr;

#define MAX_SERVER_WAIT 10000000 

#define SERVER_WAIT 4000
#define CLIENT_WAIT 1000


#define CHAN_CLNT_DELAY(m) (CLIENT_WAIT + 2*BLAST_MAX_TRIES(m)*BLAST_REC_DELAY(m))
#define CHAN_SVC_DELAY(m) (SERVER_WAIT + 2*BLAST_MAX_TRIES(m)*BLAST_REC_DELAY(m))
#define CLIENT_TRIES 5

extern int tracechanp;

#endif
