h08580
s 00023/00000/00456
d D 1.3 91/02/04 15:44:29 menze 3 2
c added GETPEERADDR and GETPROTO control ops
e
s 00119/00057/00337
d D 1.2 91/01/17 16:32:02 menze 2 1
c modified to use v3.1 conventions
e
s 00394/00000/00000
d D 1.1 91/01/10 11:48:33 llp 1 0
c date and time created 91/01/10 11:48:33 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * sim_ether.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
I 2
#include "ethernet.h"
E 2
#include "sim_ether.h"
#include "sim_ether_i.h"

/* global data of ethernet protocol */

static	ETHhost	myetheraddr;
D 2
static	Map	map;
E 2
I 2
static	Map	activeMap;
static	Map	passiveMap;
E 2
static  XObj    ETH;
/* interfaces to/from machine */

int	readether2demux();
extern	char	*init_ether();

static char NETNUM[16];
I 2

E 2
ETHhost BCAST;

static int ether_port;
static	int	_e;

D 2
#define EXT_SZ 8
E 2
I 2
int traceethp;
E 2

I 2

E 2
/*********************************************
*
* Ethernet Device
*
*********************************************/

char *init_ether(ih)
     Pfi	ih;
{
  struct  sockaddr_in	addr;
  struct  hostent *h;
  struct  in_addr *in;
  int	on = 1;
  char *n, *inet_ntoa(), *strcpy();
  char	name[100];
  int	namelen=100;
  static char	myetheraddr[7];
I 2
  char **rp;
E 2

I 2
  TRACE0(ethp, 3, "init_ether");

E 2
#ifdef XSIMUL
D 2
  char **rp;
E 2
  for (rp = rom; *rp; rp += 3) {
    if (!strcmp(*rp, "eth")) {
      ether_port = atoi(rp[1]);
      break;
    }
  }
#endif
I 2
  TRACE1(ethp, 3, "init_ether: listening on port %d", ether_port);
E 2
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = htons((unsigned short)ether_port);
  if ((_e = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
D 2
    printf("init_ether: cannot open socket\n");
E 2
I 2
    TRACE0(ethp, 1, "init_ether: cannot open socket");
E 2
    exit(1);
  }	
  setsockopt(_e, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof (on));
#ifdef SO_BROADCAST
  setsockopt(_e, SOL_SOCKET, SO_BROADCAST, (char *)&on, sizeof (on));
#endif
  if (bind(_e, (struct sockaddr *)&addr, sizeof(addr))) {
D 2
    printf("init_ether: cannot bind socket\n");
E 2
I 2
    TRACE0(ethp, 1, "init_ether: cannot bind socket");
E 2
    exit(1);
  }
  installSignalHandler(_e, ih);
  if (fcntl(_e,F_SETFL,(FASYNC | FNDELAY)) == -1)
    perror("fcntl async");
  if (fcntl(_e,F_SETOWN,getpid()) == -1)
    perror("fcntl setown");
  gethostname(name,namelen);
  h = gethostbyname(name);
  in = (struct in_addr *) h->h_addr;
  strcpy(NETNUM, inet_ntoa(*in));
  for (n = NETNUM + strlen(NETNUM) - 1; *n != '.'; n--) {
    *n = '\0';
  }
#ifdef vax
  sprintf(myetheraddr,"%2d%4d", ((*(unsigned *)in >>24) & 0xff), ether_port);
#else
  sprintf(myetheraddr,"%2d%4d", (*(unsigned *)in & 0xff), ether_port);
#endif vax
  if (*myetheraddr == ' ')
    *myetheraddr = '0';
D 2
#ifdef	XDEBUG
  printf("X: ethernet started with address :%s:\n",myetheraddr);
#endif	XDEBUG
#ifdef XSIMUL
E 2
I 2
  TRACE1(ethp, 2, "init_ether: ethernet started with address :%s:",
	 myetheraddr);
E 2
  bcopy(myetheraddr, (char *)&BCAST, EADLEN);
  bcopy("00", (char *)&BCAST, 2);
D 2
#endif
E 2
  return myetheraddr;
}

write_ether(msg,len)
     char	*msg;
     int	len;
{
  extern unsigned long inet_addr();
  struct  sockaddr_in	addr;
D 2
  char	dest[7];
  char	dest_host[20];
  int	dest_port;
E 2
I 2
  char	dest[7];	/* simulated destination ETH address */
  char	dest_host[20];	/* real destination IP address */
  int	dest_port;	/* UDP port simulating ETH on dest host */
E 2
  int	hostid;
  
I 2
  TRACE0(ethp, 5, "write_ether");

E 2
  bcopy(msg,dest,6);
  *(dest+7) = '\0';
I 2
  TRACE1(ethp, 5, "write_ether: destination: %s", dest);
  /*
   * destination IP host and the appropriate UDP port are extracted from
   * the simulated ETH address ("dest")
   */
  sscanf(dest+2,"%4d",&dest_port);
E 2
  sscanf(dest,"%2d",&hostid);
  sprintf(dest_host,"%s%d",NETNUM,hostid);
  bzero((char *)&addr, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = inet_addr(dest_host);
D 2
  sscanf(dest+2,"%4d",&dest_port);
E 2
  addr.sin_port = htons((unsigned short)dest_port);
D 2
#ifdef	XDEBUG
  printf("X: sending %d bytes to <%d,%s>\n",len,dest_port,dest_host);
#endif	XDEBUG
E 2
I 2
  TRACE3(ethp, 5, "write_ether: sending %d bytes to <%d,%s>",
	 len, dest_port, dest_host);
E 2
  if (sendto(_e, msg, len, 0, (struct sockaddr *)&addr,
	     sizeof(struct sockaddr)) != len) {
D 2
    printf("write_ether: error in sendto\n");
E 2
I 2
    TRACE0(ethp, 3, "write_ether: error in sendto");
E 2
    perror("sendto");
    exit(1);
  }
I 3
  TRACE0(ethp, 5, "End of write_ether");
E 3
}

I 2

E 2
read_ether(msg,len)
     char	*msg;
     int	len;
{
  struct  sockaddr_in	from;
  int	size,n;
  
I 2
  TRACE0(ethp, 5, "read_ether");

E 2
  size = sizeof(from);
  if ((n = recvfrom(_e, msg, len, 0, (struct sockaddr *)&from, &size)) < 0)
    return -1;
D 2
#ifdef	XDEBUG
  printf("X: receiving %d bytes from <%d,%s>\n",n,
	 ntohs(from.sin_port),inet_ntoa(from.sin_addr.s_addr));
#endif	XDEBUG
E 2
I 2
  TRACE3(ethp, 5, "read_ether: receiving %d bytes from <%d,%s>",
	 n, ntohs(from.sin_port),inet_ntoa(from.sin_addr.s_addr));
E 2
  return n;
}

I 2

E 2
eth_init(self)
     XObj self;
{
I 2
  TRACE0(ethp, 3, "eth_init");

E 2
  ETH = self;
  bcopy(init_ether(readether2demux),(char *)&myetheraddr,EADLEN);
D 2
  map = map_create(100, 8);
E 2
I 2
  activeMap = map_create(100, sizeof(ActiveID));
  passiveMap = map_create(50, sizeof(PassiveID));
E 2
}

I 2

E 2
Sessn eth_open(self, hlp, p)
     XObj	self, hlp;
     Part	*p;
{
  Sessn   s;
  struct  eheader *e_hdr;
D 2
  char	  ex_id[EXT_SZ];
E 2
I 2
  ETHaddr localAddr, remoteAddr;
  ActiveID activeKey;
E 2
  
I 2
  TRACE0(ethp, 3, "eth_open");

E 2
  assert(self == ETH);
  if (!p) {
    x_errno = BAD_ADDR;
    return ERR_SESSN;
  }
D 2
  bcopy(p[0].address, ex_id, sizeof(short));  /* ex_id = type+dest */
  bcopy(p[1].address, ex_id+sizeof(short), EADLEN);
  if ((s=(Sessn)map_resolve(map, ex_id)) != ERR_SESSN) {
E 2
I 2
  localAddr = get_part(p, 0, ETHaddr);
  remoteAddr = get_part(p, 1, ETHaddr);
  TRACE4(ethp, 4, "eth_open: destination address = %4x.%4x.%4x:%4x",
	 remoteAddr.host.high, remoteAddr.host.mid, remoteAddr.host.low,
	 remoteAddr.type);
  activeKey = remoteAddr;
  if ((s=(Sessn)map_resolve(activeMap, (char *)&activeKey)) != ERR_SESSN) {
E 2
    s->rcnt++;
    return s;
  }
  s = x_createsession(hlp, ETH, 0);
D 2
  s->binding = map_bind(map, ex_id, (int)s);
E 2
I 2
  s->binding = map_bind(activeMap, (char *)&activeKey, (int)s);
E 2
  e_hdr = (struct eheader *) malloc(sizeof(struct eheader));
  e_hdr->e_src = myetheraddr;
D 2
  e_hdr->e_dest = *(ETHhost *)p[1].address;
  e_hdr->e_ptype = htons(*(unsigned short *)p[0].address);
E 2
I 2
  e_hdr->e_dest = remoteAddr.host;
  e_hdr->e_ptype = htons(remoteAddr.type);
E 2
  s->rcnt = 1;
  s->state = (char *) e_hdr;
I 2
  TRACE1(ethp, 3, "eth_open: returning %x\n", s);
E 2
  return s;
}

I 2

E 2
eth_openenable(self, hlp, p)
     XObj	self, hlp;
     Part	*p;
{
D 2
  char	ex_id[EXT_SZ];	 /* ex_id = type+myaddr */
E 2
I 2
  PassiveID  passiveKey;
  ETHaddr    localaddr;
E 2
  
I 2
  TRACE0(ethp, 3, "eth_openenable");

E 2
  assert(self == ETH);
D 2
  bcopy(p[0].address, ex_id, sizeof(short));
  bcopy("******", ex_id+sizeof(short), EADLEN);  
  if (map_bind(map, ex_id, (int)hlp) == ERR_BIND && x_errno==INCONSISTENT_BIND) {
    x_errno = ALREADY_OPEN;
    return -1;
E 2
I 2
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  localaddr = get_part(p, 0, ETHaddr);
  TRACE2(ethp, 4, "eth_openenable: hlp=%d, protlNum=%x", hlp, localaddr.type);
  passiveKey = localaddr.type;
  if (map_bind(passiveMap, (char *) &passiveKey, (int) hlp) == ERR_BIND &&
      x_errno==INCONSISTENT_BIND) {
      x_errno = ALREADY_OPEN;
      return -1;
E 2
  }
  return 0;
}

I 2

E 2
eth_close(s)
     Sessn	s;
{
  if (--s->rcnt > 0)
    return 0;
D 2
  map_unbindbinding(map, s->binding);
E 2
I 2
  map_unbindbinding(activeMap, s->binding);
E 2
  x_destroysession(s);
  return 0;
}

I 2

E 2
/*ARGSUSED*/
eth_push(s, msg, rmsg)
     Sessn	s;
     Msg	msg, *rmsg;
{
  struct eheader *hdr;
  
D 2
#ifdef	EDEBUG
  printf("in ether push\n");
#endif	EDEBUG
E 2
I 2
  TRACE0(ethp, 5, "eth_push\n");
E 2
  
D 2
  hdr = (struct eheader *)msg_push(msg, sizeof(ETHhost));
E 2
I 2
  hdr = (struct eheader *)msg_push(msg, sizeof(struct eheader));
E 2
  *hdr = *(struct eheader *)s->state;
  push2writeether(msg);
  return 0;
}

I 2

E 2
eth_demux(self, s, msg)
     XObj self;
     Sessn	s;
     Msg	msg;
{
  struct  eheader  *hdr;
D 2
  Part  Part[2];
  char	ex_id[EXT_SZ];
E 2
I 2
  Part  Part[3];
E 2
  XObj	hlp;
  Sessn	eth_s;
I 2
  ETHaddr remoteAddr, localAddr;
  ActiveID activeKey;
  PassiveID passiveKey;
E 2
  
I 2
  TRACE0(ethp, 4, "in ether demux");

E 2
  assert(self == 0);
D 2
#ifdef	EDEBUG
  printf("in ether demux\n");
#endif	EDEBUG
E 2
  
D 2
  hdr = (struct eheader *)msg_top(msg, EHLEN);
E 2
I 2
  if ((hdr = (struct eheader *)msg_top(msg, EHLEN)) == (struct eheader *)-1) {
      TRACE0(ethp, 3, "eth_demux: incoming message too small!");
      return -1;
  }
E 2
  hdr->e_ptype = ntohs((unsigned short)hdr->e_ptype);
D 2
  *(short *)ex_id = hdr->e_ptype;
  *(ETHhost *)(ex_id+sizeof(short)) = hdr->e_src;
  if ((eth_s=(Sessn)map_resolve(map, ex_id)) != ERR_SESSN)
    return x_pop(eth_s, s, msg);
  *(ETHhost *)(ex_id+sizeof(short)) = *(ETHhost *)"******";
  if ((hlp=(XObj)map_resolve(map, ex_id)) != ERR_XOBJ) {
    Part[0].address = (char *) &hdr->e_ptype;
    Part[0].length = sizeof(short);
    Part[1].address = (char *) &hdr->e_src;
    Part[1].length = EADLEN;
E 2
I 2
  activeKey.type = hdr->e_ptype;
  activeKey.host = hdr->e_src;
  TRACE4(ethp, 6, "eth_demux: <host, id> = <%4x.%4x.%4x, 0x%x>",
	 activeKey.host.high, activeKey.host.mid, activeKey.host.low,
	 activeKey.type);
  if ((eth_s=(Sessn)map_resolve(activeMap, (char *)&activeKey)) != ERR_SESSN) {
      TRACE0(ethp, 5, "eth_demux: found active session");
      return x_pop(eth_s, s, msg);
  }
  passiveKey = hdr->e_ptype;
  if ((hlp=(XObj)map_resolve(passiveMap, (char *)&passiveKey)) != ERR_XOBJ) {
    TRACE0(ethp, 5, "eth_demux: found openenable");
    remoteAddr.host = hdr->e_src;
    remoteAddr.type = localAddr.type = hdr->e_ptype;
    localAddr.host = myetheraddr;
    init_partlist(Part, 2, ETHaddr);
    set_part(Part, 0, localAddr);
    set_part(Part, 1, remoteAddr);
E 2
    eth_s = x_opendone(hlp, ETH, Part);
    return x_pop(eth_s, s, msg);
  }
I 2
  TRACE0(ethp, 5,
	 "eth_demux: No active session or openenable.  Dropping msg");
E 2
  return 0;
}

I 2

E 2
/*ARGSUSED*/
eth_pop(s, delivery_s, msg)
     Sessn	s, delivery_s;
     Msg	msg;
{
I 2
  TRACE0(ethp, 5, "eth_pop");

E 2
  msg_pop(msg, sizeof(struct eheader));
  return x_demux(s, msg);
}

I 2

E 2
/*ARGSUSED*/
eth_controlsessn(s, opcode, buf, len)
     Sessn	s;
     int	opcode;
     char	*buf;
     int	len;
{
I 3
  struct eheader *sstate;

E 3
I 2
  TRACE1(ethp, 5, "eth_controlsessn (opcode = %d)", opcode);

I 3
  sstate = (struct eheader *)s->state;
E 3
E 2
  switch (opcode) {
  case GETMYADDR:
    if (len<EADLEN) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    else {
      bcopy((char *)&myetheraddr, buf, EADLEN);
      return EADLEN;
    }
I 3
  case GETPEERADDR:
    if (len<EADLEN) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    else {
      bcopy((char *)&sstate->e_dest, buf, EADLEN);
      return EADLEN;
    }
  case GETPROTO:
    if (len < sizeof(u_short)) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    else {
      *(u_short *) buf = sstate->e_ptype;
      return sizeof(u_short);
    }
E 3
  case GETMAXPACKET:
    if(len<sizeof(int)) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    } else {
      *(int *)buf = EDLEN;
      return sizeof(int);
    }
  default:
I 3
    TRACE0(ethp, 1, "eth_controlsessn: invalid opcode");
E 3
    x_errno = INVALID_OPCODE;
    return -1;
  }
}

I 2

E 2
eth_controlprotl(self, opcode, buf, len)
     XObj	self;
     int	opcode;
     char	*buf;
     int	len;
{
I 2
  TRACE1(ethp, 5, "eth_controlprotl (opcode = %d)", opcode);

E 2
  assert(self == ETH);
  switch (opcode) {
  case GETMYADDR:
    if (len<EADLEN) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    }
    else {
      bcopy((char *)&myetheraddr, buf, EADLEN);
      return EADLEN;
    }
  case GETMAXPACKET:
    if(len<sizeof(int)) {
      x_errno = BUFFER_TOO_SMALL;
      return -1;
    } else {
      *(int *)buf = EDLEN;
      return sizeof(int);
    }
  default:
    x_errno = INVALID_OPCODE;
    return -1;
  }
}

I 2

E 2
/***************************************
/*  Special function needed because we
/*  sit right on top of the device;
/*  in effect, the device driver
/***************************************/
  
readether2demux()
{
  Msg	msg;
  int	buflen;
  static char buf[EMAXPAK+sizeof(struct eheader)];
  
I 2
  TRACE0(ethp, 7, "readether2demux");

E 2
  while ((buflen = read_ether(buf, EMAXPAK)) != -1) {
    msg_make_allstack(msg, 16, buf, buflen);
    CreateProcess(eth_demux, 0, 5, 2 + (sizeof(Msg)+3) / 4, NULL, NULL, msg);
  }
  return 0;
}

I 2

E 2
push2writeether(packet)
     Msg	packet;
{
  int	len;
  char	buffer[EMAXPAK];
  
I 2
  TRACE0(ethp, 7, "push2writeether");

E 2
  len = msg_len(packet);
  msg_externalize(packet, buffer);
  write_ether(buffer, len);
  return 0;
}

eth_getproc(p,type)
     XObj p;
     XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = eth_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = eth_controlprotl;
  } else {
    p->push = eth_push;
    p->pop = eth_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = eth_controlsessn;
    p->close = eth_close;
  }
  p->open = (Pfi) eth_open;
  p->openenable = eth_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = eth_demux;
  p->getproc = eth_getproc;
}

E 1
