h64803
s 00003/00003/00169
d D 1.2 91/01/10 11:44:59 llp 2 1
c Prepared for 3.1 Distribution
e
s 00172/00000/00000
d D 1.1 90/11/16 10:53:10 menze 1 0
c date and time created 90/11/16 10:53:10 by menze
e
u
U
f e 0
t
T
I 1
/*
 * ip_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

#ifndef upi_h
#include "upi.h"
#endif

/* define type for old style protocols */
typedef unsigned int OLD_PROTL;
#define ERR_OLD_PROTL ((OLD_PROTL) -1)

#define	IPMAX	512
#define	IPHLEN	sizeof(IPheader)
#define	IPDLEN	(IPMAX-IPHLEN)
#define	IPVERS	4
#define IPMAXOPTLEN ((0xF*4)-IPHLEN)

typedef struct	ipheader {
#ifndef vax
	u_char	ip_v:4,		        /* version */
		ip_hl:4;	        /* header length */
#else vax
	u_char	ip_hl:4,
		ip_v:4;
#endif
	u_char	ip_tos;			/* type of service */
	u_short	ip_len;			/* total length */
	u_short	ip_id;			/* identification */
	u_short	ip_off;			/* fragment offset field */
	u_char	ip_ttl;			/* time to live */
	u_char	ip_protocol;		/* protocol */
	u_short	ip_sum;			/* checksum */
	IPhost	ip_src;			/* source address */
	IPhost	ip_dest;		/* destination address */
} IPheader;

#define NEXT(anything) ((anything) = (anything)->next)

/* ip_clear_resources --
 * called when a complete packet arrived which we were reassembling;
 * (this is a rare circumstance; general resource recovery is elsewhere)
 * let's just let it time out; if more fragments arrive a resource
 * would just be reallocated anyhow.
 */
#define IP_CLEAR_RESOURCES(foo,bar) /**/

/* here is the max # of reassemblies a given session may be up to at once */
#define REASSEMBLY_WINDOW 25
#define INTSIZE 4

/* machine-dependant: (check against intsize and endian situation) */
#define SET(bt,i) ((bt)[((unsigned)i)>>5] |= (1 << ((i) & 0x01F)))
#define SETN(bt,i,n) { int j; for(j=0;j<n;j++) SET(bt,i+j); }/* optimize me! */

typedef struct msglist {
D 2
  MSG m;
E 2
I 2
  Msg m;
E 2
  u_short off;
  u_short len;
  struct msglist *next;
} MSGlist;

/* this counts on correct casts of (RR *) into (IPtimer *) and back */
typedef struct ip_timer {
  struct ip_timer *prev, *next;
  int deadline;
} IPtimer;

extern IPtimer *(ip_timeouts[]);

typedef struct ReassemblyResource {
  IPtimer  t;
  MSGlist *data;
  u_short  length;   /* data length only... */
  u_short  nHoles;
  Bind     binding;
  Map      rrmap;
  struct ReassemblyResource *next;
} RR;
#define ERR_RR ((RR *)-1)

/*
 * ip_hdrmsg contains the standard ip header.
 * ip_tailmsg contains that part of ip_hdrmsg which is
 * appended noninitial fragments of a datagram.
 */
typedef struct	ipstate  {
  IPheader hdr;
  IPheader tailhdr;
D 2
  MSG   options;
E 2
I 2
  Msg   options;
E 2
  Sessn	down_s;
  Map   buffers;
  u_short ip_id;
} IPstate;

typedef struct {
  u_char	protocolnum;
  u_char	pad[3];
  IPhost	host;
} ActiveId;

typedef u_char PassiveId;

/* The key for reassembly is the combination of the IP host address and the
 * id found in the header.
 */
typedef struct {
  IPhost		host;
  unsigned short	id;
} ReassemblyKey;

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define DONTFRAGMENT   (0x4000)
#define MOREFRAGMENTS  (0x2000)
#define OFFSET         (0x1FFF)
#define COMPLETEPACKET(hdr) (!((hdr).ip_off & (0x3FFF)))
#define DISCARDED_DF (-1)


typedef struct RoutingTableEntry {
  OLD_PROTL  interface;
  IPhost GWaddr;
  Bind   binding;
} RTE, *RTEPtr;

#define IP_OPTION_HANDLER(dg,hdr_ptr) \
  ((hdr_ptr)->ip_hl>5 ? ip_option_handler(dg,(hdr_ptr)) : 0)


/* IP debugging option numbers */
#define IP_TIMESTAMP 4

#ifndef vax
struct ov_flag {
  u_char oflw:4;
  u_char flag:4;
};
  
typedef struct option {
  u_char ipopt_copy:1;
  u_char ipopt_class:2;
  u_char ipopt_number:5;
} IPOption;
#define htonb(uc) ((u_char)uc)
#define ntohb(uc) ((u_char)uc)

#else vax

struct ov_flag {
  u_char flag:4;
  u_char oflw:4;
};
  
typedef struct option {
  u_char ipopt_number:5;
  u_char ipopt_class:2;
  u_char ipopt_copy:1;
} IPOption;

#define htonb(uc) (htons(uc)>>8)
#define ntohb(uc) htonb(uc)
#endif


E 1
