h28436
s 00049/00008/01159
d D 1.3 91/02/11 18:08:59 menze 3 2
c blast now asks the llp for the appropriate fragmentation size
e
s 00026/00026/01141
d D 1.2 91/01/10 11:44:29 llp 2 1
c Prepared for 3.1 Distribution
e
s 01167/00000/00000
d D 1.1 90/11/16 10:52:52 menze 1 0
c date and time created 90/11/16 10:52:52 by menze
e
u
U
f e 0
t
T
I 1
/*
 * blast.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

#include "xkernel.h"
#include "ip.h"
#include "eth.h"
#include "udp.h"
#include "arp.h"
#include "blast.h"
#include "blast_internal.h"

#define sameipaddr(A,B)  (((A)->a==(B)->a) && ((A)->b == (B)->b) && ((A)->c == (B)->c) && ((A)->d == (B)->d))
#define IPNULL { 0, 0, 0, 0 }
#define DONE(mask, num_frags) (mask == full_mask[num_frags])

/* If TEST_TIMEOUTS is defined, BLAST will occasionally drop a fragment before
 * it gets to the appropriate BLAST session.
 */
/* #define TEST_TIMEOUTS */

/* One of {USE_IP_ADDRS, USE_ETH_ADDRS} should be defined, depending on
 * whether the protocol below BLAST uses IP addresses or Ethernet addresses.
 */
/* #define USE_IP_ADDRS */
#define USE_ETH_ADDRS

Map map_create();
static send_timeout();
static receive_timeout();
static unsigned short insert_frag();
D 2
static MSG reassemble();
E 2
I 2
static Msg reassemble();
E 2
static unsigned short I_TO_MASK();
static retransmit();
static free_rec_seq();
static free_send_seq();
static phdr();
static mask_to_i();
static send_nack();
static flush();


/* global data for BLAST; need data structure for assigned/free port nums */

static XObj IP;
static XObj ETH;
static XObj ARP;
int traceblastp=0;
static unsigned int full_mask[MAX_FRAGS + 1];


static blast_instantiateprotl(self)
XObj self;
{
  self->state = malloc(sizeof(PSTATE));
  return(0);
}


static blast_init(self)
XObj self;
{
  Part part[2];
  PSTATE *pstate = (PSTATE *) self->state;
  char **parr;
  int i;

  TRACE0(blastp, 1, "BLAST init");

  pstate->max_seq = 0;
  pstate->active_map = map_create(100, sizeof(ActiveID));
  pstate->passive_map = map_create(100, sizeof(PassiveID));
  InitSemaphore(&pstate->outstanding_messages, OUTSTANDING_MESSAGES);
  InitSemaphore(&pstate->access, 1);
  pstate->max_outstanding_messages = OUTSTANDING_MESSAGES;
  
I 3
  /* Determine the maximum size of datagrams which this instantiation
   * supports.  This is defined in the macro MAX_DGM as the product of
   * the number of fragments and the lower-level session fragment size
   * (minus the blast header)
   */
  if (x_controlprotl(self->down[0], GETOPTPACKET, &pstate->fragmentSize,
		     sizeof(pstate->fragmentSize)) < 0) {
      TRACE0(blastp, 3, "Blast could not get opt packet size from llp");
      if (x_controlprotl(self->down[0], GETMAXPACKET, &pstate->fragmentSize,
			 sizeof(pstate->fragmentSize)) < 0) {
	  TRACE0(blastp, 3, "Blast could not get max packet size from llp");
	  pstate->fragmentSize = 0;
      }
  }
  pstate->fragmentSize -= BLASTHLEN;
  TRACE2(blastp, 3, "Blast fragmenting into packets of size %d, max dgm: %d",
	 pstate->fragmentSize, MAX_DGM);
E 3

  /* Allocate (and then free) as much memory as this protocol instantiation
   * will ever use.  Allocating it now in big chunks results in less total
   * memory used than if it is allocated in gradually increasing sizes.
   */
  parr = (char **)malloc(OUTSTANDING_MESSAGES * sizeof(char *));
  TRACE2(blastp, 1,
	 "blast_init: initially allocating and freeing %d blocks\nof %d bytes",
	 OUTSTANDING_MESSAGES, MAX_DGM);
  for (i=0; i < OUTSTANDING_MESSAGES; i++) 
      parr[i] = malloc(MAX_DGM);
  for (i=0; i < OUTSTANDING_MESSAGES; i++) 
      free(parr[i]);
  free((char *)parr);

  for (i=1; i <= MAX_FRAGS; i++)
      full_mask[i] = (1 << i) - 1;
  
  ARP = x_getprotlbyname("arp");
  IP = x_getprotlbyname("ip");
  ETH = x_getprotlbyname("eth");

D 2
  x_controlprotl(IP, MYADDR, (char *)&pstate->myIPaddr.host, sizeof(IPhost));
E 2
I 2
  x_controlprotl(IP, GETMYADDR,(char *)&pstate->myIPaddr.host, sizeof(IPhost));
E 2
  pstate->myIPaddr.protocolnum = BLAST_IP_PROT;
  
D 2
  x_controlprotl(IP, MYADDR, (char *)&pstate->myETHaddr.host, sizeof(ETHhost));
E 2
I 2
  x_controlprotl(IP,GETMYADDR,(char *)&pstate->myETHaddr.host,sizeof(ETHhost));
E 2
  pstate->myETHaddr.type = BLAST_ETH_TYPE;

#ifdef USE_ETH_ADDRS
  init_partlist(part, 1, ETHaddr);
  set_part(part, 0, pstate->myETHaddr);
#endif
#ifdef USE_IP_ADDRS
  init_partlist(part, 1, IPaddr);
  set_part(part, 0, pstate->myIPaddr);
#endif
  return(x_openenable(self,self->down[0], part));
}


static XObj blast_open(self,hlp, p)
XObj   self;
XObj   hlp;
Part    *p;             /* p[0]= BLAST address of client (sender)
			 * p[1]= BLAST address of server (receiver)
			 */
{
  XObj		s;
  BLAST_STATE 	*state;
  Part 		part[3];
  ActiveID 	active_id;
  BLAST_HDR 	*hdr;
  ETHaddr 	remoteETHaddr;
  IPaddr	remoteIPaddr;
  BLASTaddr 	local_addr, remote_addr;
  PSTATE 	*pstate;
  union {
      IPhost	ip;
      ETHhost	eth;
  } iporeth;

  TRACE0(blastp, 3, "BLAST open");
  
  pstate = (PSTATE *) self->state;
  s = (XObj) NULL;

  if (!p) {
    x_errno = BAD_ADDR;
    TRACE0(blastp,9,"blast_open: no participant list!");
    return(ERR_XOBJ);
  }

  /* get participants */
  local_addr = get_part(p, 0, BLASTaddr);
  remote_addr = get_part(p, 1, BLASTaddr);
  active_id.rec = remote_addr.host;
  active_id.send  = local_addr.host;
  active_id.prot_id = local_addr.prot;

  TRACE1(blastp,4,"blast_open: send = %s",inet_ntoa(active_id.send));
  TRACE1(blastp,4,"blast_open: rec = %s",inet_ntoa(active_id.rec));
  TRACE1(blastp,4,"blast_open: prot_id = %d",active_id.prot_id);

  /* is there an existing session */
  s=(XObj)map_resolve(pstate->active_map, (char *) &active_id);
  if (s != (XObj)-1) {
    TRACE0(blastp,4,"blast_open: session exists");
    s->rcnt++;
    return s;
  }

  /* need new session */
  state = (BLAST_STATE *) malloc(sizeof(BLAST_STATE));
  bzero(state,sizeof(BLAST_STATE));

  /* fill in  state */
  if (sameipaddr(&active_id.send,&pstate->myIPaddr.host)) {
    state->client = 1;
  } else {
    state->client = 0;
  }
  state->send =  active_id.send;
  state->rec =  active_id.rec;
  state->prot_id =  active_id.prot_id;
  state->myBLASTaddr.host = (state->client) ? state->send : state->rec;
  state->peerBLASTaddr.host = (state->client) ? state->rec : state->send;
  state->myBLASTaddr.prot = state->peerBLASTaddr.prot = state->prot_id;
  state->send_map = map_create(100, 4);
  state->rec_map = map_create(100, 4);
I 3
  InitSemaphore(&state->recMapAccess, 1);
E 3

  /* fill in header for messages that don't require fragmentation */
  
  hdr = &state->short_hdr;
  hdr->op = BLAST_SEND;
  hdr->rec = state->rec;
  hdr->send = state->send;
  hdr->prot_id = state->prot_id;
  hdr->seq = 0; /* protocol guarantees that 0 can never be a real seq*/
  hdr->mask = 0;
  hdr->num_frag = 0;

  /* create session and bind to address */
  s = x_createsession(hlp, self, 1);
  s->rcnt = 1;
  s->state = (char *) state;
  state->self = s;

  if (state->client) {
    /* Open lower-level session */

#ifdef USE_ETH_ADDRS
D 3
    iporeth.ip = remote_addr.host;
    if (x_controlprotl(ARP, RESOLVE, (char *)&iporeth.ip, sizeof(iporeth))
E 3
I 3
   iporeth.ip = remote_addr.host;
   if (x_controlprotl(ARP, RESOLVE, (char *)&iporeth.ip, sizeof(iporeth))
E 3
	< 0) {
	TRACE0(blastp, 1,
	       "Blast_open: ARP failed.  Could not open lower session");
	x_destroysession(s);
    }
    remoteETHaddr.host = iporeth.eth;
    remoteETHaddr.type = pstate->myETHaddr.type;
    init_partlist(part, 2, ETHaddr);
    set_part(part, 0, pstate->myETHaddr);
    set_part(part, 1, remoteETHaddr);
#endif
#ifdef USE_IP_ADDRS
    remoteIPaddr.host = remote_addr.host;
    remoteIPaddr.protocolnum = pstate->myIPaddr.protocolnum;
    init_partlist(part, 2, IPaddr);
    set_part(part, 0, pstate->myIPaddr);
    set_part(part, 1, remoteIPaddr);
#endif
    
    if ((state->down_s = x_open(self,self->down[0], part)) == ERR_XOBJ) {
      TRACE1(blastp, 4, "blast_open: cannot open lower session (x_errno=%d)",
	     x_errno);
      x_destroysession(s);
      return ERR_XOBJ;
    }
    s->down[s->numdown++] = state->down_s;
  }

  s->binding = (Bind)map_bind(pstate->active_map, (char *) &active_id,s);
  /* just to be paranoid */
  if (s->binding == ERR_BIND) {
    TRACE0(blastp,4,"blast_open: could not bind session");
    x_close(s);
    return((XObj)-1);
  }

  
  TRACE1(blastp, 4, "blast_open returns %x", s);
  return(s);
}


static blast_openenable(self,hlp, p)
XObj self;
XObj   hlp;
Part    *p;
{
  BLASTaddr server;
  PassiveID key;
  PSTATE *pstate = (PSTATE *) self->state;


  TRACE0(blastp, 3, "BLAST open enable");

  if (!p) {
    x_errno = BAD_ADDR;
    TRACE0(blastp,9,"blast_openenable: no participant list!");
    return(-1);
  }

  server = get_part(p, 0, BLASTaddr);
  key = server;
  TRACE1(blastp, 4, "blast_openenable: ext_id.rec = %s",inet_ntoa(key.host));
  TRACE1(blastp, 4, "blast_openenable: ext_id.prot_id = %d",key.prot);

  /* bind server to high level protocol */
  if ((map_bind(pstate->passive_map, (char *)&key, hlp) == (Bind) ERR_BIND)) {
      x_errno = ALREADY_OPEN;
      TRACE0(blastp,9,"blast_openenable: already openenabled");
      return(-1);
  }

  return(0);
}


blast_close(s)
XObj   s;
{
  BLAST_STATE *state;
  PSTATE *pstate = (PSTATE *) s->myprotl->state;

  TRACE1(blastp, 3, "blast_close of session %x", s);

  if (!s) return(0); 
  
  /* decrement refcount */  
  s->rcnt = s->rcnt - 1;

  TRACE1(blastp,9,"blast_close: ref count = %d",s->rcnt);

  if (s->rcnt > 0) {
    return(0);
  } else {
    if (s->binding) {
      map_unbindbinding(pstate->active_map,s->binding);
    }
    /* free blast state */
    if (s->state) {
      state = (BLAST_STATE *) s->state;
      if (state->send_map) {
        flush(state->send_map);
        map_close(state->send_map);
      }
      if (state->rec_map) {
        flush(state->rec_map);
        map_close(state->rec_map);
      }
      if (state->down_s)
        x_close(state->down_s);
    }

    x_destroysession(s);
  }
  return(0);
}


blast_push(s, msg,rmsg_ptr)
XObj   s;
D 2
MSG     msg;
MSG     *rmsg_ptr;
E 2
I 2
Msg     msg;
Msg     *rmsg_ptr;
E 2
{
  BLAST_STATE   *state;
  PSTATE 	*pstate;
  MSG_STATE   	*mstate;
  BLAST_HDR 	*hdr;
  BLAST_HDR 	*top;
  int 		seq;
  int 		num_frags;
  int 		i;
I 3
  int 		len;
E 3
D 2
  MSG 		packet;
E 2
I 2
  Msg 		packet;
E 2

  pstate = (PSTATE *) s->myprotl->state;

  TRACE0(blastp, 3, "in blast_push");
  IFTRACE(blastp, 4) msg_display(msg,0);
  assert(msg.stack->ref.ref >0 );

  state = (BLAST_STATE *) s->state;
  TRACE1(blastp, 4, "blast_push: state = %d",state);
  TRACE1(blastp, 4, "blast_push: outgoing msg len (no blast hdr): %d",
	 msg_len(msg));

I 3
  len = msg_len(msg);
  if (len > MAX_DGM) {
      TRACE2(blastp, 3, "blast_push: message length %d > max size %d",
	     len, MAX_DGM);
      return -1;
  }
E 3
  /* if message is short, by-pass everthing */
  if (msg_len(msg) < MAX_FRAG_LEN) {
    state->short_hdr.len = msg_len(msg);
    IFTRACE(blastp,5) {
     phdr(&state->short_hdr);
    }
    TRACE0(blastp, 5, "in blast_push2");
    TRACE1(blastp, 5, "in blast_push2 down_s = %x",state->down_s);
    top = (BLAST_HDR *)msg_push(msg,BLASTHLEN);
    *top = state->short_hdr; 
    IFTRACE(blastp,5) {
     printf("message in header\n");
     phdr(top);
    }
    TRACE0(blastp, 5, "in blast_push2 msg \n");
    IFTRACE(blastp,5) msg_display(msg,0);
    TRACE1(blastp, 5, "in blast_push2 msg len = %d",msg_len(msg));
    IFTRACE(blastp, 5) msg_display(msg,0);
D 2
    if (x_push(state->down_s, msg,(MSG *)0) ==  -1) {
E 2
I 2
    if (x_push(state->down_s, msg,(Msg *)0) ==  -1) {
E 2
      TRACE0(blastp,5,"blast_push: can't send message");
      return(-1);
    }
    return(0);
  }
     
  TRACE0(blastp, 5, "in blast_push3");

  /* get new sequence number */
  if(++pstate->max_seq <= 0) {
    /* once every eon the seqnumber with wrap*/
    printf("blast_push: WORLD ENDS!\n");
    return(-1);
  }
  seq = pstate->max_seq;
    
  /* need new message state */
  mstate = (MSG_STATE *) malloc(sizeof(MSG_STATE));
  bzero(mstate,sizeof(MSG_STATE));

  /* bind mstate to seqence number */
  mstate->binding = (Bind) map_bind(state->send_map,(char *)&seq,mstate);
  if (mstate->binding == ERR_BIND) {
    TRACE0(blastp,1,"blast_push: can't bind seqence number");
    if (mstate) free(mstate);
    return -1;
  } 
  mstate->state = (int *)state;
  mstate->seq = seq;

  /* fill in header */
  hdr = &(mstate->send_hdr);
  *hdr = state->short_hdr;
  hdr->seq = seq;
  IFTRACE(blastp,5) {
    printf("blasts_push: static header:\n");
    phdr(hdr);
  }

  num_frags = (msg_len(msg) + MAX_FRAG_LEN - 1)/MAX_FRAG_LEN;
  hdr->num_frag = num_frags;
  hdr->mask = 1;

  mstate->frags[1] = msg;
  /* send off fragments */
  TRACE1(blastp, 4, "blast: outstanding messages (P): %d",
	 pstate->outstanding_messages.count);
  P(&pstate->outstanding_messages);
  for (i=1;i<=num_frags;i++) {
   
    if (i != num_frags) {
      msg_break(mstate->frags[i], mstate->frags[i+1], MAX_FRAG_LEN,128);
    }
    IFTRACE(blastp,7) {
      printf("mstate->frags[%d] = \n",i);
      if (!msg_isnull(mstate->frags[i])) msg_display(mstate->frags[i],0);
    }
    msg_save(packet,mstate->frags[i]);;
    TRACE2(blastp,5,"fragment: len[%d] = %d",i,msg_len(packet));
    /* fill in dynamic parts of header */
    hdr->len = msg_len(packet);

    TRACE1(blastp,5,"blast_push: sending frag %d",i);
    IFTRACE(blastp,5) {
      phdr(hdr);
    }

    top = (BLAST_HDR *)msg_push(packet,BLASTHLEN);
    *top = *hdr;
    
    /* push message to lower protocol */
D 2
    if (x_push(state->down_s,packet,(MSG *)0) ==  -1) {
E 2
I 2
    if (x_push(state->down_s,packet,(Msg *)0) ==  -1) {
E 2
      TRACE0(blastp,5,"blast_push: can't send fragment");
    }
    hdr->mask <<= 1;
  }

  /* set timer to free message if no NACK is received */
  mstate->wait = num_frags*SEND_CONST;
  mstate->event = event_register(send_timeout,(int)mstate,mstate->wait,EV_ONCE | EV_CREATEPROCESS);
  
  return(seq);
}



static blast_demux(self,s, dg)
XObj	self;
XObj   s;
D 2
MSG     dg;
E 2
I 2
Msg     dg;
E 2
{

  PSTATE 	*pstate;
  BLAST_STATE 	*state;
  BLAST_HDR 	*hdr;
  Part    	part[4];
  XObj   	blast_s;
  XObj    	hlp;
  ActiveID 	active_key;
  PassiveID 	passive_key;
  BLASTaddr 	client_addr, server_addr;

  pstate = (PSTATE *) self->state;

  TRACE0(blastp, 3, "blast_demux: called");

  assert(dg.stack->ref.ref >0 );
  hdr = (BLAST_HDR *)msg_top(dg,BLASTHLEN);
  
  IFTRACE(blastp,5) {
    msg_display(dg);
    phdr(hdr);
  }

  /* check for active sessions */
  active_key.send = hdr->send;
  active_key.rec = hdr->rec;
  active_key.prot_id = hdr->prot_id;
  blast_s = (XObj) map_resolve(pstate->active_map, (char *) &active_key);
  TRACE1(blastp,4,"blast_demux: blast_s = %d",blast_s);
 
  if (blast_s != ERR_XOBJ) { 
    /* Active session exists */

    state = (BLAST_STATE *)blast_s->state;

    /* short cut short messages */
    if (hdr->seq == 0){
      msg_pop(dg,BLASTHLEN);
      TRACE0(blastp,4,"blast_demux: short cut");
      IFTRACE(blastp,9) {
        printf("hdr_len = %d \n",hdr->len);
        msg_display(dg,0);
      }
      if (msg_len(dg) > hdr->len)  msg_chopright(dg,dg,hdr->len);
      x_demux(blast_s,dg);
    } else {
#ifdef TEST_TIMEOUTS
      /* test timeout ability */
      if ((++count % 131) == 0) {
        printf("blast_demux: dropping random message\n");
        if(!msg_isnull(dg)) msg_free(dg);
        return(0);
      }
#endif
      TRACE0(blastp,4,"blast_demux: long message");
      x_pop(blast_s,s,dg);
    }
    return(0);
  } 

  /* nacks must be sent to active session */
  if (hdr->op != BLAST_SEND) {
    TRACE0(blastp,4,"blast_demux: spurous nack droped");
    if(!msg_isnull(dg)) msg_free(dg);
    return(0);
  }
 
  /* check for passive sessions */ 
  passive_key.host = active_key.rec;
  passive_key.prot = active_key.prot_id;
  hlp = (XObj) map_resolve(pstate->passive_map, (char *)&passive_key);

  if (hlp == (XObj) -1) {
    TRACE0(blastp,4,"blast_demux: no open enable dropping message");
    if(!msg_isnull(dg)) msg_free(dg);
    return(0);
  }

  /* create new session */
  client_addr.host = hdr->send;
  client_addr.prot = hdr->prot_id;
  server_addr.host = hdr->rec;
  server_addr.prot = hdr->prot_id;
  init_partlist(part, 2, BLASTaddr);
  set_part(part, 0, client_addr);
  set_part(part, 1, server_addr);
  
  blast_s = (XObj)x_opendone(hlp,self,part);
  blast_s->down[blast_s->numdown++] = s;

  if (blast_s == ERR_XOBJ) {
    TRACE0(blastp,4,"blast_demux: can't create session ");
    if(!msg_isnull(dg)) msg_free(dg);
    return(0);
  }
  state = (BLAST_STATE *) blast_s->state;
  state->down_s = s;

  /* short cut short messages */
  if (hdr->seq == 0){
    msg_pop(dg,BLASTHLEN);
    if (msg_len(dg) > hdr->len) dg = msg_truncateright(dg,hdr->len);
    x_demux(blast_s,dg);
  } else {
    x_pop(blast_s,s,dg);
  }
  return(0);
}


static blast_pop(s, lls, dg)
XObj   s;
XObj   lls;
D 2
MSG     dg;
E 2
I 2
Msg     dg;
E 2
{
  BLAST_STATE	*state;
  MSG_STATE 	*mstate;
  BLAST_HDR 	*hdr;
D 2
  MSG 		msg;
E 2
I 2
  Msg 		msg;
E 2
  int 		seq;
  

  TRACE0(blastp, 3, "BLAST_pop");

  assert(dg.stack->ref.ref >0 );
  state = (BLAST_STATE *)s->state;

  hdr = (BLAST_HDR *)msg_top(dg,BLASTHLEN);
  msg_pop(dg,BLASTHLEN);
  seq = hdr->seq;


  /* code for receiver */
  if ((hdr->op == BLAST_RETRANSMIT) || (hdr->op == BLAST_SEND)) {
    /* look for message state */
    mstate = (MSG_STATE *) map_resolve(state->rec_map,(char *)&seq);
    if (mstate == (MSG_STATE *)-1) {
      if (hdr->op == BLAST_RETRANSMIT) {
        /* message must already be finished */
        flush_msg(dg);
        return(0);
      }
      if (state->rec_cache) {
        mstate = state->rec_cache;
        state->rec_cache = 0;
        mstate->mask = 0;
        mstate->old_mask = 0;
        mstate->nack_sent = 0;
      } else {
        TRACE0(blastp,4,"blast_pop: new_state created ");
        mstate = (MSG_STATE *) malloc(sizeof(MSG_STATE));
        bzero((char *)mstate,sizeof(MSG_STATE));
      }
      mstate->state = (int *)state;
      mstate->seq = hdr->seq;
      mstate->rec_hdr = *hdr;
      mstate->wait = hdr->num_frag*REC_CONST;
      mstate->binding = (Bind) map_bind(state->rec_map,(char *)&seq,(int)mstate);
      if (mstate->binding == (Bind)-1) {
        TRACE0(blastp,1,"blast_pop: can't bind message state ");
        return(0);
      }
      mstate->event = event_register(receive_timeout,(int)mstate,mstate->wait,EV_ONCE|EV_CREATEPROCESS);
 
    }
    /* add fragment */
    mstate->mask = insert_frag(hdr,dg,mstate);
    if (DONE(mstate->mask,hdr->num_frag)) {
      msg = reassemble(mstate);
      if (msg_isnull(msg)){ 
        TRACE0(blastp,0,"blast_pop: reassembly fails ");
        return(0);
      }

      TRACE1(blastp, 4, "blast_pop: incoming msg len (no blast hdr): %d",
	     msg_len(msg));
      /* get rid of message */
      x_demux(s,msg);

      /* flush message */
      free_rec_seq(state,mstate,mstate->seq);

      return(0);
    }
  
    /* if this is the last fragment send a nack */
    if (hdr->mask == I_TO_MASK(hdr->num_frag)) {
     if (mstate->nack_sent ==0) {
       TRACE0(blastp,4,"blast_pop: last frag !");
       flush_event(mstate->event);
       send_nack(mstate); 
       mstate->event = event_register(receive_timeout,(int)mstate,mstate->wait,EV_ONCE|EV_CREATEPROCESS);
       return(0);
     } else {
       TRACE0(blastp,4,"blast_pop: last frag disabled!");
       mstate->nack_sent = 0;
     }
    } 
    return(0);
  }
  /* code for sender */
  if (hdr->op == BLAST_NACK) {
    /* look for message state */
    mstate = (MSG_STATE *) map_resolve(state->send_map,(char *)&seq);
    if (mstate == (MSG_STATE *)-1) {
      TRACE0(blastp,4,"blast_pop: unmatched nack ");
      return(0);
    } 
    flush_event(mstate->event);
    retransmit(hdr->mask,mstate);
    mstate->event = event_register(send_timeout,(int)mstate,mstate->wait,EV_ONCE | EV_CREATEPROCESS);
    return(0);
  }
    
  TRACE0(blastp,0,"blast_pop: illegal operation ");
  return(0);
} 

    	
/* Retransmit the message referenced by mstate */
static retransmit(mask,mstate)
unsigned short mask;
MSG_STATE *mstate;
{
  int i;
  BLAST_STATE *state;
  BLAST_HDR *hdr;
  BLAST_HDR *top;
D 2
  MSG packet;
E 2
I 2
  Msg packet;
E 2


  TRACE2(blastp,3,"blast retransmit: called seq = %d mask = %x",
	 mstate->seq,mask);

  if (mstate == (MSG_STATE *)0) {
    TRACE0(blastp,3,"retransmit: no message state");
    return -1;
  }

  state = (BLAST_STATE *)mstate->state;
  if (state == (BLAST_STATE*)0) {
    TRACE0(blastp,1,"retransmit: no state");
    return -1;
  }
  hdr = &(mstate->send_hdr);

  hdr->op = BLAST_RETRANSMIT;
  /* send off fragments */
  for (i=1;i<=hdr->num_frag;i++) {
    if (I_TO_MASK(i) & (~mask)) {
      TRACE1(blastp,4,"retransmit: retransmitting msg%d ",i);
      TRACE1(blastp,4,"retransmit: retransmitting msgptr%d ",mstate->frags[i]);
      /* fill in dynamic parts of header */
      hdr->mask = I_TO_MASK(i);
      hdr->len = msg_len(mstate->frags[i]);
  
      TRACE1(blastp,4,"blast_push: sending frag %d",i);
      IFTRACE(blastp,4) {
        phdr(hdr);
      }
      TRACE1(blastp,4,"blast_push: frag_msg = %d",mstate->frags[i]);
      msg_save(packet, mstate->frags[i]);
      top = (BLAST_HDR *)msg_push(packet,BLASTHLEN);
      *top = *hdr;
  
      /* push message to lower session */
D 2
      if (x_push(state->down_s,packet,(MSG *)0) ==  -1) {
E 2
I 2
      if (x_push(state->down_s,packet,(Msg *)0) ==  -1) {
E 2
        TRACE0(blastp,4,"blast_push: can't send fragment");
      }
    }
  }
}


static blast_controlprotl(self,opcode, buf, len)
XObj 	self;
int	opcode;
char   	*buf;
int    	len;
{
    PSTATE	*pstate;
    int 	new_size;
    int		diff;
    
    TRACE1(blastp, 3, "blast_controlprotl, opcode: %d", opcode);
    pstate = (PSTATE *)self->state;
    
    switch (opcode) {
D 2
      case BLAST_SET_OUTSTANDING_MSGS:
E 2
I 2
      case BLAST_SETOUTSTANDINGMSGS:
E 2
	/* Set the number of outstanding messages to be the integer passed
         * in buf.
         */
	checkLen(len, sizeof(int));
	new_size = *(int *)buf;
	TRACE1(blastp, 4, "set outstanding messages to %d", new_size);
	if (new_size <= 0)
	    return -1;
	P(&pstate->access);
	diff = new_size - pstate->max_outstanding_messages;
	for (; diff < 0; diff++) 
	    P(&pstate->outstanding_messages);
	for (; diff > 0; diff--) 
	    V(&pstate->outstanding_messages);
	pstate->max_outstanding_messages = new_size;
	V(&pstate->access);
D 3
	return 0;
E 3
I 3
	return sizeof(int);
E 3
	
D 2
      case BLAST_GET_OUTSTANDING_MSGS:
E 2
I 2
      case BLAST_GETOUTSTANDINGMSGS:
E 2
	/* Return the current number of allowed outstanding messages */
	checkLen(len, sizeof(int));
	*(int *)buf = pstate->max_outstanding_messages;
	return 0;
I 3

      case GETOPTPACKET:
      case GETMAXPACKET:
	checkLen(len, sizeof(int));
	*(int *)buf = MAX_DGM;
	return sizeof(int);
E 3
	
      default:
        x_errno = INVALID_OPCODE;
        return(-1);
    } 
}
  
static blast_controlsessn(s, opcode, buf, len)
XObj   s;
int     opcode;
char    *buf;
int     len;
{
  BLAST_STATE	*state;

  TRACE1(blastp, 3, "in blast_control with session=%x", s); 

  state = (BLAST_STATE *) s->state;

  switch (opcode) {

I 3
    case GETOPTPACKET:
    case GETMAXPACKET:
        return blast_controlprotl(s->myprotl, opcode, buf, len);

E 3
    /* copy my IP address to buf */
D 2
    case MYADDR:
E 2
I 2
    case GETMYADDR:
E 2
        checkLen(len, sizeof(BLASTaddr));
	*(BLASTaddr *)buf = state->myBLASTaddr;
	return sizeof(BLASTaddr);

    /* copy PEER's BLAST address to buf */
D 2
    case PEERADDR:
E 2
I 2
    case GETPEERADDR:
E 2
        checkLen(len, sizeof(BLASTaddr));
	*(BLASTaddr *)buf = state->peerBLASTaddr;
	TRACE2(blastp, 5, "blast control returning address %d @ %s",
	       state->peerBLASTaddr.prot,
	       inet_ntoa(state->peerBLASTaddr.host));
	return sizeof(BLASTaddr);

D 2
    case GETCLIENTANDSVC:
E 2
I 2
    case GETALLADDRS:
E 2
	checkLen(len, 2*sizeof(IPhost));
        bcopy(&state->send, buf, sizeof(IPhost)); 
        bcopy(&state->rec, buf + sizeof(IPhost), sizeof(IPhost)); 
        return(0);

    /* free storage associated with ticket returned by push */
D 2
    case KILLTICKET:
E 2
I 2
    case FREERESOURCES:
E 2
	checkLen(len, sizeof(int));
	TRACE1(blastp, 5, "blast killticket called with id %d",
	       *(int *)buf);
        return(free_send_seq(state,0,*(int *)buf));

    case GETPROTO:
	checkLen(len, sizeof(unsigned int));
	*(unsigned int *)buf = state->prot_id;
	return sizeof(unsigned int);

    default:
        x_errno = INVALID_OPCODE;
        return(-1);
  }
}


/* Free the message and state associated with the incoming message referenced
 * by mstate
 */
static free_rec_seq(state,mstate,seq)
BLAST_STATE *state;
MSG_STATE *mstate;
int seq;
{
  int i;

  TRACE1(blastp,3,"free_rec_msg: begin seq = %d",seq);

D 3
  if (mstate == 0)  {
    mstate = (MSG_STATE *) map_resolve(state->rec_map,(char *)&seq);
  }
E 3
I 3
  
  /* We restrict access to the recMap to avoid two threads trying to
   * free the same message state.  
   */
  P(&state->recMapAccess);
  mstate = (MSG_STATE *) map_resolve(state->rec_map,(char *)&seq);
E 3
  if (mstate == (MSG_STATE *)-1) {
D 3
    TRACE0(blastp,4,"free_rec_seq: nothing to free");
E 3
I 3
    TRACE0(blastp,3,"free_rec_seq: nothing to free");
    V(&state->recMapAccess);
E 3
    return(-1);
  } 

  flush_event(mstate->event);
  if (mstate->binding) {
    if (map_unbindbinding(state->rec_map,mstate->binding) == -1) {
D 3
      TRACE0(blastp,0,"free_rec_seq: can't unbind!");
E 3
I 3
      TRACE0(blastp,1,"free_rec_seq: can't unbind!");
      V(&state->recMapAccess);
E 3
      return(-1);
     }
   } else {
     TRACE0(blastp,0,"free_rec_seq: no binding?!");
   }
I 3
   V(&state->recMapAccess);
E 3

   TRACE1(blastp,4,"free_rec_msg: num_frags = %d",mstate->rec_hdr.num_frag);
   for (i=1; i <= mstate->rec_hdr.num_frag; i++) {
     flush_msg(mstate->frags[i]);
   }

   if (!state->rec_cache) {
     state->rec_cache = mstate;
   } else {
     free(mstate);
   }
   return(0);
}


/* Free the message and state associated with the outgoing message referenced
 * by mstate
 */
static free_send_seq(state,mstate,seq)
BLAST_STATE *state;
MSG_STATE *mstate;
int seq;
{
  int i;
  PSTATE	*pstate;

  pstate = (PSTATE *)state->self->myprotl->state;
  
  TRACE1(blastp,3,"free_send_msg: begin seq = %d",seq);
  
  if (mstate == 0) 
    mstate = (MSG_STATE *) map_resolve(state->send_map,(char *)&seq);
  if (mstate == (MSG_STATE *)-1) {
    TRACE0(blastp,1,"free_send_seq: nothing to free");
    return(-1);
  } 

  flush_event(mstate->event);
  if (mstate->binding) {
    if (map_unbindbinding(state->send_map,mstate->binding) == -1) {
      TRACE0(blastp,0,"free_send_seq: can't unbind!");
      return(-1);
     }
   }

  TRACE1(blastp,4,"free_send_msg: num_frags = %d",mstate->send_hdr.num_frag);
  for (i=1;i<=mstate->send_hdr.num_frag;i++) {
      if (!msg_isnull(mstate->frags[i])) msg_free(mstate->frags[i]);
  }

  bzero(mstate,sizeof(MSG_STATE));
  free(mstate);
  TRACE1(blastp, 4, "blast: outstanding messages (v): %d",
	 pstate->outstanding_messages.count);
  V(&pstate->outstanding_messages);
  return(0);
}


static phdr(hdr)
BLAST_HDR *hdr;
{
  printf("BLAST header:\n");
  if (hdr->op == BLAST_SEND)
    printf("op: BLAST_SEND\n");
  else if (hdr->op == BLAST_RETRANSMIT)  
    printf("op: BLAST_RETRANSMIT\n");
  else if (hdr->op == BLAST_NACK)  
    printf("op: BLAST_NACK\n");
  else 
    printf("op: INVALID\n");
  printf("send: %s\n",inet_ntoa(hdr->send));
  printf("rec: %s\n",inet_ntoa(hdr->rec));
  printf("prot_id: %d\n",hdr->prot_id);
  printf("seq: %d\n",hdr->seq);
  printf("num_frags: %d\n",hdr->num_frag);
  printf("mask: %x\n",hdr->mask);
  printf("len: %x\n",hdr->len);
}


/* Insert the fragment 'msg' into the message referenced by 'mstate */
static unsigned short insert_frag(hdr,msg,mstate)
BLAST_HDR *hdr;
D 2
MSG msg;
E 2
I 2
Msg msg;
E 2
MSG_STATE *mstate;
{
  unsigned short  mask;
  int loc;
  int len;

  TRACE0(blastp,4,"insert_frag: called");
  mask = mstate->mask;
  loc =  mask_to_i(hdr->mask);
  if (loc == 0) {
    TRACE0(blastp,0,"insert_frag: illegal fragment");
    if (!msg_isnull(msg)) msg_free(msg);
    return mask;
  }

  TRACE1(blastp,4,"insert_frag: inserting fragment %d",loc);
  /* prefer later messages */
  if (!msg_isnull(mstate->frags[loc])) {
    TRACE1(blastp,5,"Freeing fragment %d", loc);
    msg_free(mstate->frags[loc]);
  }

  len = msg_len(msg);
  TRACE2(blastp,4,"insert_frag: hdr->len = %d msg_len = %d",hdr->len,len);
  if (hdr->len == len) {
    mstate->frags[loc]= msg;
  } else if (hdr->len < msg_len(msg)) {
    mstate->frags[loc]= msg_truncateright(msg,hdr->len);
  } else {
    TRACE0(blastp,0,"insert_frag: fragment too short!");
    mstate->frags[loc]= msg;
  }
  
  return(mask | hdr->mask);
}


/* Return the message formed by the assembly of the fragments in 'mstate' */
D 2
static MSG reassemble(mstate)
E 2
I 2
static Msg reassemble(mstate)
E 2
MSG_STATE *mstate;
{
D 2
  MSG msg;
E 2
I 2
  Msg msg;
E 2
  int i;

  TRACE0(blastp,4,"reassemble: called");

  msg_clear(msg);
 
  for (i=1;i<=mstate->rec_hdr.num_frag;i++) {

  if (msg_isnull(mstate->frags[i])) {
      TRACE0(blastp,4,"reassemble: missing message !");
      return(NULL_MSG);
    }
    TRACE1(blastp,5,"reassemble: frag = %d",mstate->frags[i]);
    TRACE1(blastp,5,"reassemble: frag_len = %d",msg_len(mstate->frags[i]));
    msg_join(msg,msg,mstate->frags[i]);
    TRACE1(blastp,5,"reassemble: msg_len = %d",msg_len(msg));
    msg_clear(mstate->frags[i]);
  }

  TRACE1(blastp,4,"reassemble: returns msg %x",msg);
  return(msg);
}


static unsigned short I_TO_MASK(i)
int i;
{
  unsigned short mask;

  TRACE1(blastp,4,"I_TO_MASK: called %d",i);
  mask = 1;
  if (i == 1) {
    TRACE1(blastp,4,"I_TO_MASK: returns %x",mask);
    return(mask);
  }
  mask = mask << (i-1);
  TRACE1(blastp,4,"I_TO_MASK: returns %x",mask);
  return(mask);
}

 
/* converts mask to integer. 
 *  only works if single bit is turned on
 */
static int mask_to_i(mask)
unsigned short mask;
{
  int i;
  TRACE1(blastp,4,"mask_to_i: called mask =  %x",mask);

  for (i=1;i<=16;i++) {
    if (mask == 1) {
      TRACE1(blastp,4,"mask_to_i: returns i =  %d",i);
      return(i);
    }
    mask = mask >> 1;
  }
  TRACE1(blastp,4,"mask_to_i: returns i =  %d",0);
  return(0);
}
    

/* send timout garbage collects the storage associated with 
 * a given sequence number. Since blast uses nacks it has 
 * to have some way of getting rid of storage 
 */
static send_timeout(mstate)
MSG_STATE *mstate;
{
  BLAST_STATE	*state;
  
  TRACE0(blastp, 2, "blast: send_timeout: timeout!");
  state = (BLAST_STATE *)mstate->state;
  free_send_seq(state,mstate,mstate->seq);
  return(0);
}

    
/* receive timeout: sends nack if everything has not arrived in
 * a certain time. If nothing arrives between two nacks then 
 * msg is flushed 
 */
static receive_timeout(mstate)
MSG_STATE *mstate;
{
  BLAST_STATE *state;
  
  TRACE0(blastp, 2, "blast: receive_timeout: timeout!");
  state = (BLAST_STATE *)mstate->state;

  if (mstate->old_mask == 0) {
    /* first time though */
    mstate->old_mask = mstate->mask;
    mstate->wait = 1.5*mstate->wait;
    mstate->event = event_register(receive_timeout,(int)mstate,mstate->wait,EV_ONCE|EV_CREATEPROCESS);
    send_nack(mstate);
    return(0);
  } 
  /* check for progress */
  if (mstate->old_mask != mstate->mask) {
    mstate->old_mask = mstate->mask;
    mstate->wait = 1.5*mstate->wait;
    mstate->event = event_register(receive_timeout,(int)mstate,mstate->wait,EV_ONCE|EV_CREATEPROCESS);
    send_nack(mstate);
    return(0);
  }

  /* flush message */
  free_rec_seq(state,mstate,mstate->seq);
}


static send_nack(mstate)
MSG_STATE *mstate;
{
  BLAST_STATE 	*state;
  BLAST_HDR	hdr;
D 2
  MSG 		msg;
E 2
I 2
  Msg 		msg;
E 2
  
  TRACE1(blastp,4,"send_nack: called mask = %x",mstate->mask);
  state = (BLAST_STATE *) mstate->state;
  mstate->nack_sent = 1;

  hdr = mstate->rec_hdr;
  hdr.op = BLAST_NACK;
  hdr.mask = mstate->mask;
  msg_make_allstack(msg,128,(char *)&hdr,BLASTHLEN);
  IFTRACE(blastp,4) {
  phdr(&hdr);
  }
D 2
  if (x_push(state->down_s, msg,(MSG *)0) ==  -1) {
E 2
I 2
  if (x_push(state->down_s, msg,(Msg *)0) ==  -1) {
E 2
    TRACE0(blastp,4,"send_nack: can't send nack");
    if (!msg_isnull(msg)) msg_free(msg);
  }
  return(0);
}

static flush(map)
Map map;
{
  /* should remove all entries from map but. noop for now */
}

blast_getproc(p,type)
XObj p;
D 2
XobjType type;
E 2
I 2
XObjType type;
E 2
{
  if (type == Protocol) {
    p->instantiateprotl = blast_instantiateprotl;
    p->init = blast_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = blast_controlprotl;
  } else {
    p->push = blast_push;
    p->pop = blast_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = blast_controlsessn;
    p->close = blast_close;
  }
  p->open = (Pfi) blast_open;
  p->openenable = blast_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = blast_demux;
  p->getproc = blast_getproc;
}

E 1
