/*
 * scanf.c
 *
 *  converted for xkernel v3.1 072090 cliff
 *
 */

#ifndef XSIMUL
#include "userprocess.h"
#include "userupi.h"
#include "../drivers/scr/scr.h"
#include "../drivers/kbd/kbd.h"

static int scanfkbd(), null();
static Protl scanfprotl, SCR, KBD;
static Sessn scrsessn, scanfsessn;
static Semaphore *chars;
#define bsize 256
static char buffer[bsize], *bnext = buffer, *bfirst = buffer, *bend = &buffer[bsize];
static int bcount;

static squirrel(c)
int c;
{
  int x = spl7();
  if (bcount < bsize-1) {
    *bnext = c;
    if (++bnext >= bend) bnext = buffer;
    bcount++;
    xvsem(chars);
  }
  splx(x);
}

int getc()
{
  int c, x;

  xpsem(chars);
  x = spl7();
  c = *bfirst;
#ifdef DEBUGSCANF
  printf("getc returns '%c'\n", c);
#endif
  if (++bfirst >= bend) bfirst = buffer;
  bcount--;
  splx(x);
  return c;
}

void ungetc(c)
int c;
{
  int x = spl7();
  if (--bfirst < buffer) bfirst = bend - 1;
  bcount++;
#ifdef DEBUGSCANF
  if (*bfirst != c) {
    printf("ungetc confusion '%c' != '%c'\n", *bfirst, c);
  }
#endif
  splx(x);
  xvsem(chars);
}

initscanf()
{
  Part whom[1];
  scanfprotl = xcreateprotl(scanfkbd, null, null);
  whom[0].address = NULL;
  whom[0].length = 0;

  SCR = xgetprotlbyname("scr");
  KBD = xgetprotlbyname("kbd");
  scrsessn = xopen(scanfprotl, SCR, whom);
  scanfsessn = xopen(scanfprotl, KBD, whom);
  chars = xcreatesemaphore(0);
}

static scanfkbd(s, m, l)
Sessn s;
unsigned char *m;
int l;
{
#ifdef DEBUGSCANF
  printf("Demux a character = '%c'\n", *m);
#endif
  xpush(scrsessn, m, 1);
  squirrel(*m);
}

static readstring(s)
char *s;
{
  int c;

  while ((c = getc()) == ' ' || c == '\n' || c == '\t' || c == '\r') ;
  while (c != ' ' && c != '\n' && c != '\t' && c != '\r') {
    *s++ = c;
    c = getc();
  }
  ungetc(c);
  *s = '\0';
}

/*VARARGS1*/
scanf(string)
char *string;
{
  register unsigned *argp = (unsigned *) &string;
  register char *s = string;
  register int c, width = 0;
  char lb[20];
  static int inited = 0;
  if (!inited) { inited = 1; initscanf(); }
  argp++;
  while(*s) {
    if (*s == '%') {
      s++;
      switch(*s++) {
	case 's': 
	  readstring(*argp);
#ifdef DEBUGSCANF
	  printf("scanf got '%s'\n", *argp);
#endif
	  argp++;	
	  break;
	default:
	  break;
      }
    } else {
      
    }
  }
}

static null()
{
}
#endif
