h20384
s 00007/00002/00194
d D 1.2 91/01/10 11:04:46 llp 2 1
c Prepared for 3.1 Distribution
e
s 00196/00000/00000
d D 1.1 90/12/08 23:42:09 menze 1 0
c date and time created 90/12/08 23:42:09 by menze
e
u
U
f e 0
t
T
I 1
/* 
D 2
 * @(#)useridmaptemplate.c	1.1  9/21/88
E 2
I 2
 * useridmaptemplate.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */
I 2

E 2
#include "system.h"
#include "userprocess.h"
/*
 * We need the definitions of:
 *	PREFIX
 *	KEYSIZE
 *	HASH
 *	COMPBYTES
 *	COPYBYTES
 */
struct STRUCT {
  int     int_id;
  struct  STRUCT *next_elem;
  char    ext_id[KEYSIZE];
};

typedef struct STRUCT MAP_ELEM, *BIND, **MAP;

#define	GETMAPELEM(elem) { \
    if (free_list == NULL) \
        elem = (BIND)malloc(sizeof(MAP_ELEM)); \
    else { \
        elem = free_list; \
        free_list = free_list->next_elem; \
    } \
}
#define	FREEIT(elem) { \
    elem->next_elem = free_list; \
    free_list = elem; \
}

#define STOLENFIELDS 3

static BIND free_list = NULL;

MAP MAP_CREATE (size)
int     size;
{
  MAP	table;

  table = (MAP)calloc((unsigned)(size + STOLENFIELDS), sizeof(BIND));
  *table = (BIND)size;
  *(table+1) = (BIND) 0;
  *(table+2) = (BIND) xcreatesemaphore(1);
  return(table);
}

BIND MAP_BIND (table, ext, intern)
MAP	table;
register char	*ext;
int	intern;
{
  BIND     elem_posn;
  BIND     new_elem;
  MAP      table_posn;
  register char *o_ext;

  xpsem((Semaphore *)*(table+2));
  table_posn = table + HASH(ext, table) + STOLENFIELDS;
  elem_posn = *table_posn;
  while (elem_posn != NULL) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, ext)) {
      if (elem_posn->int_id == intern) {
	xvsem((Semaphore *)*(table+2));
	return(elem_posn);
      } else {
	x_errno = INCONSISTENT_BIND;
	xvsem((Semaphore *)*(table+2));
D 2
	return(ERR_BIND);
E 2
I 2
	return((BIND) ERR_BIND);
E 2
      }
    } else {
      elem_posn = elem_posn->next_elem;
    }
  }
  GETMAPELEM(new_elem);
  COPYBYTES(new_elem->ext_id, ext);
  new_elem->int_id = intern;
  new_elem->next_elem = *table_posn;
  *(table + 1) = new_elem;
  *table_posn = new_elem;
  xvsem((Semaphore *)*(table+2));
  return(new_elem);
}

MAP_RESOLVE (table, ext)
MAP	table;
register char	*ext;
{
  register BIND elem_posn;
  register char *o_ext;

  xpsem((Semaphore *)*(table+2));
  if (elem_posn = *(table + 1)) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, ext)) {
      xvsem((Semaphore *)*(table+2));
      return(elem_posn->int_id);
    }
  }
  elem_posn = *(table + HASH(ext, table) + STOLENFIELDS);
  while (elem_posn != NULL) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, ext)) {
      *(table + 1) = elem_posn;
      xvsem((Semaphore *)*(table+2));
      return(elem_posn->int_id);
    } else {
      elem_posn = elem_posn->next_elem;
    }
  }
  x_errno = CANNOT_RESOLVE;
  xvsem((Semaphore *)*(table+2));
  return(-1);
}

MAP_UNBINDBINDING (table, binding)
MAP	table;
BIND	binding;
{
  BIND     elem_posn;
  MAP   prev_elem;
  register char *o_ext;

  xpsem((Semaphore *)*(table+2));
  prev_elem = (table + HASH(binding->ext_id, table) + STOLENFIELDS);
  elem_posn = *prev_elem;
  *(table + 1) = 0;
  while (elem_posn != NULL) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, binding->ext_id)) {
      if (elem_posn->int_id == binding->int_id) {
	*prev_elem = elem_posn->next_elem;
	FREEIT(elem_posn);
	xvsem((Semaphore *)*(table+2));
	return(0);
      } else {
	x_errno = CANNOT_UNBIND;
	xvsem((Semaphore *)*(table+2));
	return(-1);
      }
    } else {
      prev_elem = &(elem_posn->next_elem);
      elem_posn = elem_posn->next_elem;
    }
  }
  x_errno = CANNOT_UNBIND;
  xvsem((Semaphore *)*(table+2));
  return(-1);
} 

MAP_UNBIND (table, ext, intern)
MAP	table;
register char	*ext;
int	intern;
{
  BIND     elem_posn;
  MAP   prev_elem;
  register char *o_ext;

  xpsem((Semaphore *)*(table+2));
  prev_elem = (table + HASH(ext, table) + STOLENFIELDS);
  elem_posn = *prev_elem;
  *(table + 1) = 0;
  while (elem_posn != NULL) {
    o_ext = elem_posn->ext_id;
    if (COMPBYTES(o_ext, ext)) {
      if (elem_posn->int_id == intern || intern == -1) {
	*prev_elem = elem_posn->next_elem;
	FREEIT(elem_posn);
	xvsem((Semaphore *)*(table+2));
	return(0);
      } else {
	x_errno = CANNOT_UNBIND;
	xvsem((Semaphore *)*(table+2));
	return(-1);
      }
    } else {
      prev_elem = &(elem_posn->next_elem);
      elem_posn = elem_posn->next_elem;
    }
  }
  x_errno = CANNOT_UNBIND;
  xvsem((Semaphore *)*(table+2));
  return(-1);
}

MAP_CLOSE (table)
MAP	table;
{
  xdestroysemaphore((Semaphore *)*(table+2));
  free((char *)table);
}
E 1
