/* 
 * intelEthXmit.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "eth.h"
#include "intelEthType.h"
#include "intelEthRcv.h"
#include "intelEthCmd.h"
#include "intelEth.h"

extern Msg makeXbdListFromMsg();


/*
 * ethCtlrXmit
 */

ethCtlrXmit(msgToXmit, destEthAd, msgEthType)
     Msg msgToXmit;
     ethAd_t destEthAd;
     ethType_t msgEthType;
{
  cmd_t *cmdPtr;
  
#ifndef NDEBUG
  nCUXmits++;
  IFTRACE(ie, 2) putchar('t');
#endif
  TRACE5(ie, 3, "ethCtlrXmit: Transmitting    type=%x    true-length=%d    to destination %4x.%4x.%4x", msgEthType, msg_len(msgToXmit), destEthAd.high, destEthAd.mid, destEthAd.low);
  
  ALLOC_CMD(cmdPtr);
  cmdPtr->prefix.cmdKind = XMIT_CMD;
  
  /* point to chain of xmit buffers */
  msgToXmit = makeXbdListFromMsg(msgToXmit, cmdPtr->extra.xbdHeadPtr, cmdPtr->extra.firstChunk);
  cmdPtr->suffix.xmit.xbdHeadOffset =
    IE_OFFSET_FROM_AD(cmdPtr->extra.xbdHeadPtr);
  
  cmdPtr->suffix.xmit.ethType = msgEthType;
  cmdPtr->suffix.xmit.destEthAd = destEthAd;
  cmdPtr->suffix.xmit.msg = msgToXmit;
  
  postCmd(cmdPtr);
  
}				/* end ethCtlrXmit */


#define RESTMSG NMSG
#define M_Contig  NM_Contig
#define M_Single  NM_Single
#define M_Pair    NM_Pair
#define xcontig   contig.data


/*
 * makeXbdListFromRestOfMsg
 */

void makeXbdListFromRestOfMsg(msg, inheritedOffset, msgSz, xbdHeadPtr, xbdTailPtrPtr)
     RESTMSG msg;
     int inheritedOffset;
     int msgSz;
     xmitBufDesc_t *xbdHeadPtr;
     xmitBufDesc_t **xbdTailPtrPtr;
{
  int combinedOffset;
  int leftMsgSz;
  xmitBufDesc_t *leftMsgTailPtr;
  
  assert(msgSz > 0);
  assert(inheritedOffset >= 0);
  
  combinedOffset = msg->off + inheritedOffset;
  
  switch (msg->tag) {
    
  case M_Contig:
    INIT_XBD(xbdHeadPtr, &msg->body.xcontig[combinedOffset], msgSz);
    TRACE1(ie, 5, "Chunk of length %d\n", msgSz);
    *xbdTailPtrPtr = xbdHeadPtr;
    return;
    
  case M_Single:
    makeXbdListFromRestOfMsg(msg->body.single, combinedOffset, msgSz,
			     xbdHeadPtr, xbdTailPtrPtr);
    return;
    
  case M_Pair:
    leftMsgSz = msg->body.pair.l->len - combinedOffset;
    if (leftMsgSz >= msgSz) {
      /* the left child contains all the remaining desired data */
      makeXbdListFromRestOfMsg(msg->body.pair.l, combinedOffset,
			       msgSz, xbdHeadPtr, xbdTailPtrPtr);
      return;
    }
    if (leftMsgSz <= 0) {
      /* the right child contains all the desired data */
      /* subtract the entire left msg from the offset */
      combinedOffset -= msg->body.pair.l->len;
      makeXbdListFromRestOfMsg(msg->body.pair.r, combinedOffset,
			       msgSz, xbdHeadPtr, xbdTailPtrPtr);
      return;
    }
    /* the desired data is spread across both left and right msgs */
    assert((0 < leftMsgSz) && (leftMsgSz < msgSz));
    /* make an xbd list for the left msg */
    makeXbdListFromRestOfMsg(msg->body.pair.l, combinedOffset,
			     leftMsgSz, xbdHeadPtr, &leftMsgTailPtr);
    /* continue the xbd list for the right msg */
    makeXbdListFromRestOfMsg(msg->body.pair.r, 0 /* new inheritedOffset */ ,
			     msgSz - leftMsgSz, leftMsgTailPtr->nextXbdPtr, xbdTailPtrPtr);
    return;
    
  default:
    print("makeXbdListFromRestOfMsg: unrecognized Msg tag\n");
    return;
    
  }
  
}				/* end makeXbdListFromRestOfMsg */


/*
 * makeXbdListFromMsg
 *
 * Fill a linked list of xmit buffer descriptors
 * with buffers containing the data from the input Msg.
 * Perform padding if necessary.
 */

Msg  makeXbdListFromMsg(msg, xbdHeadPtr, firstChunk)
     Msg msg;
     xmitBufDesc_t *xbdHeadPtr;
     char *firstChunk;
{
  xmitBufDesc_t *xbdTailPtr;
  
  int slen, blen;
  
  slen = msg_stack_len(msg);
  blen = msg_data_len(msg);
  if (slen > 0 && blen > 0 && slen < MIN_FIRST_CHUNK) {
    int size = slen + blen;
    if (size > MIN_FIRST_CHUNK) size = MIN_FIRST_CHUNK;
    
    msg_peek(msg, 0, size, firstChunk);
    INIT_XBD(xbdHeadPtr, firstChunk, size);
    TRACE1(ie, 5, "First chunk %d\n", size);
    xbdTailPtr = xbdHeadPtr;
    xbdHeadPtr = xbdHeadPtr->nextXbdPtr;
    msg = msg_truncateleft(msg, size);
    blen = msg_data_len(msg);
  }
  else if (slen > 0) {
    INIT_XBD(xbdHeadPtr, msg_top(msg, slen), slen);
    TRACE1(ie, 5, "First chunk %d\n", slen);
    xbdTailPtr = xbdHeadPtr;
    xbdHeadPtr = xbdHeadPtr->nextXbdPtr;
  }
  if (blen > 0) {
    makeXbdListFromRestOfMsg(msg.data, 0, blen,
			     xbdHeadPtr, &xbdTailPtr);
  }
  if (msg_len(msg) < MIN_ETH_DATA_SZ) {
    /* need to pad;  controller doesn't do this automatically */
#ifdef DOITRIGHT
    /* put an extra Xmit Buf Desc describing some padding on end of list */
    static char paddingBuf[MIN_ETH_DATA_SZ];	/* shared by all xmit cmds */
    
    xbdTailPtr = xbdTailPtr->nextXbdPtr;
    INIT_XBD(xbdTailPtr, &paddingBuf[0], MIN_ETH_DATA_SZ - msg_len(msg));
#else
    /* Lie about the length of the last fragment */
    xbdTailPtr->bufSzLoByte += (MIN_ETH_DATA_SZ - msg_len(msg));
#endif
  }
  xbdTailPtr->lastXbdOfCmd = TRUE;
  return msg;
}				/* end makeXbdListFromMsg */


/*
 * printXmitErrs
 */

printXmitErrs(xmitCmdPtr)
     cmd_t *xmitCmdPtr;
{
  
  printf("Transmission failed %4x",
	 *(short *) &xmitCmdPtr->prefix);
  printf(" %d collisions", 
	 (xmitCmdPtr->prefix.tooManyCollisions && 
	 (xmitCmdPtr->prefix.numCollisions == 0)) 
	 ? 16 : xmitCmdPtr->prefix.numCollisions);
  if (xmitCmdPtr->prefix.cmdAborted)
    printf(" aborted");
  if (xmitCmdPtr->prefix.noCarrier)
    printf(" no carrier sense");
  if (xmitCmdPtr->prefix.lostClearToSend)
    printf(" no clear to send");
  if (xmitCmdPtr->prefix.dmaUnderrun) {
    printf(" dma underrun");
    printSizes(xmitCmdPtr->extra.xbdHeadPtr);
  }
  if (xmitCmdPtr->prefix.xmitDeferred)
    printf(" defered");
  if (!xmitCmdPtr->prefix.heartbeat)
    printf(" heart beat");
  if (xmitCmdPtr->prefix.tooManyCollisions)
    printf(" too many collisions");
  printf("\n");
}


printSizes(t)
     xmitBufDesc_t *t;
{
  while (1) {
    printf(" %d", CAT_BYTES(t->bufSzHiByte, t->bufSzLoByte));
    if (t->lastXbdOfCmd) break;
    t = t->nextXbdPtr;
  }
}

