/* 
 * intelEth.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 * depends on:
 *		eth.h			- controller-independent ethernet stuff
 *		intelEthType.h		- some types needed by the ie dev
 *		intelEthRcv.h		- info related to ie Receive Unit
 *		intelEthCmd.h		- info related to ie Command Unit
 */

#define volatile 

#ifndef memory_h
#include "memory.h"
#endif

extern int traceethp;
extern int handleIeIntrAsm();

#define	IE_INTR_NUM		INT3


/*
 * some delay times (?)
 */
#define SECS400		0x0affffff /* 400 secs delay */
#define SECS2		(SECS400/200)	/* 2 secs delay	 */
#define SECSPOINT02	(SECS2/100)	/* 0.02 secs delay */


/*
 * Ie Device Control Register
 */
#define	IE_CTL_REG 		(* (volatile u_char*) 0x0FE0C000)
#define	IE_CTL_REG_CHAN_ATTN	0x20	/* channel attention : normal 0	 */
#define	IE_CTL_REG_LOOPBACK	0x40	/* loop back : normal 1 */
#define	IE_CTL_REG_RESET	0x80	/* reset : normal 1	 */
#define	IE_CTL_REG_INTR_ENABLE	0x10	/* interrupt enable : normal 0 */
#define	IE_CTL_REG_INTR_PEND	0x01	/* interrupt pending : normal 0	 */

#define ALERT_IE_DEV()	{\
			   IE_CTL_REG = IE_CTL_REG_CHAN_ATTN\
			     + IE_CTL_REG_LOOPBACK\
			       + IE_CTL_REG_RESET\
				 + IE_CTL_REG_INTR_ENABLE;\
				   nop();\
				     nop();\
				       nop();\
					 nop();\
					   nop();\
					     IE_CTL_REG = IE_CTL_REG_LOOPBACK\
					       + IE_CTL_REG_RESET\
						 + IE_CTL_REG_INTR_ENABLE;\
						 }



/*
 * Initialization Root
 */
typedef struct {
  char busKind;			/* 0 => 16 bit bus; 1 => 8 bit bus */
  char unused[5];
  ieAd_t intermInitRootAd;
}      initRoot_t;


/* the ie dev looks for the initialization root at this magic address */
#define	InitRoot	(* (initRoot_t*) 0xfffffff6)


/*
 * Intermediate Initialization Root
 */
typedef struct {
  char initInProgress;		/* initialization in progress */
  char unused;
  ieOffset_t scbOffset;		/* scb offset in ieSharedMem */
  ieAd_t ieSharedMemAd;		/* base ad for ieSharedMem */
}      intermInitRoot_t;


/*
 * System Control Block
 */
typedef struct {
 unsigned:1;			/* must be 0 */
   unsigned rcvUnitStatus:3;
 unsigned:4;			/* must be 0 */
   unsigned cmdDone:1;
   unsigned frameRcvd:1;
   unsigned cuLeftActiveState:1;
   unsigned ruNotReady:1;
 unsigned:1;			/* must be 0 */
   unsigned cmdUnitStatus:3;
   unsigned resetCtlr:1;		/* reset chip ? */
   unsigned rcvUnitCtlCmd:3;
 unsigned:4;			/* unused */
   unsigned ackCmdDone:1;	/* ack command executed */
   unsigned ackFrameRcvd:1;	/* ack frame recd event */
   unsigned ackCuLeftActiveState:1;
   unsigned ackRuNotReady:1;
 unsigned:1;			/* not used */
   unsigned cmdUnitCtlCmd:3;
   ieOffset_t cmdHeadOffset;
   ieOffset_t rcvFrameDescHeadOffset;
   u_short crcErrCnt;		/* cumulative? */
   u_short alignErrCnt;		/* cumulative? */
   u_short rsrcErrCnt;		/* cumulative? */
   u_short overrunErrCnt;	/* cumulative? */
 }      sysCtlBlk_t;

/*
 * sizes of arrays in the shared memory area
 */
#define	NUM_RFDS		64	/* from old version */
#define	NUM_RBDS		NUM_RFDS
#define	NUM_CMD_BLKS		32	/* from old version */
#define XBDS_PER_CMD		12	/* just made it up; Sean may need
					 * more */
#define	NUM_XBDS		(XBDS_PER_CMD*NUM_CMD_BLKS)


/*
 * memory area shared between ie dev and cpu
 *
 * Must all be within a 64K address space (except interm init root?)
 *
 * cmdBlkArray is 2 * NUM_CMD_BLKS because I put a noop after each real command
 */
typedef struct {
  sysCtlBlk_t sysCtlBlk;
  rcvFrameDesc_t rcvFrameDescArray[NUM_RFDS];
  rcvBufDesc_t rcvBufDescArray[NUM_RBDS];
  cmd_t cmdBlkArray[2 * NUM_CMD_BLKS];
  xmitBufDesc_t xmitBufDescArray[NUM_XBDS];
}      ieSharedMem_t;


/*
 * locate the shared space at ENET_DATA_SEG, defined in sun3mem.h
 */
#define	IeSharedMemPtr 	((volatile ieSharedMem_t *) ENET_DATA_SEG)


/*
 * convenient aliases for the shared memory areas
 */
#define	SCB			(IeSharedMemPtr->sysCtlBlk)
#define	RcvFrameDescArray 	(IeSharedMemPtr->rcvFrameDescArray)
#define	RcvBufDescArray	 	(IeSharedMemPtr->rcvBufDescArray)
#define	CmdBlkArray	 	(IeSharedMemPtr->cmdBlkArray)
#define	XmitBufDescArray	(IeSharedMemPtr->xmitBufDescArray)


extern int nCUNoCommandsPending, nCUCommandsPending, nCUStarts, nCUContinues, nCULeavingActives, nCUXmits;

