h14526
s 00088/00110/00142
d D 1.3 91/01/10 10:52:36 llp 3 2
c Prepared for 3.1 Distribution
e
s 00004/00004/00248
d D 1.2 90/11/30 14:14:05 menze 2 1
c memory leak repaired
e
s 00252/00000/00000
d D 1.1 90/11/30 13:53:07 menze 1 0
c date and time created 90/11/30 13:53:07 by menze
e
u
U
f e 0
t
T
I 1
D 3

/*
E 3
I 3
/* 
E 3
 * intelEthXmit.c
 *
D 3
 * packet transmission, i.e. the Command Unit's XMIT command.
E 3
I 3
 * x-kernel v3.1	12/10/90
E 3
 *
D 3
 * Mark Abbott, Spring 89
E 3
I 3
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 3
 */

D 3

#include "upi.h"
#include "process.h"
#include "assert.h"
#include "xType.h"
E 3
I 3
#include "xkernel.h"
E 3
#include "eth.h"
#include "intelEthType.h"
#include "intelEthRcv.h"
#include "intelEthCmd.h"
#include "intelEth.h"

I 3
extern Msg makeXbdListFromMsg();
E 3


D 3



D 2
extern xmitBufDesc_t *makeXbdListFromMsg();
E 2
I 2
extern MSG makeXbdListFromMsg();
E 2








E 3
/*
 * ethCtlrXmit
 */
I 3

E 3
ethCtlrXmit(msgToXmit, destEthAd, msgEthType)
D 3
    MSG msgToXmit;
    ethAd_t destEthAd;
    ethType_t msgEthType;
E 3
I 3
     Msg msgToXmit;
     ethAd_t destEthAd;
     ethType_t msgEthType;
E 3
{
  cmd_t *cmdPtr;
D 3


E 3
I 3
  
E 3
#ifndef NDEBUG
  nCUXmits++;
  IFTRACE(ie, 2) putchar('t');
#endif
  TRACE5(ie, 3, "ethCtlrXmit: Transmitting    type=%x    true-length=%d    to destination %4x.%4x.%4x", msgEthType, msg_len(msgToXmit), destEthAd.high, destEthAd.mid, destEthAd.low);
D 3

E 3
I 3
  
E 3
  ALLOC_CMD(cmdPtr);
  cmdPtr->prefix.cmdKind = XMIT_CMD;
D 3

E 3
I 3
  
E 3
  /* point to chain of xmit buffers */
D 2
  makeXbdListFromMsg(msgToXmit, cmdPtr->extra.xbdHeadPtr, cmdPtr->extra.firstChunk);
E 2
I 2
  msgToXmit = makeXbdListFromMsg(msgToXmit, cmdPtr->extra.xbdHeadPtr, cmdPtr->extra.firstChunk);
E 2
  cmdPtr->suffix.xmit.xbdHeadOffset =
    IE_OFFSET_FROM_AD(cmdPtr->extra.xbdHeadPtr);
D 3

E 3
I 3
  
E 3
  cmdPtr->suffix.xmit.ethType = msgEthType;
  cmdPtr->suffix.xmit.destEthAd = destEthAd;
  cmdPtr->suffix.xmit.msg = msgToXmit;
D 3

E 3
I 3
  
E 3
  postCmd(cmdPtr);
D 3

E 3
I 3
  
E 3
}				/* end ethCtlrXmit */


D 3




E 3
#define RESTMSG NMSG
#define M_Contig  NM_Contig
#define M_Single  NM_Single
#define M_Pair    NM_Pair
#define xcontig   contig.data
I 3


E 3
/*
 * makeXbdListFromRestOfMsg
 */
I 3

E 3
void makeXbdListFromRestOfMsg(msg, inheritedOffset, msgSz, xbdHeadPtr, xbdTailPtrPtr)
D 3
    RESTMSG msg;
    int inheritedOffset;
    int msgSz;
    xmitBufDesc_t *xbdHeadPtr;
    xmitBufDesc_t **xbdTailPtrPtr;
E 3
I 3
     RESTMSG msg;
     int inheritedOffset;
     int msgSz;
     xmitBufDesc_t *xbdHeadPtr;
     xmitBufDesc_t **xbdTailPtrPtr;
E 3
{
  int combinedOffset;
  int leftMsgSz;
  xmitBufDesc_t *leftMsgTailPtr;
D 3


E 3
I 3
  
E 3
  assert(msgSz > 0);
  assert(inheritedOffset >= 0);
D 3


E 3
I 3
  
E 3
  combinedOffset = msg->off + inheritedOffset;
D 3


E 3
I 3
  
E 3
  switch (msg->tag) {
D 3

   case M_Contig:
     INIT_XBD(xbdHeadPtr, &msg->body.xcontig[combinedOffset], msgSz);
     TRACE1(ie, 5, "Chunk of length %d\n", msgSz);
     *xbdTailPtrPtr = xbdHeadPtr;
     return;

   case M_Single:
     makeXbdListFromRestOfMsg(msg->body.single, combinedOffset, msgSz,
			      xbdHeadPtr, xbdTailPtrPtr);
     return;

   case M_Pair:
     leftMsgSz = msg->body.pair.l->len - combinedOffset;
     if (leftMsgSz >= msgSz) {
       /* the left child contains all the remaining desired data */
       makeXbdListFromRestOfMsg(msg->body.pair.l, combinedOffset,
				msgSz, xbdHeadPtr, xbdTailPtrPtr);
       return;
     }
     if (leftMsgSz <= 0) {
       /* the right child contains all the desired data */
       /* subtract the entire left msg from the offset */
       combinedOffset -= msg->body.pair.l->len;
       makeXbdListFromRestOfMsg(msg->body.pair.r, combinedOffset,
				msgSz, xbdHeadPtr, xbdTailPtrPtr);
       return;
     }
     /* the desired data is spread across both left and right msgs */
     assert((0 < leftMsgSz) && (leftMsgSz < msgSz));
     /* make an xbd list for the left msg */
     makeXbdListFromRestOfMsg(msg->body.pair.l, combinedOffset,
			      leftMsgSz, xbdHeadPtr, &leftMsgTailPtr);
     /* continue the xbd list for the right msg */
     makeXbdListFromRestOfMsg(msg->body.pair.r, 0 /* new inheritedOffset */ ,
	      msgSz - leftMsgSz, leftMsgTailPtr->nextXbdPtr, xbdTailPtrPtr);
     return;

   default:
     print("makeXbdListFromRestOfMsg: unrecognized MSG tag\n");
     return;

E 3
I 3
    
  case M_Contig:
    INIT_XBD(xbdHeadPtr, &msg->body.xcontig[combinedOffset], msgSz);
    TRACE1(ie, 5, "Chunk of length %d\n", msgSz);
    *xbdTailPtrPtr = xbdHeadPtr;
    return;
    
  case M_Single:
    makeXbdListFromRestOfMsg(msg->body.single, combinedOffset, msgSz,
			     xbdHeadPtr, xbdTailPtrPtr);
    return;
    
  case M_Pair:
    leftMsgSz = msg->body.pair.l->len - combinedOffset;
    if (leftMsgSz >= msgSz) {
      /* the left child contains all the remaining desired data */
      makeXbdListFromRestOfMsg(msg->body.pair.l, combinedOffset,
			       msgSz, xbdHeadPtr, xbdTailPtrPtr);
      return;
    }
    if (leftMsgSz <= 0) {
      /* the right child contains all the desired data */
      /* subtract the entire left msg from the offset */
      combinedOffset -= msg->body.pair.l->len;
      makeXbdListFromRestOfMsg(msg->body.pair.r, combinedOffset,
			       msgSz, xbdHeadPtr, xbdTailPtrPtr);
      return;
    }
    /* the desired data is spread across both left and right msgs */
    assert((0 < leftMsgSz) && (leftMsgSz < msgSz));
    /* make an xbd list for the left msg */
    makeXbdListFromRestOfMsg(msg->body.pair.l, combinedOffset,
			     leftMsgSz, xbdHeadPtr, &leftMsgTailPtr);
    /* continue the xbd list for the right msg */
    makeXbdListFromRestOfMsg(msg->body.pair.r, 0 /* new inheritedOffset */ ,
			     msgSz - leftMsgSz, leftMsgTailPtr->nextXbdPtr, xbdTailPtrPtr);
    return;
    
  default:
    print("makeXbdListFromRestOfMsg: unrecognized Msg tag\n");
    return;
    
E 3
  }
D 3

E 3
I 3
  
E 3
}				/* end makeXbdListFromRestOfMsg */


D 3




E 3
/*
 * makeXbdListFromMsg
 *
 * Fill a linked list of xmit buffer descriptors
D 3
 * with buffers containing the data from the input MSG.
E 3
I 3
 * with buffers containing the data from the input Msg.
E 3
 * Perform padding if necessary.
 */
D 2
xmitBufDesc_t *
E 2
I 2
D 3
MSG
E 2
              makeXbdListFromMsg(msg, xbdHeadPtr, firstChunk)
    MSG msg;
    xmitBufDesc_t *xbdHeadPtr;
    char *firstChunk;
E 3
I 3

Msg  makeXbdListFromMsg(msg, xbdHeadPtr, firstChunk)
     Msg msg;
     xmitBufDesc_t *xbdHeadPtr;
     char *firstChunk;
E 3
{
  xmitBufDesc_t *xbdTailPtr;
D 3

E 3
I 3
  
E 3
  int slen, blen;
D 3

E 3
I 3
  
E 3
  slen = msg_stack_len(msg);
  blen = msg_data_len(msg);
  if (slen > 0 && blen > 0 && slen < MIN_FIRST_CHUNK) {
    int size = slen + blen;
    if (size > MIN_FIRST_CHUNK) size = MIN_FIRST_CHUNK;
    
    msg_peek(msg, 0, size, firstChunk);
    INIT_XBD(xbdHeadPtr, firstChunk, size);
    TRACE1(ie, 5, "First chunk %d\n", size);
    xbdTailPtr = xbdHeadPtr;
    xbdHeadPtr = xbdHeadPtr->nextXbdPtr;
    msg = msg_truncateleft(msg, size);
    blen = msg_data_len(msg);
  }
  else if (slen > 0) {
    INIT_XBD(xbdHeadPtr, msg_top(msg, slen), slen);
    TRACE1(ie, 5, "First chunk %d\n", slen);
    xbdTailPtr = xbdHeadPtr;
    xbdHeadPtr = xbdHeadPtr->nextXbdPtr;
  }
  if (blen > 0) {
    makeXbdListFromRestOfMsg(msg.data, 0, blen,
			     xbdHeadPtr, &xbdTailPtr);
  }
  if (msg_len(msg) < MIN_ETH_DATA_SZ) {
    /* need to pad;  controller doesn't do this automatically */
#ifdef DOITRIGHT
    /* put an extra Xmit Buf Desc describing some padding on end of list */
    static char paddingBuf[MIN_ETH_DATA_SZ];	/* shared by all xmit cmds */
D 3

E 3
I 3
    
E 3
    xbdTailPtr = xbdTailPtr->nextXbdPtr;
    INIT_XBD(xbdTailPtr, &paddingBuf[0], MIN_ETH_DATA_SZ - msg_len(msg));
#else
    /* Lie about the length of the last fragment */
    xbdTailPtr->bufSzLoByte += (MIN_ETH_DATA_SZ - msg_len(msg));
#endif
  }
  xbdTailPtr->lastXbdOfCmd = TRUE;
D 2

E 2
I 2
  return msg;
E 2
}				/* end makeXbdListFromMsg */


D 3




E 3
/*
 * printXmitErrs
 */
I 3

E 3
printXmitErrs(xmitCmdPtr)
D 3
    cmd_t *xmitCmdPtr;
E 3
I 3
     cmd_t *xmitCmdPtr;
E 3
{
D 3

E 3
I 3
  
E 3
  printf("Transmission failed %4x",
	 *(short *) &xmitCmdPtr->prefix);
D 3
  printf(" %d collisions", (xmitCmdPtr->prefix.tooManyCollisions && (xmitCmdPtr->prefix.numCollisions == 0)) ? 16 : xmitCmdPtr->prefix.numCollisions);
E 3
I 3
  printf(" %d collisions", 
	 (xmitCmdPtr->prefix.tooManyCollisions && 
	 (xmitCmdPtr->prefix.numCollisions == 0)) 
	 ? 16 : xmitCmdPtr->prefix.numCollisions);
E 3
  if (xmitCmdPtr->prefix.cmdAborted)
    printf(" aborted");
  if (xmitCmdPtr->prefix.noCarrier)
    printf(" no carrier sense");
  if (xmitCmdPtr->prefix.lostClearToSend)
    printf(" no clear to send");
  if (xmitCmdPtr->prefix.dmaUnderrun) {
    printf(" dma underrun");
    printSizes(xmitCmdPtr->extra.xbdHeadPtr);
  }
  if (xmitCmdPtr->prefix.xmitDeferred)
    printf(" defered");
  if (!xmitCmdPtr->prefix.heartbeat)
    printf(" heart beat");
  if (xmitCmdPtr->prefix.tooManyCollisions)
    printf(" too many collisions");
  printf("\n");
}

I 3

E 3
printSizes(t)
D 3
xmitBufDesc_t *t;
E 3
I 3
     xmitBufDesc_t *t;
E 3
{
  while (1) {
    printf(" %d", CAT_BYTES(t->bufSzHiByte, t->bufSzLoByte));
    if (t->lastXbdOfCmd) break;
    t = t->nextXbdPtr;
  }
}
I 3

E 3
E 1
