h17494
s 00072/00107/00284
d D 1.3 91/01/10 10:52:30 llp 3 2
c Prepared for 3.1 Distribution
e
s 00027/00002/00364
d D 1.2 90/11/30 14:12:01 menze 2 1
c Added several noops to the handleCuLeavingActiveState interrupt 
c handler.  This seems to correct a problem where transmission stops when 
c packets are sent to the driver too quickly.
c 
c Also added some diagnostic statements (surrounded by #ifdefs)
e
s 00366/00000/00000
d D 1.1 90/11/30 13:52:59 menze 1 0
c date and time created 90/11/30 13:52:59 by menze
e
u
U
f e 0
t
T
I 1
D 3

/*
E 3
I 3
/* 
E 3
 * intelEthCmd.c
 *
D 3
 * Functions revolving around the Intel ethernet controller's Command Unit (cu),
 * except transmission-specific stuff is in intelEthXmit.c
E 3
I 3
 * x-kernel v3.1	12/10/90
E 3
 *
D 3
 * Mark Abbott, Spring 89
E 3
I 3
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 3
 */

I 3
/*
 * Functions revolving around the Intel ethernet controller's 
 * Command Unit (cu), except transmission-specific stuff is in 
 * intelEthXmit.c
 *
 */
E 3

D 3
#include "upi.h"
#include "process.h"
#include "assert.h"
#include "xType.h"
E 3
I 3
#include "xkernel.h"
E 3
#include "eth.h"
#include "intelEthType.h"
#include "intelEthRcv.h"
#include "intelEthCmd.h"
#include "intelEth.h"

D 3



E 3
Semaphore FreeCmdCntSem;
cmd_t *NextFreeCmdPtr;

D 2
static boolean CuKnownNotActive;
E 2
I 2
boolean CuKnownNotActive;
E 2


D 3





E 3
/*
 * initCmd
 *
 * Initialize the data structures for issuing action commands.
 */
I 3

E 3
initCmd()
{
  unsigned xbdIx;		/* xmit buf desc index */
  unsigned cmdIx, nextCmdIx;	/* indices of command blocks */
D 3


E 3
I 3
  
  
E 3
  TRACE0(ie, 5, "initCmd");
D 3

E 3
I 3
  
E 3
  /*
   * Initialize the list of free command blocks. The command blocks are
   * linked in a ring, and they will always be allocated, posted, used, and
   * freed in ring order. Each command block has a linked list of xmit buffer
   * descriptors permanently associated with it, for those occasions when it
   * is instantiated as an xmit command.
   */
D 3

E 3
I 3
  
E 3
  /* make the xmit buf desc array into a bunch of linked lists */
  for (xbdIx = 0; xbdIx < NUM_XBDS; xbdIx++) {
    if ((xbdIx % XBDS_PER_CMD) == (XBDS_PER_CMD - 1)) {
      /* terminate a linked list */
      XmitBufDescArray[xbdIx].lastXbdOfCmd = TRUE;
      XmitBufDescArray[xbdIx].nextXbdPtr = NULL;
      XmitBufDescArray[xbdIx].nextXbdOffset = NULL_IE_OFFSET;
    } else {
      /* link to successor */
      XmitBufDescArray[xbdIx].lastXbdOfCmd = FALSE;
      XmitBufDescArray[xbdIx].nextXbdPtr = &XmitBufDescArray[xbdIx + 1];
      XmitBufDescArray[xbdIx].nextXbdOffset =
	IE_OFFSET_FROM_AD(&XmitBufDescArray[xbdIx + 1]);
    }
  }
D 3

E 3
I 3
  
E 3
  /* make the command block array into a ring, and associate xbd lists */
  for (cmdIx = 0; cmdIx < 2 * NUM_CMD_BLKS; cmdIx++) {
D 3

E 3
I 3
    
E 3
    nextCmdIx = (cmdIx + 1) % (2 * NUM_CMD_BLKS);	/* wrap around */
    CmdBlkArray[cmdIx].extra.nextCmdPtr = &CmdBlkArray[nextCmdIx];
    CmdBlkArray[cmdIx].prefix.nextCmdOffset =
      IE_OFFSET_FROM_AD(&CmdBlkArray[nextCmdIx]);
    CmdBlkArray[nextCmdIx].extra.prevCmdPtr = &CmdBlkArray[cmdIx];
    if (cmdIx % 2 == 0) {
      CmdBlkArray[cmdIx].extra.xbdHeadPtr =
	&XmitBufDescArray[cmdIx / 2 * XBDS_PER_CMD];
      CmdBlkArray[cmdIx].extra.firstChunk = malloc(MIN_FIRST_CHUNK);
    } else {
      CmdBlkArray[cmdIx].prefix.cmdKind = NOOP_CMD;
    }
  }
D 3

E 3
I 3
  
E 3
  NextFreeCmdPtr = &CmdBlkArray[0];	/* head of free cmd list */
  /* all cmds are free (except always keep one unallocated to avoid danger?) */
  InitSemaphore(&FreeCmdCntSem, NUM_CMD_BLKS - 1);
  SCB.cmdHeadOffset = NULL_IE_OFFSET;
  CuKnownNotActive = TRUE;
D 3

E 3
I 3
  
E 3
}				/* end initCmd */


D 3






E 3
/*
 * postCmd
 */
I 3

E 3
postCmd(cmdPtr)
D 3
    cmd_t *cmdPtr;
E 3
I 3
     cmd_t *cmdPtr;
E 3
{
  int origPrioLevel;
D 3


E 3
I 3
  
  
E 3
  TRACE0(ie, 5, "postCmd");
D 3

E 3
I 3
  
E 3
  /* add the new command to the "posted" list (the link is already there!) */
  cmdPtr->extra.nextCmdPtr->prefix.lastPostedCmd = TRUE;
  cmdPtr->extra.prevCmdPtr->prefix.lastPostedCmd = FALSE;
D 3

E 3
I 3
  
E 3
  /* start the Command Unit if known to have left active state */
  /*
   * mask interrupts to protect critical section;
   * handleCuLeavingActiveState() plays with same stuff.
   */
  origPrioLevel = spl7();
  if (CuKnownNotActive) {
#ifndef NDEBUG
    nCUStarts++;
    IFTRACE(ie, 2) putchar('a');
#endif
    TRACE0(ie, 5, "postCmd: putting Cmd Unit in active state");
    SCB.cmdHeadOffset = IE_OFFSET_FROM_AD(cmdPtr);
    SCB.cmdUnitCtlCmd = CU_START;
    CuKnownNotActive = FALSE;
    ALERT_IE_DEV();
  } else {
I 2
#ifdef ETH_OPT_TRACE
    putchar('A');
#endif
E 2
#ifndef NDEBUG
    nCUContinues++;
    IFTRACE(ie, 2) putchar('A');
#endif
    TRACE0(ie, 5, "postCmd: Cmd Unit may be in active state");
    /* if not active, will catch on and start CU when handle intr */
  }
  splx(origPrioLevel);
D 3

E 3
I 3
  
E 3
}				/* end postCmd */


D 3




E 3
/*
 * informIeDevLocalEthAd
 */
I 3

E 3
informIeDevLocalEthAd(localEthAd)
D 3
    ethAd_t localEthAd;
E 3
I 3
     ethAd_t localEthAd;
E 3
{
  cmd_t *cmdPtr;
D 3


E 3
I 3
  
E 3
  TRACE3(ie, 5, "informIeDevLocalEthAd: localEthAd = %x.%x.%x",
	 localEthAd.high, localEthAd.mid, localEthAd.low);
D 3

E 3
I 3
  
E 3
  ALLOC_CMD(cmdPtr);
D 3

E 3
I 3
  
E 3
  cmdPtr->prefix.cmdKind = INDIV_AD_SETUP_CMD;
  cmdPtr->suffix.indivAd.localEthAd = localEthAd;
D 3

E 3
I 3
  
E 3
  postCmd(cmdPtr);
D 3

E 3
I 3
  
E 3
}				/* end informIeDevLocalEthAd */


D 3




E 3
/*
 * configIeDev
 */
I 3

E 3
configIeDev(promiscMode)
D 3
int			promiscMode;
E 3
I 3
     int			promiscMode;
E 3
{
  cmd_t *cmdPtr;
D 3


E 3
I 3
  
E 3
  TRACE0(ie, 5, "configIeDev");
D 3

E 3
I 3
  
E 3
  ALLOC_CMD(cmdPtr);
D 3

E 3
I 3
  
E 3
  cmdPtr->prefix.cmdKind = CONFIG_CMD;
  cmdPtr->suffix.config.promiscMode = promiscMode;
D 3

E 3
I 3
  
E 3
  cmdPtr->suffix.config.bcnt = 12;
  cmdPtr->suffix.config.fifo = 12;
  cmdPtr->suffix.config.svbf = 0;
  cmdPtr->suffix.config.ext_lpb = 0;
  cmdPtr->suffix.config.int_lpb = 0;
  cmdPtr->suffix.config.srdy = 0;
  cmdPtr->suffix.config.pream_len = 2;
  cmdPtr->suffix.config.al_loc = 0;
  cmdPtr->suffix.config.addr_len = 6;
  cmdPtr->suffix.config.bof_met = 0;
  cmdPtr->suffix.config.acr = 0;
  cmdPtr->suffix.config.lin_prio = 0;
  cmdPtr->suffix.config.frame_sp = 96;
  cmdPtr->suffix.config.slot_timel = LO_BYTE_OF_2(512);
  cmdPtr->suffix.config.retry_num = 15;
  cmdPtr->suffix.config.slot_timeh = HI_BYTE_OF_2(512);
  cmdPtr->suffix.config.pad = 0;
  cmdPtr->suffix.config.bt_stf = 0;
  cmdPtr->suffix.config.crc_16 = 0;
  cmdPtr->suffix.config.ncrc = 0;
  cmdPtr->suffix.config.tono_crc = 0;
  cmdPtr->suffix.config.man = 0;
  cmdPtr->suffix.config.bc_dis = 0;
  cmdPtr->suffix.config.cdt_src = 0;
  cmdPtr->suffix.config.cdtf = 0;
  cmdPtr->suffix.config.crs_src = 0;
  cmdPtr->suffix.config.crsf = 3;
  cmdPtr->suffix.config.min_frm = 64;
D 3

E 3
I 3
  
E 3
  postCmd(cmdPtr);
D 3

E 3
I 3
  
E 3
}				/* end configIeDev */


D 3















E 3
/*
 * handleCuLeavingActiveState
 */
I 3

E 3
handleCuLeavingActiveState()
{
D 3
/*
 *static boolean			firstTimeCuLeftActiveState = TRUE;
 */
E 3
I 3
  /*
   *static boolean		firstTimeCuLeftActiveState = TRUE;
   */
E 3
  cmd_t *doneCmdHeadPtr;
  cmd_t *cmdPtr;
  cmd_t *lastCmdPtr;
D 3


E 3
I 3
  
E 3
#ifndef NDEBUG
  nCULeavingActives++;
  IFTRACE(ie, 2) putchar('I');
#endif
  SCB.ackCuLeftActiveState = 1;
  ALERT_IE_DEV();
D 3

E 3
I 3
  
E 3
  TRACE0(ie, 5, "handleCuLeavingActiveState");
D 3


E 3
I 3
  
E 3
  CuKnownNotActive = TRUE;
D 3


E 3
I 3
  
E 3
  /*
   * ignore the very first Cmd-Unit-left-active-state interrupt (happens when
   * start the ie dev?)
   */
D 3
/*
 *	if( firstTimeCuLeftActiveState ){
 *		firstTimeCuLeftActiveState = FALSE;
 *		TRACE0(ie,5,"handleCuLeavingActiveState: ignoring first call");
 *		SCB.ackCuLeftActiveState = 1;
 *		SCB.cmdUnitCtlCmd = CU_NOP;
 *		ALERT_IE_DEV();
 *		return;
 *	}
 */
E 3

D 3

E 3
  /*
I 3
   *	if( firstTimeCuLeftActiveState ){
   *		firstTimeCuLeftActiveState = FALSE;
   *		TRACE0(ie,5,"handleCuLeavingActiveState: ignoring first call");
   *		SCB.ackCuLeftActiveState = 1;
   *		SCB.cmdUnitCtlCmd = CU_NOP;
   *		ALERT_IE_DEV();
   *		return;
   *	}
   */
  
  /*
E 3
   * check whether there are any posted commands
   */
I 3

E 3
  if (SCB.cmdHeadOffset == NULL_IE_OFFSET) {
    /* interrupt corresponding to stuff that was already handled? */
    TRACE0(ie, 1,
	   "handleCu...:Cmd Unit left active state, but no cmd blk list!");
D 3
/*		SCB.cmdUnitCtlCmd = CU_SUSPEND;	/* why not just leave IDLE? */
E 3
I 3
    /*		SCB.cmdUnitCtlCmd = CU_SUSPEND;	/* why not just leave IDLE? */
E 3
    return;
  }
I 3

E 3
  /*
   * There are posted commands, some of which may be done.
   */
D 3


E 3
I 3
  
E 3
  /*
   * Restart the Command Unit at the next pending command, if there is one.
   */
D 3

E 3
I 3
  
E 3
  doneCmdHeadPtr = (cmd_t *) AD_FROM_IE_OFFSET(SCB.cmdHeadOffset);
  cmdPtr = doneCmdHeadPtr;
  while (cmdPtr->prefix.cmdDone) {
    cmdPtr = cmdPtr->extra.nextCmdPtr->extra.nextCmdPtr;
  }
D 3

E 3
I 3
  
E 3
  /*
   * cmdPtr->extra.prevCmdPtr now points to the last command done, and cmdPtr
   * points to the next command to be done (which may or may not have been
   * allocated/instantiated/posted yet).
   */
  if (cmdPtr->extra.prevCmdPtr->prefix.lastPostedCmd) {
    /* last one done was also last one posted, so no cmds are pending */
I 2
#ifdef ETH_OPT_TRACE
    putchar('d');
#endif
E 2
#ifndef NDEBUG
    nCUNoCommandsPending++;
    IFTRACE(ie, 2) putchar('d');
#endif
    TRACE0(ie, 5, "handleCuLeaving...: no commands pending");
    SCB.cmdHeadOffset = NULL_IE_OFFSET;
D 3
/*		SCB.cmdUnitCtlCmd = CU_SUSPEND;	/* why not just leave IDLE? */
E 3
I 3
    /*		SCB.cmdUnitCtlCmd = CU_SUSPEND;	/* why not just leave IDLE? */
E 3
  } else {
    /*
     * cmds were posted too late to be seen by the Cmd Unit, i.e. after the
     * CU had already seen a lastPostedCmd
     */
I 2
D 3
/*    putchar('D'); */
E 3
I 3
    /*    putchar('D'); */
E 3
E 2
#ifndef NDEBUG
    nCUCommandsPending++;
    IFTRACE(ie, 2) putchar('D');
#endif
    TRACE0(ie, 5, "handleCuLeaving...: there are pending commands");
I 2
#if 0
    if (cmdPtr->prefix.cmdKind != XMIT_CMD ||
	cmdPtr->prefix.cmdDone ||
	cmdPtr->prefix.lastPostedCmd) putchar('!');
#else
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
#endif
E 2
    SCB.cmdHeadOffset = IE_OFFSET_FROM_AD(cmdPtr);
    SCB.cmdUnitCtlCmd = CU_START;
    CuKnownNotActive = FALSE;
    ALERT_IE_DEV();
D 2

E 2
I 2
#ifdef ETH_OPT_TRACE
    putchar('D');
#endif
E 2
  }
D 3

E 3
I 3
  
E 3
  /*
   * Clean up the done commands.
   */
D 3

E 3
I 3
  
E 3
  /*
   * pay the price of following these links twice, to get the parallelism of
   * restarting the CU as soon as possible.
   */
  lastCmdPtr = cmdPtr;
  cmdPtr = doneCmdHeadPtr;
  while (cmdPtr != lastCmdPtr && cmdPtr->prefix.cmdDone) {
D 3

E 3
I 3
    
E 3
    if (cmdPtr->prefix.cmdKind == XMIT_CMD) {
      if (!cmdPtr->prefix.cmdSuccessful) {
	printXmitErrs(cmdPtr);
      }
      msg_free(cmdPtr->suffix.xmit.msg);
    }
    cmdPtr->prefix.cmdDone = FALSE;
    cmdPtr->extra.nextCmdPtr->prefix.cmdDone = FALSE;
    cmdPtr = cmdPtr->extra.nextCmdPtr->extra.nextCmdPtr;
    FREE_CMD;
  }
D 3

E 3
I 3
  
E 3
}				/* end handleCuLeavingActiveState */
E 1
