h65446
s 00043/00080/00120
d D 1.2 91/01/10 10:52:29 llp 2 1
c Prepared for 3.1 Distribution
e
s 00200/00000/00000
d D 1.1 90/11/30 13:52:58 menze 1 0
c date and time created 90/11/30 13:52:58 by menze
e
u
U
f e 0
t
T
I 1
D 2
/*
E 2
I 2
/* 
E 2
 * intelEth.h
 *
D 2
 * Intel 82586 Ethernet controller info.
E 2
I 2
 * x-kernel v3.1	12/10/90
E 2
 *
D 2
 * "ie" (for Intel Ethernet) refers to
 * the Intel ethernet controller layer (or abstraction).
 *
 * "dev" refers to the actual hardware device.
 *
 * Mark Abbott, Spring 89
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

/*
 * depends on:
 *		eth.h			- controller-independent ethernet stuff
 *		intelEthType.h		- some types needed by the ie dev
 *		intelEthRcv.h		- info related to ie Receive Unit
 *		intelEthCmd.h		- info related to ie Command Unit
 */

D 2

E 2
#define volatile 

#ifndef memory_h
D 2
#	include "memory.h"
E 2
I 2
#include "memory.h"
E 2
#endif

D 2





E 2
extern int traceethp;
extern int handleIeIntrAsm();

#define	IE_INTR_NUM		INT3


D 2




E 2
/*
 * some delay times (?)
 */
#define SECS400		0x0affffff /* 400 secs delay */
#define SECS2		(SECS400/200)	/* 2 secs delay	 */
#define SECSPOINT02	(SECS2/100)	/* 0.02 secs delay */


D 2



E 2
/*
 * Ie Device Control Register
 */
#define	IE_CTL_REG 		(* (volatile u_char*) 0x0FE0C000)
#define	IE_CTL_REG_CHAN_ATTN	0x20	/* channel attention : normal 0	 */
#define	IE_CTL_REG_LOOPBACK	0x40	/* loop back : normal 1 */
#define	IE_CTL_REG_RESET	0x80	/* reset : normal 1	 */
#define	IE_CTL_REG_INTR_ENABLE	0x10	/* interrupt enable : normal 0 */
#define	IE_CTL_REG_INTR_PEND	0x01	/* interrupt pending : normal 0	 */

#define ALERT_IE_DEV()	{\
D 2
		IE_CTL_REG = IE_CTL_REG_CHAN_ATTN\
				+ IE_CTL_REG_LOOPBACK\
				+ IE_CTL_REG_RESET\
				+ IE_CTL_REG_INTR_ENABLE;\
		nop();\
		nop();\
		nop();\
		nop();\
		nop();\
		IE_CTL_REG = IE_CTL_REG_LOOPBACK\
				+ IE_CTL_REG_RESET\
				+ IE_CTL_REG_INTR_ENABLE;\
		}
E 2
I 2
			   IE_CTL_REG = IE_CTL_REG_CHAN_ATTN\
			     + IE_CTL_REG_LOOPBACK\
			       + IE_CTL_REG_RESET\
				 + IE_CTL_REG_INTR_ENABLE;\
				   nop();\
				     nop();\
				       nop();\
					 nop();\
					   nop();\
					     IE_CTL_REG = IE_CTL_REG_LOOPBACK\
					       + IE_CTL_REG_RESET\
						 + IE_CTL_REG_INTR_ENABLE;\
						 }
E 2



D 2




E 2
/*
 * Initialization Root
 */
typedef struct {
  char busKind;			/* 0 => 16 bit bus; 1 => 8 bit bus */
  char unused[5];
  ieAd_t intermInitRootAd;
}      initRoot_t;


/* the ie dev looks for the initialization root at this magic address */
#define	InitRoot	(* (initRoot_t*) 0xfffffff6)


D 2


E 2
/*
 * Intermediate Initialization Root
 */
typedef struct {
  char initInProgress;		/* initialization in progress */
  char unused;
  ieOffset_t scbOffset;		/* scb offset in ieSharedMem */
  ieAd_t ieSharedMemAd;		/* base ad for ieSharedMem */
}      intermInitRoot_t;


D 2



E 2
/*
 * System Control Block
 */
typedef struct {
D 2
  unsigned:1;			/* must be 0 */
  unsigned rcvUnitStatus:3;
  unsigned:4;			/* must be 0 */
  unsigned cmdDone:1;
  unsigned frameRcvd:1;
  unsigned cuLeftActiveState:1;
  unsigned ruNotReady:1;
  unsigned:1;			/* must be 0 */
  unsigned cmdUnitStatus:3;
  unsigned resetCtlr:1;		/* reset chip ? */
  unsigned rcvUnitCtlCmd:3;
  unsigned:4;			/* unused */
  unsigned ackCmdDone:1;	/* ack command executed */
  unsigned ackFrameRcvd:1;	/* ack frame recd event */
  unsigned ackCuLeftActiveState:1;
  unsigned ackRuNotReady:1;
  unsigned:1;			/* not used */
  unsigned cmdUnitCtlCmd:3;
  ieOffset_t cmdHeadOffset;
  ieOffset_t rcvFrameDescHeadOffset;
  u_short crcErrCnt;		/* cumulative? */
  u_short alignErrCnt;		/* cumulative? */
  u_short rsrcErrCnt;		/* cumulative? */
  u_short overrunErrCnt;	/* cumulative? */
}      sysCtlBlk_t;
E 2
I 2
 unsigned:1;			/* must be 0 */
   unsigned rcvUnitStatus:3;
 unsigned:4;			/* must be 0 */
   unsigned cmdDone:1;
   unsigned frameRcvd:1;
   unsigned cuLeftActiveState:1;
   unsigned ruNotReady:1;
 unsigned:1;			/* must be 0 */
   unsigned cmdUnitStatus:3;
   unsigned resetCtlr:1;		/* reset chip ? */
   unsigned rcvUnitCtlCmd:3;
 unsigned:4;			/* unused */
   unsigned ackCmdDone:1;	/* ack command executed */
   unsigned ackFrameRcvd:1;	/* ack frame recd event */
   unsigned ackCuLeftActiveState:1;
   unsigned ackRuNotReady:1;
 unsigned:1;			/* not used */
   unsigned cmdUnitCtlCmd:3;
   ieOffset_t cmdHeadOffset;
   ieOffset_t rcvFrameDescHeadOffset;
   u_short crcErrCnt;		/* cumulative? */
   u_short alignErrCnt;		/* cumulative? */
   u_short rsrcErrCnt;		/* cumulative? */
   u_short overrunErrCnt;	/* cumulative? */
 }      sysCtlBlk_t;
E 2

D 2



E 2
/*
 * sizes of arrays in the shared memory area
 */
#define	NUM_RFDS		64	/* from old version */
#define	NUM_RBDS		NUM_RFDS
#define	NUM_CMD_BLKS		32	/* from old version */
#define XBDS_PER_CMD		12	/* just made it up; Sean may need
					 * more */
#define	NUM_XBDS		(XBDS_PER_CMD*NUM_CMD_BLKS)


D 2




E 2
/*
 * memory area shared between ie dev and cpu
 *
 * Must all be within a 64K address space (except interm init root?)
 *
 * cmdBlkArray is 2 * NUM_CMD_BLKS because I put a noop after each real command
 */
typedef struct {
  sysCtlBlk_t sysCtlBlk;
  rcvFrameDesc_t rcvFrameDescArray[NUM_RFDS];
  rcvBufDesc_t rcvBufDescArray[NUM_RBDS];
  cmd_t cmdBlkArray[2 * NUM_CMD_BLKS];
  xmitBufDesc_t xmitBufDescArray[NUM_XBDS];
}      ieSharedMem_t;


D 2


E 2
/*
 * locate the shared space at ENET_DATA_SEG, defined in sun3mem.h
 */
#define	IeSharedMemPtr 	((volatile ieSharedMem_t *) ENET_DATA_SEG)


D 2


E 2
/*
 * convenient aliases for the shared memory areas
 */
#define	SCB			(IeSharedMemPtr->sysCtlBlk)
#define	RcvFrameDescArray 	(IeSharedMemPtr->rcvFrameDescArray)
#define	RcvBufDescArray	 	(IeSharedMemPtr->rcvBufDescArray)
#define	CmdBlkArray	 	(IeSharedMemPtr->cmdBlkArray)
#define	XmitBufDescArray	(IeSharedMemPtr->xmitBufDescArray)


extern int nCUNoCommandsPending, nCUCommandsPending, nCUStarts, nCUContinues, nCULeavingActives, nCUXmits;
I 2

E 2
E 1
