# common.mak --
#
# This is the common part shared by the Jacl and Tcl Blend
# makefile.vc's
#
# Copyright (c) 1997 Sun Microsystems, Inc. All rights reserved.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# SCCS: @(#) common.mak 1.35 98/02/13 16:36:54

#----------------------------------------------------------------------
# Definitions for relative paths
#----------------------------------------------------------------------

COMMON_JAVA_DIR = ..\src\common
DEMO_JAVA_DIR	= ..\demos
JAVA_JAVA_DIR	= ..\src\java
NATIVE_JAVA_DIR	= ..\src\native
TEST_JAVA_DIR	= ..\src\tests
TEST_CLASS_DIR	= $(TCLJAVA)\tests
GENERIC_DIR	= ..\generic
WIN_DIR		= ..\win
LIB_SRC_DIR	= $(JAVA_JAVA_DIR)\tcl\lang\library
LIB_DST_DIR	= $(TCLJAVA)\tcl\lang\library

#----------------------------------------------------------------------
# Definitions for compilation targets
#----------------------------------------------------------------------

COMMON_CLASSES = \
        $(TCLJAVA)\tcl\lang\ArrayObject.class \
        $(TCLJAVA)\tcl\lang\AdaptorClassLoader.class \
        $(TCLJAVA)\tcl\lang\AdaptorGen.class \
	$(TCLJAVA)\tcl\lang\AssocData.class \
        $(TCLJAVA)\tcl\lang\BeanEvent.class \
        $(TCLJAVA)\tcl\lang\BeanEventMgr.class \
        $(TCLJAVA)\tcl\lang\BeanEventParamSet.class \
	$(TCLJAVA)\tcl\lang\BlendExtension.class \
	$(TCLJAVA)\tcl\lang\ClassRep.class \
	$(TCLJAVA)\tcl\lang\Command.class \
	$(TCLJAVA)\tcl\lang\CommandWithDispose.class \
	$(TCLJAVA)\tcl\lang\Extension.class \
        $(TCLJAVA)\tcl\lang\EventAdaptor.class \
	$(TCLJAVA)\tcl\lang\EventDeleter.class \
	$(TCLJAVA)\tcl\lang\FuncSig.class \
	$(TCLJAVA)\tcl\lang\FieldSig.class \
	$(TCLJAVA)\tcl\lang\InternalRep.class \
	$(TCLJAVA)\tcl\lang\JavaInvoke.class \
	$(TCLJAVA)\tcl\lang\JavaBindCmd.class \
	$(TCLJAVA)\tcl\lang\JavaCallCmd.class \
	$(TCLJAVA)\tcl\lang\JavaDefineClassCmd.class \
        $(TCLJAVA)\tcl\lang\JavaEventCmd.class \
	$(TCLJAVA)\tcl\lang\JavaFieldCmd.class \
	$(TCLJAVA)\tcl\lang\JavaGetInterpCmd.class \
	$(TCLJAVA)\tcl\lang\JavaInstanceofCmd.class \
	$(TCLJAVA)\tcl\lang\JavaInfoCmd.class \
	$(TCLJAVA)\tcl\lang\JavaIsNullCmd.class \
	$(TCLJAVA)\tcl\lang\JavaLoadCmd.class \
	$(TCLJAVA)\tcl\lang\JavaNewCmd.class \
	$(TCLJAVA)\tcl\lang\JavaNullCmd.class \
	$(TCLJAVA)\tcl\lang\JavaPropCmd.class \
	$(TCLJAVA)\tcl\lang\JavaThrowCmd.class \
	$(TCLJAVA)\tcl\lang\ReflectException.class \
        $(TCLJAVA)\tcl\lang\ReflectObject.class \
	$(TCLJAVA)\tcl\lang\PropertySig.class \
	$(TCLJAVA)\tcl\lang\TCL.class \
	$(TCLJAVA)\tcl\lang\TclBoolean.class \
	$(TCLJAVA)\tcl\lang\TclClassLoader.class \
	$(TCLJAVA)\tcl\lang\TclDouble.class \
	$(TCLJAVA)\tcl\lang\TclException.class \
	$(TCLJAVA)\tcl\lang\TclEvent.class \
	$(TCLJAVA)\tcl\lang\TclIndex.class \
	$(TCLJAVA)\tcl\lang\TclInteger.class \
	$(TCLJAVA)\tcl\lang\TclNumArgsException.class \
	$(TCLJAVA)\tcl\lang\TclPosixException.class \
	$(TCLJAVA)\tcl\lang\TclObject.class \
	$(TCLJAVA)\tcl\lang\TclRuntimeError.class \
	$(TCLJAVA)\tcl\lang\TclString.class \
	$(TCLJAVA)\tcl\lang\VarTrace.class 

NATIVE_CLASSES = \
	$(TCLJAVA)\tcl\lang\CObject.class \
	$(TCLJAVA)\tcl\lang\IdleHandler.class \
	$(TCLJAVA)\tcl\lang\Interp.class \
	$(TCLJAVA)\tcl\lang\NativeLock.class \
	$(TCLJAVA)\tcl\lang\Notifier.class \
	$(TCLJAVA)\tcl\lang\TclList.class \
	$(TCLJAVA)\tcl\lang\TimerHandler.class \
	$(TCLJAVA)\tcl\lang\Util.class

JAVA_CLASSES = \
	$(TCLJAVA)\tcl\lang\AfterCmd.class \
	$(TCLJAVA)\tcl\lang\AppendCmd.class \
	$(TCLJAVA)\tcl\lang\ArrayCmd.class \
        $(TCLJAVA)\tcl\lang\BackSlashResult.class \
        $(TCLJAVA)\tcl\lang\BgErrorMgr.class \
	$(TCLJAVA)\tcl\lang\Interp.class \
	$(TCLJAVA)\tcl\lang\BreakCmd.class \
	$(TCLJAVA)\tcl\lang\CallFrame.class \
	$(TCLJAVA)\tcl\lang\CaseCmd.class \
	$(TCLJAVA)\tcl\lang\CatchCmd.class \
	$(TCLJAVA)\tcl\lang\CdCmd.class \
        $(TCLJAVA)\tcl\lang\Channel.class \
        $(TCLJAVA)\tcl\lang\CharPointer.class \
	$(TCLJAVA)\tcl\lang\CloseCmd.class \
        $(TCLJAVA)\tcl\lang\CObject.class \
	$(TCLJAVA)\tcl\lang\ContinueCmd.class \
	$(TCLJAVA)\tcl\lang\ConcatCmd.class \
	$(TCLJAVA)\tcl\lang\ConsoleEvent.class \
        $(TCLJAVA)\tcl\lang\DebugInfo.class \
	$(TCLJAVA)\tcl\lang\Env.class \
	$(TCLJAVA)\tcl\lang\EofCmd.class \
	$(TCLJAVA)\tcl\lang\ErrorCmd.class \
	$(TCLJAVA)\tcl\lang\EvalCmd.class \
	$(TCLJAVA)\tcl\lang\ExecCmd.class \
	$(TCLJAVA)\tcl\lang\ExitCmd.class \
	$(TCLJAVA)\tcl\lang\ExprCmd.class \
        $(TCLJAVA)\tcl\lang\Expression.class \
        $(TCLJAVA)\tcl\lang\ExprValue.class \
	$(TCLJAVA)\tcl\lang\FblockedCmd.class \
	$(TCLJAVA)\tcl\lang\FconfigureCmd.class \
	$(TCLJAVA)\tcl\lang\FileChannel.class \
	$(TCLJAVA)\tcl\lang\FileCmd.class \
	$(TCLJAVA)\tcl\lang\FileUtil.class \
        $(TCLJAVA)\tcl\lang\FindElemResult.class \
	$(TCLJAVA)\tcl\lang\FlushCmd.class \
	$(TCLJAVA)\tcl\lang\ForCmd.class \
	$(TCLJAVA)\tcl\lang\ForeachCmd.class \
	$(TCLJAVA)\tcl\lang\FormatCmd.class \
	$(TCLJAVA)\tcl\lang\GetsCmd.class \
	$(TCLJAVA)\tcl\lang\GlobalCmd.class \
	$(TCLJAVA)\tcl\lang\GlobCmd.class \
	$(TCLJAVA)\tcl\lang\IdleHandler.class \
	$(TCLJAVA)\tcl\lang\IfCmd.class \
	$(TCLJAVA)\tcl\lang\IncrCmd.class \
	$(TCLJAVA)\tcl\lang\InfoCmd.class \
	$(TCLJAVA)\tcl\lang\Interp.class \
	$(TCLJAVA)\tcl\lang\Notifier.class \
	$(TCLJAVA)\tcl\lang\JoinCmd.class \
	$(TCLJAVA)\tcl\lang\JACL.class \
	$(TCLJAVA)\tcl\lang\LappendCmd.class \
	$(TCLJAVA)\tcl\lang\LindexCmd.class \
	$(TCLJAVA)\tcl\lang\LinsertCmd.class \
	$(TCLJAVA)\tcl\lang\ListCmd.class \
	$(TCLJAVA)\tcl\lang\LlengthCmd.class \
	$(TCLJAVA)\tcl\lang\LrangeCmd.class \
	$(TCLJAVA)\tcl\lang\LreplaceCmd.class \
	$(TCLJAVA)\tcl\lang\LsearchCmd.class \
	$(TCLJAVA)\tcl\lang\LsortCmd.class \
	$(TCLJAVA)\tcl\lang\NamespaceCmd.class \
	$(TCLJAVA)\tcl\lang\OpenCmd.class \
	$(TCLJAVA)\tcl\lang\PackageCmd.class \
        $(TCLJAVA)\tcl\lang\ParseAdaptor.class \
        $(TCLJAVA)\tcl\lang\Parser.class \
        $(TCLJAVA)\tcl\lang\ParseResult.class \
        $(TCLJAVA)\tcl\lang\ParseResultVector.class \
        $(TCLJAVA)\tcl\lang\Procedure.class \
	$(TCLJAVA)\tcl\lang\ProcCmd.class \
	$(TCLJAVA)\tcl\lang\PutsCmd.class \
	$(TCLJAVA)\tcl\lang\PwdCmd.class \
        $(TCLJAVA)\tcl\lang\QSort.class \
	$(TCLJAVA)\tcl\lang\ReadCmd.class \
	$(TCLJAVA)\tcl\lang\RegexMatcher.class \
	$(TCLJAVA)\tcl\lang\RegexpCmd.class \
	$(TCLJAVA)\tcl\lang\RegsubCmd.class \
	$(TCLJAVA)\tcl\lang\RenameCmd.class \
	$(TCLJAVA)\tcl\lang\ReturnCmd.class \
	$(TCLJAVA)\tcl\lang\ScanCmd.class \
        $(TCLJAVA)\tcl\lang\SearchId.class \
	$(TCLJAVA)\tcl\lang\SeekCmd.class \
	$(TCLJAVA)\tcl\lang\SetCmd.class \
	$(TCLJAVA)\tcl\lang\Shell.class \
	$(TCLJAVA)\tcl\lang\SocketCmd.class \
	$(TCLJAVA)\tcl\lang\SourceCmd.class \
	$(TCLJAVA)\tcl\lang\SplitCmd.class \
        $(TCLJAVA)\tcl\lang\StdChannel.class \
	$(TCLJAVA)\tcl\lang\StringCmd.class \
        $(TCLJAVA)\tcl\lang\StrtodResult.class \
        $(TCLJAVA)\tcl\lang\StrtoulResult.class \
	$(TCLJAVA)\tcl\lang\SubstCmd.class \
	$(TCLJAVA)\tcl\lang\SwitchCmd.class \
        $(TCLJAVA)\tcl\lang\TclIO.class \
        $(TCLJAVA)\tcl\lang\TclList.class \
        $(TCLJAVA)\tcl\lang\TclParse.class \
        $(TCLJAVA)\tcl\lang\TclToken.class \
        $(TCLJAVA)\tcl\lang\TclVarException.class \
	$(TCLJAVA)\tcl\lang\TellCmd.class \
	$(TCLJAVA)\tcl\lang\TimeCmd.class \
	$(TCLJAVA)\tcl\lang\TimerHandler.class \
	$(TCLJAVA)\tcl\lang\TraceCmd.class \
        $(TCLJAVA)\tcl\lang\TraceRecord.class \
	$(TCLJAVA)\tcl\lang\UnsetCmd.class \
	$(TCLJAVA)\tcl\lang\UpdateCmd.class \
	$(TCLJAVA)\tcl\lang\UplevelCmd.class \
	$(TCLJAVA)\tcl\lang\UpvarCmd.class \
        $(TCLJAVA)\tcl\lang\Util.class \
        $(TCLJAVA)\tcl\lang\Var.class \
	$(TCLJAVA)\tcl\lang\VwaitCmd.class \
	$(TCLJAVA)\tcl\lang\WhileCmd.class \
	$(TCLJAVA)\tcl\lang\Word.class

BEAN_CLASSES = \
	tclbean\tcl\bean\TclInterp.class \
	tclbean\tcl\bean\StudioTclPort.class \
	tclbean\tcl\bean\TclInterpBeanInfo.class \
	tclbean\tcl\bean\StudioTclInterp.class \
	tclbean\tcl\bean\StudioTclInterpCustomizer.class \
	tclbean\tcl\bean\StudioTclInterpVJComponentInfo.class

REGEXP_CLASSES = \
	$(TCLJAVA)\tcl\regex\OroRegexpCmd.class \
	$(TCLJAVA)\tcl\regex\OroRegsubCmd.class \
	$(TCLJAVA)\tcl\regex\OroRegexMatcher.class

DEMO_CLASSES = \
	$(DEMO_JAVA_DIR)\gluepkg\FileDialogApp.class \
	$(DEMO_JAVA_DIR)\gluepkg\FileDialogCmd.class \
	$(DEMO_JAVA_DIR)\gluepkg\GlueExtension.class \
	$(DEMO_JAVA_DIR)\gluepkg\JarCmd.class \
	$(DEMO_JAVA_DIR)\gluepkg\ListboxApp.class \
	$(DEMO_JAVA_DIR)\gluepkg\ListboxCmd.class \
	$(DEMO_JAVA_DIR)\pyramidpkg\AppletConsole.class \
	$(DEMO_JAVA_DIR)\pyramidpkg\ConsoleKeyListener.class \
	$(DEMO_JAVA_DIR)\pyramidpkg\ConsoleMouseListener.class \
	$(DEMO_JAVA_DIR)\pyramidpkg\Pyramid.class \
	$(DEMO_JAVA_DIR)\simplepkg\SayhelloCmd.class \
	$(DEMO_JAVA_DIR)\simplepkg\SimpleExtension.class \
	$(DEMO_JAVA_DIR)\watchpkg\StopWatchExtension.class \
	$(DEMO_JAVA_DIR)\watchpkg\StopWatchThread.class \
	$(DEMO_JAVA_DIR)\watchpkg\SwCmd.class

TEST_CLASSES = \
	$(TEST_CLASS_DIR)\ConvertTest.class \
	$(TEST_CLASS_DIR)\JavaTest.class \
	$(TEST_CLASS_DIR)\JavaTestSub.class \
	$(TEST_CLASS_DIR)\TestObjectCmd.class \
	$(TEST_CLASS_DIR)\invoke\ArrayTestClass.class \
	$(TEST_CLASS_DIR)\invoke\IntA.class \
	$(TEST_CLASS_DIR)\invoke\IntC.class \
	$(TEST_CLASS_DIR)\invoke\PublicTester.class \
	$(TEST_CLASS_DIR)\javainfo\InfoTestClass.class \
	$(TEST_CLASS_DIR)\javainfo\SuperTestClass.class \
	$(TEST_CLASS_DIR)\javaload\Test1Cmd.class \
	$(TEST_CLASS_DIR)\javaload\Test1Extension.class \
	$(TCLJAVA)\tcl\lang\NonPublic.class \
	$(TCLJAVA)\tcl\lang\TestcompcodeCmd.class \
	$(TCLJAVA)\tcl\lang\NoEventBean.class \
	$(TCLJAVA)\tcl\lang\TestEvent.class \
	$(TCLJAVA)\tcl\lang\TesterBean.class \
	$(TCLJAVA)\tcl\lang\Tester1Listener.class \
	$(TCLJAVA)\tcl\lang\Tester1Event.class \
	$(TCLJAVA)\tcl\lang\Tester2Listener.class \
	$(TCLJAVA)\tcl\lang\Tester2Event.class \
	$(TCLJAVA)\tcl\lang\AdaptorGenTest.class \
	$(TCLJAVA)\tcl\lang\JtestCmd.class \
	$(TCLJAVA)\tcl\lang\TclPkgInvoker.class \
	$(TCLJAVA)\pkg1\TclPkgInvoker.class \
	$(TCLJAVA)\pkg1\MyClass.class \
	$(TCLJAVA)\pkg2\MyClass.class

JAVALOAD_TEST_CLASSES = \
	$(TEST_CLASS_DIR)\javaload\Test2Cmd.class \
	$(TEST_CLASS_DIR)\javaload\Test2Extension.class \
	$(TEST_CLASS_DIR)\javaload\Test3Extension.class \
	$(TEST_CLASS_DIR)\javaload\Test4Extension.class \
	$(TEST_CLASS_DIR)\javaload\Test5Extension.class \
	$(TEST_CLASS_DIR)\javaload\Test6Extension.class \
	$(TEST_CLASS_DIR)\javaload\Test7Extension.class \
	$(TEST_CLASS_DIR)\javaload\Test8Extension.class

JAVALOAD_TEST_JAR = \
	$(TEST_CLASS_DIR)\javaload\test9.jar \
	$(TEST_CLASS_DIR)\javaload\test10.jar

TCLBLEND_TEST_CLASSES = \
	$(TEST_CLASS_DIR)/IdleHandlerTest.class \
	$(TEST_CLASS_DIR)/TimerHandlerTest.class \
	$(TEST_CLASS_DIR)/VarTraceTest.class \
	$(TCLJAVA)/tcl/lang/NativeTestExtension.class

JACL_TEST_CLASSES = \
	$(TEST_CLASS_DIR)/VarTraceTest.class \
	$(TCLJAVA)\tcl\lang\JavaTestExtension.class \
	$(TCLJAVA)\tcl\lang\TestParserCmd.class \
	$(TCLJAVA)\tcl\lang\TestEvalObjvCmd.class \
	$(TCLJAVA)\tcl\lang\TestEval2Cmd.class \
	$(TCLJAVA)\tcl\lang\TestParsevarCmd.class \
	$(TCLJAVA)\tcl\lang\TestParsevarnameCmd.class \
	$(TCLJAVA)\tcl\lang\TestgetplatformCmd.class \
	$(TCLJAVA)\tcl\lang\TestsetplatformCmd.class \
	$(TCLJAVA)\tcl\lang\TesttranslatefilenameCmd.class

COMMON_LIBRARY_FILES = \
	$(LIB_DST_DIR)\java1.0\javalock.tcl

JACL_LIBRARY_FILES = \
	$(LIB_DST_DIR)\history.tcl \
	$(LIB_DST_DIR)\init.tcl  \
	$(LIB_DST_DIR)\ldAout.tcl \
	$(LIB_DST_DIR)\parray.tcl \
	$(LIB_DST_DIR)\safe.tcl \
	$(LIB_DST_DIR)\word.tcl \
	$(LIB_DST_DIR)\tclIndex

INVOKER_CLASS = \
        $(TCLJAVA)\tcl\lang\reflect\PkgInvoker.class 

INVOKER_SRC = \
        $(COMMON_JAVA_DIR)\tcl\lang\reflect\PkgInvoker.java

TCLBLEND_CLASSES = $(INVOKER_CLASS) $(NATIVE_CLASSES) $(COMMON_CLASSES)
JACL_CLASSES = $(INVOKER_CLASS) $(JAVA_CLASSES) $(COMMON_CLASSES)

#----------------------------------------------------------------------
# Implicit rules for compiling .class files
#----------------------------------------------------------------------

.SUFFIXES: .java .class

{$(COMMON_JAVA_DIR)\tcl\lang}.java{$(TCLJAVA)\tcl\lang}.class:
	echo $< >> depend.out

{$(COMMON_JAVA_DIR)\tcl\bean}.java{tclbean\tcl\bean}.class:
	echo $< >> depend.out

{$(TEST_JAVA_DIR)}.java{$(TEST_CLASS_DIR)}.class:
	echo $< >> depend.out

{$(TEST_JAVA_DIR)}.java{$(TEST_CLASS_DIR)\invoke}.class:
	echo $< >> depend.out

{$(TEST_JAVA_DIR)}.java{$(TEST_CLASS_DIR)\javainfo}.class:
	echo $< >> depend.out

{$(TEST_JAVA_DIR)\javaload}.java{$(TEST_CLASS_DIR)\javaload}.class:
	echo $< >> depend.out

{$(TEST_JAVA_DIR)}.java{$(TCLJAVA)\tcl\lang\}.class:
	echo $< >> depend.out

{$(TEST_JAVA_DIR)\pkg1}.java{$(TCLJAVA)\pkg1}.class:
	echo $< >> depend.out

{$(TEST_JAVA_DIR)\pkg2}.java{$(TCLJAVA)\pkg2}.class:
	echo $< >> depend.out

{$(DEMO_JAVA_DIR)\gluepkg}.java{$(DEMO_JAVA_DIR)\gluepkg}.class:
	echo $< >> depend.out

{$(DEMO_JAVA_DIR)\pyramidpkg}.java{$(DEMO_JAVA_DIR)\pyramidpkg}.class:
	echo $< >> depend.out

{$(DEMO_JAVA_DIR)\simplepkg}.java{$(DEMO_JAVA_DIR)\simplepkg}.class:
	echo $< >> depend.out

{$(DEMO_JAVA_DIR)\watchpkg}.java{$(DEMO_JAVA_DIR)\watchpkg}.class:
	echo $< >> depend.out

#----------------------------------------------------------------------
# Rules for building the PkgInvoker class.
#----------------------------------------------------------------------
$(INVOKER_CLASS): $(INVOKER_SRC)
	$(JAVAC) -d $(TCLJAVA) $(INVOKER_SRC)

#----------------------------------------------------------------------
# Rules for building .class files
#----------------------------------------------------------------------

setup: BuildJava.class
	-@del depend.* 2> NUL
	-@mkdir $(TCLJAVA) 2> NUL

build:
	set CLASSPATH=$(TCLJAVA);.
	$(JAVA) BuildJava depend.out "$(JAVAC) -d $(TCLJAVA)"
	-@del depend.* 2> NUL

# Build the JAR file for Jacl or Tcl Blend. We do a "clean" beforehand
# to make sure that the JAR file doesn't include the test classes.

$(TCLJAVA).jar: $(TCLJAVA)
	cd $(TCLJAVA)
	jar cv0f ..\$(TCLJAVA).jar tcl
	cd ..

#----------------------------------------------------------------------
# Rules for copying script library files
#----------------------------------------------------------------------

copy-libs: $(LIB_DST_DIR) $(LIB_DST_DIR)\java1.0 $(LIBRARY_FILES)

$(LIB_DST_DIR):
	-mkdir $(LIB_DST_DIR) 2> NUL

$(LIB_DST_DIR)\java1.0:
	-mkdir $(LIB_DST_DIR)\java1.0 2> NUL

$(LIB_DST_DIR)\java1.0\javalock.tcl: $(GENERIC_DIR)\javalock.tcl
	copy $(GENERIC_DIR)\javalock.tcl $(LIB_DST_DIR)\java1.0

#----------------------------------------------------------------------
# Rules for building test files
#----------------------------------------------------------------------

test.build: javatest.build javaload.build $(JAVALOAD_TEST_JAR)

javatest.build: setup javatest.depend
	set CLASSPATH=$(TCLJAVA);.
	$(JAVA) BuildJava depend.out "$(JAVAC) -d $(TCLJAVA)"
	-@del depend.* 2> NUL

javaload.build: setup javaload.depend
	set CLASSPATH=$(TCLJAVA);.
	$(JAVA) BuildJava depend.out "$(JAVAC) -d $(TEST_CLASS_DIR)\javaload"
	-@del depend.* 2> NUL

javaload.depend: $(JAVALOAD_TEST_CLASSES)

$(TEST_CLASS_DIR)\javaload\test9.jar: \
$(TEST_JAVA_DIR)\javaload\Test9Extension.java
	set CLASSPATH=$(TCLJAVA);$(TEST_CLASS_DIR)\javaload
	$(JAVAC) -d $(TEST_CLASS_DIR)\javaload \
		$(TEST_JAVA_DIR)\javaload\Test9Extension.java
	cd $(TEST_CLASS_DIR)\javaload
	jar c0f test9.jar Test9Extension.class
	cd ..\..\..\

$(TEST_CLASS_DIR)\javaload\test10.jar: \
$(TEST_JAVA_DIR)\javaload\Test10Extension.java
	set CLASSPATH=$(TCLJAVA);$(TEST_CLASS_DIR)\javaload
	$(JAVAC) -d $(TEST_CLASS_DIR)\javaload \
		$(TEST_JAVA_DIR)\javaload\Test10Extension.java
	cd $(TEST_CLASS_DIR)\javaload
	jar c0f test10.jar Test10Extension.class
	cd ..\..\..\

#----------------------------------------------------------------------
# Building the demo classes.
#----------------------------------------------------------------------

demo: $(TCLJAVA) setup demo.depend demo.build

demo.depend: $(DEMO_CLASSES)

demo.build:
	set CLASSPATH=..\win\$(TCLJAVA);.
	$(JAVA) BuildJava depend.out "$(JAVAC)"
	-@del depend.* 2> NUL

#----------------------------------------------------------------------
# Building the bean classes.
#----------------------------------------------------------------------

bean: $(TCLJAVA) $(TCLJAVA).jar setup bean.depend bean.build bean.copy tclbean.jar 

bean.depend: $(BEAN_CLASSES)

bean.build:
	-@mkdir tclbean
	set CLASSPATH=$(TCLJAVA);$(STUDIO_LIB_DIR);tclbean;.
	$(JAVA) BuildJava depend.out "$(JAVAC) -d tclbean"
	-@del depend.* 2> NUL

tclbean.jar::
	cd tclbean
	jar c0fv ..\tclbean.jar tcl
	cd ..

bean.copy:
	-@mkdir tclbean 2> NUL
	-@mkdir tclbean\tcl 2> NUL
	-@mkdir tclbean\tcl\bean 2> NUL
	-@mkdir tclbean\tcl\bean\scripts
	-@mkdir tclbean\tcl\bean\images
	-@mkdir tclbean\tcl\bean\html
	-@mkdir tclbean\tcl\bean\html\JaclCmd
	copy .\..\src\common\tcl\bean\images\*.gif \
            tclbean\tcl\bean\images
	copy .\..\src\common\tcl\bean\html\JaclCmd\*.htm \
            tclbean\tcl\bean\html\JaclCmd
	copy .\..\src\common\tcl\bean\scripts\*.tcl \
            tclbean\tcl\bean\scripts
	copy .\..\src\common\tcl\bean\help.htm \
            tclbean\tcl\bean


#----------------------------------------------------------------------
# Misc stuff.
#----------------------------------------------------------------------

clean::
	-del BuildJava.class
	-del $(TCLJAVA).jar
	-rd /q /s $(TCLJAVA)
	-del tclbean.jar
	-rd /q /s tclbean

BuildJava.class: BuildJava.java
	$(JAVAC) BuildJava.java

