'\"
'\" Copyright (c) 1998 by Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) java.n 1.27 98/02/13 13:57:11
'\" 
.so man.macros
.TH "java" n 8.0 Tcl "Java Package Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
java \- Java method invocation package
.SH SYNOPSIS
\fBpackage require java ?1.0?\fP
.sp
\fBjava::new \fIsignature\fR ?\fIarg arg ...\fR?
.sp
\fBjava::new \fIarraySignature\fR \fIsizeList\fR ?\fIvalueList\fR?
.sp
\fBjava::call\fR ?\fB-noconvert\fR? \fIclass signature\fR ?\fIarg arg ...\fR?
.sp
\fBjava::field\fR ?\fB-noconvert\fR? \fIobjOrClass fieldSignature\fR ?\fIvalue fieldSignature value ...\fR?
.sp
\fBjava::instanceof\fR \fIjavaObj type\fR
.sp
\fBjava::prop\fR ?\fB-noconvert\fR? \fIjavaObj\fR \fIproperty\fR ?\fIvalue property value ...\fR?
.sp
\fBjava::info\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fBjava::null\fR
.sp
\fBjava::isnull\fR \fIjavaObj\fR
.sp
\fBjava::lock\fR \fIjavaObj\fR
.sp
\fBjava::unlock\fR \fIjavaObj\fR
.sp
\fBjava::defineclass \fIclassData\fR
.sp
\fBjava::getinterp\fR
.sp
\fIjavaObj\fR ?\fB-noconvert\fR? \fIsignature\fR ?\fIarg arg ...\fR?
.sp
\fIjavaArrayObj\fR ?\fB-noconvert\fR? \fIoption\fR ?\fIarg arg ...\fR?
.sp
.BE

.SH DESCRIPTION
.PP
The \fBjava\fR package provides an interface for creating and
manipulating Java objects via \fIoject handles\fR.  Object handles are
references to Java objects in Tcl.  Many of the commands in the java
package take arguments and return values that are object handles.

The \fBjava\fR package is automatically included in Jacl,
but needs to be loaded in Tcl Blend.  When the package is loaded in
Tcl Blend, Tcl will use an existing Java VM or initialize a new one as
needed.  Note that \fBtcl.lang\fR and the JDK 1.1 need to be on the
class path.
.RS
.TP
\fBjava::new\fR
The \fBjava::new\fR command is used to create new instances of Java
objects from Tcl.  The \fIsignature\fR argument specifies which class
constructor to use for creating the object.
.sp
See SIGNATURE below for a full description of how to specify the
signature of non-array constructors.  Additional parameters to the
\fBjava::new\fR command are converted to Java objects or primitive values
and passed to the constructor.
See the CLASS LOADING section in the \fBjava::load\fR man page for a
description on how classes are resolved and loaded into the VM.  Any
of the java commands that reference a java class also use the
mechanism described in CLASS LOADING. 
.sp
The \fIarraySignature\fR argument consists of a class name or a
primitive data type followed by one or more pairs of brackets.  The
number of pairs of brackets determines the dimension of the array
(e.g. {int[][][]}
indicates a three dimensional array of integers; the curly braces keep
the interpreter from removing the extra brackets).  The \fIsizeList\fR
argument determines the number of array elements allocated for each
dimension in the array.  The \fIi\fR'th element of \fIsizeList\fR
specifies the size of the \fIi\fR'th dimension of the array.  If
\fIsizeList\fR contains more elements than the number of dimensions
specified by \fIarraySignature\fR, then an error is returned.  If
\fIsizeList\fR contains fewer elements than the number of dimensions
specified by \fIarraySignature\fR, then the size will be determined by
the \fIvalueList\fR, if present.  The \fIvalueList\fR argument is used
to set initial values of the array cells.  Elements of the
\fIvalueList\fR must be of the same type as the base class of the
array.  If the array is multidimensional, then the list must contain
sublists of a depth equal to the number of dimensions of the array.
If no element is specified in the \fIvalueList\fR for a particular
array cell, the cell will be initialized to the standard default value
for the corresponding Java array type. If the length of the
\fIsizeList\fR is smaller than the number of array dimensions, the
size of each row whose size is not specified by the \fIsizeList\fR is
determined by the length of the corresponding sublist in
\fIvalueList\fR, or 0 if the \fIvalueList\fR contains no corresponding
sublist.  An error occurs if any dimension other than the last has
size 0.

The CONVERSION and EXCEPTIONS sections below describe the result and
possible error conditions of the \fBjava::new\fR command, including the
effect of the optional \fB-noconvert\fR flag.

.TP
\fBjava::call\fR
The \fBjava::call\fR command is used to invoke public static methods
from Tcl.  The \fIclass\fR argument specifies the fully qualified name
of the declaring class of the method to invoke.  See the CLASS NAMES
below for a full description of fully qualified class names.  The
\fIsignature\fR argument specifies which class method to invoke (see
SIGNATURE below).  Additional parameters to the \fBjava::call\fR command are
converted to Java objects or primitive types and passed to the method.
The CONVERSION and EXCEPTIONS sections below describe the result
and possible error conditions of the \fBjava::call\fR command, including
the effect of the optional \fB-noconvert\fR flag.

.TP
\fBjava::field\fR
The \fBjava::field\fR command is used to manipulate public fields from
Tcl.  The \fIobjOrClass\fR argument specifies either a fully qualified
name of the declaring class of the field to access, or an object
handle.  The \fIfieldSignature\fR argument specifies which field to
manipulate (see SIGNATURE below).  If an additional \fIvalue\fR
parameter exists, then the field will be set to \fIvalue\fR, otherwise
the current value of the field is returned.  Multiple fields may be
set via additional parameters by alternating field signatures and
values.  The \fB-noconvert\fR flag can only be used when getting the
value of a field.  The CONVERSION section below describes the effect
of the optional \fB-noconvert\fR flag on the result.

.TP
\fBjava::instanceof\fR
The \fBjava::instanceof\fR command is used to tell whether a Java
object is of a given type.  The \fIjavaObj\fR argument specifies an
object handle.  The \fItype\fR argument specifies a fully
qualified interface or class name (see CLASS NAMES below).  If the
\fItype\fR argument is a class name, \fBjava::instanceof\fR returns 1
if the \fIjavaObj\fR argument is an instance of \fItype\fR or an
instance of a subclass of \fItype\fR.  If the \fItype\fR argument is
an interface name, \fBjava::instanceof\fR returns true if the
\fIjavaObj\fR argument implements this interface. Otherwise,
\fBjava::instanceof\fR returns 0.

.TP
\fBjava::prop\fR
The \fBjava::prop\fR command is used to manipulate Java Bean
properties from Tcl.  The \fIjavaObj\fR argument specifies an object
handle.  The \fIproperty\fR argument specifies a Java Bean property
that has corresponding get and set methods.  If an additional
\fIvalue\fR parameter exists, then the property will be set to
\fIvalue\fR, otherwise the current value of the property is returned.
Multiple properties may be set via additional parameters by
alternating properties and values.  The \fB-noconvert\fR flag can only
be used when getting the value of a property.  The CONVERSION section
below describes the effect of the optional \fB-noconvert\fR flag on
the result.

.TP
\fBjava::info\fR
The \fBjava::info\fR command provides introspection for Java classes,
objects, and Beans.  The valid options for this command are:
.RS
.TP
\fBclass\fR \fIjavaObj\fR
Returns the class name of the specified Java object.
.TP
\fBevents\fR \fIobjOrClass\fR
Returns a list of the fully-qualified names of all the event
interfaces of the Java class or object. The events of a Java class are
determined by the JavaBean design patterns. Usually, if a Java class
has the methods \fBadd\fIXXX\fBListener\fR and
\fBremove\fIXXX\fBListener\fR and \fIXXX\fR is the name of an
interface, then \fIXXX\fR is considered as an event interface of the
Java class.
.TP
\fBbaseclass\fR \fIobjOrClass\fR
Returns the base class name of the specified class or Java object.
For example, the base class of a Java array object of type
String[][][] is java.lang.String.  If the class or Java object is not
an array, the base class is the same as the class.
.TP
\fBdimensions\fR \fIobjOrClass\fR
Returns the number of dimensions of the specified array class or Java
array object.  If the class or Java object is not an array, the number
of dimensions is 0.
.TP
\fBfields\fR ?\fB-type\fR? ?\fB-static\fR? \fIobjOrClass\fR
Returns a list of fieldSignatures of public fields of the specified
class or Java object (see SIGNATURE below).  For shadowed superclass
fields, the fieldSignature is full.  For all other fields, the
fieldSignature is simple.  If the ?\fB-type\fR? flag is used, then
each element of the result list is a pair containing the data type and
fieldSignature.  If the \fB-static\fR flag is used, only static fields
will appear in the result list.  Otherwise, only non-static fields
will appear in the result list.
.TP
\fBmethods\fR ?\fB-type\fR? ?\fB-static\fR? \fIobjOrClass\fR
Returns a list that describes all methods of the specified class or
Java object. If \fB\-type\fR is not used, each element in the list is
the full signature of a method. If \fB\-type\fR is used, each element
in the list is in turn a list in the form {\fItype sig exceptions\fR},
where \fItype\fR is the method's return type, \fIsig\fR is the
method's full signature, and \fIexceptions\fR is a list of the
fully-qualified names of all the checked exceptions that can be thrown
by this method.  If the method does not throw exceptions,
\fIexceptions\fR is the empty list. If the \fB-static\fR flag is used,
only static methods will appear in the result list. Otherwise, only
non-static methods will appear in the result list.
.TP
\fBconstructors\fR \fIobjOrClass\fR
Returns a list of the full signatures of constructors of the specified
class or Java object.
.TP
\fBproperties\fR \fIobjOrClass\fR ?\fB-type\fR?
Returns a list of the names of Java Bean properties of the specified
class or Java object.  If the ?\fB-type\fR? flag is used, then each
element of the result list is a pair containing the data type and name
of the property.
.TP
\fBsuperclass\fR \fIobjOrClass\fR
Returns the name of the immediate superclass of the specified Java
object or class.  If \fIobjOrClass\fR is or is an instance of
java.lang.Object, then the empty string is returned.
.RE

.TP
\fBjava::null\fR
The \fBjava::null\fR command returns an object handle that represents
the "null" value in Java.  To check for null results from Java method
invocations, compare the methods' return values to the result of
\fBjava::null\fR.  The exact form of the return value of \fBjava::null\fR is
not specified and is likely to change.

.TP
\fBjava::isnull\fR
The \fBjava::isnull\fR command is used to tell whether a Java
object has the null value.  The \fIjavaObj\fR argument specifies an
object handle.  If the object has the null value, \fBjava::isnull\fR
returns 1.  If the object is a Java object then \fBjava::isnull\fR
will return 0.  If the object is not a valid Java object but rather
a standard Tcl string, \fBjava::isnull\fR will return an error
stating that the argument was not a Java object.

.TP
\fBjava::lock\fR
The \fBjava::lock\fR command prevents the Java object, \fIjavaObj\fR,
from getting garbage collected.  A Tcl variable that references a Java
object has an internal rep that points to the Java object.  If the
Tcl variable's internal rep is changed (e.g. to a Tcl List), the
pointer to the Java Object is removed, and the Java object is garbage
collected.  The \fBjava::lock\fR maintains a copy of \fIjavaObj\fR's
internal rep, so the Java object will be preserved.  Multiple locks
can be placed on the same Tcl variable.  If \fIjavaObject\fR is not a
valid reference to a Java object, a Tcl error is generated.

.TP
\fBjava::unlock\fR
The \fBjava::unlock\fR command removes a lock placed on \fIjavaObj\fR by the
\fBjava::lock\fR command.  Multiple locks are allowed on
\fIjavaObj\fR.  The \fBjava::unlock\fR removes one lock each
time it is called.  If the internal rep of the Tcl variable referenced by
\fIjavaObj\fR is zero after the lock is removed, the Java object will
be garbage collected.  If \fIjavaObj\fR does not have an existing lock a
Tcl error is generated.

.TP
\fBjava::defineclass\fR
The \fBjava::defineclass\fR command is used to convert a string of bytes 
into a Java Class object.  The \fIclassData\fR argument is a string of
bytes that compose a class.  For example, the \fIclassData\fR 
string could be from reading a Java class file.  \fIClassData\fR
is passed to the TclClassLoader, where the TclClassLoader attempts to
construct a Java Class object from the bytes.  If \fIclassData\fR 
does not represent a valid class, \fBjava::defineclass\fR returns a
null object, otherwise it will return a handle to the Java Class
object.  A class is not valid if; the TclClassLoader cannot decifer a
class from \fIclassData\fR, the class has already been loaded into the
VM, or if the class is in the reserved java package.  See the CLASS
LOADING section in the \fBjava::load\fR man page for information on
the TclClassLoader.
.sp
The TclClassLoader maintains a cache of the Java Class objects loaded
by the \fBjava::defineclass\fR routine.  The name of the class, which
is stored within the class bytecodes, is extracted and is used to
reference the cached Java Class object.  If the class name is used in
future calls (e.g. \fBjava::new\fR) the class defined by
\fIclassData\fR is used.  For example:
.CS
set file [open Foo.class r]

# Tcl Blend users must call 'fconfigure $file -translate binary'
set data [read $file]       

# This returns a Java Class object.
set class [java::defineclass $data]

# Get an instance of the object.
set object [$class newInstance]

# The class is now loaded into the VM, so the 
# following call also works.
set object [java::new Foo]
.CE

.TP
\fBjava::getinterp\fR
The \fBjava::getinterp\fR command returns a handle to the current Java Interp
object.  This command is primarily used to pass the interp object as
an argument to a Java method.

.TP
\fBjavaObj\fR
Each Java object handle is also the name of a Tcl command that can be
used to invoke public methods of that object from Tcl.  The
\fIsignature\fR argument specifies which method to invoke (see
SIGNATURE below).  Additional parameters to an object command are
converted to Java objects or primitive values and passed to the
method.  The RETURN VALUES AND EXCEPTIONS section below describes the
result (and possible error conditions) of the object command,
including the effect of the optional \fB-noconvert\fR flag on the
result.

.TP
\fBjavaArrayObj\fR
If a Java object handle represents an instance of an array object,
then it is also the name of a Tcl command that takes the following
options: \fBlength\fR, \fBget\fR, \fBset\fR, \fBgetrange\fR, and
\fBsetrange\fR.  If any other option is chosen, the behavior of the
array object command defaults to that of the object command described
above.  The \fB-noconvert\fR flag can only be used with the \fBget\fR,
\fBgetrange\fR, and default options.  The options for this command
behave as follows:
.RS
.TP
\fBlength\fR
Returns the number of elements in the Java object.  If the object is a
multi-dimensional array, the number of elements in the first dimension
is returned.
.TP
\fBget\fR ?\fB-noconvert\fR? \fIindexList\fR
Returns the value stored in the multi-dimensional array cell specified
by \fIindexList\fR.  The \fIi\fR'th element in \fIindexList\fR
specifies the index value of the \fIi\fR'th array dimension.  For
example, the result of the following commands is the string "easy".
.RS
.CS
set a [java::new {String[]} {6} {Java scripting is easy in Tcl}]
$a get 3
.CE

To retrieve a k-dimensional subarray of an n-dimensional array,
specifiy an \fIindexList\fR with \fIn - k\fR index values.  For
example, the following commands result in \fIsubArray\fR containing a
1-dimensional char array handle that refers to a[1][0], the internal
value of which is {e f}. 

.CS
set a [java::new {char[][][]} {2 2 2} {{{a b} {c d}} {{e f} {g h}}}]
set subArray [$a get {1 0}]
.CE

The CONVERSION section below describes the effect of the optional
\fB-noconvert\fR flag on the result.
.RE

.TP
\fBset\fR \fIindexList\fR \fIvalue\fR
Sets the multi-dimensional array cell specified by \fIindexList\fR to
\fIvalue\fR.  The \fIi\fR'th element in \fIindexList\fR specifies the
index value of the \fIi\fR'th array dimension.  If \fIvalue\fR is not
the correct data type, an error is returned.  For example, the
following commands result in \fIa\fR having an interanl value of {Tcl
is a great scripting language!}.
.CS
set a [java::new {String[]} {6} {Tcl is a good scripting language!}]
$a set 3 great
.CE
.TP
\fBgetrange\fR ?\fB-noconvert\fR? ?\fIindexList\fR ?\fIcount\fR??
Returns the list of objects corresponding to the specified range of
the array.  The range starts at the element specified by
\fIindexList\fR and spans a maximum of \fIcount\fR elements or the
remaining elements of the subarray.  The \fIindexList\fR defaults to
0, and \fIcount\fR defaults to the length of the subarray.  For
example, the result of the following commands is the list {scripting
is easy}.

.CS
set a [java::new {String[]} {6} {Java scripting is easy in Tcl}]
$a getrange 1 3
.CE

To retrieve a k-dimensional subarray
of an n-dimensional array, specifiy an \fIindexList\fR with \fIn -
k\fR index values.  For example, the following commands result in
\fIpair\fR containing two 1-dimensional char array handles that refer
to a[0][1] and a[0][2], the internal values of which are {c d} and {e
f} respectively.
.CS
set a [java::new {char[][][]} {2 3 2} {{{a b} {c d} {e f}} {{g h} {i j} {k l}}}]
set pair [$a getrange {0 1} 2]
.CE  
The CONVERSION section below
describes the effect of the optional \fB-noconvert\fR flag on the
result.

.TP
\fBsetrange\fR ?\fIindexList\fR ?\fIcount\fR?? \fIvalueList\fR
Sets the range of array elements to elements of \fIvalueList\fR.  The
range starts at the element specified by \fIindexList\fR and spans a
minimum of \fIcount\fR elements, the remaining elements of the
subarray, or the size of \fIvalueList\fR.  If an element of
\fIvalueList\fR in the replacement range is not the correct data type,
an error is returned.  For example, the following commands result in
\fIa\fR having an interanl value of {Tcl is an excellent scripting
language!}
.CS
set a [java::new {String[]} {6} {Tcl is a good scripting language!}]
$a setrange 2 {an excellent}
.CE
.RE
.RE
.SH CLASS NAMES
.PP
Any command which takes as input or returns a \fIclass name\fR,
\fIinterface name\fR, or primitive value expects a fully qualified
Java class name (e.g. java.awt.Button).  If a name is not fully
qualified, it is assumed to be in java.lang.*.

.SH SIGNATURE
.PP
A \fIsignature\fR is the string which specifies a class constructor,
method, or field, thereby distinguishing it from other constructors,
methods, and fields.  We will refer to signatures of fields as
\fIfieldSignatures\fR.  Any further mention of signatures refers to
those of both constructors and methods.

Two forms of signatures are accepted: simple and full.  The \fIsimple
signature\fR is a single element list containing the method or
constructor name.  If the simple signature is used to invoke an
overloaded method, then a method will be picked based on the number of
arguments passed to the command invoking the method.  The \fIfull
signature\fR is used to distinguish between two or more methods with
the same name and number of arguments.  The \fIfull signature\fR of a
method is a Tcl list containing the method name followed by the type
of each parameter of the method.

Two forms of \fIfieldSignatures\fR are accepted: simple and full.  A
\fIsimple fieldSignature\fR is a single element list containing the
filed name.  A \fIfull fieldSignature\fR is a Tcl list containing the
field name and the name of the class in which the field is declared.
The full form of \fIfieldSignature\fR is required to specify shadowed
fields of superclasses.

.SH "CONVERSION"
.PP
For calls that return the value of a Java field, property, array
element, or method or constructor, Tcl automatically converts the
result to a corresponding Tcl value.  If the type of the return value
is a boolean or numeric type, it will be converted to an integer (or
floating-point) value.  If the result is a string, then the contents
of the string are returned.  For all other object types, a new Java
object handle is created and returned.  If the \fB-noconvert\fR option
is specified, then Tcl's automatic data conversion is overidden, and a
new Java object handle is created and returned.

.SH "EXCEPTIONS"
.PP
Java constructors and methods are invoked by calls to \fBjava::new\fR,
\fBjava::call\fR, and object commands.  If the method invoked throws
an exception, Tcl returns the string representation of the exception
as an error.  The \fBerrorCode\fR is set to a list whose first two
elements are the string "JAVA" and the object handle of the exception
object, repectively.

.SH "OBJECT GARBAGE COLLECTION"
.PP
The object handle associated with a Java object is considered to be an
object reference by the Java VM, ensuring that the Java object is not
garbage collected while Tcl is using it.  Tcl will release the object
handle when the last reference to the handle in a Tcl script goes
away.  A handle is considered to be active as long as at least one
\fBTcl_Obj\fR points to the handle.  In practice this means that Java
object handles must be stored in Tcl variables or passed as arguments
to other commands to keep them from being released.  Constructing a
Java object handle using \fBconcat\fR or some other string
manipulation command will produce a string that can be used where a
Java object handle is expected, but it will not count as a reference
to the object for garbage collection purposes.
.PP
Tcl objects usually remain one type over their life, but occasionally a
Tcl object must be converted from one type to another. For example, a
Java object handle may be passed as the argument to the \fBllength\fR
command.  The internal rep of the Tcl object is converted from a Java
object handle to a Tcl List.  When this happens the ref count of the Java
object handle is decremented.  If the ref count becomes zero, the Java
object handle is invalidated and the Tcl variable no longer accesses a
Java object.  For example:
.CS
# Create a new Java Object.  The ref count equals one.
set o [java::new java.lang.Object]

# Call a method of the Java Object.
puts [$o toString]

# Convert the Java object handle to a Tcl List.  This
# decrements the ref count by one.  The ref count equals
# zero and the  Java object is invalidated.
llength $o

# This command will generate an error, because the
# Tcl object no longer references a valid Java object.
puts [$o toString]
.CE
The solution is to guarantee that the Java object handle's ref count
does not become zero.  Use the \fBjava::lock\fR and \fBjava::unlock\fR
commands to maintain a permanent reference to the Java object handle.
For example:
.CS
# Create a new Java object.  The ref count equals one.
set o [java::new java.lang.Object]

# Lock the Java Object handle so it is not invalidated.
# The ref count now equals two.
java::lock $o

# Convert the Java object to a Tcl List.  This decrements
# the ref count by one.  The ref count equals one and the 
# Java object remains valid.
llength $o

# Now this command works.  It also increments the ref count
# of the java object, because a Tcl List is being converted
# to the original Java object handle.
puts [$o toString]

# Remove the lock and decrement the ref count.
java::unlock $o

# Now this will fail as in the previous example.
llength $o
puts [$o toString]
.CE

.SH SEE ALSO
\fBjava::load\fR, \fBjava::bind\fR

.SH KEYWORDS
java, tcl

 
