/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/*  $name.P  */

$name_export([$name/2,$name0/2]).

$name(X, L) :-
     nonvar(X) -> $name_0(X,L) ; $name_1(X,L).

$name_0(X, L) :- integer(X), !, $b_intname(X,L,[]).
$name_0(X, L) :- real(X), !, (X =:= 0 -> L = "0.0" ; $b_realname(X,L,[])).
$name_0(X, L) :- nonvar(L), $name_numlist(L, X), !.
$name_0(X, L) :- '_$builtin'(99).

$name_1(X, L) :- nonvar(L), $name_numlist(L, X), !.
$name_1(X, L) :- '_$builtin'(98). /* bldatom */

$name0(X,L) :- '_$builtin'(99).

$b_intname(N,F,L) :- 
     (N < 0 ->
          (N1 is -N,
     	   F = [45|F1]		/* 45 == 0'- */
	  ) ;
	  (N1 = N, F1 = F)
     ),
     $b_intname_p(N1,F1,L).


$b_intname_p(N,F,L) :-
     N < 10,
     D is N+48,
     F=[D|L].
$b_intname_p(N,F,L) :-
     N>=10,
     M is N//10,
     D is N-M*10+48,
     $b_intname_p(M,F,[D|L]).

$b_realname(X,F,L) :-
     X < 0,
     !,
     Xp is -X,
     F = [45|F1],
     $b_realname(Xp,F1,L).
$b_realname(X,F,L) :-
	X =:= 0 -> F = L ;
		($floor(X,I),
		 $b_intname(I,F,[46|L1]),
		 F0 is X - I,
		 $b_mkint(F0,F1,L1,L2,7),
		 $b_intname(F1,FracName,[]),
		 $strip_trailing_zeros(FracName,L2,L)
		).

$b_mkint(X,Y,L1,L2,N) :-
     N =:= 0 ->
        (X1 is (X+0.5)/10,	/* lop off last digit, not useful */
	 $floor(X1,Y),
	 L1 = L2
	) ;
	(N > 0,
	 ( ($floor(X,Y), X =:= Y) ->
	     L1 = L2 ;
	     (Z is 10 * X, $floor(Z,Z1),
	      (Z1 > 0 ->
	         L1 = L3 ;
		 L1 = [0'0|L3]
	      ),
	      N1 is N - 1, $b_mkint(Z,Y,L3,L2,N1)
	     )
	  )
	).

$strip_trailing_zeros([C|Rest],[C|SRest],L) :-
     $strip_trailing_zeros(Rest,SRest,L,_).

$strip_trailing_zeros([],L,L,1).
$strip_trailing_zeros([C|Rest], Out, Tl, Flag) :-
     C =\= 0'0 ->
          (Out = [C|ORest], Flag = 0,
           $strip_trailing_zeros(Rest,ORest,Tl,_)
	  ) ;
	  ($strip_trailing_zeros(Rest,OutRest,Tl,Flag1),
           (Flag1 =:= 1 ->
               (Out = OutRest, Flag = 1) ;
	       (Out = [0'0|OutRest], Flag = 0)
           )
          ).

$name_numlist([C|CRest], N) :-
     (nonvar(C), C =:= 45) ->
          ($name_numlist_1(CRest, 0, N1),
           N is -N1
	  ) ;
	  (C >= 48, C =< 57, 
           M is C - 48,
           $name_numlist_1(CRest,M,N)
	  ).

$name_numlist_1(L, M, N) :-
     nonvar(L),
     $name_numlist_2(L, M, N).

$name_numlist_2([], N, N).
$name_numlist_2([C|CRest], M, N) :-
     nonvar(C),
     ((C >= 48, C =< 57) ->
          (M1 is 10 * M + C - 48,
           $name_numlist_1(CRest, M1, N)
	  ) ;
	  (C =:= 46 ->
	       (nonvar(CRest), $name_numlist_3(CRest,10,M,N))
	  )
     ).

$name_numlist_3([], _, N, N).
$name_numlist_3([C|Rest], Div, SoFar, N) :-
     nonvar(C),
     C >= 48, C =< 57,
     Next is SoFar + (C-48)/Div,
     Div1 is Div*10,
     nonvar(Rest),
     $name_numlist_3(Rest,Div1,Next,N).



