/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $compare.P */

$compare_export(['=='/2,'\=='/2,'@=<'/2,'@<'/2,'@>'/2,'@>='/2,$compare/3]).

'=='(X, Y) :- $compare0(X, Y, R), R =:= 0.

'\=='(X, Y) :- $compare0(X, Y, R), R =\= 0.

'@=<'(X, Y) :- $compare0(X, Y, R), R =< 0.

'@<'(X, Y) :- $compare0(X, Y, R), R < 0.

'@>'(X, Y) :- $compare0(X, Y, R), R > 0.

'@>='(X, Y) :- $compare0(X, Y, R), R >= 0.

$compare0(X, Y, R) :- '_$builtin'(73).

$compare('=', T1, T2) :- T1 == T2.
$compare('<', T1, T2) :- T1 @< T2.
$compare('>', T1, T2) :- T1 @> T2.
