/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $call.P */

$call_export([call/1,'_$interp'/2,'_$call'/1]).

'_$interp'(','(A,B),CP) :- !,'_$interp'(A,CP),'_$interp'(B,CP).

'_$interp'(';'(A,B),CP) :- !,'_$interpor'(A,CP,B).

'_$interp'('!',CP) :- '_$cutto'(CP).

'_$interp'('->'(A,B),CP) :- !,
	'_$savecp'(NCP),'_$interp'(A,NCP),!,'_$interp'(B,CP).

'_$interp'([H|L], _) :- !, $consult_list([H|L]).
'_$interp'(Goal,_) :- '_$builtin'(10).	/* '_$call'(Goal) */

'_$interpor'('->'(Bool,Then),CP,Else) :- 
	!,'_$interpif'(Bool,CP,Else,Then).
'_$interpor'(A,CP,_) :- '_$interp'(A,CP).
'_$interpor'(_,CP,B) :- '_$interp'(B,CP).

'_$interpif'(Bool,CP,Else,Then) :- 
	'_$savecp'(NCP),'_$interp'(Bool,NCP),!,'_$interp'(Then,CP).
'_$interpif'(_,CP,Else,_) :- '_$interp'(Else,CP).


'_$call'([H|L]) :- !, $consult_list([H|L]).
'_$call'(X) :- '_$builtin'(10).

(A,B) :- '_$call'(A),'_$call'(B).

','(A,B,C,D) :- '_$call'(A),'_$call'(B),'_$call'(C),'_$call'(D).

/*
(A->B;C) :- !,(call(A) -> '_$call'(B) ; '_$call'(C)).
(A;B) :- '_$call'(A).
(A;B) :- '_$call'(B).
*/

';'(A, B) :-
    A = (Test -> Then) ->
        (call(Test) -> '_$call'(Then) ; '_$call'(B)) ;
	('_$call'(A) ; '_$call'(B)).


(A->B) :- call(A) -> '_$call'(B).

not(A) :- call(A) -> fail ; true.

call(X) :- '_$savecp'(C),'_$interp'(X,C).

