/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $arith.P */

/*  This file defines some arithmetic library predicates */

$arith_export([$floatc/3,$exp/2,$square/2,$sin/2,$floor/2]).

$floatc(FNum,Mant,Exp) :-
	$number(FNum), var(Mant), var(Exp), !,
	$b_floatc(FNum,Mant,Exp,0).
$floatc(FNum,Mant,Exp) :-
	$number(Mant),
	(integer(Exp) ->
		(var(FNum) ->
		     $b_floatc(FNum,Mant,Exp,1) ;
		     ($number(FNum) ->
		          $b_floatc(FNum,Mant,Exp,2) ;
		          ($print('*** Error: invalid arguments to floatc ***'), $nl, fail)
		     )
		)
	).

$exp(X, Y) :- var(X) ->
	(($number(Y), Y > 0) -> $b_arith(X, Y, 0) ;
		       ($print('*** illegal second argument to exp/2 ***'), $nl, fail)
	) ;
	($number(X) ->
			$b_arith(X,Y,1) ;
		       ($print('*** illegal first argument to exp/2 ***'), $nl, fail)
	).

$square(X, Y) :- var(X) ->
	($number(Y) -> $b_arith(X, Y, 2) ;
		       ($print('*** illegal second argument to square/2 ***'), $nl, fail)
	) ;
	($number(X) ->
			$b_arith(X,Y,3) ;
		       ($print('*** illegal first argument to square/2 ***'), $nl, fail)
	).

$sin(X, Y) :- var(X) ->
	($number(Y) -> $b_arith(X, Y, 5) ;
		       ($print('*** illegal second argument to sin/2 ***'), $nl, fail)
	) ;
	($number(X) ->
			$b_arith(X,Y,4) ;
		       ($print('*** illegal first argument to sin/2 ***'), $nl, fail)
	).

$b_arith(X, Y, N) :- '_$builtin'(60).
$b_floatc(F,M,E,S) :- '_$builtin'(61).

$floor(F,I) :-
     $number(F) ->
	($floor0(F,J,0),
	 (($number(I) ; var(I)) ->
	      I = J ;
	      ($telling(X), $tell(stderr),
	       $write('*** illegal second argument to floor/2: '), $write(I),
	       $nl, $told, $tell(X), fail)
	 )
	) ;
	($number(I) ->
	     (var(F) ->
	          $floor0(F,I,1) ;
		  ($telling(X), $tell(stderr),
		   $write('*** illegal first argument to floor/2: '), $write(F),
		   $nl, $told, $tell(X), fail)
	     )
	).

$floor0(F,I,N) :- '_$builtin'(63).

/* ------------------------------------- $arith.P -------------------------- */

