/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* sockets.P */

/*
comm.P  It is DEFINITELY not clean-cut. I have stuff like flock and fsync
defined in comm.P!! Some calls are commented as I do not think any one uses
them.
*/
/*  	Only in unix domain -- not supported --
		sys_pipe_unix :- true.
		sys_socketpair_unix :- true.
*/

sys_socket_inet(Af,Type,Protocol,Socket) :- 
	syscall(97,[Af,Type,Protocol],Socket).

sys_bind_inet(Sock,Namebuff,Res) :- 
	syscall(104,[Sock,Namebuff,16],Res).

sys_connect_inet(Sock,Namebuff,Res) :- 
	syscall(98,[Sock,Namebuff,16],Res).

sys_listen_inet(Sock,Num,Res) :- 
	syscall(106,[Sock,Num],Res).

sys_accept_inet(Sock,Namebuff,Namelen,Newsock) :- 
	$alloc_heap(4,Lenbuff),
	ptoc(int,16,Lenbuff,0,_),
	syscall(99,[Sock,Namebuff,Lenbuff],Newsock),
	ctop(int,Namelen,Lenbuff,0,_).

sys_send_inet(Sock, Msgbuff, Msglen, Flags, CharSent) :-
	syscall(101,[Sock, Msgbuff, Msglen, Flags], CharSent).

sys_sendto_inet(Sock, Msgbuff, Msglen, Flags, Tobuff, CharSent) :-
	syscall(133,[Sock, Msgbuff, Msglen, Flags,Tobuff,16], CharSent).

/*
sys_sendmsg_inet(Sock, Msgbuff, Flags, CharSent) :-
	syscall(114,[Sock, Msgbuff, Flags], CharSent).
*/

sys_recv_inet(Sock, Msgbuff, Msglen, Flags, CharRcvd) :-
	syscall(102,[Sock, Msgbuff, Msglen, Flags], CharRcvd).

sys_recvfrom_inet(Sock, Msgbuff, Msglen, Flags, Frombuff, Fromlen, CharRcvd):-
	$alloc_heap(4,Lenbuff),
	ptoc(int,16,Lenbuff,0,_),
	syscall(125,[Sock,Msgbuff,Msglen,Flags,Frombuff,Lenbuff],CharRcvd),
	ctop(int,Fromlen,Lenbuff,0,_).
/*
sys_recvmsg_inet(Sock, Msgbuff, Flags, CharRcvd) :-
	syscall(113,[Sock, MsgBuff, Flags], CharRcvd).
*/

sys_read_inet(Sock,Buff,Nbytes,Res) :- 
	syscall(3,[Sock,Buff,Nbytes],Res).

sys_write_inet(Sock,Buff,Nbytes,Res) :- 
	syscall(4,[Sock,Buff,Nbytes],Res).

sys_close_inet(Sock,Res) :- 
	syscall(6,[Sock],Res).

sys_gethostname_inet(Namebuff, Res) :-
	alloc_heap(20, Namebuff),
	syscall(87, [Namebuff, 20], Res).
/*
sys_sethostname_inet(Namebuff, Namelen, Res) :-
	syscall(88, [Namebuff, Namelen], Res).
*/
sys_select_inet(Nfds, Readfds, Writefds, Exceptfds, Timeout, Nfound) :-
	syscall(93, [Nfds, Readfds, Writefds, Exceptfds, Timeout], Nfound).

sys_gethostid(Hostid) :-
	syscall(142, [], Hostid).
/*
sys_sethostid(Hostid, Res) :-
	syscall(143, [Hostid], Res).
*/
sys_getsockname_inet(Sock,Namebuff,Res) :- 
	$alloc_heap(4,Lenbuff),
	ptoc(int,16,Lenbuff,0,_),
	syscall(150,[Sock,Namebuff,Lenbuff],Res),
	ctop(int,Namelen,Lenbuff,0,_).
/*
getent_inet(host, Hostentbuff) :-
	sys_getent_inet(21, Hostentbuff).
*/
/*
getent_inet(net, Netentbuff) :-
	sys_getent_inet(26, Netentbuff).
*/
/*
getent_inet(proto, Protoentbuff) :-
	sys_getent_inet(31, Protoentbuff).
*/
/*
getent_inet(serv, Serventbuff) :-
	sys_getent_inet(36, Serventbuff).
*/
getbyname_inet(host, Hname, Hostentbuff) :-
	sys_getbyname_inet(22, Hname, Hostentbuff).

getbyname_inet(net, Nname, Netentbuff) :-
	sys_getbyname_inet(27, Nname, Netentbuff).

getbyname_inet(proto, Pname, Protoentbuff) :-
	sys_getbyname_inet(32, Pname, Protoentbuff).

sys_getpid(Pid) :-
	syscall(20, [], Pid).

sys_flock(Fd, Operation, Res) :-
	syscall(131, [Fd,Operation], Res).

sys_fsync(Fd, Res) :-
	syscall(95, [Fd], Res).

ntohl_inet(Netnum, Hostnum) :-
	sys_hn(51, Netnum, Hostnum).

htonl_inet(Hostnum, Netnum) :-
	sys_hn(52, Hostnum, Netnum).

ntohs_inet(Netnum, Hostnum) :-
	sys_hn(53, Netnum, Hostnum).

htons_inet(Hostnum, Netnum) :-
	sys_hn(54, Hostnum, Netnum).

sys_hn(Callnumber, Innum, Outnum) :-
	alloc_heap(4, Argbuff), alloc_heap(4, Retbuff),
	ptoc(int, Innum, Argbuff, 0, _),
	brocall(Callnumber, Argbuff, Retbuff),
	ctop(int, Outnum, Retbuff, 0, _).

sys_getent_inet(Callnumber, Entbuff) :-
	alloc_heap(0,Argbuff), alloc_heap(4,Entbuff),
	brocall(Callnumber, Argbuff, Entbuff).

sys_getbyname_inet(Callnumber, Namebuff, Entbuff) :-
	alloc_heap(4,Argbuff), alloc_heap(4, Entbuff),
	ptoc(str,Namebuff,Argbuff,0,_),
	brocall(Callnumber,Argbuff,Entbuff).
/*
sys_gethostbyaddr_inet(Haddrbuff, Haddrlen, Haddrtype, Hostentbuff) :-
	alloc_heap(12, Argbuff), alloc_heap(4, Hostentbuff),
	ptoc([str, int, int], [Haddrbuff, Haddrlen, Haddrtype],
	     Argbuff, 0, _),
	brocall(23, Argbuff, Hostentbuff).
*/
/*
sys_getnetbyaddr_inet(Netnumber, Netentbuff) :-
	alloc_heap(4, Argbuff), alloc_heap(4, Netentbuff),
	ptoc(int, Netnumber, Argbuff, 0, _),
	brocall(28, Argbuff, Netentbuff).
*/
/*
sys_getprotobynumber_inet(Protonumber, Protoentbuff) :-
	alloc_heap(4, Argbuff), alloc_heap(4, Protoentbuff),
	ptoc(int, Protonumber, Argbuff, 0, _),
	brocall(33, Argbuff, Protoentbuff).
*/
/*
sys_getservbyport_inet(Portnumber, Protoname, Serventbuff) :-
	alloc_heap(8, Argbuff), alloc_heap(4, Serventbuff),
	ptoc([int,str], [Portnumber,Protoname], Argbuff, 0, _),
	brocall(38, Argbuff, Serventbuff).
*/
/*
getbyname_inet(serv, Sname, Sproto, Serventbuff) :-
	sys_getbyname_inet(37, Sname, Sproto, Serventbuff).
*/
sys_getbyname_inet(Callnumber, Namebuff, Protobuff, Entbuff) :-
	alloc_heap(8,Argbuff), alloc_heap(4, Entbuff),
	ptoc([str,str],[Namebuff,Protobuff],Argbuff,0,_),
	brocall(Callnumber,Argbuff,Entbuff).
/*
setent_inet(host, Stayopenflag, Result) :- 
	sys_setent_inet(24, Stayopenflag, Result).
*/
/*
endent_inet(host, Result) :- sys_endent_inet(25, Result).
*/
/*
setent_inet(net, Stayopenflag, Result) :- 
	sys_setent_inet(29, Stayopenflag, Result).
*/
/*
endent_inet(net, Result) :- sys_endent_inet(30, Result).
*/
/*
setent_inet(proto, Stayopenflag, Result) :- 
	sys_setent_inet(34, Stayopenflag, Result).
*/
/*
endent_inet(proto, Result) :- sys_endent_inet(35, Result).
*/
/*
setent_inet(serv, Stayopenflag, Result) :- 
	sys_setent_inet(39, Stayopenflag, Result).
*/
/*
endent_inet(serv, Result) :- sys_endent_inet(40, Result).
*/
/*
sys_setent_inet(Callnumber, Stayopenflag, Result) :-
	alloc_heap(4,Argbuff), alloc_heap(4, Retbuff),
	ptoc(int, Stayopenflag, Argbuff, 0, _),
	brocall(Callnumber, Argbuff, Retbuff),
	ctop(int, Result, Retbuff, 0, _).
*/
/*
sys_endent_inet(Callnumber, Result):-
	alloc_heap(0,Argbuff), alloc_heap(4, Retbuff),
	brocall(Callnumber, Argbuff, Retbuff),
	ctop(int, Result, Retbuff, 0, _).
*/
/* INET (3N) NOT IMPLEMENTED - SS			*/



