/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $tcond1.P */

/* "tcond" generates code for the test for the if_then_else.  */

/* **********************************************************************
$tcond1_export([$tcond/7]).

$tcond1_use($eval1,[$eval_exp/7,$eval_arithreloptab/4,$arithrelop/1]).
$tcond1_use($blist,[_,_,$member1/2]).
$tcond1_use($aux1,[_,_,_,_,$umsg/1,_,$disj_targ_label/2,_,_]).
$tcond1_use($computil1,[_,$hold/3,_,$getreg/2,_,_,_,_,_,_,_,_,$type/2,
     $occ/2,$loc/2,_,_,$alloc_reg/3,$release_if_done/6,$release_if_done0/5]).
$tcond1_use($inst1,[$varinst/8,_,_,_,_]).
$tcond1_use($glob,[_,$gennum/1,_]).
********************************************************************** */

$tcond(and(Goal,_,Goals),SuccLab,FailLab,Pil,Pilr,Tin,Tout,HoldRegs) :-
    !,
    $gen_label(IntLab),
    $tcond(Goal,IntLab,FailLab,Pil,[label(IntLab)|Pilm],Tin,Tmid,HoldRegs),
    $tcond(Goals,SuccLab,FailLab,Pilm,Pilr,Tmid,Tout,HoldRegs).
$tcond(or(Goal,_,Goals),SuccLab,FailLab,Pil,Pilr,Tin,Tout,HoldRegs) :-
    !,
    $gen_label(IntLab), 
    $tcond(Goal,SuccLab,IntLab,Pil,[label(IntLab)|Pilm],Tin,Tmid,HoldRegs),
    $tcond(Goals,Succlab,FailLab,Pilm,Pilr,Tmid,Tout,HoldRegs).
$tcond('_call'(Op,[Arg1,Arg2],_),SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
    $arithrelop(Op),
    !,
    $tcond_relop(Op,Arg1,Arg2,SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs).
$tcond('_call'(Op,[Arg1,Arg2],_),SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
    (Op ?= '?=' -> true ;
     Op ?= '\='
    ),
    !,
    $tcond_unif_test(Op,Arg1,Arg2,SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs).
$tcond('_call'(Op,[Arg],_),SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
    (Op ?= var -> true ;
     Op ?= nonvar
    ),
    !,
    $tcond_sot(Op,Arg,SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs).
$tcond('_call'(Op,[Arg],_),SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
    (Op ?= integer -> true ;
     Op ?= real
    ),
    !,
    $tcond_type(Op,Arg,SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs).
$tcond('_call'(true,[],_),_,_,Pil,Pil,T,T,_) :- !.
$tcond('_call'(Op,_,_),_,_,Pil,Pil,T,T,_) :-
	$umsg(['*** warning: Unknown operator',Op,'in If-Then-Else ***']).

$tcond_relop(Op,Arg1,[0],SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
    !,
    $eval_exp(Arg1,R1,Pil,[Jumpinst,jump(SLabel)|Pilr],HoldRegs,Tin,Tout1,1),
    $eval_arithreloptab(R1,Op,FLabel,Jumpinst),
    $release_if_done0(Arg1,R1,HoldRegs,Tout1,Tout).
$tcond_relop(Op,[0],Arg2,SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
    !,
    $tcond_relop(Op,Arg2,[0],SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs).
$tcond_relop(Op,Arg1,Arg2,SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
    $eval_exp(Arg1,R1,Pil,Pilm,HoldRegs,Tin,Tmid),
    $eval_exp(Arg2,R2,Pilm,
    	[subreg(R2,R1),Jumpinst,jump(SLabel)|Pilr],HoldRegs,Tmid,Tout1,1),
    $eval_arithreloptab(R1,Op,FLabel,Jumpinst),
    $release_if_done0(Arg1,R1,HoldRegs,Tout1,Tout2),
    $release_if_done0(Arg2,R2,HoldRegs,Tout2,Tout).

$tcond_unif_test('?=',Lhs,Rhs,Success,Failure,Pil,Pilr,Tin,Tout,HoldR) :-
   $geninl_load_lhs(Lhs,R1,Pil,Pil1,Tin,Tmid0,_),
   $geninl_load_lhs(Rhs,R2,Pil1,Pil2,Tmid0,Tmid1,_),
   $getreg(Tmid1,R3),
   Pil2 = [test_unifiable(R1,R2,R3),jumpz(R3,Failure),jump(Success)|Pilr],
   $geninl_unload_lhs(Rhs,R2,HoldR,Tmid1,Tout1),
   $geninl_unload_lhs(Lhs,R1,HoldR,Tout1,Tout).
$tcond_unif_test('\=',Lhs,Rhs,Success,Failure,Pil,Pilr,Tin,Tout,HoldR) :-
   $geninl_load_lhs(Lhs,R1,Pil,Pil1,Tin,Tmid0,_),
   $geninl_load_lhs(Rhs,R2,Pil1,Pil2,Tmid0,Tmid1,_),
   $getreg(Tmid1,R3),
   Pil2 = [test_unifiable(R1,R2,R3),jumpnz(R3,Failure),jump(Success)|Pilr],
   $geninl_unload_lhs(Rhs,R2,HoldR,Tmid1,Tout1),
   $geninl_unload_lhs(Lhs,R1,HoldR,Tout1,Tout).
$tcond_sot(Op,v(Vid,Prag),SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
    $alloc_reg(Prag,Tin,Tmid),
    (($type(Prag,t), $loc(Prag,L), R = L, Tmid = Tmid1) ;
     ($getreg(Tmid,R),$hold(R,Tmid,Tmid1))
    ),
    $occ(Prag,Oc), $type(Prag,T), $loc(Prag,Loc),
    $varinst(b,Oc,T,Loc,R,Pil,Pilm,Tmid1),
    ((Op = var, Pilm = [switchonterm(R,FLabel,FLabel)|Pilr]) ;
     (Op = nonvar, Pilm = [switchonterm(R,SLabel,SLabel),jump(FLabel)|Pilr]
     )
    ),
    $release_if_done(Vid,R,Prag,HoldRegs,Tmid1,Tout).
$tcond_sot(Op,Arg,SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
     $umsg(['*** warning: argument to ',Op,' is not a variable ***']),
     ((Op = var, Pil = [fail|Pilr]) ;
      (Op = nonvar, Pil = Pilr)
     ),
     told, tell(X).

$tcond_type(Op,Arg,SLabel,FLabel,Pil,Pilr,Tin,Tout,HoldRegs) :-
    $geninl_load_lhs(Arg,R1,Pil,Pil1,Tin,Tmid,_),
    $tcond_OpTag(Op,Tag),
    Pil1 = [get_tag(R1,R2),putnumcon(Tag,R3),
    	    subreg(R2,R3),jumpnz(R3,FLabel),jump(SLabel)|Pilr],
    $getreg(Tmid,R2), $getreg([R2|Tmid],R3),
    $geninl_unload_lhs(Arg,R1,HoldRegs,Tmid,Tout).

$tcond_OpTag(integer, 6).
$tcond_OpTag(real,    2).

/* end $tcond1.P **********************************************/
