/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $procvars1.P */

/* **********************************************************************
$procvars1_export([$procvars/2]).

$procvars1_use($blist,[_,_,$member1/2]).
$procvars1_use($computil1,[_,_,_,_,_,_,_,_,_,_,_,_,$type/2,$occ/2,$loc/2,
				$misc/2,_,_,_,_]).
$procvars1_use($meta,[_,_,$length/2]).
$procvars1_use($listutil1,[_,_,_,_,_,_,_,$closetail/1]).
********************************************************************** */


$procvars([],_) :- !.
$procvars([v(Vid,Occlist)|Vars],Numlits) :-
    $proc_getvartype(Occlist,Numlits,Type),
    $procvar(Type,Occlist),
    $procvars(Vars,Numlits).

$proc_getvartype(Occlist,_,vh) :-		/* vh == void in head */
    Occlist = [o(_,0,0,_,t,_)].
$proc_getvartype(Occlist,Numlits,T) :-
    Occlist = [O1|ORest], 
    $procv_firstocc(ORest,O1,o(_,_,Firstlit,_,Context,_)),
    $procv_lastocc(ORest,O1,o(_,_,Lastlit,_,_,_)),
    $procv_pathocc(Occlist,PathList),
    ($procv_tempconds(PathList,Firstlit,Context,Lastlit,Numlits) ->
    	T = t ;
	T = p
    ).

$procv_lastocc([], Last, Last).
$procv_lastocc([Occ|ORest],Lastsofar,Last) :-
	Occ = o(O1,P1,L1,A1,_,_),
	Lastsofar = o(O2,P2,L2,A2,_,_),
	$procv_getpathno(P1,Path1),
	$procv_getpathno(P2,Path2),
	( (Path2 > Path1 ; L2 > L1) ->
		 	Lastnow = Lastsofar ;
	 		( (L2 =:= L1, O2 > O1) ->
					Lastnow = Lastsofar ;
					Lastnow = Occ
			)
	),
	$procv_lastocc(ORest,Lastnow,Last).

$procv_firstocc([], First, First) :- !.
$procv_firstocc([Occ|ORest],Firstsofar,First) :-
	Occ = o(O1,P1,L1,A1,_,_),
	Firstsofar = o(O2,P2,L2,A2,_,_),
	$procv_getpathno(P1,Path1),
	$procv_getpathno(P2,Path2),
	( (Path2 < Path1 ; L2 < L1) ->
			Firstnow = Firstsofar ;
	  		( (L2 =:= L1, O2 < O1) ->
					Firstnow = Firstsofar ;
					Firstnow = Occ
			)
	),
	$procv_firstocc(ORest,Firstnow,First).

$procv_getpathno(lastlit(P),P) :- !.
$procv_getpathno(P,P).

$procv_tempconds(PathList,0,_,L,_) :- L=<1, $procv_pathcond(PathList),!.
$procv_tempconds(PathList,N,s,N,_) :- $procv_pathcond(PathList), !.
$procv_tempconds(PathList,N,_,N,N) :- $procv_pathcond(PathList).
$procv_tempconds(PathList,_,_,_,_) :- $procv_all_lastlits(PathList).

$procv_pathcond(L) :- $procv_onepath(L).
$procv_pathcond(L) :- not( ($member(P,L), $procv_getpathno(P,Path), Path > 1) ).

$procv_onepath([lastlit(P)|Rest]) :- !, $procv_onepath_1(Rest,P).
$procv_onepath([P|Rest]) :- $procv_onepath_1(Rest,P).

$procv_onepath_1([],_).
$procv_onepath_1([P|Rest],P) :- $procv_onepath_1(Rest,P).
$procv_onepath_1([lastlit(P)|Rest],P) :- $procv_onepath_1(Rest,P).

$procv_all_lastlits([]).
$procv_all_lastlits([lastlit(_)|L]) :- $procv_all_lastlits(L).

$procv_pathocc([],PathList) :- $closetail(PathList).
$procv_pathocc([o(_,P,_,_,_,_)|ORest],PathList) :-
	$member1(P,PathList),
	$procv_pathocc(ORest,PathList).

$procvar(vh, [o(_,_,_,_,_,vrec(vh,f,0,[]))]).
$procvar(t,Occlist) :-
    $length(Occlist, NumOcc),
    $proctvarr(Occlist,_,NumOcc).
$procvar(p,[o(_,Path,Firstlit,_,Context,Prag)|Occlist]) :-
   $type(Prag,p), $loc(Prag,Disp),
   $misc(Prag,Misc), $member1(Firstocc,Misc), $closetail(Misc),
   Firstocc = firstocc(Firstlit,Context),
   $procpvarr(Occlist,Firstocc,Disp).


$proctvarr(Occlist,N,Numocc) :- $proctvarr1(Occlist,N,Numocc,Use,NoUse).

$proctvarr1([],_,_,_,_).
$proctvarr1([o(_,_,L,_,_,P)|Occlist],N,NumOcc,Use,Nouse) :-
    $loc(P,N), $type(P,t), $misc(P,Misc),
    $member1(use(Use),Misc),
    $member1(nouse(Nouse),Misc),
    $member1(numocc(NumOcc),Misc),
    $proctvarr1(Occlist,N,NumOcc,Use,Nouse).


$procpvarr([],_,_).
$procpvarr([o(_,_,_,_,_,Prag)|Occlist],Firstocc,Disp) :-
    $type(Prag,p), $loc(Prag,Disp),
    $misc(Prag,Misc), $member1(Firstocc,Misc), $closetail(Misc),
    $procpvarr(Occlist,Firstocc,Disp).

/* end $procvars1.P **********************************************/
